/*
 * Decompiled with CFR 0.152.
 */
package org.Little_100.projecte.TransmutationTable;

import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class NoEmcItemGUI
implements InventoryHolder {
    private final Inventory inventory;
    private final List<ItemStack> items;
    private final int page;

    public NoEmcItemGUI(List<ItemStack> items, int page) {
        this.items = items;
        this.page = page;
        int totalPages = (int)Math.ceil((double)items.size() / 45.0);
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)54, (String)("No EMC Items (Page " + (page + 1) + "/" + totalPages + ")"));
        this.loadItems();
    }

    private void loadItems() {
        this.inventory.clear();
        int startIndex = this.page * 45;
        int endIndex = Math.min(startIndex + 45, this.items.size());
        for (int i = startIndex; i < endIndex; ++i) {
            this.inventory.addItem(new ItemStack[]{this.items.get(i)});
        }
        if (this.page > 0) {
            this.inventory.setItem(45, this.createNavItem("Previous Page", Material.ARROW));
        }
        if (endIndex < this.items.size()) {
            this.inventory.setItem(53, this.createNavItem("Next Page", Material.ARROW));
        }
    }

    private ItemStack createNavItem(String name, Material material) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(String.valueOf(ChatColor.GREEN) + name);
            item.setItemMeta(meta);
        }
        return item;
    }

    public void openInventory(Player player) {
        player.openInventory(this.inventory);
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public int getPage() {
        return this.page;
    }

    public List<ItemStack> getItems() {
        return this.items;
    }
}

