/*
 * Decompiled with CFR 0.152.
 */
package org.Little_100.projecte.compatibility;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.Little_100.projecte.EmcManager;
import org.Little_100.projecte.ProjectE;
import org.Little_100.projecte.compatibility.VersionAdapter;
import org.Little_100.projecte.storage.DatabaseManager;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.inventory.FurnaceRecipe;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.plugin.Plugin;

public class LegacyAdapter
implements VersionAdapter {
    private EmcManager emcManager;
    private final DatabaseManager databaseManager = ProjectE.getInstance().getDatabaseManager();

    private EmcManager getEmcManager() {
        if (this.emcManager == null) {
            this.emcManager = ProjectE.getInstance().getEmcManager();
        }
        return this.emcManager;
    }

    @Override
    public Material getMaterial(String name) {
        try {
            return Material.valueOf((String)name.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Override
    public String getItemKey(ItemStack itemStack) {
        if (itemStack == null || itemStack.getType() == Material.AIR) {
            return "minecraft:air";
        }
        return "minecraft:" + itemStack.getType().name().toLowerCase();
    }

    @Override
    public long calculateRecipeEmc(Recipe recipe, String divisionStrategy) {
        if (recipe == null) {
            return 0L;
        }
        long totalEmc = 0L;
        boolean isCooking = false;
        if (recipe instanceof ShapedRecipe) {
            for (ItemStack ingredient : ((ShapedRecipe)recipe).getIngredientMap().values()) {
                if (ingredient == null) continue;
                long ingredientEmc = this.getIngredientEmc(ingredient);
                if (ingredientEmc == 0L) {
                    return 0L;
                }
                totalEmc += ingredientEmc;
            }
        } else if (recipe instanceof ShapelessRecipe) {
            for (ItemStack ingredient : ((ShapelessRecipe)recipe).getIngredientList()) {
                if (ingredient == null) continue;
                long ingredientEmc = this.getIngredientEmc(ingredient);
                if (ingredientEmc == 0L) {
                    return 0L;
                }
                totalEmc += ingredientEmc;
            }
        } else if (recipe instanceof FurnaceRecipe) {
            isCooking = true;
            FurnaceRecipe furnaceRecipe = (FurnaceRecipe)recipe;
            ItemStack input = furnaceRecipe.getInput();
            if (input != null) {
                totalEmc = this.getIngredientEmc(input);
            }
        }
        if (totalEmc <= 0L) {
            return 0L;
        }
        int resultAmount = recipe.getResult().getAmount();
        if (resultAmount <= 0) {
            return 0L;
        }
        long recipeEmc = "ceil".equals(divisionStrategy) ? (long)Math.ceil((double)totalEmc / (double)resultAmount) : totalEmc / (long)resultAmount;
        if (isCooking && recipeEmc > 0L) {
            ++recipeEmc;
        }
        return recipeEmc;
    }

    private long getIngredientEmc(ItemStack ingredient) {
        if (ingredient == null) {
            return 0L;
        }
        return this.getEmcManager().getEmc(this.getItemKey(ingredient));
    }

    @Override
    public void loadInitialEmcValues() {
        FileConfiguration config = ProjectE.getInstance().getConfig();
        ConfigurationSection emcSection = config.getConfigurationSection("TransmutationTable.EMC.ImportantItems");
        if (emcSection == null) {
            ProjectE.getInstance().getLogger().warning("EMC section 'TransmutationTable.EMC.ImportantItems' not found in config.yml");
            return;
        }
        List items = emcSection.getMapList("default");
        if (items == null || items.isEmpty()) {
            ProjectE.getInstance().getLogger().warning("'default' EMC list is missing or empty in config.yml");
            return;
        }
        for (Map itemMap : items) {
            for (Map.Entry entry : itemMap.entrySet()) {
                if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof Number)) continue;
                String itemKey = (String)entry.getKey();
                long emc = ((Number)entry.getValue()).longValue();
                if (emc <= 0L) continue;
                if (this.getMaterial(itemKey) != null) {
                    this.databaseManager.setEmc("minecraft:" + itemKey.toLowerCase(), emc);
                    continue;
                }
                ProjectE.getInstance().getLogger().warning("Item '" + itemKey + "' from 'default' EMC list not found in this Minecraft version. Skipping.");
            }
        }
    }

    @Override
    public List<String> getRecipeDebugInfo(Recipe recipe, String divisionStrategy) {
        ArrayList<String> debugInfo = new ArrayList<String>();
        if (recipe == null) {
            debugInfo.add(" - \u914d\u65b9\u4e3a\u7a7a");
            return debugInfo;
        }
        debugInfo.add(" - \u914d\u65b9\u7c7b\u578b: " + recipe.getClass().getSimpleName());
        long calculatedEmc = this.calculateRecipeEmc(recipe, divisionStrategy);
        debugInfo.add(" - \u8ba1\u7b97\u51fa\u7684EMC: " + calculatedEmc);
        if (recipe instanceof ShapedRecipe) {
            debugInfo.add(" - \u6210\u5206:");
            for (Map.Entry entry : ((ShapedRecipe)recipe).getIngredientMap().entrySet()) {
                if (entry.getValue() == null) continue;
                String key = this.getItemKey((ItemStack)entry.getValue());
                long emc = this.getIngredientEmc((ItemStack)entry.getValue());
                debugInfo.add("   - " + key + ": " + emc + " EMC");
            }
        } else if (recipe instanceof ShapelessRecipe) {
            debugInfo.add(" - \u6210\u5206:");
            for (ItemStack ingredient : ((ShapelessRecipe)recipe).getIngredientList()) {
                if (ingredient == null) continue;
                String key = this.getItemKey(ingredient);
                long emc = this.getIngredientEmc(ingredient);
                debugInfo.add("   - " + key + ": " + emc + " EMC");
            }
        } else if (recipe instanceof FurnaceRecipe) {
            debugInfo.add(" - \u6210\u5206:");
            ItemStack input = ((FurnaceRecipe)recipe).getInput();
            if (input != null) {
                String key = this.getItemKey(input);
                long emc = this.getIngredientEmc(input);
                debugInfo.add("   - " + key + ": " + emc + " EMC");
            }
        }
        return debugInfo;
    }

    @Override
    public Map<String, NamespacedKey> registerTransmutationTableRecipes() {
        HashMap<String, NamespacedKey> newKeys = new HashMap<String, NamespacedKey>();
        ProjectE plugin = ProjectE.getInstance();
        ItemStack transmutationTable = new ItemStack(Material.PETRIFIED_OAK_SLAB);
        List<Material> stones = Arrays.asList(Material.STONE, Material.COBBLESTONE, Material.ANDESITE, Material.DIORITE, Material.GRANITE);
        for (Material stone : stones) {
            String key1_id = "transmutation_table_1_" + stone.name().toLowerCase();
            NamespacedKey key1 = new NamespacedKey((Plugin)plugin, key1_id);
            ShapedRecipe recipe1 = new ShapedRecipe(key1, transmutationTable);
            recipe1.shape(new String[]{"OSO", "SPS", "OSO"});
            recipe1.setIngredient('O', Material.OBSIDIAN);
            recipe1.setIngredient('S', stone);
            recipe1.setIngredient('P', plugin.getPhilosopherStone().getType());
            Bukkit.addRecipe((Recipe)recipe1);
            newKeys.put(key1_id, key1);
            String key2_id = "transmutation_table_2_" + stone.name().toLowerCase();
            NamespacedKey key2 = new NamespacedKey((Plugin)plugin, key2_id);
            ShapedRecipe recipe2 = new ShapedRecipe(key2, transmutationTable);
            recipe2.shape(new String[]{"SOS", "OPO", "SOS"});
            recipe2.setIngredient('O', Material.OBSIDIAN);
            recipe2.setIngredient('S', stone);
            recipe2.setIngredient('P', plugin.getPhilosopherStone().getType());
            Bukkit.addRecipe((Recipe)recipe2);
            newKeys.put(key2_id, key2);
        }
        return newKeys;
    }
}

