/*
 * Decompiled with CFR 0.152.
 */
package org.Little_100.projecte.devices;

import java.util.Collection;
import java.util.List;
import org.Little_100.projecte.ProjectE;
import org.Little_100.projecte.devices.AlchemicalChest;
import org.Little_100.projecte.devices.CondenserManager;
import org.Little_100.projecte.devices.DarkMatterFurnace;
import org.Little_100.projecte.devices.EnergyCollector;
import org.Little_100.projecte.devices.EnergyCondenser;
import org.Little_100.projecte.devices.EnergyCondenserMK2;
import org.Little_100.projecte.devices.FurnaceManager;
import org.Little_100.projecte.devices.RedMatterFurnace;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;

public class DeviceListener
implements Listener {
    private final ProjectE plugin;

    public DeviceListener(ProjectE plugin) {
        this.plugin = plugin;
    }

    private boolean isCustomDevice(Block block) {
        Collection nearbyEntities = block.getWorld().getNearbyEntities(block.getLocation().add(0.5, 0.5, 0.5), 0.5, 1.0, 0.5, entity -> entity instanceof ArmorStand);
        for (Entity entity2 : nearbyEntities) {
            if (!entity2.getPersistentDataContainer().has(DarkMatterFurnace.KEY, PersistentDataType.BYTE) && !entity2.getPersistentDataContainer().has(RedMatterFurnace.KEY, PersistentDataType.BYTE) && !entity2.getPersistentDataContainer().has(AlchemicalChest.KEY, PersistentDataType.BYTE) && !entity2.getPersistentDataContainer().has(EnergyCondenser.KEY, PersistentDataType.BYTE) && !entity2.getPersistentDataContainer().has(EnergyCondenserMK2.KEY, PersistentDataType.BYTE) && !entity2.getPersistentDataContainer().has(EnergyCollector.KEY_MK1, PersistentDataType.BYTE) && !entity2.getPersistentDataContainer().has(EnergyCollector.KEY_MK2, PersistentDataType.BYTE) && !entity2.getPersistentDataContainer().has(EnergyCollector.KEY_MK3, PersistentDataType.BYTE)) continue;
            return true;
        }
        return false;
    }

    @EventHandler
    public void onPistonExtend(BlockPistonExtendEvent event) {
        List blocks = event.getBlocks();
        for (Block block : blocks) {
            if (!this.isCustomDevice(block)) continue;
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler
    public void onPistonRetract(BlockPistonRetractEvent event) {
        List blocks = event.getBlocks();
        for (Block block : blocks) {
            if (!this.isCustomDevice(block)) continue;
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockPlace(BlockPlaceEvent event) {
        ItemStack itemInHand = event.getItemInHand();
        if (itemInHand.getItemMeta() == null) {
            return;
        }
        ItemMeta meta = itemInHand.getItemMeta();
        FurnaceManager.FurnaceType furnaceType = null;
        Integer collectorType = null;
        if (meta.getPersistentDataContainer().has(DarkMatterFurnace.KEY, PersistentDataType.BYTE)) {
            furnaceType = FurnaceManager.FurnaceType.DARK_MATTER;
        } else if (meta.getPersistentDataContainer().has(RedMatterFurnace.KEY, PersistentDataType.BYTE)) {
            furnaceType = FurnaceManager.FurnaceType.RED_MATTER;
        } else if (!(meta.getPersistentDataContainer().has(AlchemicalChest.KEY, PersistentDataType.BYTE) || meta.getPersistentDataContainer().has(EnergyCondenser.KEY, PersistentDataType.BYTE) || meta.getPersistentDataContainer().has(EnergyCondenserMK2.KEY, PersistentDataType.BYTE))) {
            if (meta.getPersistentDataContainer().has(EnergyCollector.KEY_MK1, PersistentDataType.BYTE)) {
                collectorType = 1;
            } else if (meta.getPersistentDataContainer().has(EnergyCollector.KEY_MK2, PersistentDataType.BYTE)) {
                collectorType = 2;
            } else if (meta.getPersistentDataContainer().has(EnergyCollector.KEY_MK3, PersistentDataType.BYTE)) {
                collectorType = 3;
            }
        }
        boolean isAlchemicalChest = meta.getPersistentDataContainer().has(AlchemicalChest.KEY, PersistentDataType.BYTE);
        boolean isEnergyCondenser = meta.getPersistentDataContainer().has(EnergyCondenser.KEY, PersistentDataType.BYTE);
        boolean isEnergyCondenserMK2 = meta.getPersistentDataContainer().has(EnergyCondenserMK2.KEY, PersistentDataType.BYTE);
        if (furnaceType != null || collectorType != null || isAlchemicalChest || isEnergyCondenser || isEnergyCondenserMK2) {
            Block block = event.getBlock();
            Player player = event.getPlayer();
            Location location = block.getLocation();
            FurnaceManager.FurnaceType finalFurnaceType = furnaceType;
            Integer finalCollectorType = collectorType;
            boolean finalIsAlchemicalChest = isAlchemicalChest;
            boolean finalIsEnergyCondenser = isEnergyCondenser;
            boolean finalIsEnergyCondenserMK2 = isEnergyCondenserMK2;
            ItemStack deviceItemCopy = itemInHand.clone();
            deviceItemCopy.setAmount(1);
            block.setType(Material.BEACON);
            this.plugin.getSchedulerAdapter().runTaskAt(location, () -> {
                try {
                    Location armorStandLoc = location.clone().add(0.5, -0.39, 0.5);
                    ArmorStand armorStand = (ArmorStand)location.getWorld().spawnEntity(armorStandLoc, EntityType.ARMOR_STAND);
                    armorStand.setSmall(true);
                    armorStand.setVisible(false);
                    armorStand.setGravity(false);
                    armorStand.setMarker(true);
                    armorStand.setInvulnerable(true);
                    armorStand.setBasePlate(false);
                    armorStand.setArms(false);
                    armorStand.setCanPickupItems(false);
                    armorStand.setPersistent(true);
                    float yaw = player.getLocation().getYaw();
                    float roundedYaw = (float)Math.round(yaw / 90.0f) * 90.0f;
                    armorStand.setRotation(roundedYaw, 0.0f);
                    armorStand.getEquipment().setHelmet(deviceItemCopy);
                    this.plugin.getLogger().info("\u6210\u529f\u751f\u6210\u76d4\u7532\u67b6: " + String.valueOf(armorStand.getUniqueId()) + " \u5728 " + String.valueOf(armorStandLoc));
                    this.plugin.getLogger().info("  - \u5934\u76d4\u7269\u54c1: " + String.valueOf(deviceItemCopy.getType()) + " (CMD: " + String.valueOf(deviceItemCopy.hasItemMeta() && deviceItemCopy.getItemMeta().hasCustomModelData() ? Integer.valueOf(deviceItemCopy.getItemMeta().getCustomModelData()) : "\u65e0") + ")");
                    this.plugin.getLogger().info("  - \u76d4\u7532\u67b6\u8bbe\u7f6e: Small=" + armorStand.isSmall() + ", Visible=" + armorStand.isVisible() + ", Marker=" + armorStand.isMarker());
                    NamespacedKey key = null;
                    if (finalFurnaceType == FurnaceManager.FurnaceType.DARK_MATTER) {
                        key = DarkMatterFurnace.KEY;
                    } else if (finalFurnaceType == FurnaceManager.FurnaceType.RED_MATTER) {
                        key = RedMatterFurnace.KEY;
                    } else if (finalIsAlchemicalChest) {
                        key = AlchemicalChest.KEY;
                    } else if (finalIsEnergyCondenser) {
                        key = EnergyCondenser.KEY;
                    } else if (finalIsEnergyCondenserMK2) {
                        key = EnergyCondenserMK2.KEY;
                    } else if (finalCollectorType != null) {
                        key = EnergyCollector.getKey(finalCollectorType);
                    }
                    if (key != null) {
                        armorStand.getPersistentDataContainer().set(key, PersistentDataType.BYTE, (Object)1);
                    }
                    if (finalFurnaceType != null) {
                        this.plugin.getFurnaceManager().addFurnace(location, player.getUniqueId(), finalFurnaceType, armorStand.getUniqueId());
                    } else if (finalIsAlchemicalChest) {
                        this.plugin.getAlchemicalChestManager().addChest(location, player.getUniqueId());
                    } else if (finalCollectorType != null) {
                        this.plugin.getEnergyCollectorManager().addCollector(location, player.getUniqueId(), finalCollectorType, armorStand.getUniqueId());
                    } else if (finalIsEnergyCondenser) {
                        this.plugin.getCondenserManager().addCondenser(location, player.getUniqueId(), CondenserManager.CondenserType.ENERGY_CONDENSER, armorStand.getUniqueId());
                    } else if (finalIsEnergyCondenserMK2) {
                        this.plugin.getCondenserManager().addCondenser(location, player.getUniqueId(), CondenserManager.CondenserType.ENERGY_CONDENSER_MK2, armorStand.getUniqueId());
                    }
                }
                catch (Exception e) {
                    this.plugin.getLogger().severe("\u751f\u6210\u76d4\u7532\u67b6\u65f6\u51fa\u9519: " + e.getMessage());
                    e.printStackTrace();
                }
            });
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        Block block = event.getBlock();
        if (block.getType() != Material.BEACON) {
            return;
        }
        Location blockLoc = block.getLocation();
        Collection nearbyEntities = block.getWorld().getNearbyEntities(blockLoc.clone().add(0.5, 0.0, 0.5), 1.0, 1.5, 1.0, entity -> entity instanceof ArmorStand);
        for (Entity entity2 : nearbyEntities) {
            ItemMeta meta;
            ArmorStand armorStand;
            ItemStack helmet;
            if (!(entity2 instanceof ArmorStand) || (helmet = (armorStand = (ArmorStand)entity2).getEquipment().getHelmet()) == null || helmet.getItemMeta() == null || !(meta = helmet.getItemMeta()).getPersistentDataContainer().has(DarkMatterFurnace.KEY, PersistentDataType.BYTE) && !meta.getPersistentDataContainer().has(RedMatterFurnace.KEY, PersistentDataType.BYTE) && !meta.getPersistentDataContainer().has(AlchemicalChest.KEY, PersistentDataType.BYTE) && !meta.getPersistentDataContainer().has(EnergyCondenser.KEY, PersistentDataType.BYTE) && !meta.getPersistentDataContainer().has(EnergyCondenserMK2.KEY, PersistentDataType.BYTE) && !meta.getPersistentDataContainer().has(EnergyCollector.KEY_MK1, PersistentDataType.BYTE) && !meta.getPersistentDataContainer().has(EnergyCollector.KEY_MK2, PersistentDataType.BYTE) && !meta.getPersistentDataContainer().has(EnergyCollector.KEY_MK3, PersistentDataType.BYTE)) continue;
            if (meta.getPersistentDataContainer().has(DarkMatterFurnace.KEY, PersistentDataType.BYTE) || meta.getPersistentDataContainer().has(RedMatterFurnace.KEY, PersistentDataType.BYTE)) {
                this.plugin.getFurnaceManager().removeFurnace(blockLoc);
            } else if (meta.getPersistentDataContainer().has(AlchemicalChest.KEY, PersistentDataType.BYTE)) {
                this.plugin.getAlchemicalChestManager().removeChest(blockLoc);
            } else if (meta.getPersistentDataContainer().has(EnergyCollector.KEY_MK1, PersistentDataType.BYTE) || meta.getPersistentDataContainer().has(EnergyCollector.KEY_MK2, PersistentDataType.BYTE) || meta.getPersistentDataContainer().has(EnergyCollector.KEY_MK3, PersistentDataType.BYTE)) {
                this.plugin.getEnergyCollectorManager().removeCollector(blockLoc);
            } else if (meta.getPersistentDataContainer().has(EnergyCondenser.KEY, PersistentDataType.BYTE) || meta.getPersistentDataContainer().has(EnergyCondenserMK2.KEY, PersistentDataType.BYTE)) {
                this.plugin.getCondenserManager().removeCondenser(blockLoc);
            }
            armorStand.remove();
            ItemStack dropItem = helmet.clone();
            dropItem.setAmount(1);
            block.getWorld().dropItemNaturally(blockLoc.clone().add(0.5, 0.5, 0.5), dropItem);
            block.setType(Material.AIR);
            event.setDropItems(false);
            event.setCancelled(true);
            this.plugin.getLogger().info("\u8bbe\u5907\u5df2\u88ab\u7834\u574f\u5e76\u6389\u843d: " + String.valueOf(helmet.getType()));
            return;
        }
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Block clickedBlock = event.getClickedBlock();
        if (clickedBlock == null || clickedBlock.getType() != Material.BEACON) {
            return;
        }
        Collection nearbyEntities = clickedBlock.getWorld().getNearbyEntities(clickedBlock.getLocation().add(0.5, 0.5, 0.5), 0.5, 1.0, 0.5, entity -> entity instanceof ArmorStand);
        for (Entity entity2 : nearbyEntities) {
            Player player = event.getPlayer();
            if (entity2.getPersistentDataContainer().has(AlchemicalChest.KEY, PersistentDataType.BYTE)) {
                event.setCancelled(true);
                player.playSound(player.getLocation(), Sound.BLOCK_CHEST_OPEN, 1.0f, 1.0f);
                this.plugin.getAlchemicalChestManager().openChestGUI(player, clickedBlock.getLocation());
                return;
            }
            if (entity2.getPersistentDataContainer().has(EnergyCollector.KEY_MK1, PersistentDataType.BYTE) || entity2.getPersistentDataContainer().has(EnergyCollector.KEY_MK2, PersistentDataType.BYTE) || entity2.getPersistentDataContainer().has(EnergyCollector.KEY_MK3, PersistentDataType.BYTE)) {
                event.setCancelled(true);
                player.playSound(player.getLocation(), Sound.BLOCK_BEACON_ACTIVATE, 1.0f, 1.0f);
                this.plugin.getEnergyCollectorManager().openCollectorGUI(player, clickedBlock.getLocation());
                return;
            }
            if (entity2.getPersistentDataContainer().has(EnergyCondenser.KEY, PersistentDataType.BYTE)) {
                event.setCancelled(true);
                player.playSound(player.getLocation(), Sound.BLOCK_CHEST_OPEN, 1.0f, 1.0f);
                this.plugin.getCondenserManager().openCondenserGUI(player, clickedBlock.getLocation());
                return;
            }
            if (!entity2.getPersistentDataContainer().has(EnergyCondenserMK2.KEY, PersistentDataType.BYTE)) continue;
            event.setCancelled(true);
            player.playSound(player.getLocation(), Sound.BLOCK_CHEST_OPEN, 1.0f, 1.0f);
            this.plugin.getCondenserManager().openCondenserGUI(player, clickedBlock.getLocation());
            return;
        }
    }
}

