/*
 * Decompiled with CFR 0.152.
 */
package org.Little_100.projecte.devices;

import java.util.Iterator;
import org.Little_100.projecte.ProjectE;
import org.Little_100.projecte.devices.EnergyCollector;
import org.Little_100.projecte.devices.EnergyCollectorManager;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class EnergyCollectorGUI
implements Listener {
    private final ProjectE plugin;
    private final Player player;
    private final Location collectorLocation;
    private final EnergyCollectorManager.CollectorData data;
    private Inventory inventory;
    private long currentEmc;
    private static final int EMC_DISPLAY_SLOT = 49;

    public EnergyCollectorGUI(ProjectE plugin, Player player, Location location, EnergyCollectorManager.CollectorData data) {
        this.plugin = plugin;
        this.player = player;
        this.collectorLocation = location;
        this.data = data;
        this.currentEmc = data.storedEmc;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public void open() {
        String title = this.getTitleForType(this.data.type);
        this.inventory = Bukkit.createInventory(null, (int)54, (String)title);
        int itemSlots = EnergyCollector.getInventorySize(this.data.type);
        int[] slotPositions = this.getSlotPositions(this.data.type);
        for (int i = 0; i < itemSlots && i < slotPositions.length; ++i) {
            if (this.data.inventory[i] == null) continue;
            this.inventory.setItem(slotPositions[i], this.data.inventory[i]);
        }
        ItemStack glassPane = this.createGlassPane();
        for (int i = 0; i < 54; ++i) {
            if (this.isItemSlot(i, this.data.type) || i == 49) continue;
            this.inventory.setItem(i, glassPane);
        }
        this.updateEmcDisplay();
        this.player.openInventory(this.inventory);
    }

    private String getTitleForType(int type) {
        switch (type) {
            case 1: {
                return this.plugin.getLanguageManager().get("gui.energy_collector_mk1.title");
            }
            case 2: {
                return this.plugin.getLanguageManager().get("gui.energy_collector_mk2.title");
            }
            case 3: {
                return this.plugin.getLanguageManager().get("gui.energy_collector_mk3.title");
            }
        }
        return "Energy Collector";
    }

    private int[] getSlotPositions(int type) {
        switch (type) {
            case 1: {
                return new int[]{20, 21, 22, 23};
            }
            case 2: {
                return new int[]{19, 20, 21, 22, 28, 29, 30, 31};
            }
            case 3: {
                return new int[]{19, 20, 21, 22, 28, 29, 30, 31, 37, 38, 39, 40};
            }
        }
        return new int[0];
    }

    private boolean isItemSlot(int slot, int type) {
        int[] validSlots;
        for (int validSlot : validSlots = this.getSlotPositions(type)) {
            if (validSlot != slot) continue;
            return true;
        }
        return false;
    }

    private void updateEmcDisplay() {
        ItemStack emcDisplay = new ItemStack(Material.GLOWSTONE_DUST);
        ItemMeta meta = emcDisplay.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(this.plugin.getLanguageManager().get("gui.energy_collector.emc_display").replace("%emc%", String.valueOf(this.currentEmc)));
            emcDisplay.setItemMeta(meta);
        }
        this.inventory.setItem(49, emcDisplay);
    }

    private ItemStack createGlassPane() {
        ItemStack glassPane = new ItemStack(Material.GRAY_STAINED_GLASS_PANE);
        ItemMeta meta = glassPane.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(" ");
            glassPane.setItemMeta(meta);
        }
        return glassPane;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        if (!event.getWhoClicked().equals((Object)this.player)) {
            return;
        }
        if (event.getInventory() != this.inventory) {
            return;
        }
        int slot = event.getRawSlot();
        if (slot < 0 || slot >= 54) {
            return;
        }
        if (!this.isItemSlot(slot, this.data.type)) {
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler
    public void onInventoryDrag(InventoryDragEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        if (!event.getWhoClicked().equals((Object)this.player)) {
            return;
        }
        if (event.getInventory() != this.inventory) {
            return;
        }
        Iterator iterator = event.getRawSlots().iterator();
        while (iterator.hasNext()) {
            int slot = (Integer)iterator.next();
            if (slot < 0 || slot >= 54 || this.isItemSlot(slot, this.data.type)) continue;
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        if (!event.getPlayer().equals((Object)this.player)) {
            return;
        }
        if (event.getInventory() != this.inventory) {
            return;
        }
        int[] slotPositions = this.getSlotPositions(this.data.type);
        for (int i = 0; i < slotPositions.length; ++i) {
            this.data.inventory[i] = this.inventory.getItem(slotPositions[i]);
        }
        this.plugin.getEnergyCollectorManager().closeCollectorGUI(this.player, this.currentEmc, this.data.inventory);
        InventoryClickEvent.getHandlerList().unregister((Listener)this);
        InventoryCloseEvent.getHandlerList().unregister((Listener)this);
        InventoryDragEvent.getHandlerList().unregister((Listener)this);
    }
}

