/*
 * Decompiled with CFR 0.152.
 */
package org.Little_100.projecte.listeners;

import org.Little_100.projecte.ProjectE;
import org.Little_100.projecte.gui.PhilosopherStoneGUI;
import org.Little_100.projecte.util.Constants;
import org.Little_100.projecte.util.InventoryViewHelper;
import org.bukkit.ChatColor;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class PhilosopherStoneGUIListener
implements Listener {
    private final ProjectE plugin;
    private static final NamespacedKey CURRENT_MODE_KEY = new NamespacedKey((Plugin)ProjectE.getInstance(), "current_mode");

    public PhilosopherStoneGUIListener(ProjectE plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        String guiTitle = this.plugin.getLanguageManager().get("clientside.philosopher_stone_gui.title");
        if (!InventoryViewHelper.getTitle((InventoryEvent)event).equals(guiTitle)) {
            return;
        }
        event.setCancelled(true);
        int slot = event.getRawSlot();
        ItemStack clickedItem = event.getCurrentItem();
        if (slot >= event.getInventory().getSize()) {
            event.setCancelled(false);
            return;
        }
        if (this.isChargeSlot(slot)) {
            this.handleChargeClick(player, clickedItem);
        } else if (this.isModeSlot(slot)) {
            this.handleModeClick(player, clickedItem);
        } else if (slot == 16) {
            this.handleCraftingTableClick(player);
        }
    }

    @EventHandler
    public void onInventoryDrag(InventoryDragEvent event) {
        String guiTitle = this.plugin.getLanguageManager().get("clientside.philosopher_stone_gui.title");
        if (InventoryViewHelper.getTitle((InventoryEvent)event).equals(guiTitle)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
    }

    private boolean isChargeSlot(int slot) {
        if (slot == 10) {
            return true;
        }
        for (int i = 11; i <= 14; ++i) {
            if (slot != i) continue;
            return true;
        }
        return false;
    }

    private boolean isModeSlot(int slot) {
        return slot >= 20 && slot <= 22;
    }

    private void handleChargeClick(Player player, ItemStack clickedItem) {
        int newChargeLevel;
        if (clickedItem == null || clickedItem.getItemMeta() == null) {
            return;
        }
        ItemMeta meta = clickedItem.getItemMeta();
        if (!meta.getPersistentDataContainer().has(Constants.CHARGE_LEVEL_KEY, PersistentDataType.INTEGER)) {
            return;
        }
        int clickedLevel = (Integer)meta.getPersistentDataContainer().get(Constants.CHARGE_LEVEL_KEY, PersistentDataType.INTEGER);
        if (clickedLevel == -1) {
            int currentChargeLevel = PhilosopherStoneGUI.getChargeLevel(player);
            newChargeLevel = (currentChargeLevel + 1) % 5;
        } else {
            newChargeLevel = clickedLevel;
        }
        PhilosopherStoneGUI.setChargeLevel(player, newChargeLevel);
        player.playSound(player.getLocation(), Sound.BLOCK_ENCHANTMENT_TABLE_USE, 1.0f, 1.5f);
        this.plugin.getSchedulerAdapter().runTaskLater(() -> new PhilosopherStoneGUI(this.plugin, player).open(), 1L);
    }

    private void handleModeClick(Player player, ItemStack clickedItem) {
        if (clickedItem == null || clickedItem.getItemMeta() == null) {
            return;
        }
        ItemMeta meta = clickedItem.getItemMeta();
        if (!meta.getPersistentDataContainer().has(CURRENT_MODE_KEY, PersistentDataType.STRING)) {
            return;
        }
        String modeString = (String)meta.getPersistentDataContainer().get(CURRENT_MODE_KEY, PersistentDataType.STRING);
        PhilosopherStoneGUI.StoneMode newMode = PhilosopherStoneGUI.StoneMode.valueOf(modeString);
        if (PhilosopherStoneGUI.getCurrentMode(player) != newMode) {
            PhilosopherStoneGUI.setCurrentMode(player, newMode);
            player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
            String message = this.plugin.getLanguageManager().get("clientside.philosopher_stone.mode_change").replace("{mode}", newMode.getDisplayName(this.plugin));
            player.sendMessage(String.valueOf(ChatColor.GREEN) + message);
        }
        this.plugin.getSchedulerAdapter().runTaskLater(() -> new PhilosopherStoneGUI(this.plugin, player).open(), 1L);
    }

    private void handleCraftingTableClick(Player player) {
        player.closeInventory();
        this.plugin.getSchedulerAdapter().runTaskLater(() -> player.openWorkbench(null, true), 1L);
    }
}

