/*
 * Decompiled with CFR 0.152.
 */
package org.Little_100.projecte.listeners;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.Little_100.projecte.ProjectE;
import org.Little_100.projecte.gui.PhilosopherStoneGUI;
import org.Little_100.projecte.gui.TransmutationGUI;
import org.Little_100.projecte.util.ParticleHelper;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.type.Slab;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class PhilosopherStoneListener
implements Listener {
    private final ProjectE plugin;
    private final Map<UUID, Long> playerCooldowns = new HashMap<UUID, Long>();
    private final Set<UUID> interactedThisTick = new HashSet<UUID>();
    private static final Material[] MATERIALS_CYCLE = new Material[]{Material.COBBLESTONE, Material.STONE, Material.GRAVEL, Material.SAND};
    private static final Material[] BUILDING_CYCLE_1 = new Material[]{Material.GRASS_BLOCK, Material.DIRT, Material.STONE};
    private static final Material[] BUILDING_CYCLE_2 = new Material[]{Material.STONE_BRICKS, Material.CRACKED_STONE_BRICKS, Material.MOSSY_STONE_BRICKS, Material.CHISELED_STONE_BRICKS};

    public PhilosopherStoneListener(ProjectE plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        ItemStack heldItem = player.getInventory().getItemInMainHand();
        if (this.plugin.isPhilosopherStone(heldItem) && event.getAction() == Action.RIGHT_CLICK_BLOCK && event.getClickedBlock() != null) {
            event.setCancelled(true);
            long currentTime = System.currentTimeMillis();
            long lastInteraction = this.playerCooldowns.getOrDefault(player.getUniqueId(), 0L);
            if (currentTime - lastInteraction < 500L) {
                return;
            }
            if (this.interactedThisTick.contains(player.getUniqueId())) {
                return;
            }
            this.playerCooldowns.put(player.getUniqueId(), currentTime);
            this.interactedThisTick.add(player.getUniqueId());
            Block clickedBlock = event.getClickedBlock();
            BlockFace blockFace = event.getBlockFace();
            this.plugin.getSchedulerAdapter().runTaskLater(() -> {
                this.interactedThisTick.remove(player.getUniqueId());
                this.plugin.getSchedulerAdapter().runTaskAt(clickedBlock.getLocation(), () -> this.handleBlockTransformation(player, player.isSneaking(), clickedBlock, blockFace));
            }, 1L);
        }
        if (event.getAction() == Action.RIGHT_CLICK_BLOCK && event.getClickedBlock() != null && event.getClickedBlock().getType() == Material.PETRIFIED_OAK_SLAB && this.plugin.getConfig().getBoolean("gui.enabled", true)) {
            Slab slab;
            if (!player.hasPermission("philosophersstone.interact.gui")) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to use the Transmutation Table.");
                return;
            }
            if (event.getClickedBlock().getBlockData() instanceof Slab && (slab = (Slab)event.getClickedBlock().getBlockData()).getType() == Slab.Type.BOTTOM && !player.isSneaking()) {
                event.setCancelled(true);
                new TransmutationGUI(player).open();
            }
        }
    }

    @EventHandler
    public void onPlayerSwapHandItems(PlayerSwapHandItemsEvent event) {
        Player player = event.getPlayer();
        ItemStack mainHandItem = player.getInventory().getItemInMainHand();
        if (player.isSneaking() && this.plugin.isPhilosopherStone(mainHandItem)) {
            event.setCancelled(true);
            this.openPhilosopherStoneGUI(player);
            player.playSound(player.getLocation(), Sound.BLOCK_ENCHANTMENT_TABLE_USE, 1.0f, 1.0f);
        }
    }

    private void openPhilosopherStoneGUI(Player player) {
        new PhilosopherStoneGUI(this.plugin, player).open();
    }

    private void handleBlockTransformation(Player player, boolean isShiftClick, Block clickedBlock, BlockFace clickedFace) {
        if (!this.plugin.getConfig().getBoolean("philosopher_stone.enabled", true)) {
            return;
        }
        if (clickedBlock == null) {
            return;
        }
        PhilosopherStoneGUI.TransformationArea area = PhilosopherStoneGUI.getTransformationArea(player);
        List<Block> blocksToTransform = this.getBlocksInAreaByClickedFace(clickedBlock, area, clickedFace);
        if (blocksToTransform.isEmpty()) {
            return;
        }
        int transformedCount = 0;
        for (Block block : blocksToTransform) {
            Material blockMaterial = block.getType();
            Material newMaterial = isShiftClick ? this.getShiftRightClickTransformation(blockMaterial) : this.getRightClickTransformation(blockMaterial);
            if (newMaterial == null) continue;
            block.setType(newMaterial);
            ++transformedCount;
        }
        if (transformedCount > 0) {
            player.playSound(clickedBlock.getLocation(), "projecte:custom.petransmute", 1.0f, 1.0f);
            String modeText = area.getMode().getDisplayName(this.plugin);
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "Transformed " + transformedCount + " blocks [" + modeText + " Level " + area.getChargeLevel() + "]");
        }
    }

    private List<Block> getBlocksInCube(Block center, int width, int height, int depth) {
        ArrayList<Block> blocks = new ArrayList<Block>();
        int halfWidth = width / 2;
        int halfHeight = height / 2;
        int halfDepth = depth / 2;
        for (int x = -halfWidth; x <= halfWidth; ++x) {
            for (int y = -halfHeight; y <= halfHeight; ++y) {
                for (int z = -halfDepth; z <= halfDepth; ++z) {
                    Location loc = center.getLocation().add((double)x, (double)y, (double)z);
                    Block block = loc.getBlock();
                    blocks.add(block);
                }
            }
        }
        return blocks;
    }

    private List<Location> calculateOutlineLocations(List<Block> blocks) {
        int z;
        int x;
        ArrayList<Location> outlineLocations = new ArrayList<Location>();
        if (blocks.isEmpty()) {
            return outlineLocations;
        }
        int minX = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int minY = Integer.MAX_VALUE;
        int maxY = Integer.MIN_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (Block block : blocks) {
            Location loc = block.getLocation();
            minX = Math.min(minX, loc.getBlockX());
            maxX = Math.max(maxX, loc.getBlockX());
            minY = Math.min(minY, loc.getBlockY());
            maxY = Math.max(maxY, loc.getBlockY());
            minZ = Math.min(minZ, loc.getBlockZ());
            maxZ = Math.max(maxZ, loc.getBlockZ());
        }
        World world = blocks.get(0).getWorld();
        for (x = minX; x <= maxX; ++x) {
            outlineLocations.add(new Location(world, (double)x, (double)minY, (double)minZ));
            outlineLocations.add(new Location(world, (double)x, (double)minY, (double)maxZ));
        }
        for (z = minZ + 1; z < maxZ; ++z) {
            outlineLocations.add(new Location(world, (double)minX, (double)minY, (double)z));
            outlineLocations.add(new Location(world, (double)maxX, (double)minY, (double)z));
        }
        if (maxY > minY) {
            for (x = minX; x <= maxX; ++x) {
                outlineLocations.add(new Location(world, (double)x, (double)maxY, (double)minZ));
                outlineLocations.add(new Location(world, (double)x, (double)maxY, (double)maxZ));
            }
            for (z = minZ + 1; z < maxZ; ++z) {
                outlineLocations.add(new Location(world, (double)minX, (double)maxY, (double)z));
                outlineLocations.add(new Location(world, (double)maxX, (double)maxY, (double)z));
            }
        }
        for (int y = minY + 1; y < maxY; ++y) {
            outlineLocations.add(new Location(world, (double)minX, (double)y, (double)minZ));
            outlineLocations.add(new Location(world, (double)minX, (double)y, (double)maxZ));
            outlineLocations.add(new Location(world, (double)maxX, (double)y, (double)minZ));
            outlineLocations.add(new Location(world, (double)maxX, (double)y, (double)maxZ));
        }
        return outlineLocations;
    }

    private Material getRightClickTransformation(Material material) {
        Material result = this.cycleMaterial(material, MATERIALS_CYCLE, false);
        if (result != null) {
            return result;
        }
        if (material == Material.GRASS_BLOCK) {
            return Material.DIRT;
        }
        if (material == Material.DIRT) {
            return Material.STONE;
        }
        result = this.cycleMaterial(material, BUILDING_CYCLE_2, false);
        if (result != null) {
            return result;
        }
        if (material == Material.OBSIDIAN) {
            return Material.LAVA;
        }
        if (material == Material.ICE) {
            return Material.WATER;
        }
        return this.getOtherCycleTransformation(material, false);
    }

    private Material getShiftRightClickTransformation(Material material) {
        Material result = this.cycleMaterial(material, MATERIALS_CYCLE, true);
        if (result != null) {
            if (material == Material.STONE) {
                return Material.GRASS_BLOCK;
            }
            return result;
        }
        if (material == Material.GRASS_BLOCK) {
            return Material.STONE;
        }
        if (material == Material.DIRT) {
            return Material.GRASS_BLOCK;
        }
        result = this.cycleMaterial(material, BUILDING_CYCLE_2, true);
        if (result != null) {
            return result;
        }
        if (material == Material.LAVA) {
            return Material.OBSIDIAN;
        }
        if (material == Material.WATER) {
            return Material.ICE;
        }
        return this.getOtherCycleTransformation(material, true);
    }

    private Material getOtherCycleTransformation(Material material, boolean reverse) {
        Material[] saplings = new Material[]{Material.OAK_SAPLING, Material.SPRUCE_SAPLING, Material.BIRCH_SAPLING, Material.JUNGLE_SAPLING, Material.ACACIA_SAPLING, Material.DARK_OAK_SAPLING, Material.MANGROVE_PROPAGULE};
        Material[] logs = new Material[]{Material.OAK_LOG, Material.SPRUCE_LOG, Material.BIRCH_LOG, Material.JUNGLE_LOG, Material.ACACIA_LOG, Material.DARK_OAK_LOG, Material.MANGROVE_LOG};
        Material[] leaves = new Material[]{Material.OAK_LEAVES, Material.SPRUCE_LEAVES, Material.BIRCH_LEAVES, Material.JUNGLE_LEAVES, Material.ACACIA_LEAVES, Material.DARK_OAK_LEAVES, Material.MANGROVE_LEAVES};
        Material[] wools = new Material[]{Material.WHITE_WOOL, Material.ORANGE_WOOL, Material.MAGENTA_WOOL, Material.LIGHT_BLUE_WOOL, Material.YELLOW_WOOL, Material.LIME_WOOL, Material.PINK_WOOL, Material.GRAY_WOOL, Material.LIGHT_GRAY_WOOL, Material.CYAN_WOOL, Material.PURPLE_WOOL, Material.BLUE_WOOL, Material.BROWN_WOOL, Material.GREEN_WOOL, Material.RED_WOOL, Material.BLACK_WOOL};
        Material result = this.cycleMaterial(material, saplings, reverse);
        if (result != null) {
            return result;
        }
        result = this.cycleMaterial(material, logs, reverse);
        if (result != null) {
            return result;
        }
        result = this.cycleMaterial(material, leaves, reverse);
        if (result != null) {
            return result;
        }
        return this.cycleMaterial(material, wools, reverse);
    }

    private Material cycleMaterial(Material current, Material[] materials, boolean reverse) {
        for (int i = 0; i < materials.length; ++i) {
            if (materials[i] != current) continue;
            if (reverse) {
                return materials[(i - 1 + materials.length) % materials.length];
            }
            return materials[(i + 1) % materials.length];
        }
        return null;
    }

    private boolean hasPhilosopherStone(HumanEntity player) {
        for (ItemStack item : player.getInventory().getContents()) {
            if (!this.plugin.isPhilosopherStone(item)) continue;
            return true;
        }
        return false;
    }

    private List<Block> getBlocksInAreaByClickedFace(Block center, PhilosopherStoneGUI.TransformationArea area, BlockFace clickedFace) {
        ArrayList<Block> blocks = new ArrayList<Block>();
        int width = area.getWidth();
        int height = area.getHeight();
        int depth = area.getDepth();
        switch (area.getMode()) {
            case PANEL: {
                blocks.addAll(this.getBlocksInPlaneByFace(center, width, height, clickedFace));
                break;
            }
            case LINE: {
                blocks.addAll(this.getBlocksInLineByFace(center, height, clickedFace));
                break;
            }
            case CUBE: {
                blocks.addAll(this.getBlocksInCube(center, width, height, depth));
            }
        }
        return blocks;
    }

    private List<Block> getBlocksInPlaneByFace(Block center, int width, int height, BlockFace clickedFace) {
        Vector right;
        ArrayList<Block> blocks = new ArrayList<Block>();
        Vector up = switch (clickedFace) {
            case BlockFace.UP, BlockFace.DOWN -> {
                right = new Vector(1, 0, 0);
                yield new Vector(0, 0, 1);
            }
            case BlockFace.NORTH, BlockFace.SOUTH -> {
                right = new Vector(1, 0, 0);
                yield new Vector(0, 1, 0);
            }
            case BlockFace.EAST, BlockFace.WEST -> {
                right = new Vector(0, 0, 1);
                yield new Vector(0, 1, 0);
            }
            default -> {
                right = new Vector(1, 0, 0);
                yield new Vector(0, 0, 1);
            }
        };
        int halfWidth = width / 2;
        int halfHeight = height / 2;
        for (int x = -halfWidth; x <= halfWidth; ++x) {
            for (int y = -halfHeight; y <= halfHeight; ++y) {
                Vector offset = right.clone().multiply(x).add(up.clone().multiply(y));
                Location loc = center.getLocation().add(offset);
                Block block = loc.getBlock();
                blocks.add(block);
            }
        }
        return blocks;
    }

    private List<Block> getBlocksInLineByFace(Block center, int length, BlockFace clickedFace) {
        ArrayList<Block> blocks = new ArrayList<Block>();
        Vector lineDirection = switch (clickedFace) {
            case BlockFace.UP, BlockFace.DOWN -> new Vector(0, 1, 0);
            case BlockFace.NORTH -> new Vector(0, 0, -1);
            case BlockFace.SOUTH -> new Vector(0, 0, 1);
            case BlockFace.EAST -> new Vector(1, 0, 0);
            case BlockFace.WEST -> new Vector(-1, 0, 0);
            default -> new Vector(0, 1, 0);
        };
        int halfLength = length / 2;
        for (int i = -halfLength; i <= halfLength; ++i) {
            Vector offset = lineDirection.clone().multiply(i);
            Location loc = center.getLocation().add(offset);
            Block block = loc.getBlock();
            blocks.add(block);
        }
        return blocks;
    }

    public void showContinuousOutline(Player player, Block targetBlock) {
        PhilosopherStoneGUI.TransformationArea area = PhilosopherStoneGUI.getTransformationArea(player);
        BlockFace face = this.getPlayerBlockFace(player);
        if (face == null) {
            face = BlockFace.UP;
        }
        List<Block> blocksToShow = this.getBlocksInAreaByClickedFace(targetBlock, area, face);
        this.spawnParticleOutline(player, blocksToShow);
    }

    private void spawnParticleOutline(Player player, List<Block> blocks) {
        FileConfiguration config = this.plugin.getConfig();
        String particleName = config.getString("philosopher_stone.particle.particle-name", "end_rod").toLowerCase();
        List<Location> outlineLocations = this.calculateOutlineLocations(blocks);
        for (Location loc : outlineLocations) {
            ParticleHelper.spawnParticle(player, particleName, loc.clone().add(0.5, 0.6, 0.5), 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    private BlockFace getPlayerBlockFace(Player player) {
        List lastTwoTargetBlocks = player.getLastTwoTargetBlocks(null, 10);
        if (lastTwoTargetBlocks.size() < 2) {
            return null;
        }
        Block targetBlock = (Block)lastTwoTargetBlocks.get(1);
        Block adjacentBlock = (Block)lastTwoTargetBlocks.get(0);
        return targetBlock.getFace(adjacentBlock);
    }
}

