/*
 * Decompiled with CFR 0.152.
 */
package org.Little_100.projecte.listeners;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.Little_100.projecte.ProjectE;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;

public class ResourcePackListener
implements Listener {
    private final ProjectE plugin;
    private final File resourcePackFile;
    private final String resourcePackUrl;
    private final boolean autoSendResourcePack;
    private File resourcePackSourceDir;

    public ResourcePackListener(ProjectE plugin) {
        this.plugin = plugin;
        File resourcePackDir = new File(plugin.getDataFolder(), "resourcepacks");
        if (!resourcePackDir.exists()) {
            resourcePackDir.mkdirs();
        }
        this.resourcePackSourceDir = new File(plugin.getDataFolder(), "ResourcePackSource");
        if (!this.resourcePackSourceDir.exists()) {
            this.resourcePackSourceDir.mkdirs();
        }
        this.resourcePackFile = new File(resourcePackDir, "ProjectE_Resourcepack.zip");
        try {
            this.extractResourcePack();
        }
        catch (IOException e) {
            plugin.getLogger().severe("Error initializing resource pack: " + e.getMessage());
            e.printStackTrace();
        }
        this.resourcePackUrl = plugin.getConfig().getString("resourcepack.url", "");
        this.autoSendResourcePack = plugin.getConfig().getBoolean("resourcepack.auto_send", true);
    }

    public void extractResourcePack() throws IOException {
        block8: {
            if (!this.resourcePackFile.exists() || this.plugin.getConfig().getBoolean("resourcepack.force_update", false)) {
                this.plugin.getLogger().info("Extracting resource pack to: " + this.resourcePackFile.getAbsolutePath());
                try (InputStream inputStream = this.plugin.getResource("pack/ProjectE Resourcepack.zip");){
                    if (inputStream != null) {
                        Files.copy(inputStream, Path.of(this.resourcePackFile.getAbsolutePath(), new String[0]), StandardCopyOption.REPLACE_EXISTING);
                        this.plugin.getLogger().info("Resource pack extracted successfully.");
                        break block8;
                    }
                    this.plugin.getLogger().warning("Could not find resource pack in JAR.");
                    throw new IOException("Resource pack file does not exist in JAR.");
                }
            }
        }
    }

    public void sendResourcePack(Player player) {
        if (this.resourcePackUrl.isEmpty()) {
            this.plugin.getLogger().warning("Cannot send resource pack to player " + player.getName() + ": URL not configured.");
            player.sendMessage("\u00a7cCould not load custom textures: Server resource pack URL is not configured.");
            return;
        }
        this.plugin.getLogger().info("Sending resource pack to player " + player.getName());
        player.sendMessage("\u00a7aSending custom texture pack...");
        player.setResourcePack(this.resourcePackUrl);
    }

    public void rebuildResourcePack() {
        if (!this.resourcePackSourceDir.exists() || !this.resourcePackSourceDir.isDirectory()) {
            this.plugin.getLogger().warning("Resource pack source directory does not exist, cannot rebuild resource pack.");
            return;
        }
        try {
            this.plugin.getLogger().info("Rebuilding resource pack from source directory...");
            try (final ZipOutputStream zipOut = new ZipOutputStream(new FileOutputStream(this.resourcePackFile));){
                Files.walkFileTree(this.resourcePackSourceDir.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        String entryPath = ResourcePackListener.this.resourcePackSourceDir.toPath().relativize(file).toString().replace('\\', '/');
                        ZipEntry zipEntry = new ZipEntry(entryPath);
                        zipOut.putNextEntry(zipEntry);
                        Files.copy(file, zipOut);
                        zipOut.closeEntry();
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            this.plugin.getLogger().info("Resource pack rebuilt successfully: " + this.resourcePackFile.getAbsolutePath());
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Error rebuilding resource pack: " + e.getMessage(), e);
        }
    }

    public File getResourcePackFile() {
        return this.resourcePackFile;
    }

    public String getResourcePackUrl() {
        return this.resourcePackUrl;
    }
}

