/*
 * Decompiled with CFR 0.152.
 */
package org.Little_100.projecte.managers;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.Little_100.projecte.Debug;
import org.Little_100.projecte.ProjectE;
import org.Little_100.projecte.compatibility.version.VersionAdapter;
import org.Little_100.projecte.devices.AlchemicalChest;
import org.Little_100.projecte.devices.DarkMatterFurnace;
import org.Little_100.projecte.devices.EnergyCollector;
import org.Little_100.projecte.devices.EnergyCondenser;
import org.Little_100.projecte.devices.EnergyCondenserMK2;
import org.Little_100.projecte.devices.RedMatterFurnace;
import org.Little_100.projecte.storage.DatabaseManager;
import org.Little_100.projecte.util.Constants;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.CookingRecipe;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class EmcManager {
    private final ProjectE plugin;
    private final DatabaseManager databaseManager;
    private final VersionAdapter versionAdapter;
    private final String recipeConflictStrategy;
    private final String divisionStrategy;
    private final Set<String> currentlyCalculating = new HashSet<String>();

    public EmcManager(ProjectE plugin) {
        this.plugin = plugin;
        this.databaseManager = plugin.getDatabaseManager();
        this.versionAdapter = plugin.getVersionAdapter();
        this.recipeConflictStrategy = plugin.getConfig().getString("gui.EMC.recipeConflictStrategy", "lowest").toLowerCase();
        this.divisionStrategy = plugin.getConfig().getString("gui.EMC.divisionStrategy", "floor").toLowerCase();
        File customEmcFile = new File(plugin.getDataFolder(), "custommoditememc.yml");
        if (!customEmcFile.exists()) {
            plugin.getLogger().info("custommoditememc.yml not found, creating default file.");
            plugin.saveResource("custommoditememc.yml", false);
        }
    }

    public void calculateAndStoreEmcValues(boolean forceRecalculate) {
        if (!forceRecalculate && this.databaseManager.hasEmcValues()) {
            this.plugin.getLogger().info("EMC values already exist in the database. Skipping calculation.");
            return;
        }
        if (forceRecalculate) {
            this.databaseManager.clearEmcValues();
        }
        this.plugin.getLogger().info("Start calculating EMC values...");
        this.versionAdapter.loadInitialEmcValues();
        for (int i = 0; i < 10; ++i) {
            this.plugin.getLogger().info("EMC calculation iteration " + (i + 1) + "...");
            boolean changed = false;
            Iterator recipeIterator = Bukkit.recipeIterator();
            while (recipeIterator.hasNext()) {
                try {
                    Recipe recipe = (Recipe)recipeIterator.next();
                    if (!this.calculateEmcForRecipe(recipe)) continue;
                    changed = true;
                }
                catch (Exception exception) {}
            }
            if (changed) continue;
            this.plugin.getLogger().info("EMC values stabilized, calculation ended early.");
            break;
        }
        this.plugin.getLogger().info("EMC value calculation completed.");
    }

    private boolean calculateEmcForRecipe(Recipe recipe) {
        ItemStack result = recipe.getResult();
        if (result.getType().isAir()) {
            return false;
        }
        NamespacedKey key = null;
        if (recipe instanceof ShapedRecipe) {
            key = ((ShapedRecipe)recipe).getKey();
        } else if (recipe instanceof ShapelessRecipe) {
            key = ((ShapelessRecipe)recipe).getKey();
        } else if (recipe instanceof CookingRecipe) {
            key = ((CookingRecipe)recipe).getKey();
        }
        if (key != null && key.getNamespace().equalsIgnoreCase("projecte")) {
            return false;
        }
        String resultKey = this.getItemKey(result);
        long existingEmc = this.getEmc(resultKey);
        long newEmc = this.versionAdapter.calculateRecipeEmc(recipe, this.divisionStrategy);
        if (newEmc <= 0L) {
            return false;
        }
        if (existingEmc <= 0L) {
            this.databaseManager.setEmc(resultKey, newEmc);
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("item", resultKey);
            placeholders.put("emc", String.valueOf(newEmc));
            Debug.log("debug.emc.item_emc_info", placeholders);
            return true;
        }
        boolean updated = false;
        if ("lowest".equals(this.recipeConflictStrategy) && newEmc < existingEmc) {
            this.databaseManager.setEmc(resultKey, newEmc);
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("item", resultKey);
            placeholders.put("emc", String.valueOf(newEmc));
            Debug.log("debug.emc.item_emc_info", placeholders);
            updated = true;
        } else if ("highest".equals(this.recipeConflictStrategy) && newEmc > existingEmc) {
            this.databaseManager.setEmc(resultKey, newEmc);
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("item", resultKey);
            placeholders.put("emc", String.valueOf(newEmc));
            Debug.log("debug.emc.item_emc_info", placeholders);
            updated = true;
        }
        return updated;
    }

    public long getEmc(ItemStack item) {
        if (item == null || item.getType().isAir()) {
            return 0L;
        }
        if (!this.hasOnlyEnchantments(item)) {
            String fullKey = this.getItemKey(item);
            long customEmc = this.getEmc(fullKey);
            if (customEmc > 0L) {
                return this.applyDurabilityModifier(item, customEmc);
            }
            return 0L;
        }
        String baseKey = this.versionAdapter.getItemKey(item);
        long baseEmc = this.getEmc(baseKey);
        if (baseEmc <= 0L) {
            return 0L;
        }
        return this.applyDurabilityModifier(item, baseEmc);
    }

    public long getEmc(String itemKey) {
        long emc = this.databaseManager.getEmc(itemKey);
        if (emc > 0L) {
            return emc;
        }
        if (this.currentlyCalculating.contains(itemKey)) {
            return 0L;
        }
        this.currentlyCalculating.add(itemKey);
        long lowestEmc = -1L;
        Iterator recipeIterator = Bukkit.recipeIterator();
        while (recipeIterator.hasNext()) {
            try {
                long calculatedEmc;
                Recipe recipe = (Recipe)recipeIterator.next();
                ItemStack result = recipe.getResult();
                NamespacedKey key = null;
                if (recipe instanceof ShapedRecipe) {
                    key = ((ShapedRecipe)recipe).getKey();
                } else if (recipe instanceof ShapelessRecipe) {
                    key = ((ShapelessRecipe)recipe).getKey();
                } else if (recipe instanceof CookingRecipe) {
                    key = ((CookingRecipe)recipe).getKey();
                }
                if (key != null && key.getNamespace().equalsIgnoreCase("projecte") || !this.getItemKey(result).equals(itemKey) || (calculatedEmc = this.versionAdapter.calculateRecipeEmc(recipe, this.divisionStrategy)) <= 0L || lowestEmc != -1L && calculatedEmc >= lowestEmc) continue;
                lowestEmc = calculatedEmc;
            }
            catch (Exception exception) {}
        }
        this.currentlyCalculating.remove(itemKey);
        if (lowestEmc > 0L) {
            this.databaseManager.setEmc(itemKey, lowestEmc);
            return lowestEmc;
        }
        return 0L;
    }

    public String getItemKey(ItemStack item) {
        ItemMeta meta;
        if (item == null || item.getType().isAir()) {
            return "minecraft:air";
        }
        if (item.hasItemMeta() && (meta = item.getItemMeta()) != null) {
            String levelName;
            int level;
            PersistentDataContainer container = meta.getPersistentDataContainer();
            if (container.has(Constants.ID_KEY, PersistentDataType.STRING)) {
                String projecteId = (String)container.get(Constants.ID_KEY, PersistentDataType.STRING);
                if ("transmutation_tablet_book".equals(projecteId)) {
                    if (meta.hasCustomModelData() && meta.getCustomModelData() == 1) {
                        return "projecte:" + projecteId;
                    }
                } else {
                    return "projecte:" + projecteId;
                }
            }
            if (container.has(Constants.KLEIN_STAR_KEY, PersistentDataType.INTEGER) && (level = ((Integer)container.get(Constants.KLEIN_STAR_KEY, PersistentDataType.INTEGER)).intValue()) > 0 && (levelName = this.getLevelName(level)) != null) {
                return "projecte:klein_star_" + levelName;
            }
            if (container.has(DarkMatterFurnace.KEY, PersistentDataType.BYTE)) {
                return "projecte:dark_matter_furnace";
            }
            if (container.has(RedMatterFurnace.KEY, PersistentDataType.BYTE)) {
                return "projecte:red_matter_furnace";
            }
            if (container.has(AlchemicalChest.KEY, PersistentDataType.BYTE)) {
                return "projecte:alchemical_chest";
            }
            if (container.has(EnergyCondenser.KEY, PersistentDataType.BYTE)) {
                return "projecte:energy_condenser";
            }
            if (container.has(EnergyCondenserMK2.KEY, PersistentDataType.BYTE)) {
                return "projecte:energy_condenser_mk2";
            }
            if (container.has(EnergyCollector.KEY_MK1, PersistentDataType.BYTE)) {
                return "projecte:energy_collector_mk1";
            }
            if (container.has(EnergyCollector.KEY_MK2, PersistentDataType.BYTE)) {
                return "projecte:energy_collector_mk2";
            }
            if (container.has(EnergyCollector.KEY_MK3, PersistentDataType.BYTE)) {
                return "projecte:energy_collector_mk3";
            }
            Set keys = container.getKeys();
            if (!keys.isEmpty()) {
                for (NamespacedKey key : keys) {
                    String customId;
                    String keyName = key.getKey().toLowerCase();
                    if (!keyName.equals("id") && !keyName.equals("item_id") && !keyName.equals("custom_id") || !container.has(key, PersistentDataType.STRING) || (customId = (String)container.get(key, PersistentDataType.STRING)) == null || customId.isEmpty()) continue;
                    return key.getNamespace() + ":" + customId;
                }
                for (NamespacedKey key : keys) {
                    String value;
                    if (key.getNamespace().equals("projecte") || !container.has(key, PersistentDataType.STRING) || (value = (String)container.get(key, PersistentDataType.STRING)) == null || value.isEmpty()) continue;
                    return key.toString().replace(":", "_") + "_" + value;
                }
            }
        }
        return this.versionAdapter.getItemKey(item);
    }

    public String getEffectiveItemKey(ItemStack item) {
        if (this.hasOnlyEnchantments(item)) {
            return this.versionAdapter.getItemKey(item);
        }
        return this.getItemKey(item);
    }

    public String getSpecificItemKey(ItemStack item) {
        return this.getItemKey(item);
    }

    public boolean isPdcItem(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return false;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        return !container.getKeys().isEmpty();
    }

    private boolean hasOnlyEnchantments(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return true;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return true;
        }
        if (!meta.getPersistentDataContainer().getKeys().isEmpty()) {
            return false;
        }
        if (meta.hasCustomModelData()) {
            return false;
        }
        if (meta.hasDisplayName()) {
            return false;
        }
        return !meta.hasLore();
    }

    private long applyDurabilityModifier(ItemStack item, long baseEmc) {
        if (item == null || !item.hasItemMeta()) {
            return baseEmc;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return baseEmc;
        }
        if (meta instanceof Damageable) {
            Damageable damageable = (Damageable)meta;
            short maxDurability = item.getType().getMaxDurability();
            if (maxDurability > 0 && damageable.hasDamage()) {
                int damage = damageable.getDamage();
                int currentDurability = maxDurability - damage;
                double durabilityPercent = (double)currentDurability / (double)maxDurability;
                return (long)((double)baseEmc * durabilityPercent);
            }
        }
        return baseEmc;
    }

    private String getLevelName(int level) {
        switch (level) {
            case 1: {
                return "ein";
            }
            case 2: {
                return "zwei";
            }
            case 3: {
                return "drei";
            }
            case 4: {
                return "vier";
            }
            case 5: {
                return "sphere";
            }
            case 6: {
                return "omega";
            }
        }
        return null;
    }

    public long getBaseEmc(ItemStack item) {
        String baseKey = this.versionAdapter.getItemKey(item);
        return this.getEmc(baseKey);
    }

    public String getPdcId(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return null;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return null;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        NamespacedKey idKey = Constants.ID_KEY;
        return (String)container.get(idKey, PersistentDataType.STRING);
    }

    public void registerEmc(String itemKey, long emcValue) {
        this.databaseManager.setEmc(itemKey, emcValue);
    }

    public void setEmcValue(ItemStack item, long emc) {
        if (item == null) {
            return;
        }
        String key = this.getItemKey(item);
        this.databaseManager.setEmc(key, emc);
    }

    public void recalculateDefaultEmcValues() {
        this.plugin.getLogger().info("Start calculating default items EMC values...");
        this.versionAdapter.loadInitialEmcValues();
        for (int i = 0; i < 10; ++i) {
            this.plugin.getLogger().info("Default EMC calculation iteration " + (i + 1) + "...");
            boolean changed = false;
            Iterator recipeIterator = Bukkit.recipeIterator();
            while (recipeIterator.hasNext()) {
                try {
                    Recipe recipe = (Recipe)recipeIterator.next();
                    if (recipe.getResult() != null && this.isPdcItem(recipe.getResult()) || !this.calculateEmcForRecipe(recipe)) continue;
                    changed = true;
                }
                catch (Exception exception) {}
            }
            if (changed) continue;
            this.plugin.getLogger().info("Default EMC values stabilized, calculation ended early.");
            break;
        }
        this.plugin.getLogger().info("Default items EMC value calculation completed.");
    }

    public int recalculatePdcEmcValues() {
        this.plugin.getLogger().info("Start calculating PDC items EMC values...");
        boolean debug = this.plugin.getConfig().getBoolean("debug");
        int pdcRecipesFound = 0;
        HashSet<String> calculatedItems = new HashSet<String>();
        Iterator recipeIterator = Bukkit.recipeIterator();
        while (recipeIterator.hasNext()) {
            try {
                Recipe recipe = (Recipe)recipeIterator.next();
                if (recipe.getResult() == null || recipe.getResult().getType().isAir() || !this.isPdcItem(recipe.getResult())) continue;
                ++pdcRecipesFound;
            }
            catch (Exception recipe) {}
        }
        if (pdcRecipesFound == 0) {
            this.plugin.getLogger().info("No PDC recipes found. Skipping PDC EMC calculation.");
            return 0;
        }
        this.plugin.getLogger().info("Found " + pdcRecipesFound + " PDC recipes. Starting EMC calculation...");
        for (int i = 0; i < 5; ++i) {
            this.plugin.getLogger().info("PDC EMC calculation iteration " + (i + 1) + "...");
            boolean changed = false;
            this.currentlyCalculating.clear();
            recipeIterator = Bukkit.recipeIterator();
            while (recipeIterator.hasNext()) {
                try {
                    Recipe recipe = (Recipe)recipeIterator.next();
                    if (recipe.getResult() == null || recipe.getResult().getType().isAir() || !this.isPdcItem(recipe.getResult())) continue;
                    String itemKey = this.getItemKey(recipe.getResult());
                    long oldEmc = this.databaseManager.getEmc(itemKey);
                    long recipeEmc = this.versionAdapter.calculateRecipeEmc(recipe, this.divisionStrategy);
                    if (debug && recipeEmc == 0L && oldEmc == 0L) {
                        this.plugin.getLogger().warning("[PDC EMC Debug] Cannot calculate EMC for: " + itemKey);
                        this.plugin.getLogger().warning("  Recipe type: " + recipe.getClass().getSimpleName());
                        if (recipe instanceof ShapedRecipe) {
                            this.plugin.getLogger().warning("  Ingredients:");
                            ShapedRecipe shaped = (ShapedRecipe)recipe;
                            for (ItemStack ingredient : shaped.getIngredientMap().values()) {
                                if (ingredient == null || ingredient.getType().isAir()) continue;
                                ingKey = this.getItemKey(ingredient);
                                ingEmc = this.databaseManager.getEmc(ingKey);
                                this.plugin.getLogger().warning("    - " + ingKey + ": " + ingEmc + " EMC");
                            }
                        } else if (recipe instanceof ShapelessRecipe) {
                            this.plugin.getLogger().warning("  Ingredients:");
                            ShapelessRecipe shapeless = (ShapelessRecipe)recipe;
                            for (ItemStack ingredient : shapeless.getIngredientList()) {
                                if (ingredient == null || ingredient.getType().isAir()) continue;
                                ingKey = this.getItemKey(ingredient);
                                ingEmc = this.databaseManager.getEmc(ingKey);
                                this.plugin.getLogger().warning("    - " + ingKey + ": " + ingEmc + " EMC");
                            }
                        }
                    }
                    if (recipeEmc <= 0L) continue;
                    boolean shouldUpdate = false;
                    if (oldEmc <= 0L) {
                        shouldUpdate = true;
                    } else if ("lowest".equals(this.recipeConflictStrategy) && recipeEmc < oldEmc) {
                        shouldUpdate = true;
                    } else if ("highest".equals(this.recipeConflictStrategy) && recipeEmc > oldEmc) {
                        shouldUpdate = true;
                    }
                    if (!shouldUpdate) continue;
                    this.databaseManager.setEmc(itemKey, recipeEmc);
                    changed = true;
                    calculatedItems.add(itemKey);
                    if (!debug) continue;
                    this.plugin.getLogger().info("[PDC EMC Calculated] " + itemKey + " = " + recipeEmc + " EMC");
                }
                catch (Exception recipe) {}
            }
            if (changed) continue;
            this.plugin.getLogger().info("PDC EMC values stabilized, calculation ended early.");
            break;
        }
        this.plugin.getLogger().info("PDC items EMC calculation completed. " + calculatedItems.size() + " unique items calculated.");
        int uncalculatedCount = 0;
        recipeIterator = Bukkit.recipeIterator();
        while (recipeIterator.hasNext()) {
            try {
                String itemKey;
                long emc;
                Recipe recipe = (Recipe)recipeIterator.next();
                if (recipe.getResult() == null || recipe.getResult().getType().isAir() || !this.isPdcItem(recipe.getResult()) || (emc = this.databaseManager.getEmc(itemKey = this.getItemKey(recipe.getResult()))) > 0L) continue;
                ++uncalculatedCount;
                if (!debug) continue;
                this.plugin.getLogger().warning("[PDC EMC] Item without EMC: " + itemKey);
            }
            catch (Exception exception) {}
        }
        if (uncalculatedCount > 0) {
            this.plugin.getLogger().warning("Warning: " + uncalculatedCount + " PDC items still don't have EMC values.");
            this.plugin.getLogger().warning("This may be due to missing ingredient EMC or circular dependencies.");
            if (!debug) {
                this.plugin.getLogger().warning("Enable debug mode in config.yml to see which items are affected.");
            }
        }
        return calculatedItems.size();
    }
}

