/*
 * Decompiled with CFR 0.152.
 */
package org.Little_100.projecte.devices;

import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.Little_100.projecte.ProjectE;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class CondenserManager {
    private final ProjectE plugin;
    private final Map<Location, CondenserState> activeCondensers = new HashMap<Location, CondenserState>();
    private final Map<CondenserType, ItemStack[]> guiLayouts = new EnumMap<CondenserType, ItemStack[]>(CondenserType.class);
    private final Map<CondenserType, List<Integer>> inputSlots = new EnumMap<CondenserType, List<Integer>>(CondenserType.class);
    private final Map<CondenserType, Integer> targetSlot = new EnumMap<CondenserType, Integer>(CondenserType.class);
    private final Map<CondenserType, List<Integer>> outputSlots = new EnumMap<CondenserType, List<Integer>>(CondenserType.class);
    private final Map<CondenserType, Integer> emcDisplaySlot = new EnumMap<CondenserType, Integer>(CondenserType.class);
    private final Map<CondenserType, List<Integer>> progressBarSlots = new EnumMap<CondenserType, List<Integer>>(CondenserType.class);
    private final Map<CondenserType, List<Integer>> nonInteractiveSlots = new EnumMap<CondenserType, List<Integer>>(CondenserType.class);
    private long tickCounter = 0L;

    public CondenserManager(ProjectE plugin) {
        this.plugin = plugin;
        this.loadGuiLayouts();
        this.startUpdateTask();
    }

    private void loadGuiLayouts() {
        for (CondenserType type : CondenserType.values()) {
            String fileName = type == CondenserType.ENERGY_CONDENSER ? "condenser.yml" : "condenser_mk2.yml";
            try (InputStreamReader reader = new InputStreamReader(Objects.requireNonNull(this.plugin.getResource(fileName)));){
                YamlConfiguration config = YamlConfiguration.loadConfiguration((Reader)reader);
                int size = config.getInt("size", 54);
                if (size > 54 || size % 9 != 0) {
                    this.plugin.getLogger().warning("Invalid size " + size + " in " + fileName + ". Defaulting to 54.");
                    size = 54;
                }
                ItemStack[] layout = new ItemStack[size];
                ArrayList<Integer> currentInput = new ArrayList<Integer>();
                ArrayList<Integer> currentOutput = new ArrayList<Integer>();
                ArrayList<Integer> currentProgressBar = new ArrayList<Integer>();
                ArrayList<Integer> currentNonInteractive = new ArrayList<Integer>();
                HashSet<Integer> definedSlots = new HashSet<Integer>();
                ConfigurationSection itemsSection = config.getConfigurationSection("items");
                if (itemsSection != null) {
                    for (String key : itemsSection.getKeys(false)) {
                        int slot = Integer.parseInt(key);
                        definedSlots.add(slot);
                        String materialName = itemsSection.getString(key + ".material");
                        Material material = Material.getMaterial((String)materialName);
                        if (material == null) continue;
                        ItemStack item = new ItemStack(material);
                        ItemMeta meta = item.getItemMeta();
                        String name = itemsSection.getString(key + ".name");
                        if (meta != null) {
                            if ("null".equalsIgnoreCase(name)) {
                                meta.setDisplayName(" ");
                            } else if (name != null) {
                                meta.setDisplayName(name);
                            }
                            item.setItemMeta(meta);
                        }
                        layout[slot] = item;
                        if ("targetitem".equalsIgnoreCase(name)) {
                            this.targetSlot.put(type, slot);
                            continue;
                        }
                        if (material == Material.ARROW) {
                            this.emcDisplaySlot.put(type, slot);
                            currentNonInteractive.add(slot);
                            continue;
                        }
                        if ("progressbar".equalsIgnoreCase(name)) {
                            currentProgressBar.add(slot);
                            currentNonInteractive.add(slot);
                            continue;
                        }
                        if (!"null".equalsIgnoreCase(name)) continue;
                        currentNonInteractive.add(slot);
                    }
                }
                for (int i = 0; i < size; ++i) {
                    if (definedSlots.contains(i)) continue;
                    currentInput.add(i);
                    currentOutput.add(i);
                }
                this.guiLayouts.put(type, layout);
                this.inputSlots.put(type, currentInput);
                this.outputSlots.put(type, currentOutput);
                this.progressBarSlots.put(type, currentProgressBar);
                this.nonInteractiveSlots.put(type, currentNonInteractive);
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Could not load GUI layout: " + fileName);
                e.printStackTrace();
            }
        }
    }

    private void startUpdateTask() {
        this.plugin.getSchedulerAdapter().runTimer(() -> {
            ++this.tickCounter;
            this.activeCondensers.forEach((location, state) -> {
                if (state.getType() == CondenserType.ENERGY_CONDENSER) {
                    if (this.tickCounter % 2L == 0L) {
                        this.tick((Location)location, (CondenserState)state);
                    }
                } else if (state.getType() == CondenserType.ENERGY_CONDENSER_MK2) {
                    this.tick((Location)location, (CondenserState)state);
                }
            });
        }, 0L, 1L);
    }

    public void addCondenser(Location location, UUID owner, CondenserType type, UUID armorStandId) {
        String titleKey = type == CondenserType.ENERGY_CONDENSER ? "gui.condenser.title" : "gui.condenser_mk2.title";
        String title = this.plugin.getLanguageManager().get(titleKey);
        int size = 54;
        Inventory inventory = Bukkit.createInventory(null, (int)size, (String)title);
        ItemStack[] layout = this.guiLayouts.get((Object)type);
        if (layout != null) {
            ItemStack[] finalLayout = new ItemStack[layout.length];
            for (int i = 0; i < layout.length; ++i) {
                finalLayout[i] = layout[i] != null && layout[i].getType() == Material.BARRIER ? null : layout[i];
            }
            inventory.setContents(finalLayout);
        }
        CondenserState state = new CondenserState(owner, inventory, type, armorStandId);
        this.activeCondensers.put(location, state);
    }

    public void removeCondenser(Location location) {
        this.activeCondensers.remove(location);
    }

    public CondenserState getCondenserState(Location location) {
        return this.activeCondensers.get(location);
    }

    public Map<Location, CondenserState> getActiveCondensers() {
        return this.activeCondensers;
    }

    public boolean isCondenser(Location location) {
        return this.activeCondensers.containsKey(location);
    }

    public void openCondenserGUI(Player player, Location location) {
        CondenserState state = this.getCondenserState(location);
        if (state != null) {
            player.openInventory(state.getInventory());
        }
    }

    public boolean isNonInteractive(CondenserType type, int slot) {
        return this.nonInteractiveSlots.getOrDefault((Object)type, Collections.emptyList()).contains(slot);
    }

    public boolean isTargetSlot(CondenserType type, int slot) {
        return this.targetSlot.get((Object)type) != null && this.targetSlot.get((Object)type) == slot;
    }

    private void tick(Location location, CondenserState state) {
        Inventory inv = state.getInventory();
        CondenserType type = state.getType();
        Integer targetSlotIndex = this.targetSlot.get((Object)type);
        if (targetSlotIndex == null) {
            return;
        }
        ItemStack targetItem = inv.getItem(targetSlotIndex.intValue());
        if (targetItem != null && targetItem.getAmount() > 0) {
            long targetEmc;
            int itemsToProcess = type == CondenserType.ENERGY_CONDENSER ? 1 : 6;
            int itemsProcessed = 0;
            Iterator iterator = this.inputSlots.getOrDefault((Object)type, Collections.emptyList()).iterator();
            while (iterator.hasNext()) {
                int slot = (Integer)iterator.next();
                if (itemsProcessed >= itemsToProcess) break;
                ItemStack item = inv.getItem(slot);
                if (item == null || item.isSimilar(targetItem)) continue;
                long emc = this.plugin.getEmcManager().getEmc(item);
                if (emc > 0L) {
                    state.addEmc(emc * (long)item.getAmount());
                    inv.setItem(slot, null);
                    itemsProcessed += item.getAmount();
                    continue;
                }
                inv.setItem(slot, null);
                for (HumanEntity viewer : new ArrayList(inv.getViewers())) {
                    Player player;
                    HashMap remaining;
                    if (!(viewer instanceof Player) || (remaining = (player = (Player)viewer).getInventory().addItem(new ItemStack[]{item})).isEmpty()) continue;
                    for (ItemStack remainingItem : remaining.values()) {
                        location.getWorld().dropItemNaturally(location, remainingItem);
                    }
                }
            }
            if ((targetEmc = this.plugin.getEmcManager().getEmc(targetItem)) > 0L && state.getStoredEmc() >= targetEmc) {
                this.produceItem(state, targetItem, targetEmc);
            }
        }
        this.updateEmcDisplay(inv, state);
        this.updateProgressBar(inv, state);
    }

    private void produceItem(CondenserState state, ItemStack targetItem, long targetEmc) {
        List availableSlots = this.outputSlots.getOrDefault((Object)state.getType(), Collections.emptyList());
        while (state.getStoredEmc() >= targetEmc) {
            boolean stacked = false;
            Iterator iterator = availableSlots.iterator();
            while (iterator.hasNext()) {
                int slot = (Integer)iterator.next();
                ItemStack currentItem = state.getInventory().getItem(slot);
                if (currentItem == null || !currentItem.isSimilar(targetItem) || currentItem.getAmount() >= currentItem.getMaxStackSize()) continue;
                currentItem.setAmount(currentItem.getAmount() + 1);
                state.removeEmc(targetEmc);
                stacked = true;
                break;
            }
            if (stacked) continue;
            boolean placedInNewSlot = false;
            Iterator iterator2 = availableSlots.iterator();
            while (iterator2.hasNext()) {
                int slot = (Integer)iterator2.next();
                if (state.getInventory().getItem(slot) != null) continue;
                ItemStack newItem = targetItem.clone();
                newItem.setAmount(1);
                state.getInventory().setItem(slot, newItem);
                state.removeEmc(targetEmc);
                placedInNewSlot = true;
                break;
            }
            if (placedInNewSlot) continue;
            break;
        }
    }

    private void updateEmcDisplay(Inventory inv, CondenserState state) {
        Integer displaySlot = this.emcDisplaySlot.get((Object)state.getType());
        if (displaySlot == null) {
            return;
        }
        ItemStack displayItem = inv.getItem(displaySlot.intValue());
        if (displayItem == null) {
            return;
        }
        ItemMeta meta = displayItem.getItemMeta();
        if (meta == null) {
            return;
        }
        Integer targetSlotIndex = this.targetSlot.get((Object)state.getType());
        ItemStack targetItem = targetSlotIndex != null ? inv.getItem(targetSlotIndex.intValue()) : null;
        long targetEmc = targetItem != null ? this.plugin.getEmcManager().getEmc(targetItem) : 0L;
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("emc", String.format("%,d", state.getStoredEmc()));
        meta.setDisplayName(this.plugin.getLanguageManager().get("gui.condenser.emc_display", placeholders));
        ArrayList<String> lore = new ArrayList<String>();
        if (targetEmc > 0L) {
            double progress;
            long remainingEmc = targetEmc - state.getStoredEmc();
            if (remainingEmc < 0L) {
                remainingEmc = 0L;
            }
            if ((progress = (double)state.getStoredEmc() / (double)targetEmc * 100.0) > 100.0) {
                progress = 100.0;
            }
            HashMap<String, String> lorePlaceholders = new HashMap<String, String>();
            lorePlaceholders.put("value", String.format("%,d", targetEmc));
            lore.add(this.plugin.getLanguageManager().get("gui.condenser.target_emc", lorePlaceholders));
            lorePlaceholders.put("value", String.format("%,d", remainingEmc));
            lore.add(this.plugin.getLanguageManager().get("gui.condenser.remaining_emc", lorePlaceholders));
            lorePlaceholders.put("value", String.format("%.2f%%", progress));
            lore.add(this.plugin.getLanguageManager().get("gui.condenser.progress", lorePlaceholders));
        }
        meta.setLore(lore);
        displayItem.setItemMeta(meta);
    }

    private void updateProgressBar(Inventory inv, CondenserState state) {
        long targetEmc;
        List<Integer> pBarSlots = this.progressBarSlots.get((Object)state.getType());
        if (pBarSlots == null || pBarSlots.isEmpty()) {
            return;
        }
        Integer targetSlotIndex = this.targetSlot.get((Object)state.getType());
        ItemStack targetItem = targetSlotIndex != null ? inv.getItem(targetSlotIndex.intValue()) : null;
        long l = targetEmc = targetItem != null ? this.plugin.getEmcManager().getEmc(targetItem) : 0L;
        if (targetEmc <= 0L) {
            for (int slot : pBarSlots) {
                ItemStack pane = inv.getItem(slot);
                if (pane == null) continue;
                pane.setType(Material.BLACK_STAINED_GLASS_PANE);
            }
            return;
        }
        double progress = (double)state.getStoredEmc() / (double)targetEmc;
        if (progress > 1.0) {
            progress = 1.0;
        }
        int greenPanes = (int)Math.floor(progress * (double)pBarSlots.size());
        for (int i = 0; i < pBarSlots.size(); ++i) {
            int slot = pBarSlots.get(i);
            ItemStack pane = inv.getItem(slot);
            if (pane == null) continue;
            if (i < greenPanes) {
                pane.setType(Material.LIME_STAINED_GLASS_PANE);
                continue;
            }
            pane.setType(Material.BLACK_STAINED_GLASS_PANE);
        }
    }

    public static enum CondenserType {
        ENERGY_CONDENSER,
        ENERGY_CONDENSER_MK2;

    }

    public static class CondenserState {
        private final UUID owner;
        private final Inventory inventory;
        private final CondenserType type;
        private final UUID armorStandId;
        private long storedEmc = 0L;
        private int progress = 0;

        public CondenserState(UUID owner, Inventory inventory, CondenserType type, UUID armorStandId) {
            this.owner = owner;
            this.inventory = inventory;
            this.type = type;
            this.armorStandId = armorStandId;
        }

        public Inventory getInventory() {
            return this.inventory;
        }

        public CondenserType getType() {
            return this.type;
        }

        public long getStoredEmc() {
            return this.storedEmc;
        }

        public void setStoredEmc(long storedEmc) {
            this.storedEmc = storedEmc;
        }

        public void addEmc(long amount) {
            this.storedEmc += amount;
        }

        public void removeEmc(long amount) {
            this.storedEmc -= amount;
        }

        public int getProgress() {
            return this.progress;
        }

        public void setProgress(int progress) {
            this.progress = progress;
        }
    }
}

