/*
 * Decompiled with CFR 0.152.
 */
package org.Little_100.projecte.devices;

import java.util.Collection;
import java.util.List;
import org.Little_100.projecte.ProjectE;
import org.Little_100.projecte.devices.AlchemicalChest;
import org.Little_100.projecte.devices.CondenserManager;
import org.Little_100.projecte.devices.DarkMatterFurnace;
import org.Little_100.projecte.devices.EnergyCollector;
import org.Little_100.projecte.devices.EnergyCondenser;
import org.Little_100.projecte.devices.EnergyCondenserMK2;
import org.Little_100.projecte.devices.FurnaceManager;
import org.Little_100.projecte.devices.RedMatterFurnace;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;

public class DeviceListener
implements Listener {
    private final ProjectE plugin;

    public DeviceListener(ProjectE plugin) {
        this.plugin = plugin;
    }

    private boolean isCustomDevice(Block block) {
        Collection nearbyEntities = block.getWorld().getNearbyEntities(block.getLocation().add(0.5, 0.5, 0.5), 0.5, 1.0, 0.5, entity -> entity instanceof ArmorStand);
        for (Entity entity2 : nearbyEntities) {
            if (!entity2.getPersistentDataContainer().has(DarkMatterFurnace.KEY, PersistentDataType.BYTE) && !entity2.getPersistentDataContainer().has(RedMatterFurnace.KEY, PersistentDataType.BYTE) && !entity2.getPersistentDataContainer().has(AlchemicalChest.KEY, PersistentDataType.BYTE) && !entity2.getPersistentDataContainer().has(EnergyCondenser.KEY, PersistentDataType.BYTE) && !entity2.getPersistentDataContainer().has(EnergyCondenserMK2.KEY, PersistentDataType.BYTE) && !entity2.getPersistentDataContainer().has(EnergyCollector.KEY_MK1, PersistentDataType.BYTE) && !entity2.getPersistentDataContainer().has(EnergyCollector.KEY_MK2, PersistentDataType.BYTE) && !entity2.getPersistentDataContainer().has(EnergyCollector.KEY_MK3, PersistentDataType.BYTE)) continue;
            return true;
        }
        return false;
    }

    @EventHandler
    public void onPistonExtend(BlockPistonExtendEvent event) {
        List blocks = event.getBlocks();
        for (Block block : blocks) {
            if (!this.isCustomDevice(block)) continue;
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler
    public void onPistonRetract(BlockPistonRetractEvent event) {
        List blocks = event.getBlocks();
        for (Block block : blocks) {
            if (!this.isCustomDevice(block)) continue;
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockPlace(BlockPlaceEvent event) {
        ItemStack itemInHand = event.getItemInHand();
        if (itemInHand.getItemMeta() == null) {
            return;
        }
        ItemMeta meta = itemInHand.getItemMeta();
        FurnaceManager.FurnaceType furnaceType = null;
        Integer collectorType = null;
        if (meta.getPersistentDataContainer().has(DarkMatterFurnace.KEY, PersistentDataType.BYTE)) {
            furnaceType = FurnaceManager.FurnaceType.DARK_MATTER;
        } else if (meta.getPersistentDataContainer().has(RedMatterFurnace.KEY, PersistentDataType.BYTE)) {
            furnaceType = FurnaceManager.FurnaceType.RED_MATTER;
        } else if (!(meta.getPersistentDataContainer().has(AlchemicalChest.KEY, PersistentDataType.BYTE) || meta.getPersistentDataContainer().has(EnergyCondenser.KEY, PersistentDataType.BYTE) || meta.getPersistentDataContainer().has(EnergyCondenserMK2.KEY, PersistentDataType.BYTE))) {
            if (meta.getPersistentDataContainer().has(EnergyCollector.KEY_MK1, PersistentDataType.BYTE)) {
                collectorType = 1;
            } else if (meta.getPersistentDataContainer().has(EnergyCollector.KEY_MK2, PersistentDataType.BYTE)) {
                collectorType = 2;
            } else if (meta.getPersistentDataContainer().has(EnergyCollector.KEY_MK3, PersistentDataType.BYTE)) {
                collectorType = 3;
            }
        }
        if (furnaceType != null || collectorType != null || meta.getPersistentDataContainer().has(AlchemicalChest.KEY, PersistentDataType.BYTE) || meta.getPersistentDataContainer().has(EnergyCondenser.KEY, PersistentDataType.BYTE) || meta.getPersistentDataContainer().has(EnergyCondenserMK2.KEY, PersistentDataType.BYTE)) {
            Block block = event.getBlock();
            Player player = event.getPlayer();
            Location location = block.getLocation();
            FurnaceManager.FurnaceType finalFurnaceType = furnaceType;
            Integer finalCollectorType = collectorType;
            block.setType(Material.BEACON);
            this.plugin.getSchedulerAdapter().runTaskAt(location, () -> {
                ArmorStand armorStand = (ArmorStand)location.getWorld().spawnEntity(location.clone().add(0.5, -0.39, 0.5), EntityType.ARMOR_STAND);
                armorStand.setVisible(false);
                armorStand.setGravity(false);
                armorStand.setSmall(true);
                armorStand.setMarker(true);
                float yaw = player.getLocation().getYaw();
                float roundedYaw = (float)Math.round(yaw / 90.0f) * 90.0f;
                armorStand.setRotation(roundedYaw, 0.0f);
                ItemStack deviceItem = itemInHand.clone();
                deviceItem.setAmount(1);
                armorStand.getEquipment().setHelmet(deviceItem);
                NamespacedKey key = null;
                if (finalFurnaceType == FurnaceManager.FurnaceType.DARK_MATTER) {
                    key = DarkMatterFurnace.KEY;
                } else if (finalFurnaceType == FurnaceManager.FurnaceType.RED_MATTER) {
                    key = RedMatterFurnace.KEY;
                } else if (meta.getPersistentDataContainer().has(AlchemicalChest.KEY, PersistentDataType.BYTE)) {
                    key = AlchemicalChest.KEY;
                } else if (meta.getPersistentDataContainer().has(EnergyCondenser.KEY, PersistentDataType.BYTE)) {
                    key = EnergyCondenser.KEY;
                } else if (meta.getPersistentDataContainer().has(EnergyCondenserMK2.KEY, PersistentDataType.BYTE)) {
                    key = EnergyCondenserMK2.KEY;
                } else if (finalCollectorType != null) {
                    key = EnergyCollector.getKey(finalCollectorType);
                }
                if (key != null) {
                    armorStand.getPersistentDataContainer().set(key, PersistentDataType.BYTE, (Object)1);
                }
                if (finalFurnaceType != null) {
                    this.plugin.getFurnaceManager().addFurnace(location, player.getUniqueId(), finalFurnaceType, armorStand.getUniqueId());
                } else if (meta.getPersistentDataContainer().has(AlchemicalChest.KEY, PersistentDataType.BYTE)) {
                    this.plugin.getAlchemicalChestManager().addChest(location, player.getUniqueId());
                } else if (finalCollectorType != null) {
                    this.plugin.getEnergyCollectorManager().addCollector(location, player.getUniqueId(), finalCollectorType, armorStand.getUniqueId());
                } else if (meta.getPersistentDataContainer().has(EnergyCondenser.KEY, PersistentDataType.BYTE)) {
                    this.plugin.getCondenserManager().addCondenser(location, player.getUniqueId(), CondenserManager.CondenserType.ENERGY_CONDENSER, armorStand.getUniqueId());
                } else if (meta.getPersistentDataContainer().has(EnergyCondenserMK2.KEY, PersistentDataType.BYTE)) {
                    this.plugin.getCondenserManager().addCondenser(location, player.getUniqueId(), CondenserManager.CondenserType.ENERGY_CONDENSER_MK2, armorStand.getUniqueId());
                }
            });
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        Block block = event.getBlock();
        if (block.getType() != Material.BEACON) {
            return;
        }
        Collection nearbyEntities = block.getWorld().getNearbyEntities(block.getLocation().add(0.5, 0.5, 0.5), 0.5, 1.0, 0.5, entity -> entity instanceof ArmorStand);
        for (Entity entity2 : nearbyEntities) {
            ItemMeta meta;
            ArmorStand armorStand;
            ItemStack helmet;
            if (!(entity2 instanceof ArmorStand) || (helmet = (armorStand = (ArmorStand)entity2).getEquipment().getHelmet()) == null || helmet.getItemMeta() == null || !(meta = helmet.getItemMeta()).getPersistentDataContainer().has(DarkMatterFurnace.KEY, PersistentDataType.BYTE) && !meta.getPersistentDataContainer().has(RedMatterFurnace.KEY, PersistentDataType.BYTE) && !meta.getPersistentDataContainer().has(AlchemicalChest.KEY, PersistentDataType.BYTE) && !meta.getPersistentDataContainer().has(EnergyCondenser.KEY, PersistentDataType.BYTE) && !meta.getPersistentDataContainer().has(EnergyCondenserMK2.KEY, PersistentDataType.BYTE) && !meta.getPersistentDataContainer().has(EnergyCollector.KEY_MK1, PersistentDataType.BYTE) && !meta.getPersistentDataContainer().has(EnergyCollector.KEY_MK2, PersistentDataType.BYTE) && !meta.getPersistentDataContainer().has(EnergyCollector.KEY_MK3, PersistentDataType.BYTE)) continue;
            if (meta.getPersistentDataContainer().has(DarkMatterFurnace.KEY, PersistentDataType.BYTE) || meta.getPersistentDataContainer().has(RedMatterFurnace.KEY, PersistentDataType.BYTE)) {
                this.plugin.getFurnaceManager().removeFurnace(block.getLocation());
            } else if (meta.getPersistentDataContainer().has(AlchemicalChest.KEY, PersistentDataType.BYTE)) {
                this.plugin.getAlchemicalChestManager().removeChest(block.getLocation());
            } else if (meta.getPersistentDataContainer().has(EnergyCollector.KEY_MK1, PersistentDataType.BYTE) || meta.getPersistentDataContainer().has(EnergyCollector.KEY_MK2, PersistentDataType.BYTE) || meta.getPersistentDataContainer().has(EnergyCollector.KEY_MK3, PersistentDataType.BYTE)) {
                this.plugin.getEnergyCollectorManager().removeCollector(block.getLocation());
            } else if (meta.getPersistentDataContainer().has(EnergyCondenser.KEY, PersistentDataType.BYTE) || meta.getPersistentDataContainer().has(EnergyCondenserMK2.KEY, PersistentDataType.BYTE)) {
                this.plugin.getCondenserManager().removeCondenser(block.getLocation());
            }
            armorStand.remove();
            block.getWorld().dropItemNaturally(block.getLocation(), helmet);
            block.setType(Material.AIR);
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Block clickedBlock = event.getClickedBlock();
        if (clickedBlock == null || clickedBlock.getType() != Material.BEACON) {
            return;
        }
        Collection nearbyEntities = clickedBlock.getWorld().getNearbyEntities(clickedBlock.getLocation().add(0.5, 0.5, 0.5), 0.5, 1.0, 0.5, entity -> entity instanceof ArmorStand);
        for (Entity entity2 : nearbyEntities) {
            Player player = event.getPlayer();
            if (entity2.getPersistentDataContainer().has(AlchemicalChest.KEY, PersistentDataType.BYTE)) {
                event.setCancelled(true);
                player.playSound(player.getLocation(), Sound.BLOCK_CHEST_OPEN, 1.0f, 1.0f);
                this.plugin.getAlchemicalChestManager().openChestGUI(player, clickedBlock.getLocation());
                return;
            }
            if (entity2.getPersistentDataContainer().has(EnergyCollector.KEY_MK1, PersistentDataType.BYTE) || entity2.getPersistentDataContainer().has(EnergyCollector.KEY_MK2, PersistentDataType.BYTE) || entity2.getPersistentDataContainer().has(EnergyCollector.KEY_MK3, PersistentDataType.BYTE)) {
                event.setCancelled(true);
                player.playSound(player.getLocation(), Sound.BLOCK_BEACON_ACTIVATE, 1.0f, 1.0f);
                this.plugin.getEnergyCollectorManager().openCollectorGUI(player, clickedBlock.getLocation());
                return;
            }
            if (entity2.getPersistentDataContainer().has(EnergyCondenser.KEY, PersistentDataType.BYTE)) {
                event.setCancelled(true);
                player.playSound(player.getLocation(), Sound.BLOCK_CHEST_OPEN, 1.0f, 1.0f);
                this.plugin.getCondenserManager().openCondenserGUI(player, clickedBlock.getLocation());
                return;
            }
            if (!entity2.getPersistentDataContainer().has(EnergyCondenserMK2.KEY, PersistentDataType.BYTE)) continue;
            event.setCancelled(true);
            player.playSound(player.getLocation(), Sound.BLOCK_CHEST_OPEN, 1.0f, 1.0f);
            this.plugin.getCondenserManager().openCondenserGUI(player, clickedBlock.getLocation());
            return;
        }
    }
}

