/*
 * Decompiled with CFR 0.152.
 */
package org.Little_100.projecte.devices;

import java.util.Collection;
import org.Little_100.projecte.ProjectE;
import org.Little_100.projecte.devices.AlchemicalChest;
import org.Little_100.projecte.devices.DarkMatterFurnace;
import org.Little_100.projecte.devices.EnergyCollector;
import org.Little_100.projecte.devices.EnergyCondenser;
import org.Little_100.projecte.devices.EnergyCondenserMK2;
import org.Little_100.projecte.devices.RedMatterFurnace;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class DeviceManager {
    private final ProjectE plugin;
    private DarkMatterFurnace darkMatterFurnace;
    private RedMatterFurnace redMatterFurnace;
    private AlchemicalChest alchemicalChest;
    private EnergyCondenser energyCondenser;
    private EnergyCondenserMK2 energyCondenserMK2;
    private EnergyCollector energyCollector;

    public DeviceManager(ProjectE plugin) {
        this.plugin = plugin;
    }

    public boolean isDevice(Block block) {
        if (block.getType() != Material.BEACON) {
            return false;
        }
        Collection nearbyEntities = block.getWorld().getNearbyEntities(block.getLocation().add(0.5, 0.5, 0.5), 0.5, 1.0, 0.5, entity -> entity instanceof ArmorStand);
        for (Entity entity2 : nearbyEntities) {
            if (!entity2.getPersistentDataContainer().has(DarkMatterFurnace.KEY, PersistentDataType.BYTE) && !entity2.getPersistentDataContainer().has(RedMatterFurnace.KEY, PersistentDataType.BYTE) && !entity2.getPersistentDataContainer().has(AlchemicalChest.KEY, PersistentDataType.BYTE) && !entity2.getPersistentDataContainer().has(EnergyCondenser.KEY, PersistentDataType.BYTE) && !entity2.getPersistentDataContainer().has(EnergyCondenserMK2.KEY, PersistentDataType.BYTE) && !entity2.getPersistentDataContainer().has(EnergyCollector.KEY_MK1, PersistentDataType.BYTE) && !entity2.getPersistentDataContainer().has(EnergyCollector.KEY_MK2, PersistentDataType.BYTE) && !entity2.getPersistentDataContainer().has(EnergyCollector.KEY_MK3, PersistentDataType.BYTE)) continue;
            return true;
        }
        return false;
    }

    public void registerDevices() {
        this.darkMatterFurnace = new DarkMatterFurnace(this.plugin);
        this.redMatterFurnace = new RedMatterFurnace(this.plugin);
        this.alchemicalChest = new AlchemicalChest(this.plugin);
        this.energyCondenser = new EnergyCondenser(this.plugin);
        this.energyCondenserMK2 = new EnergyCondenserMK2(this.plugin);
        this.energyCollector = new EnergyCollector(this.plugin);
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this.darkMatterFurnace, (Plugin)this.plugin);
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this.redMatterFurnace, (Plugin)this.plugin);
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this.alchemicalChest, (Plugin)this.plugin);
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this.energyCondenser, (Plugin)this.plugin);
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this.energyCondenserMK2, (Plugin)this.plugin);
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this.energyCollector, (Plugin)this.plugin);
    }

    public void reloadDeviceItems() {
        if (this.darkMatterFurnace != null) {
            this.darkMatterFurnace = new DarkMatterFurnace(this.plugin);
        }
        if (this.redMatterFurnace != null) {
            this.redMatterFurnace = new RedMatterFurnace(this.plugin);
        }
        if (this.alchemicalChest != null) {
            this.alchemicalChest = new AlchemicalChest(this.plugin);
        }
        if (this.energyCondenser != null) {
            this.energyCondenser = new EnergyCondenser(this.plugin);
        }
        if (this.energyCondenserMK2 != null) {
            this.energyCondenserMK2 = new EnergyCondenserMK2(this.plugin);
        }
        if (this.energyCollector != null) {
            this.energyCollector = new EnergyCollector(this.plugin);
        }
    }

    public ItemStack getDarkMatterFurnaceItem() {
        if (this.darkMatterFurnace == null) {
            return null;
        }
        return this.darkMatterFurnace.getFurnaceItem();
    }

    public ItemStack getRedMatterFurnaceItem() {
        if (this.redMatterFurnace == null) {
            return null;
        }
        return this.redMatterFurnace.getFurnaceItem();
    }

    public ItemStack getAlchemicalChestItem() {
        if (this.alchemicalChest == null) {
            return null;
        }
        return this.alchemicalChest.getChestItem();
    }

    public ItemStack getEnergyCondenserItem() {
        if (this.energyCondenser == null) {
            return null;
        }
        return this.energyCondenser.getCondenserItem();
    }

    public ItemStack getEnergyCondenserMK2Item() {
        if (this.energyCondenserMK2 == null) {
            return null;
        }
        return this.energyCondenserMK2.getCondenserMK2Item();
    }

    public DarkMatterFurnace getDarkMatterFurnace() {
        return this.darkMatterFurnace;
    }

    public RedMatterFurnace getRedMatterFurnace() {
        return this.redMatterFurnace;
    }

    public AlchemicalChest getAlchemicalChest() {
        return this.alchemicalChest;
    }

    public EnergyCondenser getEnergyCondenser() {
        return this.energyCondenser;
    }

    public EnergyCondenserMK2 getEnergyCondenserMK2() {
        return this.energyCondenserMK2;
    }

    public ItemStack getEnergyCollectorItem(int type) {
        if (this.energyCollector == null) {
            return null;
        }
        return this.energyCollector.getCollectorItem(type);
    }

    public EnergyCollector getEnergyCollector() {
        return this.energyCollector;
    }
}

