/*
 * Decompiled with CFR 0.152.
 */
package org.Little_100.projecte.listeners;

import java.util.HashMap;
import java.util.logging.Level;
import org.Little_100.projecte.Debug;
import org.Little_100.projecte.ProjectE;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.ItemStack;

public class CraftingListener
implements Listener {
    private final ProjectE plugin;

    public CraftingListener(ProjectE plugin) {
        this.plugin = plugin;
        Bukkit.getLogger().info("[ProjectE] CraftingListener initialized - Final Version");
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onCraftItem(InventoryClickEvent event) {
        if (event.getSlotType() != InventoryType.SlotType.RESULT) {
            return;
        }
        if (!(event.getInventory() instanceof CraftingInventory)) {
            return;
        }
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        CraftingInventory inventory = (CraftingInventory)event.getInventory();
        boolean hasPhilosopherStone = false;
        for (ItemStack item : inventory.getMatrix()) {
            if (!this.plugin.isPhilosopherStone(item)) continue;
            hasPhilosopherStone = true;
            break;
        }
        if (!hasPhilosopherStone) {
            return;
        }
        ItemStack result = inventory.getResult();
        if (result == null || result.getType() == Material.AIR) {
            return;
        }
        result = result.clone();
        Debug.log("\u8d24\u8005\u4e4b\u77f3\u5408\u6210: " + String.valueOf(result.getType()) + " x" + result.getAmount());
        event.setCancelled(true);
        if (event.isShiftClick()) {
            this.handleShiftClick(player, inventory, result);
        } else {
            this.handleNormalClick(player, inventory, result);
        }
    }

    private void handleShiftClick(Player player, CraftingInventory inventory, ItemStack result) {
        int maxCrafts = this.calculateMaxCrafts(inventory);
        Debug.log("\u6279\u91cf\u5408\u6210\uff0c\u6700\u5927\u6b21\u6570: " + maxCrafts);
        if (maxCrafts <= 0) {
            Debug.log("\u65e0\u6cd5\u8fdb\u884c\u6279\u91cf\u5408\u6210: \u6750\u6599\u4e0d\u8db3");
            return;
        }
        ItemStack resultStack = result.clone();
        resultStack.setAmount(result.getAmount() * maxCrafts);
        Debug.log("\u5408\u6210\u603b\u91cf: " + resultStack.getAmount());
        HashMap leftovers = player.getInventory().addItem(new ItemStack[]{resultStack});
        int craftedAmount = resultStack.getAmount();
        if (!leftovers.isEmpty()) {
            Debug.log("\u80cc\u5305\u5df2\u6ee1\uff0c\u90e8\u5206\u7269\u54c1\u6389\u843d\u5728\u5730\u4e0a");
            for (ItemStack item : leftovers.values()) {
                player.getWorld().dropItemNaturally(player.getLocation(), item);
            }
            craftedAmount -= leftovers.values().stream().mapToInt(ItemStack::getAmount).sum();
        }
        int numCrafted = craftedAmount / result.getAmount();
        Debug.log("\u5b9e\u9645\u5408\u6210\u6b21\u6570: " + numCrafted);
        if (numCrafted > 0) {
            this.consumeIngredients(inventory, numCrafted);
        }
    }

    private void handleNormalClick(Player player, CraftingInventory inventory, ItemStack result) {
        Debug.log("\u5355\u6b21\u5408\u6210: " + String.valueOf(result.getType()) + " x" + result.getAmount());
        ItemStack cursorItem = player.getItemOnCursor();
        if (cursorItem.getType() == Material.AIR) {
            Debug.log("\u9f20\u6807\u4e3a\u7a7a\uff0c\u5c06\u5408\u6210\u7ed3\u679c\u653e\u7f6e\u5230\u9f20\u6807\u4e0a");
            this.consumeIngredients(inventory, 1);
            player.setItemOnCursor(result);
        } else if (cursorItem.isSimilar(result)) {
            int canAdd = result.getMaxStackSize() - cursorItem.getAmount();
            if (canAdd >= result.getAmount()) {
                Debug.log("\u9f20\u6807\u4e0a\u6709\u540c\u7c7b\u7269\u54c1\uff0c\u5806\u53e0\u5230\u9f20\u6807\u4e0a");
                this.consumeIngredients(inventory, 1);
                cursorItem.setAmount(cursorItem.getAmount() + result.getAmount());
                player.setItemOnCursor(cursorItem);
            } else {
                Debug.log("\u9f20\u6807\u4e0a\u7684\u7269\u54c1\u65e0\u6cd5\u5b8c\u5168\u5806\u53e0\uff0c\u4e0d\u8fdb\u884c\u5408\u6210");
            }
        } else {
            Debug.log("\u9f20\u6807\u4e0a\u6709\u4e0d\u540c\u7c7b\u578b\u7684\u7269\u54c1\uff0c\u65e0\u6cd5\u8fdb\u884c\u5408\u6210");
        }
    }

    private void consumeIngredients(CraftingInventory inventory, int times) {
        if (times <= 0) {
            this.plugin.getLogger().warning("\u5c1d\u8bd5\u6d88\u80170\u6216\u8d1f\u6570\u6750\u6599\uff0c\u64cd\u4f5c\u88ab\u53d6\u6d88");
            return;
        }
        ItemStack[] matrix = inventory.getMatrix();
        Debug.log("\u6d88\u8017\u6750\u6599\uff0c\u6b21\u6570: " + times);
        StringBuilder before = new StringBuilder("\u6d88\u8017\u524d\u6750\u6599: ");
        for (ItemStack item : matrix) {
            if (item != null) {
                before.append(item.getType()).append("x").append(item.getAmount()).append(", ");
                continue;
            }
            before.append("\u7a7a, ");
        }
        Debug.log(before.toString());
        for (int i = 0; i < matrix.length; ++i) {
            ItemStack item = matrix[i];
            if (item == null || item.getType() == Material.AIR) continue;
            if (this.plugin.isPhilosopherStone(item)) {
                Debug.log("\u4fdd\u7559\u8d24\u8005\u4e4b\u77f3\u5728\u4f4d\u7f6e " + i);
                continue;
            }
            int newAmount = item.getAmount() - times;
            this.plugin.getLogger().info("\u6750\u6599 " + String.valueOf(item.getType()) + " \u5728\u4f4d\u7f6e " + i + ": " + item.getAmount() + " -> " + String.valueOf(newAmount > 0 ? Integer.valueOf(newAmount) : "\u6d88\u8017\u5b8c"));
            if (newAmount <= 0) {
                matrix[i] = null;
                continue;
            }
            item.setAmount(newAmount);
        }
        StringBuilder after = new StringBuilder("\u6d88\u8017\u540e\u6750\u6599: ");
        for (ItemStack item : matrix) {
            if (item != null) {
                after.append(item.getType()).append("x").append(item.getAmount()).append(", ");
                continue;
            }
            after.append("\u7a7a, ");
        }
        Debug.log(after.toString());
        try {
            inventory.setMatrix(matrix);
            Debug.log("\u5408\u6210\u683c\u5df2\u66f4\u65b0");
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, "\u66f4\u65b0\u5408\u6210\u683c\u5931\u8d25", e);
        }
    }

    private int calculateMaxCrafts(CraftingInventory inventory) {
        int maxCrafts = Integer.MAX_VALUE;
        for (ItemStack item : inventory.getMatrix()) {
            if (item == null || item.getType() == Material.AIR || this.plugin.isPhilosopherStone(item)) continue;
            maxCrafts = Math.min(maxCrafts, item.getAmount());
        }
        return maxCrafts == Integer.MAX_VALUE ? 0 : maxCrafts;
    }
}

