/*
 * Decompiled with CFR 0.152.
 */
package org.Little_100.projecte.listeners;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.Little_100.projecte.ProjectE;
import org.Little_100.projecte.devices.DeviceManager;
import org.Little_100.projecte.gui.ToolChargeGUI;
import org.Little_100.projecte.tools.AreaOfEffectManager;
import org.Little_100.projecte.tools.ToolManager;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.enchantment.EnchantItemEvent;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.event.player.PlayerItemDamageEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class ToolListener
implements Listener {
    private final ProjectE plugin;
    private final ToolManager toolManager;
    private final DeviceManager deviceManager;
    private final Set<UUID> processingPlayers = new HashSet<UUID>();

    public ToolListener(ProjectE plugin) {
        this.plugin = plugin;
        this.toolManager = plugin.getToolManager();
        this.deviceManager = plugin.getDeviceManager();
    }

    @EventHandler
    public void onItemDamage(PlayerItemDamageEvent event) {
        ItemStack item = event.getItem();
        if (this.toolManager.isProjectETool(item)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onSwapHand(PlayerSwapHandItemsEvent event) {
        Player player = event.getPlayer();
        ItemStack offHandItem = event.getOffHandItem();
        if (player.isSneaking() && this.toolManager.isProjectETool(offHandItem)) {
            event.setCancelled(true);
            new ToolChargeGUI(this.plugin, player, offHandItem).open();
            player.playSound(player.getLocation(), Sound.BLOCK_ENCHANTMENT_TABLE_USE, 1.0f, 1.0f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        Player player = event.getPlayer();
        UUID playerUUID = player.getUniqueId();
        if (this.processingPlayers.contains(playerUUID)) {
            return;
        }
        ItemStack tool = player.getInventory().getItemInMainHand();
        if (event.isCancelled()) return;
        if (!this.toolManager.isProjectETool(tool)) {
            return;
        }
        try {
            this.processingPlayers.add(playerUUID);
            ItemMeta meta = tool.getItemMeta();
            if (meta == null) {
                return;
            }
            PersistentDataContainer container = meta.getPersistentDataContainer();
            String mode = "standard";
            if (this.toolManager.isRedMatterMorningstar(tool)) {
                key = new NamespacedKey((Plugin)this.plugin, "projecte_morningstar_mode");
                mode = (String)container.getOrDefault(key, PersistentDataType.STRING, (Object)"normal");
            } else if (this.toolManager.isDarkMatterTool(tool)) {
                key = new NamespacedKey((Plugin)this.plugin, "projecte_mode");
                mode = (String)container.getOrDefault(key, PersistentDataType.STRING, (Object)"standard");
            }
            if (!(mode.equals("standard") || mode.equals("normal") || this.plugin.getConfig().getBoolean("Tools.area_of_effect_mining_enabled", true))) {
                return;
            }
            switch (mode) {
                case "3x3": {
                    List<Block> affectedBlocks = AreaOfEffectManager.getBlocksIn3x3Area(player, event.getBlock());
                    this.handleBlockBreaking(player, tool, affectedBlocks);
                    return;
                }
                case "tall": {
                    List<Block> affectedBlocks = AreaOfEffectManager.getBlocksInTallArea(event.getBlock());
                    this.handleBlockBreaking(player, tool, affectedBlocks);
                    return;
                }
                case "wide": {
                    List<Block> affectedBlocks = AreaOfEffectManager.getBlocksInWideArea(player, event.getBlock());
                    this.handleBlockBreaking(player, tool, affectedBlocks);
                    return;
                }
                case "long": {
                    List<Block> affectedBlocks = AreaOfEffectManager.getBlocksInLongArea(player, event.getBlock());
                    this.handleBlockBreaking(player, tool, affectedBlocks);
                    return;
                }
            }
            return;
        }
        finally {
            this.processingPlayers.remove(playerUUID);
        }
    }

    private void handleBlockBreaking(Player player, ItemStack tool, List<Block> blocks) {
        ItemMeta meta = tool.getItemMeta();
        if (!(meta instanceof Damageable)) {
            return;
        }
        Damageable damageable = (Damageable)meta;
        short maxDurability = tool.getType().getMaxDurability();
        for (Block block : blocks) {
            if (this.deviceManager.isDevice(block)) continue;
            BlockBreakEvent newEvent = new BlockBreakEvent(block, player);
            this.plugin.getServer().getPluginManager().callEvent((Event)newEvent);
            if (newEvent.isCancelled() || block.isEmpty() || block.isLiquid() || !this.toolManager.isValidMaterialForTool(block.getType(), tool)) continue;
            Collection drops = block.getDrops(tool, (Entity)player);
            block.setType(Material.AIR);
            for (ItemStack drop : drops) {
                HashMap leftover = player.getInventory().addItem(new ItemStack[]{drop});
                if (leftover.isEmpty()) continue;
                player.getWorld().dropItemNaturally(player.getLocation(), (ItemStack)leftover.get(0));
            }
        }
        tool.setItemMeta(meta);
    }

    @EventHandler
    public void onEnchantItem(EnchantItemEvent event) {
        if (this.toolManager.isProjectETool(event.getItem())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPrepareAnvil(PrepareAnvilEvent event) {
        for (ItemStack item : event.getInventory().getContents()) {
            if (item == null || !this.toolManager.isProjectETool(item)) continue;
            event.setResult(null);
            return;
        }
    }
}

