/*
 * Decompiled with CFR 0.152.
 */
package org.Little_100.projecte.accessories;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.Little_100.projecte.ProjectE;
import org.Little_100.projecte.accessories.BodyStone;
import org.Little_100.projecte.accessories.LifeStone;
import org.Little_100.projecte.accessories.MindStone;
import org.Little_100.projecte.accessories.SoulStone;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.plugin.Plugin;

public class AccessoryRecipeManager {
    private final ProjectE plugin;
    private final Map<String, NamespacedKey> recipeKeys = new HashMap<String, NamespacedKey>();

    public AccessoryRecipeManager(ProjectE plugin) {
        this.plugin = plugin;
    }

    public void registerRecipes() {
        YamlConfiguration config;
        ConfigurationSection recipesSection;
        File recipeFile = new File(this.plugin.getDataFolder(), "accessories.yml");
        if (!recipeFile.exists()) {
            this.plugin.saveResource("accessories.yml", false);
        }
        if ((recipesSection = (config = YamlConfiguration.loadConfiguration((File)recipeFile)).getConfigurationSection("accessories")) == null) {
            this.plugin.getLogger().warning("Could not find 'accessories' section in accessories.yml. Please delete the old accessories.yml and restart the server.");
            return;
        }
        for (String id : recipesSection.getKeys(false)) {
            ConfigurationSection recipeConfig;
            if (!recipesSection.isConfigurationSection(id) || (recipeConfig = recipesSection.getConfigurationSection(id)) == null || !recipeConfig.getBoolean("enabled", true)) continue;
            this.parseRecipe(id, recipeConfig);
        }
        this.plugin.getLogger().info("accessories.yml loaded");
    }

    private void parseRecipe(String id, ConfigurationSection config) {
        String type = config.getString("type", "shaped").toLowerCase();
        if (type.equals("shaped")) {
            this.parseShapedRecipe(id, config);
        } else if (type.equals("shapeless")) {
            this.parseShapelessRecipe(id, config);
        }
    }

    private void parseShapedRecipe(String id, ConfigurationSection config) {
        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, id);
        ItemStack result = this.createResultStack(config.getConfigurationSection("result"));
        if (result == null) {
            this.plugin.getLogger().warning("[Debug] Recipe " + id + " has a null result. Skipping.");
            return;
        }
        ShapedRecipe recipe = new ShapedRecipe(key, result);
        recipe.shape(config.getStringList("shape").toArray(new String[0]));
        ConfigurationSection ingredients = config.getConfigurationSection("ingredients");
        if (ingredients != null) {
            for (String ingredientKey : ingredients.getKeys(false)) {
                char keyChar = ingredientKey.charAt(0);
                String ingredientValue = ingredients.getString(ingredientKey);
                RecipeChoice choice = this.getChoice(ingredientValue);
                if (choice == null) continue;
                recipe.setIngredient(keyChar, choice);
            }
        }
        Bukkit.addRecipe((Recipe)recipe);
        this.recipeKeys.put(id, key);
    }

    private void parseShapelessRecipe(String id, ConfigurationSection config) {
        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, id);
        ItemStack result = this.createResultStack(config.getConfigurationSection("result"));
        if (result == null) {
            this.plugin.getLogger().warning("[Debug] Recipe " + id + " has a null result. Skipping.");
            return;
        }
        ShapelessRecipe recipe = new ShapelessRecipe(key, result);
        List ingredients = config.getStringList("ingredients");
        for (String ingredientValue : ingredients) {
            RecipeChoice choice = this.getChoice(ingredientValue);
            if (choice == null) continue;
            recipe.addIngredient(choice);
        }
        Bukkit.addRecipe((Recipe)recipe);
        this.recipeKeys.put(id, key);
    }

    private RecipeChoice getChoice(String ingredient) {
        if (ingredient.startsWith("projecte:")) {
            String customItemId = ingredient.substring(9);
            ItemStack customItem = this.plugin.getItemStackFromKey(customItemId);
            if (customItem != null) {
                return new RecipeChoice.ExactChoice(customItem);
            }
            return null;
        }
        try {
            Material material = Material.valueOf((String)ingredient.toUpperCase());
            return new RecipeChoice.MaterialChoice(material);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private ItemStack createResultStack(ConfigurationSection config) {
        if (config == null) {
            return null;
        }
        if (config.contains("projecte_id")) {
            String projecteId;
            switch (projecteId = config.getString("projecte_id", "")) {
                case "body_stone": {
                    return BodyStone.createBodyStone();
                }
                case "soul_stone": {
                    return SoulStone.createSoulStone();
                }
                case "life_stone": {
                    return LifeStone.createLifeStone();
                }
                case "mind_stone": {
                    return MindStone.createMindStone();
                }
            }
        }
        return null;
    }

    public void unregisterAllRecipes() {
        for (NamespacedKey key : this.recipeKeys.values()) {
            Bukkit.removeRecipe((NamespacedKey)key);
        }
        this.recipeKeys.clear();
    }
}

