/*
 * Decompiled with CFR 0.152.
 */
package org.Little_100.projecte.compatibility;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.Little_100.projecte.ProjectE;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;
import org.geysermc.geyser.api.GeyserApi;
import org.geysermc.geyser.api.connection.GeyserConnection;

public class GeyserAdapter {
    private final ProjectE plugin;
    private final Map<String, Map<String, Object>> customItemMappings = new HashMap<String, Map<String, Object>>();
    private boolean geyserApiAvailable = false;

    public GeyserAdapter(ProjectE plugin) {
        this.plugin = plugin;
        try {
            Class.forName("org.geysermc.geyser.api.GeyserApi");
            this.geyserApiAvailable = true;
            plugin.getLogger().info("Geyser API found, enabling Geyser compatibility.");
            this.loadCustomItemMappings();
        }
        catch (ClassNotFoundException e) {
            plugin.getLogger().info("Geyser API not found, Geyser compatibility is disabled.");
        }
    }

    private void loadCustomItemMappings() {
        YamlConfiguration mappingConfig;
        ConfigurationSection mappingsSection;
        File mappingFile = new File(this.plugin.getDataFolder(), "mapping.yml");
        if (!mappingFile.exists()) {
            this.plugin.saveResource("mapping.yml", false);
        }
        if ((mappingsSection = (mappingConfig = YamlConfiguration.loadConfiguration((File)mappingFile)).getConfigurationSection("geyser-mappings")) == null) {
            this.plugin.getLogger().warning("'geyser-mappings' section not found in mapping.yml. Geyser item mapping will not work.");
            return;
        }
        for (String key : mappingsSection.getKeys(false)) {
            ConfigurationSection itemSection = mappingsSection.getConfigurationSection(key);
            if (itemSection == null) continue;
            HashMap<String, Object> mapping = new HashMap<String, Object>();
            mapping.put("bedrock_identifier", itemSection.getString("bedrock_identifier"));
            mapping.put("custom_model_data", itemSection.getInt("custom_model_data"));
            this.customItemMappings.put(key, mapping);
            this.plugin.getLogger().info("Loaded Geyser mapping for '" + key + "'.");
        }
    }

    public ItemStack convertToJavaStack(ItemStack itemStack, UUID playerUUID) {
        if (!this.geyserApiAvailable || itemStack == null) {
            return itemStack;
        }
        GeyserConnection connection = GeyserApi.api().connectionByUuid(playerUUID);
        if (connection == null) {
            return itemStack;
        }
        return itemStack;
    }

    public ItemStack convertToBedrockStack(ItemStack itemStack, UUID playerUUID) {
        return itemStack;
    }

    public boolean isGeyserApiAvailable() {
        return this.geyserApiAvailable;
    }
}

