/*
 * Decompiled with CFR 0.152.
 */
package org.Little_100.projecte.devices;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import org.Little_100.projecte.ProjectE;
import org.Little_100.projecte.util.Constants;
import org.Little_100.projecte.util.CustomModelDataUtil;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.FurnaceRecipe;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class FurnaceManager {
    private static final Set<Material> ORES = new HashSet<Material>(Arrays.asList(Material.COAL_ORE, Material.COPPER_ORE, Material.IRON_ORE, Material.GOLD_ORE, Material.LAPIS_ORE, Material.REDSTONE_ORE, Material.DIAMOND_ORE, Material.EMERALD_ORE, Material.NETHER_GOLD_ORE, Material.ANCIENT_DEBRIS, Material.DEEPSLATE_COAL_ORE, Material.DEEPSLATE_COPPER_ORE, Material.DEEPSLATE_IRON_ORE, Material.DEEPSLATE_GOLD_ORE, Material.DEEPSLATE_LAPIS_ORE, Material.DEEPSLATE_REDSTONE_ORE, Material.DEEPSLATE_DIAMOND_ORE, Material.DEEPSLATE_EMERALD_ORE, Material.RAW_IRON, Material.RAW_GOLD, Material.RAW_COPPER));
    private final ProjectE plugin;
    private final Map<Location, FurnaceState> activeFurnaces = new ConcurrentHashMap<Location, FurnaceState>();
    private final Map<FurnaceType, ItemStack[]> guiLayouts = new EnumMap<FurnaceType, ItemStack[]>(FurnaceType.class);
    private final Map<FurnaceType, List<Integer>> inputSlots = new EnumMap<FurnaceType, List<Integer>>(FurnaceType.class);
    private final Map<FurnaceType, List<Integer>> outputSlots = new EnumMap<FurnaceType, List<Integer>>(FurnaceType.class);
    private final Map<FurnaceType, List<Integer>> progressBarSlots = new EnumMap<FurnaceType, List<Integer>>(FurnaceType.class);
    private final Map<FurnaceType, Integer> fuelSlot = new EnumMap<FurnaceType, Integer>(FurnaceType.class);
    private final Map<FurnaceType, Integer> arrowSlot = new EnumMap<FurnaceType, Integer>(FurnaceType.class);
    private final Map<FurnaceType, Integer> fuelIndicatorSlot = new EnumMap<FurnaceType, Integer>(FurnaceType.class);
    private final Map<FurnaceType, List<Integer>> nonInteractiveSlots = new EnumMap<FurnaceType, List<Integer>>(FurnaceType.class);

    public FurnaceManager(ProjectE plugin) {
        this.plugin = plugin;
        this.loadGuiLayouts();
        this.startUpdateTask();
    }

    private void loadGuiLayouts() {
        for (FurnaceType type : FurnaceType.values()) {
            String fileName = type.name().toLowerCase().replace("_", "") + "furnace.yml";
            try (InputStream is = this.plugin.getResource(fileName);){
                if (is == null) {
                    this.plugin.getLogger().severe("GUI layout file not found in JAR: " + fileName);
                    continue;
                }
                YamlConfiguration config = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(is));
                int size = config.getInt("size", 54);
                ItemStack[] layout = new ItemStack[size];
                ArrayList<Integer> currentInput = new ArrayList<Integer>();
                ArrayList<Integer> currentOutput = new ArrayList<Integer>();
                ArrayList<Integer> currentProgressBar = new ArrayList<Integer>();
                ArrayList<Integer> currentNonInteractive = new ArrayList<Integer>();
                ConfigurationSection itemsSection = config.getConfigurationSection("items");
                if (itemsSection != null) {
                    for (String key : itemsSection.getKeys(false)) {
                        int slot = Integer.parseInt(key);
                        String materialName = itemsSection.getString(key + ".material");
                        Material material = Material.getMaterial((String)materialName);
                        if (material == null) continue;
                        ItemStack item = new ItemStack(material);
                        ItemMeta meta = item.getItemMeta();
                        String name = itemsSection.getString(key + ".name");
                        if ("null".equalsIgnoreCase(name)) {
                            if (meta != null) {
                                meta.setDisplayName(" ");
                            }
                            currentNonInteractive.add(slot);
                        } else if (name != null && meta != null) {
                            meta.setDisplayName(name);
                        }
                        if (meta != null) {
                            item.setItemMeta(meta);
                        }
                        layout[slot] = item;
                        if (material == Material.IRON_ORE) {
                            currentInput.add(slot);
                            continue;
                        }
                        if (material == Material.IRON_INGOT) {
                            currentOutput.add(slot);
                            continue;
                        }
                        if (material == Material.COAL) {
                            this.fuelSlot.put(type, slot);
                            continue;
                        }
                        if (material == Material.ARROW) {
                            this.arrowSlot.put(type, slot);
                            continue;
                        }
                        if (material == Material.CAMPFIRE) {
                            this.fuelIndicatorSlot.put(type, slot);
                            continue;
                        }
                        if (material != Material.BLACK_STAINED_GLASS_PANE || slot >= 9) continue;
                        currentProgressBar.add(slot);
                    }
                }
                this.guiLayouts.put(type, layout);
                this.inputSlots.put(type, currentInput);
                this.outputSlots.put(type, currentOutput);
                this.progressBarSlots.put(type, currentProgressBar);
                this.nonInteractiveSlots.put(type, currentNonInteractive);
            }
            catch (IOException e) {
                this.plugin.getLogger().log(Level.SEVERE, "Could not load GUI layout: " + fileName, e);
            }
        }
    }

    private void startUpdateTask() {
        this.plugin.getSchedulerAdapter().runTimer(() -> this.activeFurnaces.forEach(this::tick), 0L, 1L);
    }

    public void addFurnace(Location location, UUID owner, FurnaceType type, UUID armorStandId) {
        String titleKey = type == FurnaceType.DARK_MATTER ? "gui.furnace.dark_matter_title" : "gui.furnace.red_matter_title";
        String title = this.plugin.getLanguageManager().get(titleKey);
        Inventory inventory = Bukkit.createInventory(null, (int)54, (String)title);
        ItemStack[] layout = this.guiLayouts.get((Object)type);
        if (layout != null) {
            for (int i = 0; i < layout.length; ++i) {
                if (this.inputSlots.get((Object)type).contains(i) || this.outputSlots.get((Object)type).contains(i) || this.fuelSlot.get((Object)type).equals(i) || layout[i] == null) continue;
                inventory.setItem(i, layout[i].clone());
            }
        }
        FurnaceState state = new FurnaceState(owner, inventory, type, armorStandId);
        this.activeFurnaces.put(location, state);
    }

    public void removeFurnace(Location location) {
        FurnaceState state = this.activeFurnaces.remove(location);
        if (state != null) {
            this.plugin.getSchedulerAdapter().runTaskAt(location, () -> {
                Entity armorStand = Bukkit.getEntity((UUID)state.getArmorStandId());
                if (armorStand != null) {
                    armorStand.remove();
                }
            });
        }
    }

    public FurnaceState getFurnaceState(Location location) {
        return this.activeFurnaces.get(location);
    }

    public Map<Location, FurnaceState> getActiveFurnaces() {
        return this.activeFurnaces;
    }

    public boolean isFurnace(Location location) {
        return this.activeFurnaces.containsKey(location);
    }

    public boolean isNonInteractive(FurnaceType type, int slot) {
        return this.nonInteractiveSlots.getOrDefault((Object)type, Collections.emptyList()).contains(slot);
    }

    public boolean isOutputSlot(FurnaceType type, int slot) {
        return this.outputSlots.getOrDefault((Object)type, Collections.emptyList()).contains(slot);
    }

    public boolean isArrowSlot(FurnaceType type, int slot) {
        return this.arrowSlot.get((Object)type) != null && this.arrowSlot.get((Object)type) == slot;
    }

    public boolean isFuelIndicatorSlot(FurnaceType type, int slot) {
        return this.fuelIndicatorSlot.get((Object)type) != null && this.fuelIndicatorSlot.get((Object)type) == slot;
    }

    private void tick(Location location, FurnaceState state) {
        boolean isBurning;
        Inventory inv = state.getInventory();
        FurnaceType type = state.getType();
        boolean bl = isBurning = state.getFuelTicksLeft() > 0;
        if (state.getFuelTicksLeft() > 0) {
            state.setFuelTicksLeft(state.getFuelTicksLeft() - 1);
        }
        ItemStack firstSmeltable = this.findNextInput(inv, type);
        if (isBurning) {
            if (firstSmeltable != null) {
                ItemStack result = this.getSmeltingResult(firstSmeltable);
                if (result != null) {
                    int maxPossibleAmount = 1;
                    if (this.isOre(firstSmeltable.getType()) && (type == FurnaceType.DARK_MATTER || type == FurnaceType.RED_MATTER)) {
                        maxPossibleAmount = 2;
                    }
                    if (this.canFitOutput(inv, type, result, maxPossibleAmount)) {
                        int cookTimeNeeded = type == FurnaceType.DARK_MATTER ? 8 : 2;
                        state.setCookTimeProgress(state.getCookTimeProgress() + 1);
                        if (state.getCookTimeProgress() >= cookTimeNeeded) {
                            int finalAmount = 1;
                            if (this.isOre(firstSmeltable.getType())) {
                                if (type == FurnaceType.RED_MATTER) {
                                    finalAmount = 2;
                                } else if (type == FurnaceType.DARK_MATTER && Math.random() < 0.5) {
                                    finalAmount = 2;
                                }
                            }
                            this.smeltItem(inv, type, firstSmeltable, result, finalAmount);
                            state.setCookTimeProgress(0);
                        }
                    } else {
                        state.setCookTimeProgress(0);
                    }
                } else {
                    state.setCookTimeProgress(0);
                }
            } else {
                state.setCookTimeProgress(0);
            }
        } else {
            ItemStack fuel;
            int fuelTime;
            Integer fuelSlotIndex;
            if (firstSmeltable != null && (fuelSlotIndex = this.fuelSlot.get((Object)type)) != null && (fuelTime = this.getFuelTime(fuel = inv.getItem(fuelSlotIndex.intValue()))) > 0) {
                state.setFuelTicksLeft(fuelTime);
                if (fuel.getAmount() > 1) {
                    fuel.setAmount(fuel.getAmount() - 1);
                } else {
                    inv.setItem(fuelSlotIndex.intValue(), null);
                }
                isBurning = true;
            }
            state.setCookTimeProgress(0);
        }
        this.updateProgressBar(inv, state);
        this.updateFuelDisplay(inv, state);
        if (isBurning != state.wasBurning()) {
            this.updateFurnaceModel(location, state, isBurning);
            state.setWasBurning(isBurning);
        }
    }

    private ItemStack findNextInput(Inventory inv, FurnaceType type) {
        Iterator iterator = this.inputSlots.getOrDefault((Object)type, Collections.emptyList()).iterator();
        while (iterator.hasNext()) {
            int slot = (Integer)iterator.next();
            ItemStack item = inv.getItem(slot);
            if (item == null || this.getSmeltingResult(item) == null) continue;
            return item;
        }
        return null;
    }

    private boolean canFitOutput(Inventory inv, FurnaceType type, ItemStack result, int amount) {
        int spaceAvailable = 0;
        Iterator iterator = this.outputSlots.getOrDefault((Object)type, Collections.emptyList()).iterator();
        while (iterator.hasNext()) {
            int slot = (Integer)iterator.next();
            ItemStack existing = inv.getItem(slot);
            if (existing == null) {
                spaceAvailable += result.getMaxStackSize();
                continue;
            }
            if (!existing.isSimilar(result)) continue;
            spaceAvailable += existing.getMaxStackSize() - existing.getAmount();
        }
        return spaceAvailable >= amount;
    }

    private void smeltItem(Inventory inv, FurnaceType type, ItemStack input, ItemStack result, int amount) {
        int slot;
        input.setAmount(input.getAmount() - 1);
        ItemStack toAdd = result.clone();
        toAdd.setAmount(amount);
        int amountLeft = toAdd.getAmount();
        Iterator iterator = this.outputSlots.getOrDefault((Object)type, Collections.emptyList()).iterator();
        while (iterator.hasNext()) {
            int space;
            slot = (Integer)iterator.next();
            if (amountLeft <= 0) break;
            ItemStack existing = inv.getItem(slot);
            if (existing == null || !existing.isSimilar(toAdd) || (space = existing.getMaxStackSize() - existing.getAmount()) <= 0) continue;
            int addAmount = Math.min(amountLeft, space);
            existing.setAmount(existing.getAmount() + addAmount);
            amountLeft -= addAmount;
        }
        iterator = this.outputSlots.getOrDefault((Object)type, Collections.emptyList()).iterator();
        while (iterator.hasNext()) {
            slot = (Integer)iterator.next();
            if (amountLeft <= 0) break;
            if (inv.getItem(slot) != null) continue;
            ItemStack newItem = toAdd.clone();
            int addAmount = Math.min(amountLeft, newItem.getMaxStackSize());
            newItem.setAmount(addAmount);
            inv.setItem(slot, newItem);
            amountLeft -= addAmount;
        }
    }

    private void updateProgressBar(Inventory inv, FurnaceState state) {
        ItemMeta meta;
        ItemStack arrow;
        FurnaceType type = state.getType();
        int cookTimeNeeded = type == FurnaceType.DARK_MATTER ? 8 : 2;
        float percentage = cookTimeNeeded > 0 ? (float)state.getCookTimeProgress() / (float)cookTimeNeeded : 0.0f;
        List pBarSlots = this.progressBarSlots.getOrDefault((Object)type, Collections.emptyList());
        int greenPanes = (int)((float)pBarSlots.size() * percentage);
        ItemStack greenPane = new ItemStack(Material.GREEN_STAINED_GLASS_PANE);
        ItemMeta greenMeta = greenPane.getItemMeta();
        if (greenMeta != null) {
            greenMeta.setDisplayName(" ");
            greenPane.setItemMeta(greenMeta);
        }
        for (int i = 0; i < pBarSlots.size(); ++i) {
            int slot = (Integer)pBarSlots.get(i);
            if (i < greenPanes) {
                inv.setItem(slot, greenPane);
                continue;
            }
            inv.setItem(slot, this.guiLayouts.get((Object)type)[slot].clone());
        }
        Integer arrowSlotIndex = this.arrowSlot.get((Object)type);
        if (arrowSlotIndex != null && (arrow = inv.getItem(arrowSlotIndex.intValue())) != null && arrow.getType() == Material.ARROW && (meta = arrow.getItemMeta()) != null) {
            meta.setDisplayName("\u00a7a" + (int)(percentage * 100.0f) + "%");
            arrow.setItemMeta(meta);
        }
    }

    private void updateFuelDisplay(Inventory inv, FurnaceState state) {
        ItemMeta meta;
        ItemStack fuelItem;
        Integer fuelIndicatorIndex = this.fuelIndicatorSlot.get((Object)state.getType());
        if (fuelIndicatorIndex != null && (fuelItem = inv.getItem(fuelIndicatorIndex.intValue())) != null && fuelItem.getType() == Material.CAMPFIRE && (meta = fuelItem.getItemMeta()) != null) {
            int seconds = state.getFuelTicksLeft() / 20;
            String key = "gui.furnace.fuel_time";
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("time", String.valueOf(seconds));
            meta.setDisplayName(this.plugin.getLanguageManager().get(key, placeholders));
            fuelItem.setItemMeta(meta);
        }
    }

    private ItemStack getSmeltingResult(ItemStack input) {
        if (input == null) {
            return null;
        }
        Iterator iterator = Bukkit.recipeIterator();
        while (iterator.hasNext()) {
            FurnaceRecipe furnaceRecipe;
            Recipe recipe = (Recipe)iterator.next();
            if (!(recipe instanceof FurnaceRecipe) || !(furnaceRecipe = (FurnaceRecipe)recipe).getInput().isSimilar(input)) continue;
            return furnaceRecipe.getResult();
        }
        return null;
    }

    private int getFuelTime(ItemStack item) {
        Material type;
        PersistentDataContainer container;
        if (item == null) {
            return 0;
        }
        if (item.hasItemMeta() && (container = item.getItemMeta().getPersistentDataContainer()).has(Constants.ID_KEY, PersistentDataType.STRING)) {
            String projecteId;
            switch (projecteId = (String)container.get(Constants.ID_KEY, PersistentDataType.STRING)) {
                case "alchemical_coal": {
                    return 6400;
                }
                case "mobius_fuel": {
                    return 25600;
                }
                case "aeternalis_fuel": {
                    return 102400;
                }
                case "alchemical_coal_block": {
                    return 57600;
                }
                case "mobius_fuel_block": {
                    return 230400;
                }
                case "aeternalis_fuel_block": {
                    return 921600;
                }
            }
        }
        if ((type = item.getType()).isFuel()) {
            if (type == Material.COAL) {
                return 1600;
            }
            if (type == Material.COAL_BLOCK) {
                return 16000;
            }
            if (type == Material.LAVA_BUCKET) {
                return 20000;
            }
            return 300;
        }
        return 0;
    }

    private boolean isOre(Material material) {
        return ORES.contains(material);
    }

    private void updateFurnaceModel(Location location, FurnaceState state, boolean isBurning) {
        this.plugin.getSchedulerAdapter().runTaskAt(location, () -> {
            int currentModelData;
            Entity entity = Bukkit.getEntity((UUID)state.getArmorStandId());
            if (!(entity instanceof ArmorStand)) {
                return;
            }
            ArmorStand armorStand = (ArmorStand)entity;
            ItemStack furnaceItem = armorStand.getEquipment().getHelmet();
            if (furnaceItem == null || !furnaceItem.hasItemMeta()) {
                return;
            }
            int baseModelData = state.getType() == FurnaceType.DARK_MATTER ? 1 : 2;
            int newModelData = isBurning ? baseModelData + 2 : baseModelData;
            if (newModelData != (currentModelData = CustomModelDataUtil.getCustomModelDataInt(furnaceItem))) {
                CustomModelDataUtil.setCustomModelData(furnaceItem, newModelData);
                armorStand.getEquipment().setHelmet(furnaceItem);
            }
        });
    }

    private ArmorStand getArmorStandAt(Location location) {
        Entity entity = Bukkit.getEntity((UUID)this.activeFurnaces.get(location).getArmorStandId());
        if (entity instanceof ArmorStand) {
            return (ArmorStand)entity;
        }
        return null;
    }

    public static enum FurnaceType {
        DARK_MATTER,
        RED_MATTER;

    }

    public static class FurnaceState {
        private final UUID owner;
        private final Inventory inventory;
        private final FurnaceType type;
        private UUID armorStandId;
        private int fuelTicksLeft = 0;
        private int cookTimeProgress = 0;
        private boolean wasBurning = false;

        public FurnaceState(UUID owner, Inventory inventory, FurnaceType type, UUID armorStandId) {
            this.owner = owner;
            this.inventory = inventory;
            this.type = type;
            this.armorStandId = armorStandId;
        }

        public UUID getOwner() {
            return this.owner;
        }

        public Inventory getInventory() {
            return this.inventory;
        }

        public FurnaceType getType() {
            return this.type;
        }

        public UUID getArmorStandId() {
            return this.armorStandId;
        }

        public void setArmorStandId(UUID armorStandId) {
            this.armorStandId = armorStandId;
        }

        public int getFuelTicksLeft() {
            return this.fuelTicksLeft;
        }

        public void setFuelTicksLeft(int fuelTicksLeft) {
            this.fuelTicksLeft = fuelTicksLeft;
        }

        public int getCookTimeProgress() {
            return this.cookTimeProgress;
        }

        public void setCookTimeProgress(int cookTimeProgress) {
            this.cookTimeProgress = cookTimeProgress;
        }

        public boolean wasBurning() {
            return this.wasBurning;
        }

        public void setWasBurning(boolean wasBurning) {
            this.wasBurning = wasBurning;
        }
    }
}

