/*
 * Decompiled with CFR 0.152.
 */
package org.Little_100.projecte.gui;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.Little_100.projecte.Debug;
import org.Little_100.projecte.ProjectE;
import org.Little_100.projecte.gui.NoEmcItemGUI;
import org.Little_100.projecte.gui.TransmutationGUI;
import org.Little_100.projecte.managers.EmcManager;
import org.Little_100.projecte.managers.LanguageManager;
import org.Little_100.projecte.storage.DatabaseManager;
import org.Little_100.projecte.tools.kleinstar.KleinStarManager;
import org.Little_100.projecte.util.ShulkerBoxUtil;
import org.bukkit.World;
import org.bukkit.block.ShulkerBox;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;

public class GUIListener
implements Listener {
    private final Map<Player, Boolean> searchingPlayers = new HashMap<Player, Boolean>();

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        InventoryHolder holder = event.getInventory().getHolder();
        if (holder instanceof NoEmcItemGUI) {
            this.handleNoEmcItemGUIClick(event);
            return;
        }
        if (!(holder instanceof TransmutationGUI)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        TransmutationGUI gui = (TransmutationGUI)holder;
        if (gui.getCurrentState() == TransmutationGUI.GuiState.SELL) {
            if (event.getClickedInventory() == player.getInventory() || this.isTransactionArea(event.getSlot())) {
                event.setCancelled(false);
                this.updateSellButton(gui);
                return;
            }
        } else if (!(gui.getCurrentState() != TransmutationGUI.GuiState.LEARN && gui.getCurrentState() != TransmutationGUI.GuiState.CHARGE || event.getClickedInventory() != player.getInventory() && !this.isTransactionArea(event.getSlot()))) {
            event.setCancelled(false);
            return;
        }
        if ((gui.getCurrentState() == TransmutationGUI.GuiState.BUY || gui.getCurrentState() == TransmutationGUI.GuiState.MAIN) && event.getClickedInventory() != gui.getInventory()) {
            event.setCancelled(true);
            return;
        }
        if (event.getClickedInventory() != gui.getInventory()) {
            return;
        }
        event.setCancelled(true);
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null || clickedItem.getType().isAir()) {
            return;
        }
        switch (gui.getCurrentState()) {
            case MAIN: {
                this.handleMainScreenClick(event, gui);
                break;
            }
            case SELL: {
                this.handleSellScreenClick(event, gui);
                break;
            }
            case BUY: {
                this.handleBuyScreenClick(event, gui);
                break;
            }
            case LEARN: {
                this.handleLearnScreenClick(event, gui);
                break;
            }
            case CHARGE: {
                this.handleChargeScreenClick(event, gui);
            }
        }
    }

    private void handleMainScreenClick(InventoryClickEvent event, TransmutationGUI gui) {
        int slot = event.getSlot();
        if (slot == 20) {
            gui.setState(TransmutationGUI.GuiState.SELL);
        } else if (slot == 22) {
            gui.setState(TransmutationGUI.GuiState.BUY);
        } else if (slot == 24) {
            gui.setState(TransmutationGUI.GuiState.LEARN);
        } else if (slot == 21) {
            gui.setState(TransmutationGUI.GuiState.CHARGE);
        }
    }

    private void handleSellScreenClick(InventoryClickEvent event, TransmutationGUI gui) {
        int slot = event.getSlot();
        if (slot == 0) {
            this.returnCursorItemToPlayer(event);
            gui.setState(TransmutationGUI.GuiState.MAIN);
        } else if (slot == 49) {
            this.handleTransaction(event.getWhoClicked(), gui);
        }
    }

    private void updateSellButton(TransmutationGUI gui) {
        ProjectE.getInstance().getSchedulerAdapter().runTaskLater(() -> {
            ItemMeta meta;
            Inventory inventory = gui.getInventory();
            long totalEmcChange = 0L;
            for (int i = 0; i < 54; ++i) {
                ItemStack item;
                if (!this.isTransactionArea(i) || (item = inventory.getItem(i)) == null || item.getType().isAir()) continue;
                totalEmcChange += this.calculateItemSellEmc(item);
            }
            ItemStack confirmButton = inventory.getItem(49);
            if (confirmButton != null && (meta = confirmButton.getItemMeta()) != null) {
                String formattedEmc = String.format("%,d", totalEmcChange);
                LanguageManager lang = ProjectE.getInstance().getLanguageManager();
                HashMap<String, String> placeholders = new HashMap<String, String>();
                placeholders.put("emc", formattedEmc);
                meta.setLore(Arrays.asList(lang.get("clientside.transmutation_table.buttons.confirm_transaction_lore"), lang.get("clientside.transmutation_table.buttons.you_will_get", placeholders)));
                confirmButton.setItemMeta(meta);
            }
        }, 1L);
    }

    private long calculateItemSellEmc(ItemStack item) {
        if (item == null || item.getType().isAir()) {
            return 0L;
        }
        EmcManager emcManager = ProjectE.getInstance().getEmcManager();
        KleinStarManager kleinStarManager = ProjectE.getInstance().getKleinStarManager();
        long itemEmc = emcManager.getEmc(item);
        if (item.getItemMeta() instanceof BlockStateMeta && ((BlockStateMeta)item.getItemMeta()).getBlockState() instanceof ShulkerBox) {
            if (ShulkerBoxUtil.getFirstItemWithoutEmc(item) == null) {
                return (itemEmc + ShulkerBoxUtil.getTotalEmcOfContents(item)) * (long)item.getAmount();
            }
            return 0L;
        }
        if (kleinStarManager.isKleinStar(item)) {
            long baseEmc = emcManager.getEmc(emcManager.getItemKey(item));
            long storedEmc = kleinStarManager.getStoredEmc(item);
            return (baseEmc + storedEmc) * (long)item.getAmount();
        }
        if (item.getItemMeta() instanceof Damageable) {
            Damageable damageable = (Damageable)item.getItemMeta();
            short maxDurability = item.getType().getMaxDurability();
            if (maxDurability > 0) {
                int currentDamage = damageable.getDamage();
                double durabilityPercentage = (double)(maxDurability - currentDamage) / (double)maxDurability;
                long durabilityAdjustedEmc = (long)Math.max(1.0, (double)itemEmc * durabilityPercentage);
                return durabilityAdjustedEmc * (long)item.getAmount();
            }
        }
        return itemEmc * (long)item.getAmount();
    }

    private void handleBuyScreenClick(InventoryClickEvent event, TransmutationGUI gui) {
        Player player = (Player)event.getWhoClicked();
        int slot = event.getSlot();
        if (event.getClickedInventory() != gui.getInventory()) {
            return;
        }
        if (slot == 0) {
            this.returnCursorItemToPlayer(event);
            gui.setState(TransmutationGUI.GuiState.MAIN);
            return;
        }
        if (slot == 4) {
            player.closeInventory();
            Debug.log("Player " + player.getName() + " clicked search button.");
            this.searchingPlayers.put(player, true);
            LanguageManager languageManager = ProjectE.getInstance().getLanguageManager();
            player.sendMessage("\u00a7a" + languageManager.get("clientside.transmutation_table.search_sign.line1"));
            player.sendMessage("\u00a7e\u4f8b\u5982: \u94bb\u77f3, \u94c1\u952d, \u7164\u70ad, \u7ea2\u77f3, \u9752\u91d1\u77f3, \u6728\u6750, \u77f3\u5934\u7b49");
            player.sendMessage("\u00a7e\u652f\u6301\u641c\u7d22\u6750\u6599\u7c7b\u578b: \u00a7b\u94c1, \u91d1, \u94bb\u77f3, \u6728, \u77f3, \u94dc, \u7f8a\u6bdb, \u73bb\u7483, \u6df7\u51dd\u571f\u7b49");
            player.sendMessage("\u00a7e\u652f\u6301\u641c\u7d22\u7269\u54c1\u7c7b\u578b: \u00a7b\u5251, \u65a7, \u9550, \u9504, \u9539, \u76d4\u7532, \u5e8a, \u7bb1\u5b50\u7b49");
            player.sendMessage("\u00a7e\u60a8\u8fd8\u53ef\u4ee5\u641c\u7d22: \u00a7b\u65b9\u5757, \u77ff\u77f3, \u5de5\u5177, \u98df\u7269, \u88c5\u9970\u54c1, \u79cd\u5b50, \u6811\u82d7\u7b49");
            player.sendMessage("\u00a7a\u8bf7\u8f93\u5165\u60a8\u60f3\u8981\u67e5\u627e\u7684\u7269\u54c1\u5173\u952e\u8bcd:");
            return;
        }
        if (slot == 48) {
            if (gui.getPage() > 0) {
                gui.setPage(gui.getPage() - 1);
            }
            return;
        }
        if (slot == 50) {
            gui.setPage(gui.getPage() + 1);
            return;
        }
        if (slot < 9 || slot > 44 || slot % 9 == 0 || slot % 9 == 8) {
            return;
        }
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem != null && !clickedItem.getType().isAir()) {
            long totalCost;
            int amountToBuy;
            String itemKey = ProjectE.getInstance().getEmcManager().getItemKey(clickedItem);
            long itemEmc = ProjectE.getInstance().getEmcManager().getEmc(itemKey);
            if (itemEmc <= 0L) {
                return;
            }
            long playerEmc = ProjectE.getInstance().getDatabaseManager().getPlayerEmc(player.getUniqueId());
            if (ProjectE.getInstance().isPhilosopherStone(clickedItem)) {
                if (player.getInventory().containsAtLeast(ProjectE.getInstance().getPhilosopherStone(), 1)) {
                    player.sendMessage(ProjectE.getInstance().getLanguageManager().get("serverside.command.generic.already_have_philosopher_stone"));
                    return;
                }
                amountToBuy = 1;
                totalCost = itemEmc;
            } else if (event.isLeftClick()) {
                amountToBuy = 1;
                totalCost = itemEmc;
            } else if (event.isRightClick()) {
                amountToBuy = clickedItem.getMaxStackSize();
                totalCost = itemEmc * (long)amountToBuy;
            } else {
                return;
            }
            if (amountToBuy > 0) {
                if (playerEmc >= totalCost) {
                    ItemMeta meta;
                    ProjectE.getInstance().getDatabaseManager().setPlayerEmc(player.getUniqueId(), playerEmc - totalCost);
                    ItemStack purchasedItem = ProjectE.getInstance().getItemStackFromKey(itemKey);
                    if (purchasedItem != null) {
                        purchasedItem.setAmount(amountToBuy);
                    } else {
                        purchasedItem = new ItemStack(clickedItem.getType(), amountToBuy);
                        if (clickedItem.hasItemMeta()) {
                            purchasedItem.setItemMeta(clickedItem.getItemMeta());
                        }
                    }
                    HashMap remainingItems = player.getInventory().addItem(new ItemStack[]{purchasedItem});
                    if (!remainingItems.isEmpty()) {
                        for (ItemStack remaining : remainingItems.values()) {
                            player.getWorld().dropItemNaturally(player.getLocation(), remaining);
                        }
                    }
                    String displayName = (meta = purchasedItem.getItemMeta()) != null && meta.hasDisplayName() ? meta.getDisplayName() : purchasedItem.getType().name();
                    LanguageManager lang = ProjectE.getInstance().getLanguageManager();
                    HashMap<String, String> placeholders = new HashMap<String, String>();
                    placeholders.put("amount", String.valueOf(amountToBuy));
                    placeholders.put("item", displayName);
                    player.sendMessage(lang.get("serverside.command.generic.buy_success", placeholders));
                    this.refreshGui(player, gui);
                } else {
                    player.sendMessage(ProjectE.getInstance().getLanguageManager().get("serverside.command.generic.not_enough_emc"));
                }
            }
        }
    }

    private void handleTransaction(HumanEntity humanEntity, TransmutationGUI gui) {
        int i;
        Player player = (Player)humanEntity;
        Inventory inventory = gui.getInventory();
        long totalEmcChange = 0L;
        boolean transactionValid = true;
        for (i = 0; i < 54; ++i) {
            ItemStack itemWithoutEmc;
            ItemStack item;
            if (!this.isTransactionArea(i) || (item = inventory.getItem(i)) == null || item.getType().isAir()) continue;
            if (item.getItemMeta() instanceof BlockStateMeta && ((BlockStateMeta)item.getItemMeta()).getBlockState() instanceof ShulkerBox && (itemWithoutEmc = ShulkerBoxUtil.getFirstItemWithoutEmc(item)) != null) {
                LanguageManager lang = ProjectE.getInstance().getLanguageManager();
                HashMap<String, String> placeholders = new HashMap<String, String>();
                String shulkerColor = item.getType().name().replace("_SHULKER_BOX", "").toLowerCase();
                placeholders.put("color", shulkerColor);
                placeholders.put("item_id", item.getType().name());
                placeholders.put("item", itemWithoutEmc.hasItemMeta() && itemWithoutEmc.getItemMeta().hasDisplayName() ? itemWithoutEmc.getItemMeta().getDisplayName() : itemWithoutEmc.getType().name());
                player.sendMessage(lang.get("serverside.command.generic.shulker_box_no_emc", placeholders));
                HashMap remainingItems = player.getInventory().addItem(new ItemStack[]{item});
                if (!remainingItems.isEmpty()) {
                    for (ItemStack remaining : remainingItems.values()) {
                        player.getWorld().dropItemNaturally(player.getLocation(), remaining);
                    }
                }
                inventory.setItem(i, null);
                transactionValid = false;
                continue;
            }
            long itemEmc = this.calculateItemSellEmc(item);
            if (itemEmc > 0L) {
                totalEmcChange += itemEmc;
                String itemKey = ProjectE.getInstance().getEmcManager().getItemKey(item);
                ProjectE.getInstance().getDatabaseManager().addLearnedItem(player.getUniqueId(), itemKey);
                if (!(item.getItemMeta() instanceof BlockStateMeta) || !(((BlockStateMeta)item.getItemMeta()).getBlockState() instanceof ShulkerBox)) continue;
                BlockStateMeta bsm = (BlockStateMeta)item.getItemMeta();
                ShulkerBox shulkerBox = (ShulkerBox)bsm.getBlockState();
                for (ItemStack contentItem : shulkerBox.getInventory().getContents()) {
                    if (contentItem == null || contentItem.getType().isAir()) continue;
                    ProjectE.getInstance().getDatabaseManager().addLearnedItem(player.getUniqueId(), ProjectE.getInstance().getEmcManager().getItemKey(contentItem));
                }
                continue;
            }
            this.handleNoEmcItem(player, item);
            HashMap remainingItems = player.getInventory().addItem(new ItemStack[]{item});
            if (!remainingItems.isEmpty()) {
                for (ItemStack remaining : remainingItems.values()) {
                    player.getWorld().dropItemNaturally(player.getLocation(), remaining);
                }
            }
            inventory.setItem(i, null);
            transactionValid = false;
        }
        if (!transactionValid) {
            player.sendMessage(ProjectE.getInstance().getLanguageManager().get("serverside.command.generic.partial_trade_fail"));
            this.updateSellButton(gui);
            return;
        }
        if (totalEmcChange > 0L) {
            long currentEmc = ProjectE.getInstance().getDatabaseManager().getPlayerEmc(player.getUniqueId());
            long newEmc = currentEmc + totalEmcChange;
            ProjectE.getInstance().getDatabaseManager().setPlayerEmc(player.getUniqueId(), newEmc);
            LanguageManager lang = ProjectE.getInstance().getLanguageManager();
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("emc", String.format("%,d", totalEmcChange));
            player.sendMessage(lang.get("serverside.command.generic.sell_success", placeholders));
        }
        for (i = 0; i < 54; ++i) {
            if (!this.isTransactionArea(i)) continue;
            inventory.setItem(i, null);
        }
        this.refreshGui(player, gui);
    }

    private void handleLearnScreenClick(InventoryClickEvent event, TransmutationGUI gui) {
        int slot = event.getSlot();
        if (event.getClickedInventory() != gui.getInventory()) {
            return;
        }
        if (slot == 0) {
            this.returnCursorItemToPlayer(event);
            gui.setState(TransmutationGUI.GuiState.MAIN);
        } else if (slot == 49) {
            this.handleLearn(event.getWhoClicked(), gui);
        } else if (this.isTransactionArea(slot)) {
            event.setCancelled(false);
        }
    }

    private void handleLearn(HumanEntity humanEntity, TransmutationGUI gui) {
        ItemStack item;
        int i;
        Player player = (Player)humanEntity;
        Inventory inventory = gui.getInventory();
        boolean learnedSomething = false;
        for (i = 0; i < 54; ++i) {
            if (!this.isTransactionArea(i) || (item = inventory.getItem(i)) == null || item.getType().isAir()) continue;
            String itemKey = ProjectE.getInstance().getEmcManager().getItemKey(item);
            long itemEmc = ProjectE.getInstance().getEmcManager().getEmc(itemKey);
            if (itemEmc > 0L) {
                ProjectE.getInstance().getDatabaseManager().addLearnedItem(player.getUniqueId(), itemKey);
                learnedSomething = true;
                continue;
            }
            this.handleNoEmcItem(player, item);
        }
        if (learnedSomething) {
            player.sendMessage(ProjectE.getInstance().getLanguageManager().get("serverside.command.generic.learn_success"));
        }
        for (i = 0; i < 54; ++i) {
            if (!this.isTransactionArea(i)) continue;
            item = inventory.getItem(i);
            World world = player.getWorld();
            if (item == null || item.getType().isAir()) continue;
            player.getInventory().addItem(new ItemStack[]{item});
            inventory.setItem(i, null);
        }
        player.closeInventory();
    }

    private void refreshGui(Player player, TransmutationGUI oldGui) {
        TransmutationGUI.GuiState state = oldGui.getCurrentState();
        int page = oldGui.getPage();
        String searchQuery = oldGui.getSearchQuery();
        player.closeInventory();
        ProjectE.getInstance().getSchedulerAdapter().runTaskLater(() -> {
            TransmutationGUI newGui = new TransmutationGUI(player);
            newGui.setState(state);
            newGui.setPage(page);
            if (searchQuery != null && !searchQuery.isEmpty()) {
                newGui.setSearchQuery(searchQuery);
            }
            newGui.open();
        }, 1L);
    }

    @EventHandler
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        if (this.searchingPlayers.containsKey(player) && this.searchingPlayers.get(player).booleanValue()) {
            event.setCancelled(true);
            String searchQuery = event.getMessage();
            Debug.log("Search query from chat: '" + searchQuery + "'");
            this.searchingPlayers.remove(player);
            ProjectE.getInstance().getSchedulerAdapter().runTask(() -> {
                Debug.log("Re-opening TransmutationGUI for " + player.getName() + " with search query: '" + searchQuery + "'");
                TransmutationGUI newGui = new TransmutationGUI(player);
                newGui.setState(TransmutationGUI.GuiState.BUY);
                if (searchQuery != null && !searchQuery.trim().isEmpty()) {
                    newGui.setSearchQuery(searchQuery);
                }
                newGui.open();
            });
        }
    }

    private boolean isTransactionArea(int slot) {
        return slot > 9 && slot < 44 && slot % 9 != 0 && slot % 9 != 8;
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        InventoryHolder holder = event.getInventory().getHolder();
        if (!(holder instanceof TransmutationGUI)) {
            return;
        }
        TransmutationGUI gui = (TransmutationGUI)holder;
        if (gui.getCurrentState() == TransmutationGUI.GuiState.SELL || gui.getCurrentState() == TransmutationGUI.GuiState.LEARN || gui.getCurrentState() == TransmutationGUI.GuiState.CHARGE) {
            Inventory inventory = event.getInventory();
            Player player = (Player)event.getPlayer();
            for (int i = 0; i < 54; ++i) {
                HashMap remainingItems;
                ItemStack item;
                if (!this.isTransactionArea(i) || (item = inventory.getItem(i)) == null || item.getType().isAir() || (remainingItems = player.getInventory().addItem(new ItemStack[]{item})).isEmpty()) continue;
                for (ItemStack remaining : remainingItems.values()) {
                    player.getWorld().dropItemNaturally(player.getLocation(), remaining);
                }
            }
        }
    }

    private void handleNoEmcItemGUIClick(InventoryClickEvent event) {
        int startIndex;
        event.setCancelled(true);
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        NoEmcItemGUI gui = (NoEmcItemGUI)event.getInventory().getHolder();
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null || clickedItem.getType().isAir()) {
            return;
        }
        int slot = event.getSlot();
        if (slot == 45 && gui.getPage() > 0) {
            new NoEmcItemGUI(gui.getItems(), gui.getPage() - 1).openInventory(player);
        } else if (slot == 53 && (startIndex = (gui.getPage() + 1) * 45) < gui.getItems().size()) {
            new NoEmcItemGUI(gui.getItems(), gui.getPage() + 1).openInventory(player);
        }
    }

    private void handleChargeScreenClick(InventoryClickEvent event, TransmutationGUI gui) {
        int slot = event.getSlot();
        if (event.getClickedInventory() != gui.getInventory()) {
            return;
        }
        if (slot == 0) {
            this.returnCursorItemToPlayer(event);
            gui.setState(TransmutationGUI.GuiState.MAIN);
        } else if (slot == 49) {
            Player player = (Player)event.getWhoClicked();
            Inventory inventory = gui.getInventory();
            DatabaseManager databaseManager = ProjectE.getInstance().getDatabaseManager();
            EmcManager emcManager = ProjectE.getInstance().getEmcManager();
            LanguageManager languageManager = ProjectE.getInstance().getLanguageManager();
            KleinStarManager kleinStarManager = ProjectE.getInstance().getKleinStarManager();
            ItemStack kleinStarItem = null;
            int kleinStarSlot = -1;
            int itemCount = 0;
            for (int i = 0; i < 54; ++i) {
                ItemStack item;
                if (!this.isTransactionArea(i) || (item = inventory.getItem(i)) == null || item.getType().isAir()) continue;
                ++itemCount;
                if (kleinStarManager.isKleinStar(item)) {
                    if (kleinStarItem != null) {
                        player.sendMessage(languageManager.get("serverside.command.generic.multiple_klein_stars"));
                        return;
                    }
                    kleinStarItem = item;
                    kleinStarSlot = i;
                    continue;
                }
                player.sendMessage(languageManager.get("serverside.command.generic.invalid_charge_item"));
                return;
            }
            if (kleinStarItem == null) {
                player.sendMessage(languageManager.get("serverside.command.generic.no_klein_star"));
                return;
            }
            if (itemCount > 1) {
                player.sendMessage(languageManager.get("serverside.command.generic.multiple_items_in_charge"));
                return;
            }
            long playerEmc = databaseManager.getPlayerEmc(player.getUniqueId());
            long storedEmc = kleinStarManager.getStoredEmc(kleinStarItem);
            long capacity = kleinStarManager.getCapacity(kleinStarItem);
            long space = capacity - storedEmc;
            if (playerEmc <= 0L) {
                player.sendMessage(languageManager.get("serverside.command.generic.not_enough_emc_to_charge"));
                return;
            }
            if (space <= 0L) {
                player.sendMessage(languageManager.get("serverside.command.generic.klein_star_full"));
                return;
            }
            long amountToCharge = event.isShiftClick() ? space : Math.min(playerEmc, space);
            if (amountToCharge <= 0L) {
                player.sendMessage(languageManager.get("serverside.command.generic.not_enough_emc_to_charge"));
                return;
            }
            if (playerEmc < amountToCharge) {
                player.sendMessage(languageManager.get("serverside.command.generic.not_enough_emc_to_charge"));
                return;
            }
            databaseManager.setPlayerEmc(player.getUniqueId(), playerEmc - amountToCharge);
            ItemStack updatedKleinStar = kleinStarManager.setStoredEmc(kleinStarItem, storedEmc + amountToCharge);
            inventory.setItem(kleinStarSlot, null);
            player.getInventory().addItem(new ItemStack[]{updatedKleinStar});
            this.refreshGui(player, gui);
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("emc", String.format("%,d", amountToCharge));
            player.sendMessage(languageManager.get("serverside.command.generic.charge_success", placeholders));
        } else if (this.isTransactionArea(slot)) {
            event.setCancelled(false);
        }
    }

    private void handleNoEmcItem(Player player, ItemStack item) {
        LanguageManager lang = ProjectE.getInstance().getLanguageManager();
        HashMap<String, String> placeholders = new HashMap<String, String>();
        String displayName = item.hasItemMeta() && item.getItemMeta().hasDisplayName() ? item.getItemMeta().getDisplayName() : item.getType().name();
        placeholders.put("item", displayName);
        player.sendMessage(lang.get("serverside.command.generic.no_emc_value_trade", placeholders));
    }

    private void returnCursorItemToPlayer(InventoryClickEvent event) {
        ItemStack cursorItem = event.getCursor();
        if (cursorItem != null && !cursorItem.getType().isAir()) {
            Player player = (Player)event.getWhoClicked();
            HashMap remaining = player.getInventory().addItem(new ItemStack[]{cursorItem});
            if (!remaining.isEmpty()) {
                for (ItemStack item : remaining.values()) {
                    player.getWorld().dropItemNaturally(player.getLocation(), item);
                }
            }
            event.setCursor(null);
        }
    }
}

