/*
 * Decompiled with CFR 0.152.
 */
package org.Little_100.projecte.gui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.Little_100.projecte.ProjectE;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class ProjectEGiveGUI
implements Listener {
    private final ProjectE plugin;
    private final Player player;
    private Inventory inventory;
    private int currentPage = 0;
    private static final int ITEMS_PER_PAGE = 45;
    private static final int PREV_PAGE_SLOT = 48;
    private static final int CLOSE_SLOT = 49;
    private static final int NEXT_PAGE_SLOT = 50;
    private final List<GiveItem> allItems = new ArrayList<GiveItem>();

    public ProjectEGiveGUI(ProjectE plugin, Player player) {
        this.plugin = plugin;
        this.player = player;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.initializeItems();
    }

    private void initializeItems() {
        this.addItem("philosophers_stone", "\u00a75\u8d24\u8005\u4e4b\u77f3", "\u5de5\u5177", this.plugin.getPhilosopherStone());
        this.addItem("dark_matter_pickaxe", "\u00a7d\u6697\u7269\u8d28\u9550", "\u5de5\u5177", this.plugin.getItemStackFromKey("dark_matter_pickaxe"));
        this.addItem("dark_matter_axe", "\u00a7d\u6697\u7269\u8d28\u65a7", "\u5de5\u5177", this.plugin.getItemStackFromKey("dark_matter_axe"));
        this.addItem("dark_matter_shovel", "\u00a7d\u6697\u7269\u8d28\u9539", "\u5de5\u5177", this.plugin.getItemStackFromKey("dark_matter_shovel"));
        this.addItem("dark_matter_sword", "\u00a7d\u6697\u7269\u8d28\u5251", "\u5de5\u5177", this.plugin.getItemStackFromKey("dark_matter_sword"));
        this.addItem("dark_matter_hoe", "\u00a7d\u6697\u7269\u8d28\u9504", "\u5de5\u5177", this.plugin.getItemStackFromKey("dark_matter_hoe"));
        this.addItem("dark_matter_hammer", "\u00a7d\u6697\u7269\u8d28\u9524", "\u5de5\u5177", this.plugin.getItemStackFromKey("dark_matter_hammer"));
        this.addItem("dark_matter_shears", "\u00a7d\u6697\u7269\u8d28\u526a\u5200", "\u5de5\u5177", this.plugin.getItemStackFromKey("dark_matter_shears"));
        this.addItem("red_matter_pickaxe", "\u00a7c\u7ea2\u7269\u8d28\u9550", "\u5de5\u5177", this.plugin.getItemStackFromKey("red_matter_pickaxe"));
        this.addItem("red_matter_axe", "\u00a7c\u7ea2\u7269\u8d28\u65a7", "\u5de5\u5177", this.plugin.getItemStackFromKey("red_matter_axe"));
        this.addItem("red_matter_shovel", "\u00a7c\u7ea2\u7269\u8d28\u9539", "\u5de5\u5177", this.plugin.getItemStackFromKey("red_matter_shovel"));
        this.addItem("red_matter_sword", "\u00a7c\u7ea2\u7269\u8d28\u5251", "\u5de5\u5177", this.plugin.getItemStackFromKey("red_matter_sword"));
        this.addItem("red_matter_hoe", "\u00a7c\u7ea2\u7269\u8d28\u9504", "\u5de5\u5177", this.plugin.getItemStackFromKey("red_matter_hoe"));
        this.addItem("red_matter_hammer", "\u00a7c\u7ea2\u7269\u8d28\u9524", "\u5de5\u5177", this.plugin.getItemStackFromKey("red_matter_hammer"));
        this.addItem("red_matter_shears", "\u00a7c\u7ea2\u7269\u8d28\u526a\u5200", "\u5de5\u5177", this.plugin.getItemStackFromKey("red_matter_shears"));
        this.addItem("klein_star_ein", "\u00a7b\u514b\u83b1\u56e0\u4e4b\u661f Ein", "\u5b58\u50a8", this.plugin.getItemStackFromKey("klein_star_ein"));
        this.addItem("klein_star_zwei", "\u00a7b\u514b\u83b1\u56e0\u4e4b\u661f Zwei", "\u5b58\u50a8", this.plugin.getItemStackFromKey("klein_star_zwei"));
        this.addItem("klein_star_drei", "\u00a7b\u514b\u83b1\u56e0\u4e4b\u661f Drei", "\u5b58\u50a8", this.plugin.getItemStackFromKey("klein_star_drei"));
        this.addItem("klein_star_vier", "\u00a7b\u514b\u83b1\u56e0\u4e4b\u661f Vier", "\u5b58\u50a8", this.plugin.getItemStackFromKey("klein_star_vier"));
        this.addItem("klein_star_sphere", "\u00a7b\u514b\u83b1\u56e0\u4e4b\u661f Sphere", "\u5b58\u50a8", this.plugin.getItemStackFromKey("klein_star_sphere"));
        this.addItem("klein_star_omega", "\u00a7b\u514b\u83b1\u56e0\u4e4b\u661f Omega", "\u5b58\u50a8", this.plugin.getItemStackFromKey("klein_star_omega"));
        this.addItem("dark_matter", "\u00a7d\u6697\u7269\u8d28", "\u6750\u6599", this.plugin.getItemStackFromKey("dark_matter"));
        this.addItem("red_matter", "\u00a7c\u7ea2\u7269\u8d28", "\u6750\u6599", this.plugin.getItemStackFromKey("red_matter"));
        this.addItem("dark_matter_block", "\u00a7d\u6697\u7269\u8d28\u5757", "\u6750\u6599", this.plugin.getItemStackFromKey("dark_matter_block"));
        this.addItem("red_matter_block", "\u00a7c\u7ea2\u7269\u8d28\u5757", "\u6750\u6599", this.plugin.getItemStackFromKey("red_matter_block"));
        this.addItem("low_covalence_dust", "\u00a7f\u4f4e\u7b49\u5171\u4ef7\u7c89", "\u6750\u6599", this.plugin.getItemStackFromKey("low_covalence_dust"));
        this.addItem("medium_covalence_dust", "\u00a7a\u4e2d\u7b49\u5171\u4ef7\u7c89", "\u6750\u6599", this.plugin.getItemStackFromKey("medium_covalence_dust"));
        this.addItem("high_covalence_dust", "\u00a7e\u9ad8\u7b49\u5171\u4ef7\u7c89", "\u6750\u6599", this.plugin.getItemStackFromKey("high_covalence_dust"));
        this.addItem("alchemical_coal", "\u00a7e\u70bc\u91d1\u7164\u70ad", "\u71c3\u6599", this.plugin.getItemStackFromKey("alchemical_coal"));
        this.addItem("mobius_fuel", "\u00a7b\u83ab\u6bd4\u4e4c\u65af\u71c3\u6599", "\u71c3\u6599", this.plugin.getItemStackFromKey("mobius_fuel"));
        this.addItem("aeternalis_fuel", "\u00a7d\u6c38\u6052\u71c3\u6599", "\u71c3\u6599", this.plugin.getItemStackFromKey("aeternalis_fuel"));
        this.addItem("alchemical_coal_block", "\u00a7e\u70bc\u91d1\u7164\u70ad\u5757", "\u71c3\u6599", this.plugin.getItemStackFromKey("alchemical_coal_block"));
        this.addItem("mobius_fuel_block", "\u00a7b\u83ab\u6bd4\u4e4c\u65af\u71c3\u6599\u5757", "\u71c3\u6599", this.plugin.getItemStackFromKey("mobius_fuel_block"));
        this.addItem("aeternalis_fuel_block", "\u00a7d\u6c38\u6052\u71c3\u6599\u5757", "\u71c3\u6599", this.plugin.getItemStackFromKey("aeternalis_fuel_block"));
        this.addItem("dark_matter_helmet", "\u00a7d\u6697\u7269\u8d28\u5934\u76d4", "\u62a4\u7532", this.plugin.getItemStackFromKey("dark_matter_helmet"));
        this.addItem("dark_matter_chestplate", "\u00a7d\u6697\u7269\u8d28\u80f8\u7532", "\u62a4\u7532", this.plugin.getItemStackFromKey("dark_matter_chestplate"));
        this.addItem("dark_matter_leggings", "\u00a7d\u6697\u7269\u8d28\u62a4\u817f", "\u62a4\u7532", this.plugin.getItemStackFromKey("dark_matter_leggings"));
        this.addItem("dark_matter_boots", "\u00a7d\u6697\u7269\u8d28\u9774\u5b50", "\u62a4\u7532", this.plugin.getItemStackFromKey("dark_matter_boots"));
        this.addItem("red_matter_helmet", "\u00a7c\u7ea2\u7269\u8d28\u5934\u76d4", "\u62a4\u7532", this.plugin.getItemStackFromKey("red_matter_helmet"));
        this.addItem("red_matter_chestplate", "\u00a7c\u7ea2\u7269\u8d28\u80f8\u7532", "\u62a4\u7532", this.plugin.getItemStackFromKey("red_matter_chestplate"));
        this.addItem("red_matter_leggings", "\u00a7c\u7ea2\u7269\u8d28\u62a4\u817f", "\u62a4\u7532", this.plugin.getItemStackFromKey("red_matter_leggings"));
        this.addItem("red_matter_boots", "\u00a7c\u7ea2\u7269\u8d28\u9774\u5b50", "\u62a4\u7532", this.plugin.getItemStackFromKey("red_matter_boots"));
        this.addItem("gem_helmet", "\u00a7b\u5b9d\u77f3\u5934\u76d4", "\u62a4\u7532", this.plugin.getItemStackFromKey("gem_helmet"));
        this.addItem("body_stone", "\u00a76\u8eab\u4f53\u4e4b\u77f3", "\u9970\u54c1", this.plugin.getItemStackFromKey("body_stone"));
        this.addItem("soul_stone", "\u00a76\u7075\u9b42\u4e4b\u77f3", "\u9970\u54c1", this.plugin.getItemStackFromKey("soul_stone"));
        this.addItem("life_stone", "\u00a76\u751f\u547d\u4e4b\u77f3", "\u9970\u54c1", this.plugin.getItemStackFromKey("life_stone"));
        this.addItem("mind_stone", "\u00a76\u5fc3\u7075\u4e4b\u77f3", "\u9970\u54c1", this.plugin.getItemStackFromKey("mind_stone"));
        this.addItem("dark_matter_furnace", "\u00a7d\u6697\u7269\u8d28\u7194\u7089", "\u8bbe\u5907", this.plugin.getItemStackFromKey("dark_matter_furnace"));
        this.addItem("red_matter_furnace", "\u00a7c\u7ea2\u7269\u8d28\u7194\u7089", "\u8bbe\u5907", this.plugin.getItemStackFromKey("red_matter_furnace"));
        this.addItem("alchemical_chest", "\u00a7e\u70bc\u91d1\u672f\u7bb1\u5b50", "\u8bbe\u5907", this.plugin.getItemStackFromKey("alchemical_chest"));
        this.addItem("energy_condenser", "\u00a7e\u80fd\u91cf\u51dd\u805a\u5668", "\u8bbe\u5907", this.plugin.getItemStackFromKey("energy_condenser"));
        this.addItem("energy_condenser_mk2", "\u00a7c\u80fd\u91cf\u51dd\u805a\u5668 MK2", "\u8bbe\u5907", this.plugin.getItemStackFromKey("energy_condenser_mk2"));
        this.addItem("energy_collector_mk1", "\u00a7e\u80fd\u91cf\u6536\u96c6\u5668 MK1", "\u8bbe\u5907", this.plugin.getItemStackFromKey("energy_collector_mk1"));
        this.addItem("energy_collector_mk2", "\u00a7b\u80fd\u91cf\u6536\u96c6\u5668 MK2", "\u8bbe\u5907", this.plugin.getItemStackFromKey("energy_collector_mk2"));
        this.addItem("energy_collector_mk3", "\u00a7c\u80fd\u91cf\u6536\u96c6\u5668 MK3", "\u8bbe\u5907", this.plugin.getItemStackFromKey("energy_collector_mk3"));
        this.addItem("alchemical_bag", "\u00a7f\u70bc\u91d1\u672f\u888b", "\u5176\u4ed6", this.plugin.getItemStackFromKey("alchemical_bag"));
        this.addItem("transmutation_tablet_book", "\u00a75\u8f6c\u6362\u684c", "\u5176\u4ed6", this.plugin.getItemStackFromKey("transmutation_tablet_book"));
        this.addItem("repair_talisman", "\u00a76\u4fee\u590d\u62a4\u7b26", "\u5176\u4ed6", this.plugin.getItemStackFromKey("repair_talisman"));
        this.addItem("divining_rod", "\u00a7b\u63a2\u77ff\u6756", "\u5176\u4ed6", this.plugin.getItemStackFromKey("divining_rod"));
    }

    private void addItem(String id, String displayName, String category, ItemStack item) {
        if (item != null) {
            this.allItems.add(new GiveItem(id, displayName, category, item));
        }
    }

    public void open() {
        this.openPage(0);
    }

    private void openPage(int page) {
        int i;
        this.currentPage = page;
        String title = this.plugin.getLanguageManager().get("gui.projecte_give.title").replace("%page%", String.valueOf(page + 1)).replace("%total%", String.valueOf(this.getTotalPages()));
        this.inventory = Bukkit.createInventory(null, (int)54, (String)title);
        int startIndex = page * 45;
        int endIndex = Math.min(startIndex + 45, this.allItems.size());
        for (int i2 = startIndex; i2 < endIndex; ++i2) {
            GiveItem giveItem = this.allItems.get(i2);
            ItemStack displayItem = giveItem.itemStack.clone();
            ItemMeta meta = displayItem.getItemMeta();
            if (meta != null) {
                List lore = meta.hasLore() ? meta.getLore() : new ArrayList();
                lore.add("");
                lore.add("\u00a77\u7c7b\u522b: \u00a7f" + giveItem.category);
                lore.add("\u00a77ID: \u00a7f" + giveItem.id);
                lore.add("");
                lore.add("\u00a7e\u5de6\u952e\u70b9\u51fb\u83b7\u53d6 1 \u4e2a");
                lore.add("\u00a7e\u53f3\u952e\u70b9\u51fb\u83b7\u53d6 64 \u4e2a");
                meta.setLore(lore);
                displayItem.setItemMeta(meta);
            }
            this.inventory.setItem(i2 - startIndex, displayItem);
        }
        ItemStack glassPane = this.createGlassPane();
        for (i = endIndex - startIndex; i < 45; ++i) {
            this.inventory.setItem(i, glassPane);
        }
        for (i = 45; i < 54; ++i) {
            this.inventory.setItem(i, glassPane);
        }
        if (this.currentPage > 0) {
            this.inventory.setItem(48, this.createControlButton(Material.ARROW, this.plugin.getLanguageManager().get("gui.projecte_give.prev_page")));
        }
        this.inventory.setItem(49, this.createControlButton(Material.BARRIER, this.plugin.getLanguageManager().get("gui.projecte_give.close")));
        if (this.currentPage < this.getTotalPages() - 1) {
            this.inventory.setItem(50, this.createControlButton(Material.ARROW, this.plugin.getLanguageManager().get("gui.projecte_give.next_page")));
        }
        this.player.openInventory(this.inventory);
    }

    private int getTotalPages() {
        return (int)Math.ceil((double)this.allItems.size() / 45.0);
    }

    private ItemStack createControlButton(Material material, String name) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(name);
            item.setItemMeta(meta);
        }
        return item;
    }

    private ItemStack createGlassPane() {
        ItemStack glassPane = new ItemStack(Material.GRAY_STAINED_GLASS_PANE);
        ItemMeta meta = glassPane.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(" ");
            glassPane.setItemMeta(meta);
        }
        return glassPane;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        if (!event.getWhoClicked().equals((Object)this.player)) {
            return;
        }
        if (event.getInventory() != this.inventory) {
            return;
        }
        event.setCancelled(true);
        int slot = event.getRawSlot();
        if (slot < 0 || slot >= 54) {
            return;
        }
        if (slot >= 45) {
            if (slot == 48 && this.currentPage > 0) {
                this.openPage(this.currentPage - 1);
            } else if (slot == 50 && this.currentPage < this.getTotalPages() - 1) {
                this.openPage(this.currentPage + 1);
            } else if (slot == 49) {
                this.player.closeInventory();
            }
            return;
        }
        int itemIndex = this.currentPage * 45 + slot;
        if (itemIndex < this.allItems.size()) {
            GiveItem giveItem = this.allItems.get(itemIndex);
            ItemStack item = giveItem.itemStack.clone();
            if (event.isRightClick()) {
                item.setAmount(64);
            } else {
                item.setAmount(1);
            }
            HashMap remaining = this.player.getInventory().addItem(new ItemStack[]{item});
            if (remaining.isEmpty()) {
                this.player.sendMessage("\u00a7a\u5df2\u83b7\u5f97: " + giveItem.displayName + " \u00a77x" + item.getAmount());
            } else {
                this.player.sendMessage("\u00a7c\u80cc\u5305\u7a7a\u95f4\u4e0d\u8db3\uff01");
            }
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        if (!event.getPlayer().equals((Object)this.player)) {
            return;
        }
        if (event.getInventory() != this.inventory) {
            return;
        }
        InventoryClickEvent.getHandlerList().unregister((Listener)this);
        InventoryCloseEvent.getHandlerList().unregister((Listener)this);
    }

    private static class GiveItem {
        String id;
        String displayName;
        String category;
        ItemStack itemStack;

        GiveItem(String id, String displayName, String category, ItemStack itemStack) {
            this.id = id;
            this.displayName = displayName;
            this.category = category;
            this.itemStack = itemStack;
        }
    }
}

