/*
 * Decompiled with CFR 0.152.
 */
package org.Little_100.projecte.gui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.Little_100.projecte.Debug;
import org.Little_100.projecte.ProjectE;
import org.Little_100.projecte.managers.EmcManager;
import org.Little_100.projecte.managers.LanguageManager;
import org.Little_100.projecte.managers.SearchLanguageManager;
import org.Little_100.projecte.storage.DatabaseManager;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class TransmutationGUI
implements InventoryHolder {
    private final Inventory inventory;
    private final Player player;
    private final DatabaseManager databaseManager;
    private final EmcManager emcManager;
    private final LanguageManager languageManager;
    private final SearchLanguageManager searchLanguageManager;
    private GuiState currentState = GuiState.MAIN;
    private int page = 0;
    private String searchQuery = null;

    public TransmutationGUI(Player player) {
        this.player = player;
        this.databaseManager = ProjectE.getInstance().getDatabaseManager();
        this.emcManager = ProjectE.getInstance().getEmcManager();
        this.languageManager = ProjectE.getInstance().getLanguageManager();
        this.searchLanguageManager = ProjectE.getInstance().getSearchLanguageManager();
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)54, (String)this.getTitle());
        this.initializeItems();
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public void open() {
        this.player.openInventory(this.inventory);
    }

    private String getTitle() {
        String formattedEmc = String.format("%,d", this.databaseManager.getPlayerEmc(this.player.getUniqueId()));
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("emc", formattedEmc);
        switch (this.currentState.ordinal()) {
            case 1: {
                return this.languageManager.get("clientside.transmutation_table.sell_title", placeholders);
            }
            case 2: {
                return this.languageManager.get("clientside.transmutation_table.buy_title", placeholders);
            }
            case 4: {
                return this.languageManager.get("clientside.transmutation_table.charge_title", placeholders);
            }
        }
        return this.languageManager.get("clientside.transmutation_table.title", placeholders);
    }

    private void initializeItems() {
        this.inventory.clear();
        switch (this.currentState.ordinal()) {
            case 0: {
                this.setupMainScreen();
                break;
            }
            case 1: {
                this.setupSellScreen();
                break;
            }
            case 2: {
                this.setupBuyScreen();
                break;
            }
            case 3: {
                this.setupLearnScreen();
                break;
            }
            case 4: {
                this.setupChargeScreen();
            }
        }
    }

    private void setupMainScreen() {
        ItemStack sellButton = this.createGuiItem(Material.ANVIL, this.languageManager.get("clientside.transmutation_table.buttons.sell"), this.languageManager.get("clientside.transmutation_table.buttons.sell_lore"));
        ItemStack buyButton = this.createGuiItem(Material.EMERALD, this.languageManager.get("clientside.transmutation_table.buttons.buy"), this.languageManager.get("clientside.transmutation_table.buttons.buy_lore"));
        ItemStack learnButton = this.createGuiItem(Material.BOOK, this.languageManager.get("clientside.transmutation_table.buttons.learn"), this.languageManager.get("clientside.transmutation_table.buttons.learn_lore"));
        ItemStack chargeButton = this.createGuiItem(Material.REDSTONE_TORCH, this.languageManager.get("clientside.transmutation_table.buttons.charge"), this.languageManager.get("clientside.transmutation_table.buttons.charge_lore"));
        this.inventory.setItem(20, sellButton);
        this.inventory.setItem(21, chargeButton);
        this.inventory.setItem(22, buyButton);
        this.inventory.setItem(24, learnButton);
    }

    private void setupSellScreen() {
        this.setupCommon();
        ItemStack confirmButton = this.createGuiItem(Material.EMERALD_BLOCK, this.languageManager.get("clientside.transmutation_table.buttons.confirm_sell"), this.languageManager.get("clientside.transmutation_table.buttons.confirm_sell_lore"));
        ItemStack backButton = this.createGuiItem(Material.BARRIER, this.languageManager.get("clientside.transmutation_table.buttons.back"), this.languageManager.get("clientside.transmutation_table.buttons.back_lore"));
        this.inventory.setItem(49, confirmButton);
        this.inventory.setItem(0, backButton);
    }

    public void setupBuyScreen() {
        this.inventory.clear();
        ItemStack grayPane = this.createGuiItem(Material.LIGHT_GRAY_STAINED_GLASS_PANE, " ", new String[0]);
        for (int i = 0; i < 54; ++i) {
            if (i >= 9 && i <= 44 && i % 9 != 0 && i % 9 != 8) continue;
            this.inventory.setItem(i, grayPane);
        }
        ItemStack searchButton = this.createGuiItem(Material.SNOWBALL, this.languageManager.get("clientside.transmutation_table.buttons.search"), this.languageManager.get("clientside.transmutation_table.buttons.search_lore"));
        if (this.searchQuery != null && !this.searchQuery.isEmpty()) {
            ItemMeta meta = searchButton.getItemMeta();
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("search", this.searchQuery);
            ArrayList<String> lore = new ArrayList<String>();
            lore.add(this.languageManager.get("clientside.transmutation_table.buttons.search_lore_current", placeholders));
            meta.setLore(lore);
            searchButton.setItemMeta(meta);
        }
        this.inventory.setItem(4, searchButton);
        List<String> learnedItems = this.databaseManager.getLearnedItems(this.player.getUniqueId());
        if (this.searchQuery != null && !this.searchQuery.isEmpty()) {
            String searchLower = this.searchQuery.toLowerCase();
            long startTime = System.currentTimeMillis();
            Map<String, String> matchingIds = this.searchLanguageManager.findMatchingIds(searchLower);
            long searchTime = System.currentTimeMillis() - startTime;
            if (ProjectE.getInstance().getConfig().getBoolean("debug")) {
                Debug.log("\u641c\u7d22 '" + this.searchQuery + "' \u627e\u5230 " + matchingIds.size() + " \u4e2a\u6f5c\u5728\u5339\u914d\u9879\uff0c\u8017\u65f6: " + searchTime + "ms");
            }
            ArrayList<String> filteredItems = new ArrayList<String>();
            if (!matchingIds.isEmpty()) {
                for (String itemKey : learnedItems) {
                    item = ProjectE.getInstance().getItemStackFromKey(itemKey);
                    if (item == null) continue;
                    String itemType = item.getType().name().toLowerCase();
                    String minecraftId = "item.minecraft." + itemType;
                    String blockMinecraftId = "block.minecraft." + itemType;
                    String displayName = item.getItemMeta() != null && item.getItemMeta().hasDisplayName() ? item.getItemMeta().getDisplayName().toLowerCase() : itemType;
                    boolean matches = matchingIds.containsKey(minecraftId) || matchingIds.containsKey(blockMinecraftId) || displayName.contains(searchLower) || itemType.contains(searchLower) || itemType.replace("_", " ").contains(searchLower);
                    if (!matches) continue;
                    filteredItems.add(itemKey);
                    if (!ProjectE.getInstance().getConfig().getBoolean("debug")) continue;
                    Debug.log("\u5339\u914d\u6210\u529f: " + itemKey);
                }
            } else {
                for (String itemKey : learnedItems) {
                    item = ProjectE.getInstance().getItemStackFromKey(itemKey);
                    if (item == null) continue;
                    String displayName = item.getItemMeta() != null && item.getItemMeta().hasDisplayName() ? item.getItemMeta().getDisplayName().toLowerCase() : "";
                    String typeName = item.getType().name().toLowerCase();
                    if (!displayName.contains(searchLower) && !typeName.contains(searchLower) && !typeName.replace("_", " ").contains(searchLower)) continue;
                    filteredItems.add(itemKey);
                    if (!ProjectE.getInstance().getConfig().getBoolean("debug")) continue;
                    Debug.log("\u7b80\u5355\u5339\u914d: " + itemKey);
                }
            }
            if (ProjectE.getInstance().getConfig().getBoolean("debug")) {
                Debug.log("\u6700\u7ec8\u5339\u914d\u5230 " + filteredItems.size() + " \u4e2a\u5df2\u5b66\u4e60\u7684\u7269\u54c1");
            }
            learnedItems = filteredItems;
        }
        int itemsPerPage = 28;
        int startIndex = this.page * itemsPerPage;
        int endIndex = Math.min(startIndex + itemsPerPage, learnedItems.size());
        int slotIndex = 0;
        for (int i = startIndex; i < endIndex; ++i) {
            long emc;
            String itemKey = learnedItems.get(i);
            ItemStack item = ProjectE.getInstance().getItemStackFromKey(itemKey);
            if (item == null || (emc = this.emcManager.getEmc(itemKey)) <= 0L) continue;
            ItemMeta meta = item.getItemMeta();
            long stackEmc = emc * (long)item.getMaxStackSize();
            HashMap<String, String> lorePlaceholders = new HashMap<String, String>();
            lorePlaceholders.put("emc", String.format("%,d", emc));
            lorePlaceholders.put("stack_emc", String.format("%,d", stackEmc));
            lorePlaceholders.put("amount", String.valueOf(item.getMaxStackSize()));
            meta.setLore(Arrays.asList(this.languageManager.get("clientside.transmutation_table.item_lore.emc_single", lorePlaceholders), this.languageManager.get("clientside.transmutation_table.item_lore.emc_stack", lorePlaceholders), this.languageManager.get("clientside.transmutation_table.item_lore.buy_one", lorePlaceholders), this.languageManager.get("clientside.transmutation_table.item_lore.buy_stack", lorePlaceholders)));
            item.setItemMeta(meta);
            int row = slotIndex / 7;
            int col = slotIndex % 7;
            this.inventory.setItem(9 + row * 9 + (col + 1), item);
            ++slotIndex;
        }
        ItemStack backButton = this.createGuiItem(Material.BARRIER, this.languageManager.get("clientside.transmutation_table.buttons.back"), this.languageManager.get("clientside.transmutation_table.buttons.back_lore"));
        this.inventory.setItem(0, backButton);
        if (this.page > 0) {
            ItemStack prevButton = this.createGuiItem(Material.ARROW, this.languageManager.get("clientside.transmutation_table.buttons.prev_page"), new String[0]);
            this.inventory.setItem(48, prevButton);
        }
        if (endIndex < learnedItems.size()) {
            ItemStack nextButton = this.createGuiItem(Material.ARROW, this.languageManager.get("clientside.transmutation_table.buttons.next_page"), new String[0]);
            this.inventory.setItem(50, nextButton);
        }
    }

    private void setupLearnScreen() {
        this.setupCommon();
        ItemStack confirmButton = this.createGuiItem(Material.EMERALD_BLOCK, this.languageManager.get("clientside.transmutation_table.buttons.confirm_learn"), this.languageManager.get("clientside.transmutation_table.buttons.confirm_learn_lore"));
        ItemStack backButton = this.createGuiItem(Material.BARRIER, this.languageManager.get("clientside.transmutation_table.buttons.back"), this.languageManager.get("clientside.transmutation_table.buttons.back_lore"));
        this.inventory.setItem(49, confirmButton);
        this.inventory.setItem(0, backButton);
    }

    private void setupChargeScreen() {
        this.setupCommon();
        ItemStack confirmButton = this.createGuiItem(Material.EMERALD_BLOCK, this.languageManager.get("clientside.transmutation_table.buttons.confirm_charge"), this.languageManager.get("clientside.transmutation_table.buttons.confirm_charge_lore"));
        ItemStack backButton = this.createGuiItem(Material.BARRIER, this.languageManager.get("clientside.transmutation_table.buttons.back"), this.languageManager.get("clientside.transmutation_table.buttons.back_lore"));
        this.inventory.setItem(49, confirmButton);
        this.inventory.setItem(0, backButton);
    }

    private void setupCommon() {
        int i;
        ItemStack grayPane = this.createGuiItem(Material.LIGHT_GRAY_STAINED_GLASS_PANE, " ", new String[0]);
        for (i = 0; i < 54; ++i) {
            this.inventory.setItem(i, grayPane);
        }
        for (i = 1; i < 5; ++i) {
            for (int j = 1; j < 8; ++j) {
                this.inventory.setItem(i * 9 + j, null);
            }
        }
    }

    public GuiState getCurrentState() {
        return this.currentState;
    }

    public void setState(GuiState state) {
        this.currentState = state;
        this.page = 0;
        this.initializeItems();
    }

    public void setPage(int page) {
        this.page = page;
        this.initializeItems();
    }

    public int getPage() {
        return this.page;
    }

    public String getSearchQuery() {
        return this.searchQuery;
    }

    public void setSearchQuery(String query) {
        this.searchQuery = query;
        this.page = 0;
        this.initializeItems();
    }

    protected ItemStack createGuiItem(Material material, String name, String ... lore) {
        ItemStack item = new ItemStack(material, 1);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(name);
        meta.setLore(Arrays.asList(lore));
        item.setItemMeta(meta);
        return item;
    }

    private boolean isGuiItem(int slot, GuiState state) {
        if (state == GuiState.CHARGE) {
            if (slot == 49 || slot == 0) {
                return true;
            }
            if (slot >= 1 && slot <= 7) {
                return true;
            }
            if (slot >= 46 && slot <= 52) {
                return true;
            }
            if (slot % 9 == 0 || slot % 9 == 8) {
                return true;
            }
        }
        return false;
    }

    public static enum GuiState {
        MAIN,
        SELL,
        BUY,
        LEARN,
        CHARGE;

    }
}

