/*
 * Decompiled with CFR 0.152.
 */
package org.Little_100.projecte.managers;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.Little_100.projecte.Debug;
import org.Little_100.projecte.ProjectE;
import org.Little_100.projecte.alchemicalbag.AlchemicalBagManager;
import org.Little_100.projecte.managers.FuelManager;
import org.Little_100.projecte.util.CustomModelDataUtil;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class RecipeManager {
    private final ProjectE plugin;
    private final Map<String, NamespacedKey> recipeKeys = new HashMap<String, NamespacedKey>();

    public RecipeManager(ProjectE plugin) {
        this.plugin = plugin;
    }

    public void registerAllRecipes() {
        this.loadRecipesFromYaml();
        this.loadOpItemRecipes();
        this.registerUpgradeRecipes();
        this.registerDowngradeRecipes();
        this.registerOreTransmutationRecipes();
        this.loadDeviceRecipes();
        this.registerSpecialFuelRecipes();
    }

    private void loadDeviceRecipes() {
        YamlConfiguration config;
        ConfigurationSection devicesSection;
        File deviceFile = new File(this.plugin.getDataFolder(), "devices.yml");
        if (!deviceFile.exists()) {
            this.plugin.saveResource("devices.yml", false);
        }
        if ((devicesSection = (config = YamlConfiguration.loadConfiguration((File)deviceFile)).getConfigurationSection("devices")) == null) {
            return;
        }
        for (String id : devicesSection.getKeys(false)) {
            ConfigurationSection recipeConfig = devicesSection.getConfigurationSection(id);
            if (recipeConfig == null || !recipeConfig.getBoolean("enabled", true)) continue;
            this.parseRecipe(id, recipeConfig);
        }
        this.plugin.getLogger().info("devices.yml loaded");
    }

    private void loadRecipesFromYaml() {
        YamlConfiguration config;
        ConfigurationSection recipesSection;
        File recipeFile = new File(this.plugin.getDataFolder(), "recipe.yml");
        if (!recipeFile.exists()) {
            this.plugin.getLogger().info("\u672a\u627e\u5230 recipe.yml\uff0c\u6b63\u5728\u521b\u5efa\u9ed8\u8ba4\u6587\u4ef6\u3002");
            this.plugin.saveResource("recipe.yml", false);
        }
        if ((recipesSection = (config = YamlConfiguration.loadConfiguration((File)recipeFile)).getConfigurationSection("recipes")) == null) {
            return;
        }
        for (String id : recipesSection.getKeys(false)) {
            ConfigurationSection recipeConfig;
            if (recipesSection.isList(id)) {
                List recipeList = recipesSection.getMapList(id);
                int i = 0;
                for (Map recipeMap : recipeList) {
                    ConfigurationSection recipeConfig2 = new YamlConfiguration().createSection("recipe", recipeMap);
                    if (!recipeConfig2.getBoolean("enabled", true)) continue;
                    this.parseRecipe(id + "_" + i, recipeConfig2);
                    ++i;
                }
                continue;
            }
            if (!recipesSection.isConfigurationSection(id) || (recipeConfig = recipesSection.getConfigurationSection(id)) == null || !recipeConfig.getBoolean("enabled", true)) continue;
            this.parseRecipe(id, recipeConfig);
        }
        this.plugin.getLogger().info("recipe.yml loaded");
    }

    private void loadOpItemRecipes() {
        File opItemFile = new File(this.plugin.getDataFolder(), "op_item.yml");
        if (!opItemFile.exists()) {
            this.plugin.saveResource("op_item.yml", false);
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)opItemFile);
        for (String id : config.getKeys(false)) {
            ConfigurationSection recipeConfig;
            if (!config.isConfigurationSection(id) || (recipeConfig = config.getConfigurationSection(id)) == null || !recipeConfig.isSet("type") || !recipeConfig.getBoolean("enabled", true)) continue;
            this.parseRecipe(id, recipeConfig);
        }
        this.plugin.getLogger().info("op_item.yml recipes loaded");
    }

    private void parseRecipe(String id, ConfigurationSection config) {
        if (id.contains("_pickaxe") || id.contains("_axe") || id.contains("_shovel") || id.contains("_hoe") || id.contains("_sword") || id.contains("_shears") || id.contains("_hammer")) {
            if (id.startsWith("dark_matter_") && !this.plugin.getConfig().getBoolean("Tools.dark_matter_tools_enabled", true)) {
                return;
            }
            if (id.startsWith("red_matter_") && !this.plugin.getConfig().getBoolean("Tools.red_matter_tools_enabled", true)) {
                return;
            }
        }
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("recipe", id);
        Debug.log("debug.recipe.loading_recipe", placeholders);
        String type = config.getString("type", "shaped").toLowerCase();
        if (type.equals("shaped")) {
            this.parseShapedRecipe(id, config);
        } else if (type.equals("shapeless")) {
            this.parseShapelessRecipe(id, config);
        }
    }

    private void parseShapedRecipe(String id, ConfigurationSection config) {
        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, id);
        String originalId = id.split("_")[0];
        int kleinStarLevel = this.getKleinStarLevelFromId(originalId);
        ItemStack result = kleinStarLevel != -1 ? this.plugin.getKleinStarManager().getKleinStar(kleinStarLevel) : this.createResultStack(config.getConfigurationSection("result"));
        if (result == null) {
            if (this.plugin.getConfig().getBoolean("debug")) {
                this.plugin.getLogger().warning("[Debug] Recipe " + id + " has a null result. Skipping.");
            }
            return;
        }
        ShapedRecipe recipe = new ShapedRecipe(key, result);
        recipe.shape(config.getStringList("shape").toArray(new String[0]));
        ConfigurationSection ingredients = config.getConfigurationSection("ingredients");
        if (ingredients != null) {
            for (String ingredientKey : ingredients.getKeys(false)) {
                char keyChar = ingredientKey.charAt(0);
                String ingredientValue = ingredients.getString(ingredientKey);
                RecipeChoice choice = this.getChoice(ingredientValue);
                if (choice != null) {
                    try {
                        recipe.setIngredient(keyChar, choice);
                        if (!this.plugin.getConfig().getBoolean("debug")) continue;
                        this.plugin.getLogger().info("[Debug] Recipe " + id + ": ingredient " + keyChar + " = " + ingredientValue);
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        this.plugin.getLogger().severe("ERROR in recipe '" + id + "': Character '" + keyChar + "' does not appear in shape " + Arrays.toString(config.getStringList("shape").toArray()));
                        this.plugin.getLogger().severe("Recipe shape: " + String.valueOf(config.getStringList("shape")));
                        this.plugin.getLogger().severe("Trying to set ingredient: " + keyChar + " = " + ingredientValue);
                        throw e;
                    }
                }
                if (!this.plugin.getConfig().getBoolean("debug")) continue;
                this.plugin.getLogger().warning("[Debug] Recipe " + id + ": ingredient " + keyChar + " (" + ingredientValue + ") is invalid. Skipping.");
            }
        }
        Bukkit.addRecipe((Recipe)recipe);
        this.recipeKeys.put(id, key);
        if (this.plugin.getConfig().getBoolean("debug")) {
            this.plugin.getLogger().info("[Debug] Successfully registered shaped recipe: " + id);
        }
    }

    private void parseShapelessRecipe(String id, ConfigurationSection config) {
        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, id);
        String originalId = id.split("_")[0];
        int kleinStarLevel = this.getKleinStarLevelFromId(originalId);
        ItemStack result = kleinStarLevel != -1 ? this.plugin.getKleinStarManager().getKleinStar(kleinStarLevel) : this.createResultStack(config.getConfigurationSection("result"));
        if (result == null) {
            if (this.plugin.getConfig().getBoolean("debug")) {
                this.plugin.getLogger().warning("[Debug] Recipe " + id + " has a null result. Skipping.");
            }
            return;
        }
        ShapelessRecipe recipe = new ShapelessRecipe(key, result);
        List ingredients = config.getStringList("ingredients");
        for (String ingredientValue : ingredients) {
            RecipeChoice choice = this.getChoice(ingredientValue);
            if (choice != null) {
                recipe.addIngredient(choice);
                if (!this.plugin.getConfig().getBoolean("debug")) continue;
                this.plugin.getLogger().info("[Debug] Recipe " + id + ": ingredient = " + ingredientValue);
                continue;
            }
            if (!this.plugin.getConfig().getBoolean("debug")) continue;
            this.plugin.getLogger().warning("[Debug] Recipe " + id + ": ingredient " + ingredientValue + " is invalid. Skipping.");
        }
        Bukkit.addRecipe((Recipe)recipe);
        this.recipeKeys.put(id, key);
        if (this.plugin.getConfig().getBoolean("debug")) {
            this.plugin.getLogger().info("[Debug] Successfully registered shapeless recipe: " + id);
        }
    }

    private RecipeChoice getChoice(String ingredient) {
        if (this.plugin.getConfig().getBoolean("debug")) {
            this.plugin.getLogger().info("[Debug] Getting choice for ingredient: " + ingredient);
        }
        if (ingredient.startsWith("projecte:")) {
            String customItemId = ingredient.substring(9);
            ItemStack customItem = customItemId.equals("alchemical_bag") ? AlchemicalBagManager.getAlchemicalBag() : this.plugin.getItemStackFromKey(customItemId);
            if (customItem != null) {
                if (this.plugin.getConfig().getBoolean("debug")) {
                    this.plugin.getLogger().info("[Debug] Matched custom item: " + customItemId);
                }
                return new RecipeChoice.ExactChoice(customItem);
            }
            if (this.plugin.getConfig().getBoolean("debug")) {
                this.plugin.getLogger().warning("[Debug] Custom item not found: " + customItemId);
            }
            return null;
        }
        if (ingredient.equalsIgnoreCase("any_wool")) {
            if (this.plugin.getConfig().getBoolean("debug")) {
                this.plugin.getLogger().info("[Debug] Matched special case: any_wool");
            }
            return new RecipeChoice.MaterialChoice(new Material[]{Material.WHITE_WOOL, Material.ORANGE_WOOL, Material.MAGENTA_WOOL, Material.LIGHT_BLUE_WOOL, Material.YELLOW_WOOL, Material.LIME_WOOL, Material.PINK_WOOL, Material.GRAY_WOOL, Material.LIGHT_GRAY_WOOL, Material.CYAN_WOOL, Material.PURPLE_WOOL, Material.BLUE_WOOL, Material.BROWN_WOOL, Material.GREEN_WOOL, Material.RED_WOOL, Material.BLACK_WOOL});
        }
        if (ingredient.equalsIgnoreCase("any_dye")) {
            if (this.plugin.getConfig().getBoolean("debug")) {
                this.plugin.getLogger().info("[Debug] Matched special case: any_dye");
            }
            return new RecipeChoice.MaterialChoice(new Material[]{Material.RED_DYE, Material.GREEN_DYE, Material.BLUE_DYE, Material.WHITE_DYE, Material.BLACK_DYE, Material.YELLOW_DYE, Material.PURPLE_DYE, Material.ORANGE_DYE});
        }
        if (ingredient.equalsIgnoreCase("any_stone")) {
            if (this.plugin.getConfig().getBoolean("debug")) {
                this.plugin.getLogger().info("[Debug] Matched special case: any_stone");
            }
            return new RecipeChoice.MaterialChoice(new Material[]{Material.STONE, Material.COBBLESTONE, Material.ANDESITE, Material.DIORITE, Material.GRANITE, Material.STONE_BRICKS, Material.COBBLESTONE_STAIRS, Material.STONE_STAIRS, Material.ANDESITE_STAIRS, Material.DIORITE_STAIRS, Material.GRANITE_STAIRS, Material.STONE_SLAB, Material.COBBLESTONE_SLAB, Material.ANDESITE_SLAB, Material.DIORITE_SLAB, Material.GRANITE_SLAB, Material.SMOOTH_STONE, Material.SMOOTH_STONE_SLAB});
        }
        try {
            String materialName = ingredient;
            if (materialName.startsWith("minecraft:")) {
                materialName = materialName.substring(10);
            }
            Material material = Material.valueOf((String)materialName.toUpperCase());
            if (this.plugin.getConfig().getBoolean("debug")) {
                this.plugin.getLogger().info("[Debug] Matched material: " + material.name());
            }
            return new RecipeChoice.MaterialChoice(material);
        }
        catch (IllegalArgumentException e) {
            if (this.plugin.getConfig().getBoolean("debug")) {
                this.plugin.getLogger().warning("[Debug] No choice found for ingredient: " + ingredient);
            }
            return null;
        }
    }

    private void registerSpecialFuelRecipes() {
        String[] wrongRecipeIds;
        FuelManager fuelManager = this.plugin.getFuelManager();
        ItemStack philosopherStone = this.plugin.getPhilosopherStone();
        boolean alchemicalCoalExists = this.recipeKeys.containsKey("alchemical_coal");
        boolean mobiusFuelExists = this.recipeKeys.containsKey("mobius_fuel");
        boolean aeternalisFuelExists = this.recipeKeys.containsKey("aeternalis_fuel");
        boolean aeternalisToMobiusExists = this.recipeKeys.containsKey("aeternalis_to_mobius");
        boolean mobiusToAlchemicalExists = this.recipeKeys.containsKey("mobius_to_alchemical");
        boolean alchemicalToCoalExists = this.recipeKeys.containsKey("alchemical_to_coal");
        for (String wrongId : wrongRecipeIds = new String[]{"aeternalis_to_alchemical", "aeternalis_to_coal", "wrong_aeternalis_recipe", "aeternalis_downgrade"}) {
            if (!this.recipeKeys.containsKey(wrongId)) continue;
            NamespacedKey wrongKey = this.recipeKeys.get(wrongId);
            Bukkit.removeRecipe((NamespacedKey)wrongKey);
            this.recipeKeys.remove(wrongId);
            this.plugin.getLogger().warning("\u5df2\u5220\u9664\u9519\u8bef\u7684\u71c3\u6599\u914d\u65b9: " + wrongId);
        }
        Iterator it = Bukkit.recipeIterator();
        while (it.hasNext()) {
            Recipe recipe = (Recipe)it.next();
            NamespacedKey key = null;
            if (recipe instanceof Keyed) {
                key = ((Keyed)recipe).getKey();
            }
            if (key == null || !key.getNamespace().equals(this.plugin.getName().toLowerCase()) || !key.getKey().contains("aeternalis") || !key.getKey().contains("alchemical") || key.getKey().equals("aeternalis_to_mobius")) continue;
            it.remove();
            this.plugin.getLogger().warning("\u5220\u9664\u4e86\u9519\u8bef\u7684\u71c3\u6599\u914d\u65b9: " + key.toString());
        }
        this.validateFuelRecipeChain();
        if (!alchemicalCoalExists) {
            this.registerFuelUpgradeRecipe("code_alchemical_coal", new ItemStack(Material.COAL, 4), fuelManager.getAlchemicalCoal(), philosopherStone);
            this.plugin.getLogger().info("Registered alchemical coal recipe from code");
        }
        if (!mobiusFuelExists) {
            this.registerFuelUpgradeRecipe("code_mobius_fuel", fuelManager.getAlchemicalCoal(), 4, fuelManager.getMobiusFuel(), 1, philosopherStone);
            this.plugin.getLogger().info("Registered mobius fuel recipe from code");
        }
        if (!aeternalisFuelExists) {
            this.registerFuelUpgradeRecipe("code_aeternalis_fuel", fuelManager.getMobiusFuel(), 4, fuelManager.getAeternalisFuel(), 1, philosopherStone);
            this.plugin.getLogger().info("Registered aeternalis fuel recipe from code");
        }
        if (!aeternalisToMobiusExists) {
            this.registerFuelDowngradeRecipe("code_aeternalis_to_mobius", fuelManager.getAeternalisFuel(), fuelManager.getMobiusFuel(), 4, philosopherStone);
            this.plugin.getLogger().info("Registered aeternalis to mobius recipe from code");
        }
        if (!mobiusToAlchemicalExists) {
            this.registerFuelDowngradeRecipe("code_mobius_to_alchemical", fuelManager.getMobiusFuel(), fuelManager.getAlchemicalCoal(), 4, philosopherStone);
            this.plugin.getLogger().info("Registered mobius to alchemical recipe from code");
        }
        if (!alchemicalToCoalExists) {
            this.registerFuelDowngradeRecipe("code_alchemical_to_coal", fuelManager.getAlchemicalCoal(), new ItemStack(Material.COAL, 4), philosopherStone);
            this.plugin.getLogger().info("Registered alchemical to coal recipe from code");
        }
    }

    private void registerFuelUpgradeRecipe(String id, ItemStack input, int inputAmount, ItemStack output, int outputAmount, ItemStack catalyst) {
        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "upgrade_" + id);
        ShapelessRecipe recipe = new ShapelessRecipe(key, new ItemStack(output.getType(), outputAmount));
        ItemMeta meta = output.getItemMeta();
        if (meta != null) {
            recipe.getResult().setItemMeta(meta);
        }
        recipe.addIngredient((RecipeChoice)new RecipeChoice.ExactChoice(input));
        recipe.addIngredient((RecipeChoice)new RecipeChoice.ExactChoice(catalyst));
        Bukkit.addRecipe((Recipe)recipe);
        this.recipeKeys.put("upgrade_" + id, key);
    }

    private void registerFuelUpgradeRecipe(String id, ItemStack input, ItemStack output, ItemStack catalyst) {
        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "upgrade_" + id);
        ShapelessRecipe recipe = new ShapelessRecipe(key, output);
        recipe.addIngredient((RecipeChoice)new RecipeChoice.ExactChoice(input));
        recipe.addIngredient((RecipeChoice)new RecipeChoice.ExactChoice(catalyst));
        Bukkit.addRecipe((Recipe)recipe);
        this.recipeKeys.put("upgrade_" + id, key);
    }

    private void registerFuelDowngradeRecipe(String id, ItemStack input, ItemStack output, int outputAmount, ItemStack catalyst) {
        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "downgrade_" + id);
        ShapelessRecipe recipe = new ShapelessRecipe(key, new ItemStack(output.getType(), outputAmount));
        ItemMeta meta = output.getItemMeta();
        if (meta != null) {
            recipe.getResult().setItemMeta(meta);
        }
        recipe.addIngredient((RecipeChoice)new RecipeChoice.ExactChoice(input));
        recipe.addIngredient((RecipeChoice)new RecipeChoice.ExactChoice(catalyst));
        Bukkit.addRecipe((Recipe)recipe);
        this.recipeKeys.put("downgrade_" + id, key);
    }

    private void registerFuelDowngradeRecipe(String id, ItemStack input, ItemStack output, ItemStack catalyst) {
        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "downgrade_" + id);
        ShapelessRecipe recipe = new ShapelessRecipe(key, output);
        recipe.addIngredient((RecipeChoice)new RecipeChoice.ExactChoice(input));
        recipe.addIngredient((RecipeChoice)new RecipeChoice.ExactChoice(catalyst));
        Bukkit.addRecipe((Recipe)recipe);
        this.recipeKeys.put("downgrade_" + id, key);
    }

    private ItemStack createResultStack(ConfigurationSection config) {
        if (config == null) {
            return null;
        }
        if (config.contains("projecte_id")) {
            ItemStack item;
            String projecteId = config.getString("projecte_id");
            if (projecteId != null && projecteId.startsWith("projecte:")) {
                projecteId = projecteId.substring(9);
            }
            if (this.plugin.getConfig().getBoolean("debug")) {
                this.plugin.getLogger().info("[Debug] Creating result with projecte_id: " + projecteId);
            }
            if ((item = this.plugin.getItemStackFromKey(projecteId)) != null && this.plugin.getConfig().getBoolean("debug")) {
                this.plugin.getLogger().info("[Debug] Found item from getItemStackFromKey: " + projecteId);
            }
            if (item != null) {
                YamlConfiguration emcConfig;
                item.setAmount(config.getInt("amount", 1));
                File customEmcFile = new File(this.plugin.getDataFolder(), "custommoditememc.yml");
                if (customEmcFile.exists() && (emcConfig = YamlConfiguration.loadConfiguration((File)customEmcFile)).contains(projecteId)) {
                    long emc = emcConfig.getLong(projecteId);
                    this.plugin.getEmcManager().setEmcValue(item, emc);
                }
                if (this.plugin.getConfig().getBoolean("debug")) {
                    this.plugin.getLogger().info("[Debug] Successfully created item for projecte_id: " + projecteId);
                }
                return item;
            }
            if (this.plugin.getConfig().getBoolean("debug")) {
                this.plugin.getLogger().warning("[Debug] Failed to create item for projecte_id: " + projecteId);
            }
        } else {
            String materialName = config.getString("material");
            Material material = this.plugin.getVersionAdapter().getMaterial(materialName);
            if (material == null) {
                material = Material.matchMaterial((String)materialName);
            }
            if (material == null) {
                return null;
            }
            ItemStack item = new ItemStack(material, config.getInt("amount", 1));
            ItemMeta meta = item.getItemMeta();
            if (meta != null) {
                int i;
                ArrayList<String> lore;
                if (config.contains("display_name")) {
                    meta.setDisplayName(this.plugin.getLanguageManager().get(config.getString("display_name")));
                }
                if (config.contains("lore1")) {
                    lore = new ArrayList<String>();
                    i = 1;
                    while (config.contains("lore" + i)) {
                        lore.add(this.plugin.getLanguageManager().get(config.getString("lore" + i)));
                        ++i;
                    }
                    meta.setLore(lore);
                }
                if (config.contains("custom_model_data")) {
                    item = CustomModelDataUtil.setCustomModelData(item, config.getString("custom_model_data"));
                    meta = item.getItemMeta();
                    if (config.contains("display_name")) {
                        meta.setDisplayName(this.plugin.getLanguageManager().get(config.getString("display_name")));
                    }
                    if (config.contains("lore1")) {
                        lore = new ArrayList();
                        i = 1;
                        while (config.contains("lore" + i)) {
                            lore.add(this.plugin.getLanguageManager().get(config.getString("lore" + i)));
                            ++i;
                        }
                        meta.setLore(lore);
                    }
                }
                if (config.getBoolean("unbreakable")) {
                    meta.setUnbreakable(true);
                }
                item.setItemMeta(meta);
            }
            return item;
        }
        return null;
    }

    private void registerUpgradeRecipes() {
        ItemStack philosopherStone = this.plugin.getPhilosopherStone();
        this.registerUpgradeRecipe("copper_to_iron", Material.COPPER_INGOT, Material.IRON_INGOT, 4, 1, philosopherStone);
        this.registerUpgradeRecipe("iron_to_gold", Material.IRON_INGOT, Material.GOLD_INGOT, 8, 1, philosopherStone);
        this.registerUpgradeRecipe("gold_to_diamond", Material.GOLD_INGOT, Material.DIAMOND, 4, 1, philosopherStone);
        this.registerSpecialUpgradeRecipe("diamond_to_netherite", Material.DIAMOND_BLOCK, Material.NETHERITE_INGOT, 8, 1, philosopherStone);
    }

    private void registerDowngradeRecipes() {
        ItemStack philosopherStone = this.plugin.getPhilosopherStone();
        this.registerDowngradeRecipe("copper_to_coal", Material.COPPER_INGOT, Material.COAL, 1, 4, philosopherStone);
        this.registerDowngradeRecipe("iron_to_copper", Material.IRON_INGOT, Material.COPPER_INGOT, 1, 4, philosopherStone);
        this.registerDowngradeRecipe("gold_to_iron", Material.GOLD_INGOT, Material.IRON_INGOT, 1, 8, philosopherStone);
        this.registerDowngradeRecipe("diamond_to_gold", Material.DIAMOND, Material.GOLD_INGOT, 1, 4, philosopherStone);
        this.registerDowngradeRecipe("netherite_to_diamond", Material.NETHERITE_INGOT, Material.DIAMOND_BLOCK, 1, 8, philosopherStone);
    }

    private void registerUpgradeRecipe(String id, Material input, Material output, int inputAmount, int outputAmount, ItemStack catalyst) {
        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "upgrade_" + id);
        ShapelessRecipe recipe = new ShapelessRecipe(key, new ItemStack(output, outputAmount));
        recipe.addIngredient(inputAmount, input);
        recipe.addIngredient(catalyst.getType());
        Bukkit.addRecipe((Recipe)recipe);
        this.recipeKeys.put("upgrade_" + id, key);
    }

    private void registerSpecialUpgradeRecipe(String id, Material input, Material output, int inputAmount, int outputAmount, ItemStack catalyst) {
        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "special_" + id);
        ShapelessRecipe recipe = new ShapelessRecipe(key, new ItemStack(output, outputAmount));
        recipe.addIngredient(inputAmount, input);
        recipe.addIngredient(catalyst.getType());
        Bukkit.addRecipe((Recipe)recipe);
        this.recipeKeys.put("special_" + id, key);
    }

    private void registerDowngradeRecipe(String id, Material input, Material output, int inputAmount, int outputAmount, ItemStack catalyst) {
        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "downgrade_" + id);
        ShapelessRecipe recipe = new ShapelessRecipe(key, new ItemStack(output, outputAmount));
        recipe.addIngredient(inputAmount, input);
        recipe.addIngredient(catalyst.getType());
        Bukkit.addRecipe((Recipe)recipe);
        this.recipeKeys.put("downgrade_" + id, key);
    }

    public Map<String, NamespacedKey> getRecipeKeys() {
        return this.recipeKeys;
    }

    public Set<String> getRegisteredItemIds() {
        return this.recipeKeys.keySet();
    }

    public void unregisterAllRecipes() {
        for (NamespacedKey key : this.recipeKeys.values()) {
            Bukkit.removeRecipe((NamespacedKey)key);
        }
        this.recipeKeys.clear();
    }

    private void registerOreTransmutationRecipes() {
        RecipeChoice.ExactChoice catalyst = new RecipeChoice.ExactChoice(this.plugin.getPhilosopherStone());
        RecipeChoice.MaterialChoice fuel = new RecipeChoice.MaterialChoice(new Material[]{Material.COAL, Material.CHARCOAL});
        this.registerOreTransmutationRecipe("iron", (RecipeChoice)new RecipeChoice.MaterialChoice(new Material[]{Material.IRON_ORE, Material.DEEPSLATE_IRON_ORE, Material.RAW_IRON}), new ItemStack(Material.IRON_INGOT, 7), (RecipeChoice)catalyst, (RecipeChoice)fuel);
        this.registerOreTransmutationRecipe("gold", (RecipeChoice)new RecipeChoice.MaterialChoice(new Material[]{Material.GOLD_ORE, Material.DEEPSLATE_GOLD_ORE, Material.RAW_GOLD}), new ItemStack(Material.GOLD_INGOT, 7), (RecipeChoice)catalyst, (RecipeChoice)fuel);
        this.registerOreTransmutationRecipe("copper", (RecipeChoice)new RecipeChoice.MaterialChoice(new Material[]{Material.COPPER_ORE, Material.DEEPSLATE_COPPER_ORE, Material.RAW_COPPER}), new ItemStack(Material.COPPER_INGOT, 7), (RecipeChoice)catalyst, (RecipeChoice)fuel);
        this.registerOreTransmutationRecipe("diamond", (RecipeChoice)new RecipeChoice.MaterialChoice(new Material[]{Material.DIAMOND_ORE, Material.DEEPSLATE_DIAMOND_ORE}), new ItemStack(Material.DIAMOND, 7), (RecipeChoice)catalyst, (RecipeChoice)fuel);
        this.registerOreTransmutationRecipe("netherite", (RecipeChoice)new RecipeChoice.MaterialChoice(Material.ANCIENT_DEBRIS), new ItemStack(Material.NETHERITE_SCRAP, 7), (RecipeChoice)catalyst, (RecipeChoice)fuel);
        RecipeChoice.MaterialChoice logChoice = new RecipeChoice.MaterialChoice(new Material[]{Material.OAK_LOG, Material.SPRUCE_LOG, Material.BIRCH_LOG, Material.JUNGLE_LOG, Material.ACACIA_LOG, Material.DARK_OAK_LOG, Material.MANGROVE_LOG, Material.CHERRY_LOG, Material.STRIPPED_OAK_LOG, Material.STRIPPED_SPRUCE_LOG, Material.STRIPPED_BIRCH_LOG, Material.STRIPPED_JUNGLE_LOG, Material.STRIPPED_ACACIA_LOG, Material.STRIPPED_DARK_OAK_LOG, Material.STRIPPED_MANGROVE_LOG, Material.STRIPPED_CHERRY_LOG});
        this.registerOreTransmutationRecipe("wood_to_charcoal", (RecipeChoice)logChoice, new ItemStack(Material.CHARCOAL, 7), (RecipeChoice)catalyst, (RecipeChoice)fuel);
    }

    private void registerOreTransmutationRecipe(String id, RecipeChoice oreChoice, ItemStack result, RecipeChoice catalyst, RecipeChoice fuel) {
        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "transmute_" + id);
        ShapelessRecipe recipe = new ShapelessRecipe(key, result);
        for (int i = 0; i < 7; ++i) {
            recipe.addIngredient(oreChoice);
        }
        recipe.addIngredient(fuel);
        recipe.addIngredient(catalyst);
        Bukkit.addRecipe((Recipe)recipe);
        this.recipeKeys.put("transmute_" + id, key);
    }

    private int getKleinStarLevelFromId(String id) {
        switch (id) {
            case "klein_star_ein": {
                return 1;
            }
            case "klein_star_zwei": {
                return 2;
            }
            case "klein_star_drei": {
                return 3;
            }
            case "klein_star_vier": {
                return 4;
            }
            case "klein_star_sphere": {
                return 5;
            }
            case "klein_star_omega": {
                return 6;
            }
        }
        return -1;
    }

    private void validateFuelRecipeChain() {
        String[] correctRecipes;
        this.plugin.getLogger().info("\u9a8c\u8bc1\u71c3\u6599\u914d\u65b9\u94fe...");
        for (String recipeId : correctRecipes = new String[]{"alchemical_coal", "mobius_fuel", "aeternalis_fuel", "aeternalis_to_mobius", "mobius_to_alchemical", "alchemical_to_coal"}) {
            if (this.recipeKeys.containsKey(recipeId)) {
                this.plugin.getLogger().info("\u2713 \u71c3\u6599\u914d\u65b9\u5b58\u5728: " + recipeId);
                continue;
            }
            this.plugin.getLogger().warning("\u2717 \u71c3\u6599\u914d\u65b9\u7f3a\u5931: " + recipeId);
        }
        this.plugin.getLogger().info("\u71c3\u6599\u914d\u65b9\u94fe\u9a8c\u8bc1\u5b8c\u6210");
    }
}

