/*
 * Decompiled with CFR 0.152.
 */
package org.Little_100.projecte.storage;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.io.BukkitObjectInputStream;
import org.bukkit.util.io.BukkitObjectOutputStream;
import org.yaml.snakeyaml.external.biz.base64Coder.Base64Coder;

public class DatabaseManager {
    private Connection connection;
    private final File dataFolder;

    public DatabaseManager(File dataFolder) {
        this.dataFolder = dataFolder;
        this.connect();
    }

    private void connect() {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                return;
            }
            File dbFile = new File(this.dataFolder, "gui/transmutation.db");
            if (!dbFile.getParentFile().exists()) {
                dbFile.getParentFile().mkdirs();
            }
            Class.forName("org.sqlite.JDBC");
            this.connection = DriverManager.getConnection("jdbc:sqlite:" + dbFile.getAbsolutePath());
            this.createTables();
        }
        catch (ClassNotFoundException | SQLException e) {
            e.printStackTrace();
        }
    }

    private void createTables() {
        try (Statement statement = this.connection.createStatement();){
            statement.execute("CREATE TABLE IF NOT EXISTS emc_values (item_key TEXT PRIMARY KEY,emc BIGINT NOT NULL);");
            statement.execute("CREATE TABLE IF NOT EXISTS player_emc (player_uuid TEXT PRIMARY KEY,emc BIGINT NOT NULL);");
            statement.execute("CREATE TABLE IF NOT EXISTS learned_items (player_uuid TEXT NOT NULL,item_key TEXT NOT NULL,PRIMARY KEY (player_uuid, item_key));");
            statement.execute("CREATE TABLE IF NOT EXISTS alchemical_bags (player_uuid TEXT NOT NULL,bag_color TEXT NOT NULL,inventory_contents TEXT,PRIMARY KEY (player_uuid, bag_color));");
            statement.execute("CREATE TABLE IF NOT EXISTS alchemical_chests (location TEXT PRIMARY KEY,owner_uuid TEXT NOT NULL,inventory_contents TEXT);");
            statement.execute("CREATE TABLE IF NOT EXISTS energy_collectors (location TEXT PRIMARY KEY,owner_uuid TEXT NOT NULL,collector_type INTEGER NOT NULL,stored_emc BIGINT NOT NULL DEFAULT 0,inventory_contents TEXT);");
            statement.execute("CREATE TABLE IF NOT EXISTS energy_condensers (location TEXT PRIMARY KEY,owner_uuid TEXT NOT NULL,condenser_type INTEGER NOT NULL,inventory_contents TEXT,target_item TEXT,stored_emc BIGINT NOT NULL DEFAULT 0);");
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void setEmc(String itemKey, long emc) {
        String sql = "INSERT OR REPLACE INTO emc_values (item_key, emc) VALUES (?, ?);";
        try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
            pstmt.setString(1, itemKey);
            pstmt.setLong(2, emc);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getEmc(String itemKey) {
        String sql = "SELECT emc FROM emc_values WHERE item_key = ?;";
        try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
            pstmt.setString(1, itemKey);
            ResultSet rs = pstmt.executeQuery();
            if (!rs.next()) return 0L;
            long l = rs.getLong("emc");
            return l;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return 0L;
    }

    public boolean hasEmcValues() {
        boolean bl;
        block8: {
            String sql = "SELECT 1 FROM emc_values LIMIT 1;";
            PreparedStatement pstmt = this.connection.prepareStatement(sql);
            try {
                ResultSet rs = pstmt.executeQuery();
                bl = rs.next();
                if (pstmt == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (pstmt != null) {
                        try {
                            pstmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    return false;
                }
            }
            pstmt.close();
        }
        return bl;
    }

    public void clearEmcValues() {
        String sql = "DELETE FROM emc_values;";
        try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getPlayerEmc(UUID playerUuid) {
        String sql = "SELECT emc FROM player_emc WHERE player_uuid = ?;";
        try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
            pstmt.setString(1, playerUuid.toString());
            ResultSet rs = pstmt.executeQuery();
            if (!rs.next()) return 0L;
            long l = rs.getLong("emc");
            return l;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return 0L;
    }

    public void setPlayerEmc(UUID playerUuid, long emc) {
        String sql = "INSERT OR REPLACE INTO player_emc (player_uuid, emc) VALUES (?, ?);";
        try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
            pstmt.setString(1, playerUuid.toString());
            pstmt.setLong(2, emc);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void addLearnedItem(UUID playerUuid, String itemKey) {
        String sql = "INSERT OR IGNORE INTO learned_items (player_uuid, item_key) VALUES (?, ?);";
        try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
            pstmt.setString(1, playerUuid.toString());
            pstmt.setString(2, itemKey);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public boolean learnItem(UUID playerUuid, String itemKey) {
        if (this.isLearned(playerUuid, itemKey)) {
            return false;
        }
        this.addLearnedItem(playerUuid, itemKey);
        return true;
    }

    public List<String> getLearnedItems(UUID playerUuid) {
        ArrayList<String> learnedItems = new ArrayList<String>();
        String sql = "SELECT item_key FROM learned_items WHERE player_uuid = ?;";
        try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
            pstmt.setString(1, playerUuid.toString());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                learnedItems.add(rs.getString("item_key"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return learnedItems;
    }

    public boolean isLearned(UUID playerUuid, String itemKey) {
        boolean bl;
        block8: {
            String sql = "SELECT 1 FROM learned_items WHERE player_uuid = ? AND item_key = ? LIMIT 1;";
            PreparedStatement pstmt = this.connection.prepareStatement(sql);
            try {
                pstmt.setString(1, playerUuid.toString());
                pstmt.setString(2, itemKey);
                ResultSet rs = pstmt.executeQuery();
                bl = rs.next();
                if (pstmt == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (pstmt != null) {
                        try {
                            pstmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    return false;
                }
            }
            pstmt.close();
        }
        return bl;
    }

    public void close() {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                this.connection.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void saveBagInventory(UUID playerUUID, String bagColor, ItemStack[] items) {
        String base64Data;
        if (items == null) {
            return;
        }
        try {
            base64Data = this.itemStackArrayToBase64(items);
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
            return;
        }
        String sql = "INSERT OR REPLACE INTO alchemical_bags (player_uuid, bag_color, inventory_contents) VALUES (?, ?, ?);";
        try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
            pstmt.setString(1, playerUUID.toString());
            pstmt.setString(2, bagColor);
            pstmt.setString(3, base64Data);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ItemStack[] loadBagInventory(UUID playerUUID, String bagColor) {
        String sql = "SELECT inventory_contents FROM alchemical_bags WHERE player_uuid = ? AND bag_color = ?;";
        try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
            pstmt.setString(1, playerUUID.toString());
            pstmt.setString(2, bagColor);
            ResultSet rs = pstmt.executeQuery();
            if (!rs.next()) return new ItemStack[54];
            String base64Data = rs.getString("inventory_contents");
            ItemStack[] itemStackArray = this.itemStackArrayFromBase64(base64Data);
            return itemStackArray;
        }
        catch (IOException | SQLException e) {
            e.printStackTrace();
        }
        return new ItemStack[54];
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String itemStackArrayToBase64(ItemStack[] items) throws IllegalStateException {
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            String string;
            try (BukkitObjectOutputStream dataOutput = new BukkitObjectOutputStream((OutputStream)outputStream);){
                dataOutput.writeInt(items.length);
                for (ItemStack item : items) {
                    dataOutput.writeObject((Object)item);
                }
                string = Base64Coder.encodeLines((byte[])outputStream.toByteArray());
            }
            return string;
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not serialize ItemStack[] to Base64!", e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String itemStackToBase64(ItemStack item) throws IllegalStateException {
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            String string;
            try (BukkitObjectOutputStream dataOutput = new BukkitObjectOutputStream((OutputStream)outputStream);){
                dataOutput.writeObject((Object)item);
                string = Base64Coder.encodeLines((byte[])outputStream.toByteArray());
            }
            return string;
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to serialize ItemStack", e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private ItemStack itemStackFromBase64(String data) throws IOException {
        if (data == null || data.isEmpty()) {
            return null;
        }
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(Base64Coder.decodeLines((String)data));){
            ItemStack itemStack;
            try (BukkitObjectInputStream dataInput = new BukkitObjectInputStream((InputStream)inputStream);){
                itemStack = (ItemStack)dataInput.readObject();
            }
            return itemStack;
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Unable to deserialize ItemStack", e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private ItemStack[] itemStackArrayFromBase64(String data) throws IOException {
        if (data == null || data.isEmpty()) {
            return new ItemStack[54];
        }
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(Base64Coder.decodeLines((String)data));){
            ItemStack[] items;
            BukkitObjectInputStream dataInput;
            block16: {
                ItemStack[] itemStackArray;
                dataInput = new BukkitObjectInputStream((InputStream)inputStream);
                try {
                    int size = dataInput.readInt();
                    items = new ItemStack[size];
                    for (int i = 0; i < size; ++i) {
                        items[i] = (ItemStack)dataInput.readObject();
                    }
                    if (size >= 54) break block16;
                    ItemStack[] resizedItems = new ItemStack[54];
                    System.arraycopy(items, 0, resizedItems, 0, size);
                    itemStackArray = resizedItems;
                }
                catch (Throwable throwable) {
                    try {
                        dataInput.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                dataInput.close();
                return itemStackArray;
            }
            ItemStack[] itemStackArray = items;
            dataInput.close();
            return itemStackArray;
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Could not find ItemStack class for deserialization!", e);
        }
    }

    public List<String> getBagColors(UUID playerUuid) {
        ArrayList<String> bagColors = new ArrayList<String>();
        String sql = "SELECT bag_color FROM alchemical_bags WHERE player_uuid = ?;";
        try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
            pstmt.setString(1, playerUuid.toString());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                bagColors.add(rs.getString("bag_color"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return bagColors;
    }

    public void saveChestInventory(String locationKey, UUID ownerUUID, ItemStack[] items) {
        String base64Data;
        if (items == null) {
            return;
        }
        try {
            base64Data = this.itemStackArrayToBase64(items);
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
            return;
        }
        String sql = "INSERT OR REPLACE INTO alchemical_chests (location, owner_uuid, inventory_contents) VALUES (?, ?, ?);";
        try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
            pstmt.setString(1, locationKey);
            pstmt.setString(2, ownerUUID.toString());
            pstmt.setString(3, base64Data);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ItemStack[] loadChestInventory(String locationKey) {
        String sql = "SELECT inventory_contents FROM alchemical_chests WHERE location = ?;";
        try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
            pstmt.setString(1, locationKey);
            ResultSet rs = pstmt.executeQuery();
            if (!rs.next()) return new ItemStack[104];
            String base64Data = rs.getString("inventory_contents");
            ItemStack[] items = this.itemStackArrayFromBase64(base64Data);
            if (items.length < 104) {
                ItemStack[] resizedItems = new ItemStack[104];
                System.arraycopy(items, 0, resizedItems, 0, items.length);
                ItemStack[] itemStackArray = resizedItems;
                return itemStackArray;
            }
            ItemStack[] itemStackArray = items;
            return itemStackArray;
        }
        catch (IOException | SQLException e) {
            e.printStackTrace();
        }
        return new ItemStack[104];
    }

    public void deleteChestInventory(String locationKey) {
        String sql = "DELETE FROM alchemical_chests WHERE location = ?;";
        try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
            pstmt.setString(1, locationKey);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public UUID getChestOwner(String locationKey) {
        String sql = "SELECT owner_uuid FROM alchemical_chests WHERE location = ?;";
        try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
            pstmt.setString(1, locationKey);
            ResultSet rs = pstmt.executeQuery();
            if (!rs.next()) return null;
            UUID uUID = UUID.fromString(rs.getString("owner_uuid"));
            return uUID;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void saveCollectorData(String locationKey, UUID ownerUUID, int collectorType, long storedEmc, ItemStack[] items) {
        String base64Data = null;
        if (items != null) {
            try {
                base64Data = this.itemStackArrayToBase64(items);
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
            }
        }
        String sql = "INSERT OR REPLACE INTO energy_collectors (location, owner_uuid, collector_type, stored_emc, inventory_contents) VALUES (?, ?, ?, ?, ?);";
        try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
            pstmt.setString(1, locationKey);
            pstmt.setString(2, ownerUUID.toString());
            pstmt.setInt(3, collectorType);
            pstmt.setLong(4, storedEmc);
            pstmt.setString(5, base64Data);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ItemStack[] loadCollectorInventory(String locationKey, int expectedSize) {
        String sql = "SELECT inventory_contents FROM energy_collectors WHERE location = ?;";
        try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
            pstmt.setString(1, locationKey);
            ResultSet rs = pstmt.executeQuery();
            if (!rs.next()) return new ItemStack[expectedSize];
            String base64Data = rs.getString("inventory_contents");
            if (base64Data == null) return new ItemStack[expectedSize];
            if (base64Data.isEmpty()) return new ItemStack[expectedSize];
            ItemStack[] items = this.itemStackArrayFromBase64(base64Data);
            if (items.length < expectedSize) {
                ItemStack[] resizedItems = new ItemStack[expectedSize];
                System.arraycopy(items, 0, resizedItems, 0, items.length);
                ItemStack[] itemStackArray = resizedItems;
                return itemStackArray;
            }
            ItemStack[] itemStackArray = items;
            return itemStackArray;
        }
        catch (IOException | SQLException e) {
            e.printStackTrace();
        }
        return new ItemStack[expectedSize];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long loadCollectorEmc(String locationKey) {
        String sql = "SELECT stored_emc FROM energy_collectors WHERE location = ?;";
        try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
            pstmt.setString(1, locationKey);
            ResultSet rs = pstmt.executeQuery();
            if (!rs.next()) return 0L;
            long l = rs.getLong("stored_emc");
            return l;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return 0L;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int loadCollectorType(String locationKey) {
        String sql = "SELECT collector_type FROM energy_collectors WHERE location = ?;";
        try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
            pstmt.setString(1, locationKey);
            ResultSet rs = pstmt.executeQuery();
            if (!rs.next()) return 1;
            int n = rs.getInt("collector_type");
            return n;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return 1;
    }

    public void deleteCollectorData(String locationKey) {
        String sql = "DELETE FROM energy_collectors WHERE location = ?;";
        try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
            pstmt.setString(1, locationKey);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public UUID getCollectorOwner(String locationKey) {
        String sql = "SELECT owner_uuid FROM energy_collectors WHERE location = ?;";
        try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
            pstmt.setString(1, locationKey);
            ResultSet rs = pstmt.executeQuery();
            if (!rs.next()) return null;
            UUID uUID = UUID.fromString(rs.getString("owner_uuid"));
            return uUID;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void saveCondenserData(String locationKey, UUID ownerUUID, int condenserType, ItemStack[] inventoryContents, ItemStack targetItem, long storedEmc) {
        String base64Inventory = "";
        if (inventoryContents != null) {
            try {
                base64Inventory = this.itemStackArrayToBase64(inventoryContents);
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
                return;
            }
        }
        String base64Target = "";
        if (targetItem != null && !targetItem.getType().isAir()) {
            try {
                base64Target = this.itemStackToBase64(targetItem);
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
            }
        }
        String sql = "INSERT OR REPLACE INTO energy_condensers (location, owner_uuid, condenser_type, inventory_contents, target_item, stored_emc) VALUES (?, ?, ?, ?, ?, ?);";
        try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
            pstmt.setString(1, locationKey);
            pstmt.setString(2, ownerUUID.toString());
            pstmt.setInt(3, condenserType);
            pstmt.setString(4, base64Inventory);
            pstmt.setString(5, base64Target);
            pstmt.setLong(6, storedEmc);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ItemStack[] loadCondenserInventory(String locationKey, int expectedSize) {
        String sql = "SELECT inventory_contents FROM energy_condensers WHERE location = ?;";
        try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
            pstmt.setString(1, locationKey);
            ResultSet rs = pstmt.executeQuery();
            if (!rs.next()) return new ItemStack[expectedSize];
            String base64Data = rs.getString("inventory_contents");
            if (base64Data == null) return new ItemStack[expectedSize];
            if (base64Data.isEmpty()) return new ItemStack[expectedSize];
            ItemStack[] items = this.itemStackArrayFromBase64(base64Data);
            if (items.length < expectedSize) {
                ItemStack[] resizedItems = new ItemStack[expectedSize];
                System.arraycopy(items, 0, resizedItems, 0, items.length);
                ItemStack[] itemStackArray = resizedItems;
                return itemStackArray;
            }
            ItemStack[] itemStackArray = items;
            return itemStackArray;
        }
        catch (IOException | SQLException e) {
            e.printStackTrace();
        }
        return new ItemStack[expectedSize];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ItemStack loadCondenserTargetItem(String locationKey) {
        String sql = "SELECT target_item FROM energy_condensers WHERE location = ?;";
        try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
            pstmt.setString(1, locationKey);
            ResultSet rs = pstmt.executeQuery();
            if (!rs.next()) return null;
            String base64Data = rs.getString("target_item");
            if (base64Data == null) return null;
            if (base64Data.isEmpty()) return null;
            ItemStack itemStack = this.itemStackFromBase64(base64Data);
            return itemStack;
        }
        catch (IOException | SQLException e) {
            e.printStackTrace();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long loadCondenserEmc(String locationKey) {
        String sql = "SELECT stored_emc FROM energy_condensers WHERE location = ?;";
        try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
            pstmt.setString(1, locationKey);
            ResultSet rs = pstmt.executeQuery();
            if (!rs.next()) return 0L;
            long l = rs.getLong("stored_emc");
            return l;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return 0L;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int loadCondenserType(String locationKey) {
        String sql = "SELECT condenser_type FROM energy_condensers WHERE location = ?;";
        try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
            pstmt.setString(1, locationKey);
            ResultSet rs = pstmt.executeQuery();
            if (!rs.next()) return 1;
            int n = rs.getInt("condenser_type");
            return n;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return 1;
    }

    public void deleteCondenserData(String locationKey) {
        String sql = "DELETE FROM energy_condensers WHERE location = ?;";
        try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
            pstmt.setString(1, locationKey);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public UUID getCondenserOwner(String locationKey) {
        String sql = "SELECT owner_uuid FROM energy_condensers WHERE location = ?;";
        try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
            pstmt.setString(1, locationKey);
            ResultSet rs = pstmt.executeQuery();
            if (!rs.next()) return null;
            UUID uUID = UUID.fromString(rs.getString("owner_uuid"));
            return uUID;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return null;
    }
}

