/*
 * Decompiled with CFR 0.152.
 */
package org.Little_100.projecte.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.Little_100.projecte.ProjectE;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.components.CustomModelDataComponent;

public class CustomModelDataUtil {
    private static Boolean useNewApi = null;
    private static final Map<String, Integer> STRING_TO_INT_MAPPING = new HashMap<String, Integer>();
    private static final Map<Integer, String> INT_TO_STRING_MAPPING = new HashMap<Integer, String>();

    public static boolean isNewApiSupported() {
        if (useNewApi == null) {
            try {
                Class.forName("org.bukkit.inventory.meta.components.CustomModelDataComponent");
                useNewApi = true;
            }
            catch (ClassNotFoundException e) {
                useNewApi = false;
            }
        }
        return useNewApi;
    }

    public static ItemStack setCustomModelData(ItemStack item, String modelId) {
        if (item == null) {
            return null;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return item;
        }
        Integer intValue = STRING_TO_INT_MAPPING.getOrDefault(modelId, 0);
        return CustomModelDataUtil.setCustomModelDataBoth(item, modelId, intValue);
    }

    public static ItemStack setCustomModelData(ItemStack item, int intValue) {
        if (item == null) {
            return null;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return item;
        }
        String modelId = INT_TO_STRING_MAPPING.getOrDefault(intValue, "cmd_" + intValue);
        return CustomModelDataUtil.setCustomModelDataBoth(item, modelId, intValue);
    }

    public static ItemStack setNewCustomModelData(ItemStack item, String modelId) {
        if (item == null) {
            return null;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return item;
        }
        try {
            CustomModelDataUtil.setNewApiModelData(meta, modelId);
            item.setItemMeta(meta);
        }
        catch (Exception e) {
            ProjectE.getInstance().getLogger().warning("Failed to set new CustomModelData: " + e.getMessage());
        }
        return item;
    }

    public static ItemStack setOldCustomModelData(ItemStack item, int intValue) {
        if (item == null) {
            return null;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return item;
        }
        try {
            meta.setCustomModelData(Integer.valueOf(intValue));
            item.setItemMeta(meta);
        }
        catch (Exception e) {
            ProjectE.getInstance().getLogger().warning("Failed to set old CustomModelData: " + e.getMessage());
        }
        return item;
    }

    private static void setNewApiModelData(ItemMeta meta, String modelId) {
        try {
            CustomModelDataComponent component = meta.getCustomModelDataComponent();
            component.setStrings(Collections.singletonList(modelId));
            meta.setCustomModelDataComponent(component);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to set new API model data: " + e.getMessage(), e);
        }
    }

    public static ItemStack setCustomModelDataBoth(ItemStack item, String modelId, int intValue) {
        if (item == null) {
            return null;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return item;
        }
        if (intValue > 0) {
            try {
                meta.setCustomModelData(Integer.valueOf(intValue));
            }
            catch (Exception e) {
                ProjectE.getInstance().getLogger().warning("[CMD] \u8bbe\u7f6e\u6574\u6570\u503c\u65f6\u51fa\u9519: " + e.getMessage());
            }
        }
        if (CustomModelDataUtil.isNewApiSupported() && modelId != null && !modelId.isEmpty()) {
            try {
                CustomModelDataComponent component = meta.getCustomModelDataComponent();
                component.setStrings(Collections.singletonList(String.valueOf(intValue)));
                meta.setCustomModelDataComponent(component);
            }
            catch (Throwable e) {
                ProjectE.getInstance().getLogger().warning("[CMD] \u8bbe\u7f6e\u5b57\u7b26\u4e32\u7ec4\u4ef6\u65f6\u51fa\u9519: " + e.getMessage());
            }
        }
        item.setItemMeta(meta);
        return item;
    }

    public static String getCustomModelDataString(ItemStack item) {
        if (item == null) {
            return null;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return null;
        }
        if (CustomModelDataUtil.isNewApiSupported()) {
            try {
                CustomModelDataComponent component = meta.getCustomModelDataComponent();
                if (!component.getStrings().isEmpty()) {
                    return (String)component.getStrings().get(0);
                }
            }
            catch (Exception component) {
                // empty catch block
            }
        }
        if (meta.hasCustomModelData()) {
            try {
                int intValue = meta.getCustomModelData();
                String modelId = INT_TO_STRING_MAPPING.get(intValue);
                if (modelId != null) {
                    return modelId;
                }
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        return null;
    }

    public static int getCustomModelDataInt(ItemStack item) {
        if (item == null) {
            return 0;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return 0;
        }
        if (meta.hasCustomModelData()) {
            try {
                return meta.getCustomModelData();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        if (CustomModelDataUtil.isNewApiSupported()) {
            try {
                CustomModelDataComponent component = meta.getCustomModelDataComponent();
                if (!component.getStrings().isEmpty()) {
                    String modelId = (String)component.getStrings().get(0);
                    return STRING_TO_INT_MAPPING.getOrDefault(modelId, 0);
                }
            }
            catch (Exception e) {
                ProjectE.getInstance().getLogger().warning("Warning: Failed to get CustomModelDataInt: " + e.getMessage());
            }
        }
        return 0;
    }

    public static int getIntValueForModelId(String modelId) {
        return STRING_TO_INT_MAPPING.getOrDefault(modelId, 0);
    }

    public static void registerMapping(String modelId, int intValue) {
        STRING_TO_INT_MAPPING.put(modelId, intValue);
        INT_TO_STRING_MAPPING.put(intValue, modelId);
    }

    public static void clearCache() {
        useNewApi = null;
    }

    public static Map<String, Integer> getAllMappings() {
        return new HashMap<String, Integer>(STRING_TO_INT_MAPPING);
    }

    public static Map<Integer, String> getAllReverseMappings() {
        return new HashMap<Integer, String>(INT_TO_STRING_MAPPING);
    }

    public static boolean hasCustomModelData(ItemStack item) {
        if (item == null) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return false;
        }
        try {
            if (meta.hasCustomModelData()) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (CustomModelDataUtil.isNewApiSupported()) {
            try {
                CustomModelDataComponent component = meta.getCustomModelDataComponent();
                return !component.getStrings().isEmpty();
            }
            catch (Exception e) {
                ProjectE.getInstance().getLogger().log(Level.WARNING, "Failed to check CustomModelData", e);
            }
        }
        return false;
    }

    public static void registerMappings(Map<String, Integer> mappings) {
        if (mappings == null || mappings.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Integer> entry : mappings.entrySet()) {
            CustomModelDataUtil.registerMapping(entry.getKey(), entry.getValue());
        }
    }

    static {
        CustomModelDataUtil.registerMapping("diamond_lattice", 1001);
    }
}

