/*
 * Decompiled with CFR 0.152.
 */
package org.Little_100.projecte;

import java.io.File;
import java.util.List;
import org.Little_100.projecte.ProjectE;
import org.Little_100.projecte.managers.EmcManager;
import org.Little_100.projecte.util.Constants;
import org.Little_100.projecte.util.CustomModelDataUtil;
import org.Little_100.projecte.util.ItemUtils;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class CovalenceDust {
    private final ProjectE plugin;
    private final NamespacedKey lowKey;
    private final NamespacedKey mediumKey;
    private final NamespacedKey highKey;
    private ItemStack lowCovalenceDust;
    private ItemStack mediumCovalenceDust;
    private ItemStack highCovalenceDust;

    public CovalenceDust(ProjectE plugin) {
        this.plugin = plugin;
        this.lowKey = new NamespacedKey((Plugin)plugin, "low_covalence_dust");
        this.mediumKey = new NamespacedKey((Plugin)plugin, "medium_covalence_dust");
        this.highKey = new NamespacedKey((Plugin)plugin, "high_covalence_dust");
        this.createCovalenceDustItems();
    }

    private void createCovalenceDustItems() {
        this.lowCovalenceDust = this.createCovalenceDustItem(Material.GLOWSTONE_DUST, "item.low_covalence_dust.name", 1, List.of("item.low_covalence_dust.lore1", "item.low_covalence_dust.lore2"), this.lowKey, "low_covalence_dust");
        this.mediumCovalenceDust = this.createCovalenceDustItem(Material.GLOWSTONE_DUST, "item.medium_covalence_dust.name", 2, List.of("item.medium_covalence_dust.lore1", "item.medium_covalence_dust.lore2"), this.mediumKey, "medium_covalence_dust");
        this.highCovalenceDust = this.createCovalenceDustItem(Material.GLOWSTONE_DUST, "item.high_covalence_dust.name", 3, List.of("item.high_covalence_dust.lore1", "item.high_covalence_dust.lore2"), this.highKey, "high_covalence_dust");
    }

    private ItemStack createCovalenceDustItem(Material material, String displayNameKey, int customModelData, List<String> loreKeys, NamespacedKey key, String id) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = (item = CustomModelDataUtil.setCustomModelDataBoth(item, id, customModelData)).getItemMeta();
        if (meta != null) {
            meta.setDisplayName(this.plugin.getLanguageManager().get(displayNameKey));
            List<String> translatedLore = loreKeys.stream().map(this.plugin.getLanguageManager()::get).toList();
            meta.setLore(translatedLore);
            PersistentDataContainer container = meta.getPersistentDataContainer();
            container.set(Constants.ID_KEY, PersistentDataType.STRING, (Object)id);
            container.set(key, PersistentDataType.BYTE, (Object)1);
            item.setItemMeta(meta);
        }
        return item;
    }

    public ItemStack getLowCovalenceDust() {
        return this.lowCovalenceDust.clone();
    }

    public ItemStack getMediumCovalenceDust() {
        return this.mediumCovalenceDust.clone();
    }

    public ItemStack getHighCovalenceDust() {
        return this.highCovalenceDust.clone();
    }

    public void setCovalenceDustEmcValues() {
        EmcManager emcManager = this.plugin.getEmcManager();
        File configFile = new File(this.plugin.getDataFolder(), "custommoditememc.yml");
        if (!configFile.exists()) {
            this.plugin.getLogger().warning("custommoditememc.yml not found, custom covalence dust EMC values will not be loaded.");
            return;
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
        String lowKey = emcManager.getItemKey(this.getLowCovalenceDust());
        long lowEmc = config.getLong("low_covalence_dust", 1L);
        emcManager.registerEmc(lowKey, lowEmc);
        String mediumKey = emcManager.getItemKey(this.getMediumCovalenceDust());
        long mediumEmc = config.getLong("medium_covalence_dust", 8L);
        emcManager.registerEmc(mediumKey, mediumEmc);
        String highKey = emcManager.getItemKey(this.getHighCovalenceDust());
        long highEmc = config.getLong("high_covalence_dust", 208L);
        emcManager.registerEmc(highKey, highEmc);
    }

    public boolean isLowCovalenceDust(ItemStack item) {
        return this.isCovalenceDust(item, "low_covalence_dust");
    }

    public boolean isMediumCovalenceDust(ItemStack item) {
        return this.isCovalenceDust(item, "medium_covalence_dust");
    }

    public boolean isHighCovalenceDust(ItemStack item) {
        return this.isCovalenceDust(item, "high_covalence_dust");
    }

    private boolean isCovalenceDust(ItemStack item, String id) {
        return ItemUtils.isProjectEItem(item, id);
    }
}

