/*
 * Decompiled with CFR 0.152.
 */
package org.Little_100.projecte.listeners;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.stream.Collectors;
import org.Little_100.projecte.ProjectE;
import org.Little_100.projecte.tools.ToolManager;
import org.Little_100.projecte.util.Constants;
import org.bukkit.DyeColor;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.entity.Sheep;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.util.Vector;

public class ToolAbilityListener
implements Listener {
    private final ProjectE plugin;
    private final ToolManager toolManager;
    private final Map<UUID, Long> swordCooldowns = new HashMap<UUID, Long>();
    private static final long SWORD_ABILITY_COOLDOWN = 1000L;

    public ToolAbilityListener(ProjectE plugin) {
        this.plugin = plugin;
        this.toolManager = plugin.getToolManager();
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        Action action = event.getAction();
        if (action != Action.RIGHT_CLICK_BLOCK && action != Action.RIGHT_CLICK_AIR) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack itemInHand = player.getInventory().getItemInMainHand();
        if (this.toolManager.isDarkMatterShears(itemInHand) || this.toolManager.isRedMatterShears(itemInHand)) {
            this.handleShearsAbility(player, itemInHand);
            return;
        }
        if (player.isSneaking() && (this.toolManager.isDarkMatterSword(itemInHand) || this.toolManager.isRedMatterSword(itemInHand))) {
            this.handleSwordAbility(player, itemInHand);
            event.setCancelled(true);
            return;
        }
        if (this.toolManager.isRedMatterKatar(itemInHand)) {
            this.plugin.getLogger().info("[DEBUG] \u68c0\u6d4b\u5230\u62f3\u5251\u53f3\u952e\uff0c\u52a8\u4f5c: " + String.valueOf(action) + ", \u8e72\u4e0b: " + player.isSneaking());
            if (player.isSneaking()) {
                this.plugin.getLogger().info("[DEBUG] \u8e72\u4e0b\u72b6\u6001\uff0c\u6267\u884c\u526a\u5207\u529f\u80fd");
                this.handleKatarShear(player, itemInHand);
                event.setCancelled(true);
                return;
            }
            this.plugin.getLogger().info("[DEBUG] \u975e\u8e72\u4e0b\u72b6\u6001\uff0c\u8c03\u7528handleKatarAbility");
            this.handleKatarAbility(player, itemInHand, event);
            return;
        }
        if (action == Action.RIGHT_CLICK_BLOCK) {
            Block clickedBlock = event.getClickedBlock();
            if (this.toolManager.isRedMatterMorningstar(itemInHand)) {
                this.handleMorningstarAbility(player, itemInHand, clickedBlock);
            } else if (this.toolManager.isDarkMatterHoe(itemInHand) || this.toolManager.isRedMatterHoe(itemInHand)) {
                this.handleHoeAbility(player, itemInHand, clickedBlock);
            } else if (this.toolManager.isDarkMatterShovel(itemInHand) || this.toolManager.isRedMatterShovel(itemInHand)) {
                this.handleShovelAbility(player, itemInHand, clickedBlock);
            } else if (this.toolManager.isDarkMatterPickaxe(itemInHand) || this.toolManager.isRedMatterPickaxe(itemInHand)) {
                this.handlePickaxeAbility(player, itemInHand, clickedBlock);
            } else if (this.toolManager.isDarkMatterHammer(itemInHand) || this.toolManager.isRedMatterHammer(itemInHand)) {
                this.handleHammerAbility(player, itemInHand, clickedBlock);
            }
        }
    }

    private void handleKatarShear(Player player, ItemStack katar) {
        int range = 50;
        List sheepList = player.getWorld().getEntitiesByClass(Sheep.class).stream().filter(sheep -> !sheep.isSheared() && sheep.getLocation().distance(player.getLocation()) <= (double)range).collect(Collectors.toList());
        if (!sheepList.isEmpty()) {
            player.playSound(player.getLocation(), Sound.ENTITY_SHEEP_SHEAR, 1.0f, 1.0f);
        }
        for (Sheep sheep2 : sheepList) {
            sheep2.setSheared(true);
            int woolAmount = 1 + new Random().nextInt(3);
            Material woolType = this.getWoolMaterial(sheep2.getColor());
            ItemStack woolStack = new ItemStack(woolType, woolAmount);
            HashMap leftover = player.getInventory().addItem(new ItemStack[]{woolStack});
            if (leftover.isEmpty()) continue;
            player.getWorld().dropItemNaturally(player.getLocation(), (ItemStack)leftover.get(0));
        }
    }

    private void handleKatarRightClickAir(Player player, ItemStack katar) {
        this.plugin.getLogger().info("[DEBUG] handleKatarRightClickAir\u88ab\u8c03\u7528 - \u5f00\u59cb\u5904\u7406\u653b\u51fb");
        long now = System.currentTimeMillis();
        long lastUsed = this.swordCooldowns.getOrDefault(player.getUniqueId(), 0L);
        if (now - lastUsed < 1000L) {
            this.plugin.getLogger().info("[DEBUG] \u51b7\u5374\u65f6\u95f4\u672a\u5230\uff0c\u8df3\u8fc7");
            return;
        }
        if (!katar.hasItemMeta()) {
            this.plugin.getLogger().info("[DEBUG] \u62f3\u5251\u6ca1\u6709meta\uff0c\u8df3\u8fc7");
            return;
        }
        ItemMeta meta = katar.getItemMeta();
        PersistentDataContainer container = meta.getPersistentDataContainer();
        int currentMode = (Integer)container.getOrDefault(Constants.KATAR_MODE_KEY, PersistentDataType.INTEGER, (Object)0);
        this.plugin.getLogger().info("[DEBUG] \u5f53\u524d\u62f3\u5251\u6a21\u5f0f: " + currentMode);
        boolean attackAllModeEnabled = this.plugin.getConfig().getBoolean("Tools.katar_attack_all_mode_enabled", true);
        double damage = 1000.0;
        int range = 10;
        Collection nearbyEntities = player.getWorld().getNearbyEntities(player.getLocation(), (double)range, (double)range, (double)range);
        List targets = nearbyEntities.stream().filter(e -> e instanceof LivingEntity && !e.equals((Object)player) && !(e instanceof ArmorStand)).filter(e -> {
            if (currentMode == 1) {
                return e instanceof Monster;
            }
            if (attackAllModeEnabled) {
                return true;
            }
            return e instanceof Monster;
        }).map(e -> (LivingEntity)e).collect(Collectors.toList());
        this.plugin.getLogger().info("[DEBUG] \u627e\u5230\u76ee\u6807\u6570\u91cf: " + targets.size());
        if (targets.isEmpty()) {
            this.plugin.getLogger().info("[DEBUG] \u6ca1\u6709\u76ee\u6807\uff0c\u76f4\u63a5\u8fd4\u56de");
            return;
        }
        this.plugin.getLogger().info("[DEBUG] \u5f00\u59cb\u653b\u51fb\u76ee\u6807");
        player.playSound(player.getLocation(), "projecte:custom.pecharge", 1.0f, 1.0f);
        for (LivingEntity target : targets) {
            target.setHealth(Math.max(0.0, target.getHealth() - damage));
        }
        this.swordCooldowns.put(player.getUniqueId(), now);
        this.plugin.getLogger().info("[DEBUG] \u653b\u51fb\u5b8c\u6210");
    }

    private void handleMorningstarAbility(Player player, ItemStack morningstar, Block clickedBlock) {
        int radius;
        if (clickedBlock == null) {
            return;
        }
        int charge = this.toolManager.getCharge(morningstar);
        if (charge == 0) {
            return;
        }
        switch (charge) {
            case 1: {
                radius = 1;
                break;
            }
            case 2: {
                radius = 2;
                break;
            }
            case 3: {
                radius = 3;
                break;
            }
            case 4: {
                radius = 4;
                break;
            }
            default: {
                return;
            }
        }
        Material blockType = clickedBlock.getType();
        List<Object> affectedBlocks = this.isRock(blockType) || this.isShovelable(blockType) || Tag.LOGS.isTagged((Keyed)blockType) || this.toolManager.isValidMaterialForTool(blockType, new ItemStack(Material.DIAMOND_PICKAXE)) || this.toolManager.isValidMaterialForTool(blockType, new ItemStack(Material.DIAMOND_SHOVEL)) || this.toolManager.isValidMaterialForTool(blockType, new ItemStack(Material.DIAMOND_AXE)) ? this.getBlocksInCube(clickedBlock, radius) : this.getBlocksInCube(clickedBlock, radius).stream().filter(b -> b.getType() == blockType).collect(Collectors.toList());
        if (!affectedBlocks.isEmpty()) {
            player.playSound(player.getLocation(), "projecte:custom.pedestruct", 1.0f, 1.0f);
            this.breakBlocksAndDropAtCenter(player, morningstar, affectedBlocks, clickedBlock.getLocation().add(0.5, 0.5, 0.5));
        }
    }

    private boolean isShovelable(Material material) {
        return Tag.DIRT.isTagged((Keyed)material) || Tag.SAND.isTagged((Keyed)material) || material == Material.GRAVEL || material == Material.CLAY;
    }

    private void breakBlocksAndGiveToPlayer(Player player, ItemStack tool, List<Block> blocks) {
        for (Block block : blocks) {
            if (block.isPassable() || block.isLiquid()) continue;
            Collection drops = block.getDrops(tool);
            block.setType(Material.AIR);
            for (ItemStack drop : drops) {
                HashMap leftover = player.getInventory().addItem(new ItemStack[]{drop});
                if (leftover.isEmpty()) continue;
                player.getWorld().dropItemNaturally(block.getLocation(), (ItemStack)leftover.get(0));
            }
        }
    }

    private void breakBlocksAndDropAtCenter(Player player, ItemStack tool, List<Block> blocks, Location dropLocation) {
        for (Block block : blocks) {
            if (block.getType() == Material.AIR || block.getType() == Material.BEDROCK || block.isLiquid() || block.isPassable()) continue;
            Collection drops = block.getDrops(tool);
            block.setType(Material.AIR);
            for (ItemStack drop : drops) {
                player.getWorld().dropItemNaturally(dropLocation, drop);
            }
        }
    }

    private List<Block> getBlocksInCube(Block centerBlock, int radius) {
        ArrayList<Block> blocks = new ArrayList<Block>();
        Location centerLoc = centerBlock.getLocation();
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    Block block = centerLoc.clone().add((double)x, (double)y, (double)z).getBlock();
                    blocks.add(block);
                }
            }
        }
        return blocks;
    }

    private void handleKatarAbility(Player player, ItemStack katar, PlayerInteractEvent event) {
        Action action = event.getAction();
        Block clickedBlock = event.getClickedBlock();
        this.plugin.getLogger().info("[DEBUG] handleKatarAbility\u88ab\u8c03\u7528\uff0c\u52a8\u4f5c: " + String.valueOf(action));
        if (action == Action.RIGHT_CLICK_AIR) {
            this.plugin.getLogger().info("[DEBUG] \u53f3\u952e\u7a7a\u6c14\uff0c\u8c03\u7528handleKatarRightClickAir");
            this.handleKatarRightClickAir(player, katar);
        } else if (action == Action.RIGHT_CLICK_BLOCK && clickedBlock != null) {
            Material type = clickedBlock.getType();
            if (Tag.LEAVES.isTagged((Keyed)type) || Tag.LOGS.isTagged((Keyed)type)) {
                this.handleKatarChop(player, katar, clickedBlock);
                event.setCancelled(true);
                return;
            }
            if (type == Material.DIRT || type == Material.GRASS_BLOCK || type == Material.DIRT_PATH) {
                this.handleKatarTill(player, katar, clickedBlock);
                event.setCancelled(true);
            }
        }
    }

    private void handleKatarTill(Player player, ItemStack katar, Block clickedBlock) {
        int charge = this.toolManager.getCharge(katar);
        if (charge == 0) {
            return;
        }
        int range = 4;
        ArrayList<Block> affectedBlocks = new ArrayList<Block>();
        for (int x = -range; x <= range; ++x) {
            for (int z = -range; z <= range; ++z) {
                Block block = clickedBlock.getRelative(x, 0, z);
                Material type = block.getType();
                if (type != Material.DIRT && type != Material.GRASS_BLOCK && type != Material.DIRT_PATH) continue;
                affectedBlocks.add(block);
            }
        }
        if (!affectedBlocks.isEmpty()) {
            player.playSound(player.getLocation(), Sound.ITEM_HOE_TILL, 1.0f, 1.0f);
        }
        for (Block block : affectedBlocks) {
            block.setType(Material.FARMLAND);
        }
    }

    private List<Block> findTree(Block startBlock) {
        ArrayList<Block> treeBlocks = new ArrayList<Block>();
        ArrayList<Block> toCheck = new ArrayList<Block>();
        ArrayList<Block> checked = new ArrayList<Block>();
        toCheck.add(startBlock);
        checked.add(startBlock);
        int limit = 5000;
        int count = 0;
        while (!toCheck.isEmpty() && count < limit) {
            Block current = (Block)toCheck.remove(0);
            treeBlocks.add(current);
            ++count;
            for (int x = -1; x <= 1; ++x) {
                for (int y = -1; y <= 1; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        Block neighbor;
                        Material type;
                        if (x == 0 && y == 0 && z == 0 || !Tag.LOGS.isTagged((Keyed)(type = (neighbor = current.getRelative(x, y, z)).getType())) && !Tag.LEAVES.isTagged((Keyed)type) || checked.contains(neighbor)) continue;
                        toCheck.add(neighbor);
                        checked.add(neighbor);
                    }
                }
            }
        }
        return treeBlocks;
    }

    private void handleKatarChop(Player player, ItemStack katar, Block clickedBlock) {
        List<Block> blocksToBreak = this.findTree(clickedBlock);
        if (!blocksToBreak.isEmpty()) {
            player.playSound(player.getLocation(), "projecte:custom.pedestruct", 1.0f, 1.0f);
        }
        this.breakBlocksAndGiveToPlayer(player, katar, blocksToBreak);
    }

    @EventHandler
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        Player player;
        if (event.getEntity() instanceof ArmorStand && event.getDamager() instanceof Player && this.toolManager.isRedMatterKatar((player = (Player)event.getDamager()).getInventory().getItemInMainHand())) {
            event.setCancelled(true);
            return;
        }
        if (!(event.getDamager() instanceof Player)) {
            return;
        }
        player = (Player)event.getDamager();
        ItemStack itemInHand = player.getInventory().getItemInMainHand();
        if (!this.toolManager.isRedMatterKatar(itemInHand)) {
            return;
        }
        if (!itemInHand.hasItemMeta()) {
            return;
        }
        ItemMeta meta = itemInHand.getItemMeta();
        PersistentDataContainer container = meta.getPersistentDataContainer();
        int currentMode = (Integer)container.getOrDefault(Constants.KATAR_MODE_KEY, PersistentDataType.INTEGER, (Object)0);
        boolean attackAllModeEnabled = this.plugin.getConfig().getBoolean("Tools.katar_attack_all_mode_enabled", true);
        if (!(attackAllModeEnabled && currentMode != 1 || event.getEntity() instanceof Monster)) {
            event.setCancelled(true);
        }
    }

    private void handleShearsAbility(Player player, ItemStack shears) {
        int range;
        int charge = this.toolManager.getCharge(shears);
        if (charge == 0 && !this.toolManager.isRedMatterKatar(shears)) {
            return;
        }
        boolean isRedMatter = this.toolManager.isRedMatterShears(shears);
        if (isRedMatter) {
            range = charge == 1 ? 30 : (charge == 2 ? 60 : (charge == 3 ? 90 : 0));
        } else {
            int n = charge == 1 ? 30 : (range = charge == 2 ? 60 : 0);
        }
        if (range == 0) {
            return;
        }
        List sheepList = player.getWorld().getEntitiesByClass(Sheep.class).stream().filter(sheep -> !sheep.isSheared() && sheep.getLocation().distance(player.getLocation()) <= (double)range).collect(Collectors.toList());
        if (!sheepList.isEmpty()) {
            player.playSound(player.getLocation(), Sound.ENTITY_SHEEP_SHEAR, 1.0f, 1.0f);
        }
        for (Sheep sheep2 : sheepList) {
            sheep2.setSheared(true);
            int woolAmount = 1 + new Random().nextInt(3);
            Material woolType = this.getWoolMaterial(sheep2.getColor());
            ItemStack woolStack = new ItemStack(woolType, woolAmount);
            HashMap leftover = player.getInventory().addItem(new ItemStack[]{woolStack});
            if (leftover.isEmpty()) continue;
            player.getWorld().dropItemNaturally(player.getLocation(), (ItemStack)leftover.get(0));
        }
    }

    private Material getWoolMaterial(DyeColor color) {
        if (color == null) {
            return Material.WHITE_WOOL;
        }
        try {
            return Material.valueOf((String)(color.name() + "_WOOL"));
        }
        catch (IllegalArgumentException e) {
            return Material.WHITE_WOOL;
        }
    }

    private void handleSwordAbility(Player player, ItemStack sword) {
        long lastUsed;
        long now = System.currentTimeMillis();
        if (now - (lastUsed = this.swordCooldowns.getOrDefault(player.getUniqueId(), 0L).longValue()) < 1000L) {
            return;
        }
        if (this.toolManager.isDarkMatterSword(sword)) {
            double damage = 12.0;
            int range = 2;
            Location eyeLocation = player.getEyeLocation();
            Vector direction = eyeLocation.getDirection();
            Location center = eyeLocation.add(direction.multiply(range + 1));
            Collection nearbyEntities = player.getWorld().getNearbyEntities(center, (double)range, (double)range, (double)range);
            List targets = nearbyEntities.stream().filter(e -> e instanceof Monster && !e.equals((Object)player)).map(e -> (LivingEntity)e).collect(Collectors.toList());
            if (targets.isEmpty()) {
                return;
            }
            player.getWorld().playSound(player.getLocation(), Sound.ENTITY_PLAYER_ATTACK_SWEEP, 1.0f, 1.0f);
            player.playSound(player.getLocation(), "projecte:custom.pecharge", 1.0f, 1.0f);
            for (LivingEntity target : targets) {
                target.damage(damage, (Entity)player);
            }
            this.swordCooldowns.put(player.getUniqueId(), now);
        } else if (this.toolManager.isRedMatterSword(sword)) {
            int charge = this.toolManager.getCharge(sword);
            if (charge == 0) {
                return;
            }
            double damage = 18.0;
            int range = charge;
            int mode = this.toolManager.getSwordMode(sword);
            Location eyeLocation = player.getEyeLocation();
            Vector direction = eyeLocation.getDirection();
            Location center = eyeLocation.add(direction.multiply(range + 1));
            Collection nearbyEntities = player.getWorld().getNearbyEntities(center, (double)range, (double)range, (double)range);
            List targets = nearbyEntities.stream().filter(e -> e instanceof LivingEntity && !e.equals((Object)player)).filter(e -> {
                if (mode == 0) {
                    return e instanceof Monster;
                }
                return true;
            }).map(e -> (LivingEntity)e).collect(Collectors.toList());
            if (targets.isEmpty()) {
                return;
            }
            player.getWorld().playSound(player.getLocation(), Sound.ENTITY_PLAYER_ATTACK_SWEEP, 1.0f, 1.5f);
            player.playSound(player.getLocation(), "projecte:custom.pecharge", 1.0f, 1.0f);
            for (LivingEntity target : targets) {
                target.damage(damage, (Entity)player);
            }
            this.swordCooldowns.put(player.getUniqueId(), now);
        }
    }

    private void handleHammerAbility(Player player, ItemStack hammer, Block clickedBlock) {
        int depth;
        int height;
        int width;
        int charge = this.toolManager.getCharge(hammer);
        if (charge == 0) {
            return;
        }
        switch (charge) {
            case 1: {
                width = 3;
                height = 3;
                depth = 2;
                break;
            }
            case 2: {
                width = 5;
                height = 4;
                depth = 3;
                break;
            }
            case 3: {
                width = 7;
                height = 5;
                depth = 4;
                break;
            }
            default: {
                return;
            }
        }
        List<Block> affectedBlocks = this.getBlocksInVolume(clickedBlock, player.getFacing(), width, height, depth);
        if (!affectedBlocks.isEmpty()) {
            player.playSound(player.getLocation(), "projecte:custom.pedestruct", 1.0f, 1.0f);
        }
        for (Block block : affectedBlocks) {
            if (this.isRock(block.getType())) {
                block.breakNaturally(hammer);
                continue;
            }
            if (!block.isLiquid()) continue;
            block.setType(Material.AIR);
        }
    }

    private boolean isRock(Material material) {
        String name = material.name();
        return name.endsWith("_ORE") || name.endsWith("STONE") || name.equals("GRANITE") || name.equals("DIORITE") || name.equals("ANDESITE") || name.equals("DEEPSLATE") || name.equals("NETHERRACK") || name.equals("BASALT") || name.equals("BLACKSTONE") || name.equals("END_STONE") || name.equals("OBSIDIAN");
    }

    private List<Block> getBlocksInVolume(Block start, BlockFace facing, int width, int height, int depth) {
        boolean isHorizontal;
        ArrayList<Block> blocks = new ArrayList<Block>();
        int halfWidth = (width - 1) / 2;
        int halfHeight = (height - 1) / 2;
        boolean bl = isHorizontal = facing == BlockFace.NORTH || facing == BlockFace.SOUTH || facing == BlockFace.EAST || facing == BlockFace.WEST;
        if (isHorizontal) {
            for (int d = 0; d < depth; ++d) {
                Block depthBlock = start.getRelative(facing.getOppositeFace(), d);
                for (int w = -halfWidth; w <= halfWidth; ++w) {
                    for (int h = -halfHeight; h <= halfHeight; ++h) {
                        Block horizontalBlock = depthBlock.getRelative(this.getPerpendicularFace(facing), w);
                        blocks.add(horizontalBlock.getRelative(BlockFace.UP, h));
                    }
                }
            }
        } else {
            for (int d = 0; d < depth; ++d) {
                Block depthBlock = start.getRelative(facing.getOppositeFace(), d);
                for (int w = -halfWidth; w <= halfWidth; ++w) {
                    for (int h = -halfWidth; h <= halfWidth; ++h) {
                        blocks.add(depthBlock.getRelative(w, 0, h));
                    }
                }
            }
        }
        return blocks;
    }

    private BlockFace getPerpendicularFace(BlockFace facing) {
        switch (facing) {
            case NORTH: 
            case SOUTH: {
                return BlockFace.EAST;
            }
        }
        return BlockFace.NORTH;
    }

    private void handlePickaxeAbility(Player player, ItemStack pickaxe, Block clickedBlock) {
        if (clickedBlock == null) {
            return;
        }
        Material blockType = clickedBlock.getType();
        if (!blockType.toString().endsWith("_ORE")) {
            return;
        }
        List<Block> vein = this.findVein(clickedBlock);
        if (!vein.isEmpty()) {
            player.playSound(player.getLocation(), "projecte:custom.pedestruct", 1.0f, 1.0f);
        }
        for (Block block : vein) {
            block.breakNaturally(pickaxe);
        }
    }

    private List<Block> findVein(Block startBlock) {
        ArrayList<Block> vein = new ArrayList<Block>();
        ArrayList<Block> toCheck = new ArrayList<Block>();
        ArrayList<Block> checked = new ArrayList<Block>();
        toCheck.add(startBlock);
        checked.add(startBlock);
        Material oreType = startBlock.getType();
        while (!toCheck.isEmpty()) {
            Block current = (Block)toCheck.remove(0);
            vein.add(current);
            for (int x = -1; x <= 1; ++x) {
                for (int y = -1; y <= 1; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        Block neighbor;
                        if (x == 0 && y == 0 && z == 0 || (neighbor = current.getRelative(x, y, z)).getType() != oreType || checked.contains(neighbor)) continue;
                        toCheck.add(neighbor);
                        checked.add(neighbor);
                    }
                }
            }
        }
        return vein;
    }

    private void handleShovelAbility(Player player, ItemStack shovel, Block clickedBlock) {
        if (clickedBlock == null) {
            return;
        }
        Material blockType = clickedBlock.getType();
        if (!blockType.toString().endsWith("_CONCRETE_POWDER") && !Tag.SAND.isTagged((Keyed)blockType) && blockType != Material.CLAY && blockType != Material.DIRT && blockType != Material.GRASS_BLOCK && blockType != Material.DIRT_PATH && blockType != Material.GRAVEL && blockType != Material.SOUL_SAND && blockType != Material.SOUL_SOIL) {
            return;
        }
        int charge = this.toolManager.getCharge(shovel);
        if (charge == 0) {
            return;
        }
        boolean isDarkMatter = this.toolManager.isDarkMatterShovel(shovel);
        int range = isDarkMatter ? (charge >= 1 ? 1 : 0) : charge;
        if (range == 0) {
            return;
        }
        BlockFace facing = player.getFacing();
        List<Block> affectedBlocks = this.getBlocksInArea(clickedBlock, facing, range);
        for (Block block : affectedBlocks) {
            if (block.getType() != blockType) continue;
            block.breakNaturally(shovel);
        }
    }

    private void handleHoeAbility(Player player, ItemStack hoe, Block clickedBlock) {
        int range;
        if (clickedBlock == null) {
            return;
        }
        Material blockType = clickedBlock.getType();
        if (blockType != Material.DIRT && blockType != Material.GRASS_BLOCK && blockType != Material.DIRT_PATH) {
            return;
        }
        int charge = this.toolManager.getCharge(hoe);
        if (charge == 0) {
            return;
        }
        boolean isDarkMatter = this.toolManager.isDarkMatterHoe(hoe);
        if (isDarkMatter) {
            range = charge == 1 ? 1 : (charge == 2 ? 2 : 0);
        } else {
            int n = charge == 1 ? 1 : (charge == 2 ? 2 : (range = charge == 3 ? 3 : 0));
        }
        if (range == 0) {
            return;
        }
        BlockFace facing = player.getFacing();
        List<Block> affectedBlocks = this.getBlocksInArea(clickedBlock, facing, range);
        for (Block block : affectedBlocks) {
            Material type = block.getType();
            if (type != Material.DIRT && type != Material.GRASS_BLOCK && type != Material.DIRT_PATH) continue;
            block.setType(Material.FARMLAND);
        }
    }

    private List<Block> getBlocksInArea(Block centerBlock, BlockFace facing, int range) {
        ArrayList<Block> blocks = new ArrayList<Block>();
        Location centerLoc = centerBlock.getLocation();
        for (int x = -range; x <= range; ++x) {
            for (int z = -range; z <= range; ++z) {
                Block block = centerLoc.clone().add((double)x, 0.0, (double)z).getBlock();
                blocks.add(block);
            }
        }
        return blocks;
    }
}

