/*
 * Decompiled with CFR 0.152.
 */
package org.Little_100.projecte.managers;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.Little_100.projecte.ProjectE;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;

public class BlockDataManager {
    private final ProjectE plugin;
    private final File blockFile;
    private final FileConfiguration blockConfig;
    private final Map<String, ItemStack> customBlocks = new HashMap<String, ItemStack>();
    private final Map<String, String> customBlockCommands = new HashMap<String, String>();
    private final Map<String, Material> customBlockBaseBlocks = new HashMap<String, Material>();
    private final Map<ItemStack, String> itemToIdMap = new HashMap<ItemStack, String>();

    public BlockDataManager(ProjectE plugin) {
        this.plugin = plugin;
        this.blockFile = new File(plugin.getDataFolder(), "Block.yml");
        if (!this.blockFile.exists()) {
            try {
                if (this.blockFile.createNewFile()) {
                    plugin.getLogger().info("Created empty Block.yml as it was not found.");
                }
            }
            catch (IOException e) {
                plugin.getLogger().log(Level.SEVERE, "Could not create Block.yml", e);
            }
        }
        this.blockConfig = YamlConfiguration.loadConfiguration((File)this.blockFile);
        this.loadBlocks();
    }

    private void loadBlocks() {
        ConfigurationSection blocksSection = this.blockConfig.getConfigurationSection("blocks");
        if (blocksSection != null) {
            for (String id : blocksSection.getKeys(false)) {
                ConfigurationSection blockData = blocksSection.getConfigurationSection(id);
                if (blockData == null) continue;
                ItemStack item = blockData.getItemStack("item");
                if (item != null) {
                    String baseBlockStr;
                    this.customBlocks.put(id, item);
                    this.itemToIdMap.put(item.clone(), id);
                    String command = blockData.getString("command");
                    if (command != null && !command.isEmpty()) {
                        this.customBlockCommands.put(id, command);
                    }
                    if ((baseBlockStr = blockData.getString("base_block")) == null) continue;
                    try {
                        Material baseBlock = Material.valueOf((String)baseBlockStr.toUpperCase());
                        this.customBlockBaseBlocks.put(id, baseBlock);
                    }
                    catch (IllegalArgumentException e) {
                        this.plugin.getLogger().warning("Invalid base_block material '" + baseBlockStr + "' for custom block '" + id + "'.");
                    }
                    continue;
                }
                this.plugin.getLogger().warning("Item is missing for custom block '" + id + "' in Block.yml.");
            }
        }
    }

    public void saveBlock(String id, ItemStack item, String command) {
        this.customBlocks.put(id, item);
        this.itemToIdMap.put(item.clone(), id);
        this.blockConfig.set("blocks." + id + ".item", (Object)item);
        if (command != null) {
            this.customBlockCommands.put(id, command);
            this.blockConfig.set("blocks." + id + ".command", (Object)command);
        } else {
            this.customBlockCommands.remove(id);
            this.blockConfig.set("blocks." + id + ".command", null);
        }
        try {
            this.blockConfig.save(this.blockFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not save Block.yml", e);
        }
    }

    public ItemStack getBlock(String id) {
        return this.customBlocks.get(id);
    }

    public String getBlockIdByItem(ItemStack item) {
        if (item == null) {
            return null;
        }
        for (Map.Entry<ItemStack, String> entry : this.itemToIdMap.entrySet()) {
            if (!item.isSimilar(entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    public ItemStack getBlockByItem(ItemStack item) {
        String id = this.getBlockIdByItem(item);
        return id != null ? this.getBlock(id) : null;
    }

    public String getPlaceCommand(String id) {
        return this.customBlockCommands.get(id);
    }

    public Material getBaseBlock(String id) {
        return this.customBlockBaseBlocks.get(id);
    }

    public Set<String> getAllBlockIds() {
        return this.customBlocks.keySet();
    }
}

