/*
 * Decompiled with CFR 0.152.
 */
package org.Little_100.projecte.tools;

import java.io.File;
import java.util.List;
import org.Little_100.projecte.ProjectE;
import org.Little_100.projecte.managers.EmcManager;
import org.Little_100.projecte.util.Constants;
import org.Little_100.projecte.util.CustomModelDataUtil;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class RepairTalisman {
    private final ProjectE plugin;
    private final NamespacedKey key;
    private ItemStack repairTalisman;

    public RepairTalisman(ProjectE plugin) {
        this.plugin = plugin;
        this.key = new NamespacedKey((Plugin)plugin, "repair_talisman");
        this.createRepairTalisman();
    }

    private void createRepairTalisman() {
        this.repairTalisman = new ItemStack(Material.PAPER);
        this.repairTalisman = CustomModelDataUtil.setCustomModelDataBoth(this.repairTalisman, "repair_talisman", 1);
        ItemMeta meta = this.repairTalisman.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(this.plugin.getLanguageManager().get("item.repair_talisman.name"));
            meta.setLore(List.of(this.plugin.getLanguageManager().get("item.repair_talisman.lore1")));
            PersistentDataContainer container = meta.getPersistentDataContainer();
            container.set(this.key, PersistentDataType.BYTE, (Object)1);
            container.set(Constants.ID_KEY, PersistentDataType.STRING, (Object)"repair_talisman");
            this.repairTalisman.setItemMeta(meta);
        }
    }

    public ItemStack getRepairTalisman() {
        return this.repairTalisman.clone();
    }

    public boolean isRepairTalisman(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return false;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        String foundId = (String)container.get(Constants.ID_KEY, PersistentDataType.STRING);
        return "repair_talisman".equals(foundId);
    }

    public void setEmcValue() {
        EmcManager emcManager = this.plugin.getEmcManager();
        File configFile = new File(this.plugin.getDataFolder(), "custommoditememc.yml");
        if (!configFile.exists()) {
            this.plugin.getLogger().warning("custommoditememc.yml not found, repair talisman EMC value will not be loaded.");
            return;
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
        String itemKey = emcManager.getItemKey(this.getRepairTalisman());
        long emc = config.getLong("repair_talisman", 490L);
        emcManager.registerEmc(itemKey, emc);
    }
}

