/*
 * Decompiled with CFR 0.152.
 */
package org.Little_100.projecte.util;

import java.util.Collection;
import org.Little_100.projecte.ProjectE;
import org.Little_100.projecte.compatibility.scheduler.SchedulerAdapter;
import org.Little_100.projecte.managers.BlockDataManager;
import org.Little_100.projecte.util.Constants;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Stairs;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class CustomBlockArtUtil
implements Listener {
    private static double yOffset = -0.39;
    private static ProjectE plugin;
    private static SchedulerAdapter scheduler;
    private static BlockDataManager blockDataManager;

    public static double getYOffset() {
        return yOffset;
    }

    public static void addToYOffset(double value) {
        yOffset += value;
    }

    public CustomBlockArtUtil(ProjectE plugin, SchedulerAdapter scheduler) {
        CustomBlockArtUtil.plugin = plugin;
        CustomBlockArtUtil.scheduler = scheduler;
        blockDataManager = plugin.getBlockDataManager();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public static ArmorStand placeArtBlock(Location location, ItemStack item) {
        return CustomBlockArtUtil.placeArtBlock(location, item, Material.COBBLESTONE_STAIRS, Bisected.Half.TOP);
    }

    public static ArmorStand placeArtBlock(Location location, ItemStack item, Material baseBlock) {
        return CustomBlockArtUtil.placeArtBlock(location, item, baseBlock, Bisected.Half.TOP);
    }

    public static ArmorStand placeArtBlock(Location location, ItemStack item, Material baseBlock, Bisected.Half half) {
        Location adjustedLocation = location.clone().add(0.5, yOffset, 0.5);
        ArmorStand armorStand = (ArmorStand)location.getWorld().spawnEntity(adjustedLocation, EntityType.ARMOR_STAND);
        armorStand.setVisible(false);
        armorStand.setInvulnerable(true);
        armorStand.setGravity(false);
        armorStand.setBasePlate(false);
        armorStand.setArms(false);
        armorStand.setSmall(true);
        armorStand.setMarker(true);
        armorStand.getEquipment().setHelmet(item.clone());
        PersistentDataContainer pdc = armorStand.getPersistentDataContainer();
        if (item.hasItemMeta()) {
            ItemMeta meta = item.getItemMeta();
            if (meta.hasCustomModelData()) {
                pdc.set(Constants.MODEL_KEY, PersistentDataType.INTEGER, (Object)meta.getCustomModelData());
            }
            if (meta.hasDisplayName()) {
                pdc.set(Constants.NAME_KEY, PersistentDataType.STRING, (Object)meta.getDisplayName());
            }
        }
        pdc.set(Constants.MATERIAL_KEY, PersistentDataType.STRING, (Object)item.getType().toString());
        return armorStand;
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBlockPlace(BlockPlaceEvent event) {
        ItemStack itemInHand = event.getItemInHand();
        String blockId = blockDataManager.getBlockIdByItem(itemInHand);
        if (blockId != null) {
            event.setCancelled(true);
            Player player = event.getPlayer();
            Block block = event.getBlock();
            String command = blockDataManager.getPlaceCommand(blockId);
            if (command != null) {
                String processedCommand = command.replace("{x}", String.valueOf(block.getX())).replace("{y}", String.valueOf(block.getY())).replace("{z}", String.valueOf(block.getZ())).replace("{world}", block.getWorld().getName()).replace("{player}", player.getName());
                Bukkit.dispatchCommand((CommandSender)player, (String)processedCommand);
            } else {
                ItemStack customBlockItem = blockDataManager.getBlock(blockId);
                Material baseMaterial = blockDataManager.getBaseBlock(blockId);
                if (baseMaterial == null) {
                    baseMaterial = Material.COBBLESTONE_STAIRS;
                }
                Material finalBaseMaterial = baseMaterial;
                scheduler.runTaskAt(block.getLocation(), () -> {
                    block.setType(finalBaseMaterial, false);
                    if (block.getBlockData() instanceof Stairs) {
                        Stairs stairsData = (Stairs)block.getBlockData();
                        stairsData.setHalf(Bisected.Half.TOP);
                        block.setBlockData((BlockData)stairsData, true);
                    }
                });
                CustomBlockArtUtil.placeArtBlock(block.getLocation(), customBlockItem, finalBaseMaterial, Bisected.Half.TOP);
            }
            if (player.getGameMode() != GameMode.CREATIVE) {
                itemInHand.setAmount(itemInHand.getAmount() - 1);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        Block block = event.getBlock();
        if (block.getBlockData() instanceof Stairs) {
            Collection nearbyEntities = block.getWorld().getNearbyEntities(block.getLocation().add(0.5, 0.0, 0.5), 0.5, 0.5, 0.5, entity -> entity.getType() == EntityType.ARMOR_STAND);
            for (Entity entity2 : nearbyEntities) {
                ArmorStand stand;
                PersistentDataContainer pdc;
                if (!(entity2 instanceof ArmorStand) || !(pdc = (stand = (ArmorStand)entity2).getPersistentDataContainer()).has(Constants.MATERIAL_KEY, PersistentDataType.STRING)) continue;
                event.setCancelled(true);
                ItemStack dropItem = this.createDropItem(stand);
                stand.remove();
                String originalBlockStr = (String)pdc.getOrDefault(new NamespacedKey((Plugin)plugin, "original_block"), PersistentDataType.STRING, (Object)"AIR");
                Material originalMaterial = Material.getMaterial((String)originalBlockStr);
                block.setType(originalMaterial != null ? originalMaterial : Material.AIR);
                ItemStack helmet = stand.getEquipment().getHelmet();
                ItemStack fullDrop = blockDataManager.getBlockByItem(helmet);
                if (fullDrop != null) {
                    block.getWorld().dropItemNaturally(block.getLocation(), fullDrop.clone());
                    break;
                }
                if (dropItem == null) break;
                block.getWorld().dropItemNaturally(block.getLocation(), dropItem);
                break;
            }
        }
    }

    @EventHandler
    public void onArmorStandInteract(PlayerInteractAtEntityEvent event) {
        ArmorStand stand;
        PersistentDataContainer pdc;
        if (event.getRightClicked() instanceof ArmorStand && (pdc = (stand = (ArmorStand)event.getRightClicked()).getPersistentDataContainer()).has(Constants.MATERIAL_KEY, PersistentDataType.STRING)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onArmorStandDamage(EntityDamageEvent event) {
        ArmorStand stand;
        PersistentDataContainer pdc;
        if (event.getEntity() instanceof ArmorStand && (pdc = (stand = (ArmorStand)event.getEntity()).getPersistentDataContainer()).has(Constants.MATERIAL_KEY, PersistentDataType.STRING)) {
            event.setCancelled(true);
        }
    }

    private ItemStack createDropItem(ArmorStand stand) {
        PersistentDataContainer pdc = stand.getPersistentDataContainer();
        String materialStr = (String)pdc.get(Constants.MATERIAL_KEY, PersistentDataType.STRING);
        if (materialStr == null) {
            return null;
        }
        Material material = Material.getMaterial((String)materialStr);
        if (material == null) {
            return null;
        }
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return item;
        }
        if (pdc.has(Constants.MODEL_KEY, PersistentDataType.INTEGER)) {
            int cmd = (Integer)pdc.get(Constants.MODEL_KEY, PersistentDataType.INTEGER);
            meta.setCustomModelData(Integer.valueOf(cmd));
        }
        if (pdc.has(Constants.NAME_KEY, PersistentDataType.STRING)) {
            String name = (String)pdc.get(Constants.NAME_KEY, PersistentDataType.STRING);
            meta.setDisplayName(name);
        }
        item.setItemMeta(meta);
        return item;
    }
}

