/*
 * Decompiled with CFR 0.152.
 */
package org.Little_100.projecte;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.Little_100.projecte.AlchemicalBag.AlchemicalBagManager;
import org.Little_100.projecte.DebugManager;
import org.Little_100.projecte.ProjectE;
import org.Little_100.projecte.Tome.TransmutationTabletBook;
import org.Little_100.projecte.util.CustomModelDataUtil;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class RecipeManager {
    private final ProjectE plugin;
    private final Map<String, NamespacedKey> recipeKeys = new HashMap<String, NamespacedKey>();

    public RecipeManager(ProjectE plugin) {
        this.plugin = plugin;
    }

    public void registerAllRecipes() {
        this.loadRecipesFromYaml();
        this.registerUpgradeRecipes();
        this.registerDowngradeRecipes();
        this.registerOreTransmutationRecipes();
    }

    private void loadRecipesFromYaml() {
        YamlConfiguration config;
        ConfigurationSection recipesSection;
        File recipeFile = new File(this.plugin.getDataFolder(), "recipe.yml");
        if (!recipeFile.exists()) {
            this.plugin.getLogger().info("\u672a\u627e\u5230 recipe.yml\uff0c\u6b63\u5728\u521b\u5efa\u9ed8\u8ba4\u6587\u4ef6\u3002");
            this.plugin.saveResource("recipe.yml", false);
        }
        if ((recipesSection = (config = YamlConfiguration.loadConfiguration((File)recipeFile)).getConfigurationSection("recipes")) == null) {
            return;
        }
        for (String id : recipesSection.getKeys(false)) {
            ConfigurationSection recipeConfig;
            if (recipesSection.isList(id)) {
                List recipeList = recipesSection.getMapList(id);
                int i = 0;
                for (Map recipeMap : recipeList) {
                    ConfigurationSection recipeConfig2 = new YamlConfiguration().createSection("recipe", recipeMap);
                    if (!recipeConfig2.getBoolean("enabled", true)) continue;
                    this.parseRecipe(id + "_" + i, recipeConfig2);
                    ++i;
                }
                continue;
            }
            if (!recipesSection.isConfigurationSection(id) || (recipeConfig = recipesSection.getConfigurationSection(id)) == null || !recipeConfig.getBoolean("enabled", true)) continue;
            this.parseRecipe(id, recipeConfig);
        }
    }

    private void parseRecipe(String id, ConfigurationSection config) {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("recipe", id);
        DebugManager.log("debug.recipe.loading_recipe", placeholders);
        String type = config.getString("type", "shaped").toLowerCase();
        if (type.equals("shaped")) {
            this.parseShapedRecipe(id, config);
        } else if (type.equals("shapeless")) {
            this.parseShapelessRecipe(id, config);
        }
    }

    private void parseShapedRecipe(String id, ConfigurationSection config) {
        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, id);
        String originalId = id.split("_")[0];
        int kleinStarLevel = this.getKleinStarLevelFromId(originalId);
        ItemStack result = kleinStarLevel != -1 ? this.plugin.getKleinStarManager().getKleinStar(kleinStarLevel) : this.createResultStack(config.getConfigurationSection("result"));
        if (result == null) {
            if (this.plugin.getConfig().getBoolean("debug")) {
                this.plugin.getLogger().warning("[Debug] Recipe " + id + " has a null result. Skipping.");
            }
            return;
        }
        ShapedRecipe recipe = new ShapedRecipe(key, result);
        recipe.shape(config.getStringList("shape").toArray(new String[0]));
        ConfigurationSection ingredients = config.getConfigurationSection("ingredients");
        if (ingredients != null) {
            for (String ingredientKey : ingredients.getKeys(false)) {
                char keyChar = ingredientKey.charAt(0);
                String ingredientValue = ingredients.getString(ingredientKey);
                RecipeChoice choice = this.getChoice(ingredientValue);
                if (choice != null) {
                    recipe.setIngredient(keyChar, choice);
                    if (!this.plugin.getConfig().getBoolean("debug")) continue;
                    this.plugin.getLogger().info("[Debug] Recipe " + id + ": ingredient " + keyChar + " = " + ingredientValue);
                    continue;
                }
                if (!this.plugin.getConfig().getBoolean("debug")) continue;
                this.plugin.getLogger().warning("[Debug] Recipe " + id + ": ingredient " + keyChar + " (" + ingredientValue + ") is invalid. Skipping.");
            }
        }
        Bukkit.addRecipe((Recipe)recipe);
        this.recipeKeys.put(id, key);
        if (this.plugin.getConfig().getBoolean("debug")) {
            this.plugin.getLogger().info("[Debug] Successfully registered shaped recipe: " + id);
        }
    }

    private void parseShapelessRecipe(String id, ConfigurationSection config) {
        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, id);
        String originalId = id.split("_")[0];
        int kleinStarLevel = this.getKleinStarLevelFromId(originalId);
        ItemStack result = kleinStarLevel != -1 ? this.plugin.getKleinStarManager().getKleinStar(kleinStarLevel) : this.createResultStack(config.getConfigurationSection("result"));
        if (result == null) {
            if (this.plugin.getConfig().getBoolean("debug")) {
                this.plugin.getLogger().warning("[Debug] Recipe " + id + " has a null result. Skipping.");
            }
            return;
        }
        ShapelessRecipe recipe = new ShapelessRecipe(key, result);
        List ingredients = config.getStringList("ingredients");
        for (String ingredientValue : ingredients) {
            RecipeChoice choice = this.getChoice(ingredientValue);
            if (choice != null) {
                recipe.addIngredient(choice);
                if (!this.plugin.getConfig().getBoolean("debug")) continue;
                this.plugin.getLogger().info("[Debug] Recipe " + id + ": ingredient = " + ingredientValue);
                continue;
            }
            if (!this.plugin.getConfig().getBoolean("debug")) continue;
            this.plugin.getLogger().warning("[Debug] Recipe " + id + ": ingredient " + ingredientValue + " is invalid. Skipping.");
        }
        Bukkit.addRecipe((Recipe)recipe);
        this.recipeKeys.put(id, key);
        if (this.plugin.getConfig().getBoolean("debug")) {
            this.plugin.getLogger().info("[Debug] Successfully registered shapeless recipe: " + id);
        }
    }

    private RecipeChoice getChoice(String ingredient) {
        if (this.plugin.getConfig().getBoolean("debug")) {
            this.plugin.getLogger().info("[Debug] Getting choice for ingredient: " + ingredient);
        }
        if (ingredient.startsWith("projecte:")) {
            String customItemId = ingredient.substring(9);
            ItemStack customItem = customItemId.equals("alchemical_bag") ? AlchemicalBagManager.getAlchemicalBag() : this.plugin.getItemStackFromKey(customItemId);
            if (customItem != null) {
                if (this.plugin.getConfig().getBoolean("debug")) {
                    this.plugin.getLogger().info("[Debug] Matched custom item: " + customItemId);
                }
                return new RecipeChoice.ExactChoice(customItem);
            }
            if (this.plugin.getConfig().getBoolean("debug")) {
                this.plugin.getLogger().warning("[Debug] Custom item not found: " + customItemId);
            }
            return null;
        }
        if (ingredient.equalsIgnoreCase("any_wool")) {
            if (this.plugin.getConfig().getBoolean("debug")) {
                this.plugin.getLogger().info("[Debug] Matched special case: any_wool");
            }
            return new RecipeChoice.MaterialChoice(new Material[]{Material.WHITE_WOOL, Material.ORANGE_WOOL, Material.MAGENTA_WOOL, Material.LIGHT_BLUE_WOOL, Material.YELLOW_WOOL, Material.LIME_WOOL, Material.PINK_WOOL, Material.GRAY_WOOL, Material.LIGHT_GRAY_WOOL, Material.CYAN_WOOL, Material.PURPLE_WOOL, Material.BLUE_WOOL, Material.BROWN_WOOL, Material.GREEN_WOOL, Material.RED_WOOL, Material.BLACK_WOOL});
        }
        if (ingredient.equalsIgnoreCase("any_dye")) {
            if (this.plugin.getConfig().getBoolean("debug")) {
                this.plugin.getLogger().info("[Debug] Matched special case: any_dye");
            }
            return new RecipeChoice.MaterialChoice(new Material[]{Material.RED_DYE, Material.GREEN_DYE, Material.BLUE_DYE, Material.WHITE_DYE, Material.BLACK_DYE, Material.YELLOW_DYE, Material.PURPLE_DYE, Material.ORANGE_DYE});
        }
        try {
            Material material = Material.valueOf((String)ingredient.toUpperCase());
            if (this.plugin.getConfig().getBoolean("debug")) {
                this.plugin.getLogger().info("[Debug] Matched material: " + material.name());
            }
            return new RecipeChoice.MaterialChoice(material);
        }
        catch (IllegalArgumentException e) {
            if (this.plugin.getConfig().getBoolean("debug")) {
                this.plugin.getLogger().warning("[Debug] No choice found for ingredient: " + ingredient);
            }
            return null;
        }
    }

    private void registerSpecialFuelRecipes() {
    }

    private ItemStack createResultStack(ConfigurationSection config) {
        if (config == null) {
            return null;
        }
        if (config.contains("projecte_id")) {
            String projecteId = config.getString("projecte_id");
            ItemStack item = null;
            switch (projecteId) {
                case "low_covalence_dust": {
                    item = this.plugin.getCovalenceDust().getLowCovalenceDust();
                    break;
                }
                case "medium_covalence_dust": {
                    item = this.plugin.getCovalenceDust().getMediumCovalenceDust();
                    break;
                }
                case "high_covalence_dust": {
                    item = this.plugin.getCovalenceDust().getHighCovalenceDust();
                    break;
                }
                case "low_divining_rod": {
                    item = this.plugin.getDiviningRod().getLowDiviningRod();
                    break;
                }
                case "medium_divining_rod": {
                    item = this.plugin.getDiviningRod().getMediumDiviningRod();
                    break;
                }
                case "high_divining_rod": {
                    item = this.plugin.getDiviningRod().getHighDiviningRod();
                    break;
                }
                case "repair_talisman": {
                    item = this.plugin.getRepairTalisman().getRepairTalisman();
                    break;
                }
                case "dark_matter": {
                    item = this.plugin.getFuelManager().getDarkMatter();
                    break;
                }
                case "red_matter": {
                    item = this.plugin.getFuelManager().getRedMatter();
                    break;
                }
                case "dark_matter_block": {
                    item = this.plugin.getFuelManager().getDarkMatterBlock();
                    break;
                }
                case "red_matter_block": {
                    item = this.plugin.getFuelManager().getRedMatterBlock();
                    break;
                }
                case "klein_star_ein": {
                    item = this.plugin.getKleinStarManager().getKleinStar(1);
                    break;
                }
                case "klein_star_zwei": {
                    item = this.plugin.getKleinStarManager().getKleinStar(2);
                    break;
                }
                case "klein_star_drei": {
                    item = this.plugin.getKleinStarManager().getKleinStar(3);
                    break;
                }
                case "klein_star_vier": {
                    item = this.plugin.getKleinStarManager().getKleinStar(4);
                    break;
                }
                case "klein_star_sphere": {
                    item = this.plugin.getKleinStarManager().getKleinStar(5);
                    break;
                }
                case "klein_star_omega": {
                    item = this.plugin.getKleinStarManager().getKleinStar(6);
                    break;
                }
                case "transmutation_tablet_book": {
                    item = TransmutationTabletBook.createTransmutationTabletBook();
                    break;
                }
                default: {
                    String materialName = config.getString("material", "GLOWSTONE_DUST");
                    item = this.plugin.getItemStackFromKey(materialName + "{projecte_id:\"" + projecteId + "\"}");
                }
            }
            if (item != null) {
                YamlConfiguration emcConfig;
                item.setAmount(config.getInt("amount", 1));
                File customEmcFile = new File(this.plugin.getDataFolder(), "custommoditememc.yml");
                if (customEmcFile.exists() && (emcConfig = YamlConfiguration.loadConfiguration((File)customEmcFile)).contains(projecteId)) {
                    long emc = emcConfig.getLong(projecteId);
                    this.plugin.getEmcManager().setEmcValue(item, emc);
                }
                return item;
            }
        }
        String materialName = config.getString("material");
        Material material = this.plugin.getVersionAdapter().getMaterial(materialName);
        if (material == null) {
            material = Material.matchMaterial((String)materialName);
        }
        if (material == null) {
            return null;
        }
        ItemStack item = new ItemStack(material, config.getInt("amount", 1));
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            if (config.contains("display_name")) {
                meta.setDisplayName(this.plugin.getLanguageManager().get(config.getString("display_name")));
            }
            if (config.contains("lore")) {
                List loreKeys = config.getStringList("lore");
                List translatedLore = loreKeys.stream().map(key -> this.plugin.getLanguageManager().get((String)key)).collect(Collectors.toList());
                meta.setLore(translatedLore);
            }
            if (config.contains("custom_model_data")) {
                item = CustomModelDataUtil.setCustomModelData(item, config.getString("custom_model_data"));
                meta = item.getItemMeta();
                if (config.contains("display_name")) {
                    meta.setDisplayName(this.plugin.getLanguageManager().get(config.getString("display_name")));
                }
                if (config.contains("lore")) {
                    List loreKeys2 = config.getStringList("lore");
                    List translatedLore2 = loreKeys2.stream().map(key -> this.plugin.getLanguageManager().get((String)key)).collect(Collectors.toList());
                    meta.setLore(translatedLore2);
                }
            }
            if (config.getBoolean("unbreakable")) {
                meta.setUnbreakable(true);
            }
            item.setItemMeta(meta);
        }
        return item;
    }

    private void registerUpgradeRecipes() {
        ItemStack philosopherStone = this.plugin.getPhilosopherStone();
        this.registerUpgradeRecipe("copper_to_iron", Material.COPPER_INGOT, Material.IRON_INGOT, 4, 1, philosopherStone);
        this.registerUpgradeRecipe("iron_to_gold", Material.IRON_INGOT, Material.GOLD_INGOT, 4, 1, philosopherStone);
        this.registerUpgradeRecipe("gold_to_diamond", Material.GOLD_INGOT, Material.DIAMOND, 4, 1, philosopherStone);
        this.registerSpecialUpgradeRecipe("diamond_to_netherite", Material.DIAMOND_BLOCK, Material.NETHERITE_INGOT, 8, 1, philosopherStone);
    }

    private void registerDowngradeRecipes() {
        ItemStack philosopherStone = this.plugin.getPhilosopherStone();
        this.registerDowngradeRecipe("copper_to_coal", Material.COPPER_INGOT, Material.COAL, 1, 4, philosopherStone);
        this.registerDowngradeRecipe("iron_to_copper", Material.IRON_INGOT, Material.COPPER_INGOT, 1, 4, philosopherStone);
        this.registerDowngradeRecipe("gold_to_iron", Material.GOLD_INGOT, Material.IRON_INGOT, 1, 4, philosopherStone);
        this.registerDowngradeRecipe("diamond_to_gold", Material.DIAMOND, Material.GOLD_INGOT, 1, 4, philosopherStone);
        this.registerDowngradeRecipe("netherite_to_diamond", Material.NETHERITE_INGOT, Material.DIAMOND_BLOCK, 1, 8, philosopherStone);
    }

    private void registerUpgradeRecipe(String id, Material input, Material output, int inputAmount, int outputAmount, ItemStack catalyst) {
        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "upgrade_" + id);
        ShapelessRecipe recipe = new ShapelessRecipe(key, new ItemStack(output, outputAmount));
        recipe.addIngredient(inputAmount, input);
        recipe.addIngredient(catalyst.getType());
        Bukkit.addRecipe((Recipe)recipe);
        this.recipeKeys.put("upgrade_" + id, key);
    }

    private void registerSpecialUpgradeRecipe(String id, Material input, Material output, int inputAmount, int outputAmount, ItemStack catalyst) {
        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "special_" + id);
        ShapelessRecipe recipe = new ShapelessRecipe(key, new ItemStack(output, outputAmount));
        recipe.addIngredient(inputAmount, input);
        recipe.addIngredient(catalyst.getType());
        Bukkit.addRecipe((Recipe)recipe);
        this.recipeKeys.put("special_" + id, key);
    }

    private void registerDowngradeRecipe(String id, Material input, Material output, int inputAmount, int outputAmount, ItemStack catalyst) {
        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "downgrade_" + id);
        ShapelessRecipe recipe = new ShapelessRecipe(key, new ItemStack(output, outputAmount));
        recipe.addIngredient(inputAmount, input);
        recipe.addIngredient(catalyst.getType());
        Bukkit.addRecipe((Recipe)recipe);
        this.recipeKeys.put("downgrade_" + id, key);
    }

    public Map<String, NamespacedKey> getRecipeKeys() {
        return this.recipeKeys;
    }

    public void unregisterAllRecipes() {
        for (NamespacedKey key : this.recipeKeys.values()) {
            Bukkit.removeRecipe((NamespacedKey)key);
        }
        this.recipeKeys.clear();
    }

    private void registerOreTransmutationRecipes() {
        RecipeChoice.ExactChoice catalyst = new RecipeChoice.ExactChoice(this.plugin.getPhilosopherStone());
        RecipeChoice.MaterialChoice fuel = new RecipeChoice.MaterialChoice(new Material[]{Material.COAL, Material.CHARCOAL});
        this.registerOreTransmutationRecipe("iron", (RecipeChoice)new RecipeChoice.MaterialChoice(new Material[]{Material.IRON_ORE, Material.DEEPSLATE_IRON_ORE, Material.RAW_IRON}), new ItemStack(Material.IRON_INGOT, 7), (RecipeChoice)catalyst, (RecipeChoice)fuel);
        this.registerOreTransmutationRecipe("gold", (RecipeChoice)new RecipeChoice.MaterialChoice(new Material[]{Material.GOLD_ORE, Material.DEEPSLATE_GOLD_ORE, Material.RAW_GOLD}), new ItemStack(Material.GOLD_INGOT, 7), (RecipeChoice)catalyst, (RecipeChoice)fuel);
        this.registerOreTransmutationRecipe("copper", (RecipeChoice)new RecipeChoice.MaterialChoice(new Material[]{Material.COPPER_ORE, Material.DEEPSLATE_COPPER_ORE, Material.RAW_COPPER}), new ItemStack(Material.COPPER_INGOT, 7), (RecipeChoice)catalyst, (RecipeChoice)fuel);
        this.registerOreTransmutationRecipe("diamond", (RecipeChoice)new RecipeChoice.MaterialChoice(new Material[]{Material.DIAMOND_ORE, Material.DEEPSLATE_DIAMOND_ORE}), new ItemStack(Material.DIAMOND, 7), (RecipeChoice)catalyst, (RecipeChoice)fuel);
        this.registerOreTransmutationRecipe("netherite", (RecipeChoice)new RecipeChoice.MaterialChoice(Material.ANCIENT_DEBRIS), new ItemStack(Material.NETHERITE_SCRAP, 7), (RecipeChoice)catalyst, (RecipeChoice)fuel);
        RecipeChoice.MaterialChoice logChoice = new RecipeChoice.MaterialChoice(new Material[]{Material.OAK_LOG, Material.SPRUCE_LOG, Material.BIRCH_LOG, Material.JUNGLE_LOG, Material.ACACIA_LOG, Material.DARK_OAK_LOG, Material.MANGROVE_LOG, Material.CHERRY_LOG, Material.STRIPPED_OAK_LOG, Material.STRIPPED_SPRUCE_LOG, Material.STRIPPED_BIRCH_LOG, Material.STRIPPED_JUNGLE_LOG, Material.STRIPPED_ACACIA_LOG, Material.STRIPPED_DARK_OAK_LOG, Material.STRIPPED_MANGROVE_LOG, Material.STRIPPED_CHERRY_LOG});
        this.registerOreTransmutationRecipe("wood_to_charcoal", (RecipeChoice)logChoice, new ItemStack(Material.CHARCOAL, 7), (RecipeChoice)catalyst, (RecipeChoice)fuel);
    }

    private void registerOreTransmutationRecipe(String id, RecipeChoice oreChoice, ItemStack result, RecipeChoice catalyst, RecipeChoice fuel) {
        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "transmute_" + id);
        ShapelessRecipe recipe = new ShapelessRecipe(key, result);
        for (int i = 0; i < 7; ++i) {
            recipe.addIngredient(oreChoice);
        }
        recipe.addIngredient(fuel);
        recipe.addIngredient(catalyst);
        Bukkit.addRecipe((Recipe)recipe);
        this.recipeKeys.put("transmute_" + id, key);
    }

    private int getKleinStarLevelFromId(String id) {
        switch (id) {
            case "klein_star_ein": {
                return 1;
            }
            case "klein_star_zwei": {
                return 2;
            }
            case "klein_star_drei": {
                return 3;
            }
            case "klein_star_vier": {
                return 4;
            }
            case "klein_star_sphere": {
                return 5;
            }
            case "klein_star_omega": {
                return 6;
            }
        }
        return -1;
    }
}

