/*
 * Decompiled with CFR 0.152.
 */
package org.Little_100.projecte.storage;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.io.BukkitObjectInputStream;
import org.bukkit.util.io.BukkitObjectOutputStream;
import org.yaml.snakeyaml.external.biz.base64Coder.Base64Coder;

public class DatabaseManager {
    private Connection connection;
    private final File dataFolder;

    public DatabaseManager(File dataFolder) {
        this.dataFolder = dataFolder;
        this.connect();
    }

    private void connect() {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                return;
            }
            File dbFile = new File(this.dataFolder, "TransmutationTable/transmutation.db");
            if (!dbFile.getParentFile().exists()) {
                dbFile.getParentFile().mkdirs();
            }
            Class.forName("org.sqlite.JDBC");
            this.connection = DriverManager.getConnection("jdbc:sqlite:" + dbFile.getAbsolutePath());
            this.createTables();
        }
        catch (ClassNotFoundException | SQLException e) {
            e.printStackTrace();
        }
    }

    private void createTables() {
        try (Statement statement = this.connection.createStatement();){
            statement.execute("CREATE TABLE IF NOT EXISTS emc_values (item_key TEXT PRIMARY KEY,emc BIGINT NOT NULL);");
            statement.execute("CREATE TABLE IF NOT EXISTS player_emc (player_uuid TEXT PRIMARY KEY,emc BIGINT NOT NULL);");
            statement.execute("CREATE TABLE IF NOT EXISTS learned_items (player_uuid TEXT NOT NULL,item_key TEXT NOT NULL,PRIMARY KEY (player_uuid, item_key));");
            statement.execute("CREATE TABLE IF NOT EXISTS alchemical_bags (player_uuid TEXT NOT NULL,bag_color TEXT NOT NULL,inventory_contents TEXT,PRIMARY KEY (player_uuid, bag_color));");
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void setEmc(String itemKey, long emc) {
        String sql = "INSERT OR REPLACE INTO emc_values (item_key, emc) VALUES (?, ?);";
        try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
            pstmt.setString(1, itemKey);
            pstmt.setLong(2, emc);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getEmc(String itemKey) {
        String sql = "SELECT emc FROM emc_values WHERE item_key = ?;";
        try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
            pstmt.setString(1, itemKey);
            ResultSet rs = pstmt.executeQuery();
            if (!rs.next()) return 0L;
            long l = rs.getLong("emc");
            return l;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return 0L;
    }

    public boolean hasEmcValues() {
        boolean bl;
        block8: {
            String sql = "SELECT 1 FROM emc_values LIMIT 1;";
            PreparedStatement pstmt = this.connection.prepareStatement(sql);
            try {
                ResultSet rs = pstmt.executeQuery();
                bl = rs.next();
                if (pstmt == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (pstmt != null) {
                        try {
                            pstmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    return false;
                }
            }
            pstmt.close();
        }
        return bl;
    }

    public void clearEmcValues() {
        String sql = "DELETE FROM emc_values;";
        try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getPlayerEmc(UUID playerUuid) {
        String sql = "SELECT emc FROM player_emc WHERE player_uuid = ?;";
        try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
            pstmt.setString(1, playerUuid.toString());
            ResultSet rs = pstmt.executeQuery();
            if (!rs.next()) return 0L;
            long l = rs.getLong("emc");
            return l;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return 0L;
    }

    public void setPlayerEmc(UUID playerUuid, long emc) {
        String sql = "INSERT OR REPLACE INTO player_emc (player_uuid, emc) VALUES (?, ?);";
        try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
            pstmt.setString(1, playerUuid.toString());
            pstmt.setLong(2, emc);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void addLearnedItem(UUID playerUuid, String itemKey) {
        String sql = "INSERT OR IGNORE INTO learned_items (player_uuid, item_key) VALUES (?, ?);";
        try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
            pstmt.setString(1, playerUuid.toString());
            pstmt.setString(2, itemKey);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public List<String> getLearnedItems(UUID playerUuid) {
        ArrayList<String> learnedItems = new ArrayList<String>();
        String sql = "SELECT item_key FROM learned_items WHERE player_uuid = ?;";
        try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
            pstmt.setString(1, playerUuid.toString());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                learnedItems.add(rs.getString("item_key"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return learnedItems;
    }

    public boolean isLearned(UUID playerUuid, String itemKey) {
        boolean bl;
        block8: {
            String sql = "SELECT 1 FROM learned_items WHERE player_uuid = ? AND item_key = ? LIMIT 1;";
            PreparedStatement pstmt = this.connection.prepareStatement(sql);
            try {
                pstmt.setString(1, playerUuid.toString());
                pstmt.setString(2, itemKey);
                ResultSet rs = pstmt.executeQuery();
                bl = rs.next();
                if (pstmt == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (pstmt != null) {
                        try {
                            pstmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    return false;
                }
            }
            pstmt.close();
        }
        return bl;
    }

    public void close() {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                this.connection.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void saveBagInventory(UUID playerUUID, String bagColor, ItemStack[] items) {
        String base64Data;
        if (items == null) {
            return;
        }
        try {
            base64Data = this.itemStackArrayToBase64(items);
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
            return;
        }
        String sql = "INSERT OR REPLACE INTO alchemical_bags (player_uuid, bag_color, inventory_contents) VALUES (?, ?, ?);";
        try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
            pstmt.setString(1, playerUUID.toString());
            pstmt.setString(2, bagColor);
            pstmt.setString(3, base64Data);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ItemStack[] loadBagInventory(UUID playerUUID, String bagColor) {
        String sql = "SELECT inventory_contents FROM alchemical_bags WHERE player_uuid = ? AND bag_color = ?;";
        try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
            pstmt.setString(1, playerUUID.toString());
            pstmt.setString(2, bagColor);
            ResultSet rs = pstmt.executeQuery();
            if (!rs.next()) return new ItemStack[54];
            String base64Data = rs.getString("inventory_contents");
            ItemStack[] itemStackArray = this.itemStackArrayFromBase64(base64Data);
            return itemStackArray;
        }
        catch (IOException | SQLException e) {
            e.printStackTrace();
        }
        return new ItemStack[54];
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String itemStackArrayToBase64(ItemStack[] items) throws IllegalStateException {
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            String string;
            try (BukkitObjectOutputStream dataOutput = new BukkitObjectOutputStream((OutputStream)outputStream);){
                dataOutput.writeInt(items.length);
                for (ItemStack item : items) {
                    dataOutput.writeObject((Object)item);
                }
                string = Base64Coder.encodeLines((byte[])outputStream.toByteArray());
            }
            return string;
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not serialize ItemStack[] to Base64!", e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private ItemStack[] itemStackArrayFromBase64(String data) throws IOException {
        if (data == null || data.isEmpty()) {
            return new ItemStack[54];
        }
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(Base64Coder.decodeLines((String)data));){
            ItemStack[] items;
            BukkitObjectInputStream dataInput;
            block16: {
                ItemStack[] itemStackArray;
                dataInput = new BukkitObjectInputStream((InputStream)inputStream);
                try {
                    int size = dataInput.readInt();
                    items = new ItemStack[size];
                    for (int i = 0; i < size; ++i) {
                        items[i] = (ItemStack)dataInput.readObject();
                    }
                    if (size >= 54) break block16;
                    ItemStack[] resizedItems = new ItemStack[54];
                    System.arraycopy(items, 0, resizedItems, 0, size);
                    itemStackArray = resizedItems;
                }
                catch (Throwable throwable) {
                    try {
                        dataInput.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                dataInput.close();
                return itemStackArray;
            }
            ItemStack[] itemStackArray = items;
            dataInput.close();
            return itemStackArray;
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Could not find ItemStack class for deserialization!", e);
        }
    }

    public List<String> getBagColors(UUID playerUuid) {
        ArrayList<String> bagColors = new ArrayList<String>();
        String sql = "SELECT bag_color FROM alchemical_bags WHERE player_uuid = ?;";
        try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
            pstmt.setString(1, playerUuid.toString());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                bagColors.add(rs.getString("bag_color"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return bagColors;
    }
}

