/*
 * Decompiled with CFR 0.152.
 */
package org.Little_100.projecte.armor;

import java.util.ArrayList;
import java.util.UUID;
import org.Little_100.projecte.ProjectE;
import org.Little_100.projecte.util.Constants;
import org.Little_100.projecte.util.CustomModelDataUtil;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class ArmorManager {
    private final ProjectE plugin;
    private ItemStack darkMatterHelmet;
    private ItemStack darkMatterChestplate;
    private ItemStack darkMatterLeggings;
    private ItemStack darkMatterBoots;
    private ItemStack redMatterHelmet;
    private ItemStack redMatterChestplate;
    private ItemStack redMatterLeggings;
    private ItemStack redMatterBoots;
    private ItemStack gemHelmet;
    private ItemStack gemChestplate;
    private ItemStack gemLeggings;
    private ItemStack gemBoots;

    public ArmorManager(ProjectE plugin) {
        this.plugin = plugin;
        this.createDarkMatterArmor();
        this.createRedMatterArmor();
        this.createGemArmor();
        this.registerArmorEmcValues();
    }

    private void createGemArmor() {
        this.gemHelmet = this.createArmorItem(Material.DIAMOND_HELMET, "gem_helmet", 4, "item.gem_helmet.name", EquipmentSlot.HEAD, 4.0, 2.0);
        this.gemChestplate = this.createArmorItem(Material.DIAMOND_CHESTPLATE, "gem_chestplate", 3, "item.gem_chestplate.name", EquipmentSlot.CHEST, 14.0, 2.0);
        this.gemLeggings = this.createArmorItem(Material.DIAMOND_LEGGINGS, "gem_leggings", 3, "item.gem_leggings.name", EquipmentSlot.LEGS, 12.0, 2.0);
        this.gemBoots = this.createArmorItem(Material.DIAMOND_BOOTS, "gem_boots", 3, "item.gem_boots.name", EquipmentSlot.FEET, 7.0, 2.0);
    }

    private void createDarkMatterArmor() {
        this.darkMatterHelmet = this.createArmorItem(Material.DIAMOND_HELMET, "dark_matter_helmet", 1, "item.dark_matter_helmet.name", EquipmentSlot.HEAD, 7.0, 2.0);
        this.darkMatterChestplate = this.createArmorItem(Material.DIAMOND_CHESTPLATE, "dark_matter_chestplate", 1, "item.dark_matter_chestplate.name", EquipmentSlot.CHEST, 14.0, 2.0);
        this.darkMatterLeggings = this.createArmorItem(Material.DIAMOND_LEGGINGS, "dark_matter_leggings", 1, "item.dark_matter_leggings.name", EquipmentSlot.LEGS, 12.0, 2.0);
        this.darkMatterBoots = this.createArmorItem(Material.DIAMOND_BOOTS, "dark_matter_boots", 1, "item.dark_matter_boots.name", EquipmentSlot.FEET, 7.0, 2.0);
    }

    private void createRedMatterArmor() {
        this.redMatterHelmet = this.createArmorItem(Material.DIAMOND_HELMET, "red_matter_helmet", 2, "item.red_matter_helmet.name", EquipmentSlot.HEAD, 7.0, 2.0);
        this.redMatterChestplate = this.createArmorItem(Material.DIAMOND_CHESTPLATE, "red_matter_chestplate", 2, "item.red_matter_chestplate.name", EquipmentSlot.CHEST, 14.0, 2.0);
        this.redMatterLeggings = this.createArmorItem(Material.DIAMOND_LEGGINGS, "red_matter_leggings", 2, "item.red_matter_leggings.name", EquipmentSlot.LEGS, 12.0, 2.0);
        this.redMatterBoots = this.createArmorItem(Material.DIAMOND_BOOTS, "red_matter_boots", 2, "item.red_matter_boots.name", EquipmentSlot.FEET, 7.0, 2.0);
    }

    private void registerArmorEmcValues() {
        this.plugin.getEmcManager().setEmcValue(this.darkMatterHelmet, 696320L);
        this.plugin.getEmcManager().setEmcValue(this.darkMatterChestplate, 0x110000L);
        this.plugin.getEmcManager().setEmcValue(this.darkMatterLeggings, 974848L);
        this.plugin.getEmcManager().setEmcValue(this.darkMatterBoots, 557056L);
        this.plugin.getEmcManager().setEmcValue(this.redMatterHelmet, 3031040L);
        this.plugin.getEmcManager().setEmcValue(this.redMatterChestplate, 0x4A0000L);
        this.plugin.getEmcManager().setEmcValue(this.redMatterLeggings, 0x40C000L);
        this.plugin.getEmcManager().setEmcValue(this.redMatterBoots, 0x250000L);
        this.plugin.getEmcManager().setEmcValue(this.gemHelmet, 29133920L);
        this.plugin.getEmcManager().setEmcValue(this.gemChestplate, 30950432L);
        this.plugin.getEmcManager().setEmcValue(this.gemLeggings, 30258440L);
        this.plugin.getEmcManager().setEmcValue(this.gemBoots, 28709248L);
    }

    private ItemStack createArmorItem(Material baseMaterial, String id, int customModelData, String displayNameKey, EquipmentSlot slot, double armor, double armorToughness) {
        ItemStack item = new ItemStack(baseMaterial);
        CustomModelDataUtil.registerMapping(id, customModelData);
        item = CustomModelDataUtil.setCustomModelData(item, id);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(this.plugin.getLanguageManager().get(displayNameKey));
            meta.setUnbreakable(true);
            PersistentDataContainer container = meta.getPersistentDataContainer();
            container.set(Constants.ID_KEY, PersistentDataType.STRING, (Object)id);
            if (armor > 0.0) {
                AttributeModifier armorModifier = new AttributeModifier(UUID.randomUUID(), "generic.armor", armor, AttributeModifier.Operation.ADD_NUMBER, slot);
                meta.addAttributeModifier(Attribute.valueOf((String)"GENERIC_ARMOR"), armorModifier);
            }
            if (armorToughness > 0.0) {
                AttributeModifier toughnessModifier = new AttributeModifier(UUID.randomUUID(), "generic.armor_toughness", armorToughness, AttributeModifier.Operation.ADD_NUMBER, slot);
                meta.addAttributeModifier(Attribute.valueOf((String)"GENERIC_ARMOR_TOUGHNESS"), toughnessModifier);
            }
            if (id.equals("gem_boots")) {
                AttributeModifier speedModifier = new AttributeModifier(UUID.randomUUID(), "generic.movement_speed", 1.0, AttributeModifier.Operation.MULTIPLY_SCALAR_1, slot);
                meta.addAttributeModifier(Attribute.valueOf((String)"GENERIC_MOVEMENT_SPEED"), speedModifier);
            }
            ArrayList<String> lore = new ArrayList<String>();
            if (id.startsWith("dark_matter_")) {
                lore.add(this.plugin.getLanguageManager().get("item.dark_matter_armor.lore1"));
            } else if (id.startsWith("red_matter_")) {
                lore.add(this.plugin.getLanguageManager().get("item.red_matter_armor.lore1"));
            } else if (id.equals("gem_helmet")) {
                lore.add(this.plugin.getLanguageManager().get("item.gem_helmet.lore1"));
                lore.add(this.plugin.getLanguageManager().get("item.gem_helmet.lore2"));
                lore.add(this.plugin.getLanguageManager().get("item.gem_helmet.lore3"));
            } else if (id.equals("gem_chestplate")) {
                lore.add(this.plugin.getLanguageManager().get("item.gem_chestplate.lore1"));
                lore.add(this.plugin.getLanguageManager().get("item.gem_chestplate.lore2"));
            } else if (id.equals("gem_leggings")) {
                lore.add(this.plugin.getLanguageManager().get("item.gem_leggings.lore1"));
                lore.add(this.plugin.getLanguageManager().get("item.gem_leggings.lore2"));
                lore.add(this.plugin.getLanguageManager().get("item.gem_leggings.lore3"));
            } else if (id.equals("gem_boots")) {
                lore.add(this.plugin.getLanguageManager().get("item.gem_boots.lore1"));
                lore.add(this.plugin.getLanguageManager().get("item.gem_boots.lore2"));
                lore.add(this.plugin.getLanguageManager().get("item.gem_boots.lore3"));
                lore.add(this.plugin.getLanguageManager().get("item.gem_boots.lore4"));
                lore.add(this.plugin.getLanguageManager().get("item.gem_boots.lore5"));
            }
            meta.setLore(lore);
            item.setItemMeta(meta);
        }
        return item;
    }

    public ItemStack getDarkMatterHelmet() {
        return this.darkMatterHelmet.clone();
    }

    public ItemStack getDarkMatterChestplate() {
        return this.darkMatterChestplate.clone();
    }

    public ItemStack getDarkMatterLeggings() {
        return this.darkMatterLeggings.clone();
    }

    public ItemStack getDarkMatterBoots() {
        return this.darkMatterBoots.clone();
    }

    public ItemStack getRedMatterHelmet() {
        return this.redMatterHelmet.clone();
    }

    public ItemStack getRedMatterChestplate() {
        return this.redMatterChestplate.clone();
    }

    public ItemStack getRedMatterLeggings() {
        return this.redMatterLeggings.clone();
    }

    public ItemStack getRedMatterBoots() {
        return this.redMatterBoots.clone();
    }

    public ItemStack getGemHelmet() {
        return this.gemHelmet.clone();
    }

    public ItemStack getGemChestplate() {
        return this.gemChestplate.clone();
    }

    public ItemStack getGemLeggings() {
        return this.gemLeggings.clone();
    }

    public ItemStack getGemBoots() {
        return this.gemBoots.clone();
    }

    public boolean isDarkMatterArmor(ItemStack item) {
        String id = this.getArmorId(item);
        return id != null && id.startsWith("dark_matter_") && (id.endsWith("_helmet") || id.endsWith("_chestplate") || id.endsWith("_leggings") || id.endsWith("_boots"));
    }

    public boolean isRedMatterArmor(ItemStack item) {
        String id = this.getArmorId(item);
        return id != null && id.startsWith("red_matter_") && (id.endsWith("_helmet") || id.endsWith("_chestplate") || id.endsWith("_leggings") || id.endsWith("_boots"));
    }

    public boolean isGemHelmet(ItemStack item) {
        String id = this.getArmorId(item);
        return "gem_helmet".equals(id);
    }

    public boolean isGemChestplate(ItemStack item) {
        String id = this.getArmorId(item);
        return "gem_chestplate".equals(id);
    }

    public boolean isGemLeggings(ItemStack item) {
        String id = this.getArmorId(item);
        return "gem_leggings".equals(id);
    }

    public boolean isGemBoots(ItemStack item) {
        String id = this.getArmorId(item);
        return "gem_boots".equals(id);
    }

    public String getArmorId(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return null;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return null;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        return (String)container.get(Constants.ID_KEY, PersistentDataType.STRING);
    }

    public boolean isArmor(String id) {
        if (id == null) {
            return false;
        }
        switch (id) {
            case "dark_matter_helmet": 
            case "dark_matter_chestplate": 
            case "dark_matter_leggings": 
            case "dark_matter_boots": 
            case "red_matter_helmet": 
            case "red_matter_chestplate": 
            case "red_matter_leggings": 
            case "red_matter_boots": 
            case "gem_helmet": 
            case "gem_chestplate": 
            case "gem_leggings": 
            case "gem_boots": {
                return true;
            }
        }
        return false;
    }

    public ItemStack getArmor(String id) {
        if (id == null) {
            return null;
        }
        switch (id) {
            case "dark_matter_helmet": {
                return this.getDarkMatterHelmet();
            }
            case "dark_matter_chestplate": {
                return this.getDarkMatterChestplate();
            }
            case "dark_matter_leggings": {
                return this.getDarkMatterLeggings();
            }
            case "dark_matter_boots": {
                return this.getDarkMatterBoots();
            }
            case "red_matter_helmet": {
                return this.getRedMatterHelmet();
            }
            case "red_matter_chestplate": {
                return this.getRedMatterChestplate();
            }
            case "red_matter_leggings": {
                return this.getRedMatterLeggings();
            }
            case "red_matter_boots": {
                return this.getRedMatterBoots();
            }
            case "gem_helmet": {
                return this.getGemHelmet();
            }
            case "gem_chestplate": {
                return this.getGemChestplate();
            }
            case "gem_leggings": {
                return this.getGemLeggings();
            }
            case "gem_boots": {
                return this.getGemBoots();
            }
        }
        return null;
    }
}

