/*
 * Decompiled with CFR 0.152.
 */
package org.Little_100.projecte.compatibility.version;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.Little_100.projecte.ProjectE;
import org.Little_100.projecte.compatibility.version.VersionAdapter;
import org.Little_100.projecte.managers.EmcManager;
import org.Little_100.projecte.storage.DatabaseManager;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Sign;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.CookingRecipe;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.inventory.SmithingTransformRecipe;
import org.bukkit.inventory.SmithingTrimRecipe;
import org.bukkit.inventory.StonecuttingRecipe;
import org.bukkit.plugin.Plugin;

public class ModernAdapter
implements VersionAdapter {
    private EmcManager emcManager;
    private final DatabaseManager databaseManager = ProjectE.getInstance().getDatabaseManager();

    ModernAdapter() {
    }

    private EmcManager getEmcManager() {
        if (this.emcManager == null) {
            this.emcManager = ProjectE.getInstance().getEmcManager();
        }
        return this.emcManager;
    }

    @Override
    public Material getMaterial(String name) {
        return Material.matchMaterial((String)name.toUpperCase());
    }

    @Override
    public String getItemKey(ItemStack itemStack) {
        if (itemStack == null || itemStack.getType().isAir()) {
            return "minecraft:air";
        }
        return itemStack.getType().getKey().toString();
    }

    @Override
    public long calculateRecipeEmc(Recipe recipe, String divisionStrategy) {
        if (recipe == null || recipe instanceof StonecuttingRecipe || recipe instanceof SmithingTrimRecipe) {
            return 0L;
        }
        long totalEmc = 0L;
        boolean isCooking = false;
        if (recipe instanceof ShapedRecipe) {
            ShapedRecipe shapedRecipe = (ShapedRecipe)recipe;
            for (RecipeChoice choice : shapedRecipe.getChoiceMap().values()) {
                if (choice == null) continue;
                long ingredientEmc = this.getChoiceEmc(choice);
                if (ingredientEmc == 0L) {
                    return 0L;
                }
                totalEmc += ingredientEmc;
            }
        } else if (recipe instanceof ShapelessRecipe) {
            ShapelessRecipe shapelessRecipe = (ShapelessRecipe)recipe;
            for (RecipeChoice choice : shapelessRecipe.getChoiceList()) {
                if (choice == null) continue;
                long ingredientEmc = this.getChoiceEmc(choice);
                if (ingredientEmc == 0L) {
                    return 0L;
                }
                totalEmc += ingredientEmc;
            }
        } else if (recipe instanceof SmithingTransformRecipe) {
            SmithingTransformRecipe smithingRecipe = (SmithingTransformRecipe)recipe;
            long baseEmc = this.getChoiceEmc(smithingRecipe.getBase());
            long additionEmc = this.getChoiceEmc(smithingRecipe.getAddition());
            long templateEmc = this.getChoiceEmc(smithingRecipe.getTemplate());
            if (baseEmc == 0L || additionEmc == 0L || templateEmc == 0L) {
                return 0L;
            }
            totalEmc = baseEmc + additionEmc + templateEmc;
        } else if (recipe instanceof CookingRecipe) {
            isCooking = true;
            CookingRecipe cookingRecipe = (CookingRecipe)recipe;
            totalEmc = this.getChoiceEmc(cookingRecipe.getInputChoice());
        } else {
            return 0L;
        }
        if (totalEmc <= 0L) {
            return 0L;
        }
        int resultAmount = recipe.getResult().getAmount();
        if (resultAmount <= 0) {
            return 0L;
        }
        long recipeEmc = "ceil".equals(divisionStrategy) ? (long)Math.ceil((double)totalEmc / (double)resultAmount) : totalEmc / (long)resultAmount;
        if (isCooking && recipeEmc > 0L) {
            ++recipeEmc;
        }
        return recipeEmc;
    }

    private long getIngredientEmc(ItemStack ingredient) {
        if (ingredient == null) {
            return 0L;
        }
        return this.getEmcManager().getEmc(this.getEmcManager().getItemKey(ingredient));
    }

    private long getChoiceEmc(RecipeChoice choice) {
        if (choice == null) {
            return 0L;
        }
        long lowestEmc = -1L;
        ArrayList<ItemStack> itemChoices = new ArrayList<ItemStack>();
        if (choice instanceof RecipeChoice.MaterialChoice) {
            for (Material mat : ((RecipeChoice.MaterialChoice)choice).getChoices()) {
                itemChoices.add(new ItemStack(mat));
            }
        } else if (choice instanceof RecipeChoice.ExactChoice) {
            itemChoices.addAll(((RecipeChoice.ExactChoice)choice).getChoices());
        } else {
            return 0L;
        }
        for (ItemStack item : itemChoices) {
            long emc = this.getIngredientEmc(item);
            if (emc <= 0L || lowestEmc != -1L && emc >= lowestEmc) continue;
            lowestEmc = emc;
        }
        return lowestEmc > 0L ? lowestEmc : 0L;
    }

    @Override
    public void loadInitialEmcValues() {
        FileConfiguration config = ProjectE.getInstance().getConfig();
        ConfigurationSection emcSection = config.getConfigurationSection("TransmutationTable.EMC.ImportantItems");
        if (emcSection == null) {
            ProjectE.getInstance().getLogger().warning("EMC section 'TransmutationTable.EMC.ImportantItems' not found in config.yml");
            return;
        }
        List items = emcSection.getMapList("default");
        ProjectE.getInstance().getLogger().info("Loading " + items.size() + " EMC entries from config's default list...");
        for (Map itemMap : items) {
            if (itemMap == null) {
                ProjectE.getInstance().getLogger().warning("Found a null entry in config's EMC list. Skipping.");
                continue;
            }
            for (Map.Entry entry : itemMap.entrySet()) {
                try {
                    String configKey = entry.getKey().toString();
                    if (!(entry.getValue() instanceof Number)) {
                        ProjectE.getInstance().getLogger().warning("Invalid EMC value for '" + configKey + "': not a number. Skipping.");
                        continue;
                    }
                    Material material = this.getMaterial(configKey);
                    if (material == null) continue;
                    String correctItemKey = material.getKey().toString();
                    long emc = ((Number)entry.getValue()).longValue();
                    if (emc <= 0L) continue;
                    this.databaseManager.setEmc(correctItemKey, emc);
                }
                catch (Exception e) {
                    ProjectE.getInstance().getLogger().log(Level.SEVERE, "Failed to process an EMC entry: " + entry.toString(), e);
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<String> getRecipeDebugInfo(Recipe recipe, String divisionStrategy) {
        ArrayList<String> debugInfo = new ArrayList<String>();
        if (recipe == null) {
            debugInfo.add(" - \u914d\u65b9\u4e3a\u7a7a");
            return debugInfo;
        }
        debugInfo.add(" - \u914d\u65b9\u7c7b\u578b: " + recipe.getClass().getSimpleName());
        long calculatedEmc = this.calculateRecipeEmc(recipe, divisionStrategy);
        debugInfo.add(" - \u8ba1\u7b97\u51fa\u7684EMC: " + calculatedEmc);
        if (recipe instanceof ShapedRecipe) {
            debugInfo.add(" - \u6210\u5206:");
            for (Map.Entry entry : ((ShapedRecipe)recipe).getIngredientMap().entrySet()) {
                if (entry.getValue() == null) continue;
                String key = this.getItemKey((ItemStack)entry.getValue());
                long emc = this.getIngredientEmc((ItemStack)entry.getValue());
                debugInfo.add("   - " + key + ": " + emc + " EMC");
            }
            return debugInfo;
        } else if (recipe instanceof ShapelessRecipe) {
            debugInfo.add(" - \u6210\u5206:");
            for (ItemStack ingredient : ((ShapelessRecipe)recipe).getIngredientList()) {
                if (ingredient == null) continue;
                String key = this.getItemKey(ingredient);
                long emc = this.getIngredientEmc(ingredient);
                debugInfo.add("   - " + key + ": " + emc + " EMC");
            }
            return debugInfo;
        } else if (recipe instanceof SmithingTransformRecipe) {
            debugInfo.add(" - \u6210\u5206:");
            SmithingTransformRecipe smithingRecipe = (SmithingTransformRecipe)recipe;
            ItemStack base = smithingRecipe.getBase().getItemStack();
            ItemStack addition = smithingRecipe.getAddition().getItemStack();
            debugInfo.add("   - \u57fa\u7840: " + this.getItemKey(base) + ": " + this.getIngredientEmc(base) + " EMC");
            debugInfo.add("   - \u6dfb\u52a0\u7269: " + this.getItemKey(addition) + ": " + this.getIngredientEmc(addition) + " EMC");
            return debugInfo;
        } else {
            if (!(recipe instanceof CookingRecipe)) return debugInfo;
            debugInfo.add(" - \u6210\u5206:");
            try {
                Method getInputMethod = recipe.getClass().getMethod("getInput", new Class[0]);
                Object inputObject = getInputMethod.invoke((Object)recipe, new Object[0]);
                if (inputObject instanceof ItemStack) {
                    ItemStack input = (ItemStack)inputObject;
                    debugInfo.add("   - " + this.getItemKey(input) + ": " + this.getIngredientEmc(input) + " EMC");
                    return debugInfo;
                }
                if (inputObject instanceof RecipeChoice.ExactChoice) {
                    ItemStack input = ((RecipeChoice.ExactChoice)inputObject).getItemStack();
                    debugInfo.add("   - " + this.getItemKey(input) + ": " + this.getIngredientEmc(input) + " EMC");
                    return debugInfo;
                }
                if (!(inputObject instanceof RecipeChoice.MaterialChoice)) return debugInfo;
                debugInfo.add("   - (MaterialChoice, e.g., a tag)");
                return debugInfo;
            }
            catch (Exception e) {
                debugInfo.add("   - (\u65e0\u6cd5\u83b7\u53d6\u6210\u5206)");
            }
        }
        return debugInfo;
    }

    @Override
    public Map<String, NamespacedKey> registerTransmutationTableRecipes() {
        HashMap<String, NamespacedKey> newKeys = new HashMap<String, NamespacedKey>();
        ProjectE plugin = ProjectE.getInstance();
        ItemStack transmutationTable = new ItemStack(Material.PETRIFIED_OAK_SLAB);
        RecipeChoice.MaterialChoice stoneChoice = new RecipeChoice.MaterialChoice(new Material[]{Material.STONE, Material.COBBLESTONE, Material.ANDESITE, Material.DIORITE, Material.GRANITE});
        NamespacedKey key1 = new NamespacedKey((Plugin)plugin, "transmutation_table_1");
        ShapedRecipe recipe1 = new ShapedRecipe(key1, transmutationTable);
        recipe1.shape(new String[]{"OSO", "SPS", "OSO"});
        recipe1.setIngredient('O', Material.OBSIDIAN);
        recipe1.setIngredient('S', (RecipeChoice)stoneChoice);
        recipe1.setIngredient('P', (RecipeChoice)new RecipeChoice.ExactChoice(plugin.getPhilosopherStone()));
        Bukkit.addRecipe((Recipe)recipe1);
        newKeys.put("transmutation_table_1", key1);
        NamespacedKey key2 = new NamespacedKey((Plugin)plugin, "transmutation_table_2");
        ShapedRecipe recipe2 = new ShapedRecipe(key2, transmutationTable);
        recipe2.shape(new String[]{"SOS", "OPO", "SOS"});
        recipe2.setIngredient('O', Material.OBSIDIAN);
        recipe2.setIngredient('S', (RecipeChoice)stoneChoice);
        recipe2.setIngredient('P', (RecipeChoice)new RecipeChoice.ExactChoice(plugin.getPhilosopherStone()));
        Bukkit.addRecipe((Recipe)recipe2);
        newKeys.put("transmutation_table_2", key2);
        return newKeys;
    }

    @Override
    public void openSign(Player player, Sign sign) {
        player.openSign(sign);
    }
}

