/*
 * Decompiled with CFR 0.152.
 */
package org.Little_100.projecte.gui;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.Little_100.projecte.ProjectE;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.inventory.meta.ItemMeta;

public class PdcItemDebugGUI {
    private final ProjectE plugin;
    private final Player player;
    private final List<ItemStack> pdcItems;
    private int page;

    public PdcItemDebugGUI(ProjectE plugin, Player player) {
        this.plugin = plugin;
        this.player = player;
        this.pdcItems = new ArrayList<ItemStack>();
        this.page = 0;
        this.scanPdcItems();
    }

    private void scanPdcItems() {
        HashSet<String> addedKeys = new HashSet<String>();
        Iterator recipeIterator = Bukkit.recipeIterator();
        while (recipeIterator.hasNext()) {
            try {
                String itemKey;
                Recipe recipe = (Recipe)recipeIterator.next();
                if (recipe.getResult() == null || recipe.getResult().getType().isAir()) continue;
                ItemStack result = recipe.getResult();
                if (!this.plugin.getEmcManager().isPdcItem(result) || addedKeys.contains(itemKey = this.plugin.getEmcManager().getItemKey(result))) continue;
                addedKeys.add(itemKey);
                this.pdcItems.add(result.clone());
            }
            catch (Exception exception) {}
        }
        this.pdcItems.sort((a, b) -> {
            String keyA = this.plugin.getEmcManager().getItemKey((ItemStack)a);
            String keyB = this.plugin.getEmcManager().getItemKey((ItemStack)b);
            return keyA.compareTo(keyB);
        });
    }

    public void open() {
        ItemMeta meta;
        Inventory gui = Bukkit.createInventory(null, (int)54, (String)(String.valueOf(ChatColor.DARK_PURPLE) + "PDC\u7269\u54c1\u8c03\u8bd5 - \u9875 " + (this.page + 1)));
        int startIndex = this.page * 45;
        int endIndex = Math.min(startIndex + 45, this.pdcItems.size());
        for (int i = startIndex; i < endIndex; ++i) {
            ItemStack item = this.pdcItems.get(i).clone();
            ItemMeta meta2 = item.getItemMeta();
            if (meta2 != null) {
                String itemKey = this.plugin.getEmcManager().getItemKey(item);
                long emc = this.plugin.getDatabaseManager().getEmc(itemKey);
                ArrayList<Object> lore = new ArrayList<Object>();
                lore.add(String.valueOf(ChatColor.GRAY) + "Key: " + String.valueOf(ChatColor.YELLOW) + itemKey);
                lore.add(String.valueOf(ChatColor.GRAY) + "EMC: " + String.valueOf(ChatColor.GREEN) + String.valueOf(emc > 0L ? Long.valueOf(emc) : String.valueOf(ChatColor.RED) + "\u672a\u8ba1\u7b97"));
                lore.add("");
                lore.add(String.valueOf(ChatColor.GOLD) + "\u70b9\u51fb\u67e5\u770b\u8be6\u7ec6\u4fe1\u606f");
                meta2.setLore(lore);
                item.setItemMeta(meta2);
            }
            gui.setItem(i - startIndex, item);
        }
        if (this.page > 0) {
            ItemStack prevPage = new ItemStack(Material.ARROW);
            meta = prevPage.getItemMeta();
            meta.setDisplayName(String.valueOf(ChatColor.GREEN) + "\u4e0a\u4e00\u9875");
            prevPage.setItemMeta(meta);
            gui.setItem(48, prevPage);
        }
        if (endIndex < this.pdcItems.size()) {
            ItemStack nextPage = new ItemStack(Material.ARROW);
            meta = nextPage.getItemMeta();
            meta.setDisplayName(String.valueOf(ChatColor.GREEN) + "\u4e0b\u4e00\u9875");
            nextPage.setItemMeta(meta);
            gui.setItem(50, nextPage);
        }
        ItemStack close = new ItemStack(Material.BARRIER);
        meta = close.getItemMeta();
        meta.setDisplayName(String.valueOf(ChatColor.RED) + "\u5173\u95ed");
        close.setItemMeta(meta);
        gui.setItem(49, close);
        this.player.openInventory(gui);
    }

    public void nextPage() {
        if ((this.page + 1) * 45 < this.pdcItems.size()) {
            ++this.page;
            this.open();
        }
    }

    public void previousPage() {
        if (this.page > 0) {
            --this.page;
            this.open();
        }
    }

    public void showItemDebug(ItemStack item) {
        if (item == null || item.getType().isAir()) {
            return;
        }
        String itemKey = this.plugin.getEmcManager().getItemKey(item);
        long emc = this.plugin.getDatabaseManager().getEmc(itemKey);
        this.player.sendMessage(String.valueOf(ChatColor.GOLD) + "========== PDC\u7269\u54c1\u8c03\u8bd5\u4fe1\u606f ==========");
        this.player.sendMessage(String.valueOf(ChatColor.YELLOW) + "\u7269\u54c1Key: " + String.valueOf(ChatColor.WHITE) + itemKey);
        this.player.sendMessage(String.valueOf(ChatColor.YELLOW) + "\u5f53\u524dEMC: " + String.valueOf(ChatColor.WHITE) + String.valueOf(emc > 0L ? Long.valueOf(emc) : String.valueOf(ChatColor.RED) + "\u672a\u8ba1\u7b97"));
        this.plugin.getLogger().info("========== PDC Item Debug ==========");
        this.plugin.getLogger().info("Item Key: " + itemKey);
        this.plugin.getLogger().info("Current EMC: " + emc);
        this.plugin.getLogger().info("Item Type: " + String.valueOf(item.getType()));
        this.plugin.getLogger().info("Has ItemMeta: " + item.hasItemMeta());
        if (item.hasItemMeta()) {
            ItemMeta meta = item.getItemMeta();
            this.plugin.getLogger().info("Has DisplayName: " + meta.hasDisplayName());
            this.plugin.getLogger().info("Has CustomModelData: " + meta.hasCustomModelData());
            this.plugin.getLogger().info("PDC Keys: " + String.valueOf(meta.getPersistentDataContainer().getKeys()));
        }
        this.player.sendMessage(String.valueOf(ChatColor.YELLOW) + "\u76f8\u5173\u914d\u65b9:");
        this.plugin.getLogger().info("Related Recipes:");
        int recipeCount = 0;
        Iterator recipeIterator = Bukkit.recipeIterator();
        while (recipeIterator.hasNext()) {
            try {
                String resultKey;
                Recipe recipe = (Recipe)recipeIterator.next();
                if (recipe.getResult() == null || !(resultKey = this.plugin.getEmcManager().getItemKey(recipe.getResult())).equals(itemKey)) continue;
                this.showRecipeDebug(recipe, ++recipeCount);
            }
            catch (Exception exception) {}
        }
        if (recipeCount == 0) {
            this.player.sendMessage(String.valueOf(ChatColor.RED) + "  \u672a\u627e\u5230\u4efb\u4f55\u914d\u65b9\uff01");
            this.plugin.getLogger().warning("  No recipes found!");
        }
        this.player.sendMessage(String.valueOf(ChatColor.GOLD) + "===================================");
        this.plugin.getLogger().info("====================================");
    }

    private void showRecipeDebug(Recipe recipe, int index) {
        block3: {
            block2: {
                this.player.sendMessage(String.valueOf(ChatColor.AQUA) + "\u914d\u65b9 #" + index + " (" + recipe.getClass().getSimpleName() + ")");
                this.plugin.getLogger().info("Recipe #" + index + " (" + recipe.getClass().getSimpleName() + ")");
                String divisionStrategy = this.plugin.getConfig().getString("TransmutationTable.EMC.divisionStrategy", "floor");
                long calculatedEmc = this.plugin.getVersionAdapter().calculateRecipeEmc(recipe, divisionStrategy);
                this.player.sendMessage(String.valueOf(ChatColor.YELLOW) + "  \u8ba1\u7b97\u51fa\u7684EMC: " + String.valueOf(ChatColor.WHITE) + String.valueOf(calculatedEmc > 0L ? Long.valueOf(calculatedEmc) : String.valueOf(ChatColor.RED) + "0 (\u65e0\u6cd5\u8ba1\u7b97)"));
                this.plugin.getLogger().info("  Calculated EMC: " + calculatedEmc);
                this.player.sendMessage(String.valueOf(ChatColor.YELLOW) + "  \u539f\u6599:");
                this.plugin.getLogger().info("  Ingredients:");
                if (!(recipe instanceof ShapedRecipe)) break block2;
                ShapedRecipe shaped = (ShapedRecipe)recipe;
                for (Map.Entry entry : shaped.getIngredientMap().entrySet()) {
                    if (entry.getValue() == null || ((ItemStack)entry.getValue()).getType().isAir()) continue;
                    this.showIngredientDebug((ItemStack)entry.getValue());
                }
                break block3;
            }
            if (!(recipe instanceof ShapelessRecipe)) break block3;
            ShapelessRecipe shapeless = (ShapelessRecipe)recipe;
            for (ItemStack ingredient : shapeless.getIngredientList()) {
                if (ingredient == null || ingredient.getType().isAir()) continue;
                this.showIngredientDebug(ingredient);
            }
        }
    }

    private void showIngredientDebug(ItemStack ingredient) {
        String ingKey = this.plugin.getEmcManager().getItemKey(ingredient);
        String baseKey = this.plugin.getVersionAdapter().getItemKey(ingredient);
        long ingEmc = this.plugin.getDatabaseManager().getEmc(ingKey);
        boolean isPdc = this.plugin.getEmcManager().isPdcItem(ingredient);
        String message = String.valueOf(ChatColor.GRAY) + "    - " + String.valueOf(ingredient.getType()) + " x" + ingredient.getAmount() + String.valueOf(ChatColor.YELLOW) + " [" + (isPdc ? "PDC" : "\u539f\u7248") + "]";
        this.player.sendMessage(message);
        this.player.sendMessage(String.valueOf(ChatColor.GRAY) + "      Key: " + String.valueOf(ChatColor.WHITE) + ingKey);
        if (!ingKey.equals(baseKey)) {
            this.player.sendMessage(String.valueOf(ChatColor.GRAY) + "      Base Key: " + String.valueOf(ChatColor.WHITE) + baseKey);
        }
        this.player.sendMessage(String.valueOf(ChatColor.GRAY) + "      EMC: " + String.valueOf(ChatColor.WHITE) + String.valueOf(ingEmc > 0L ? Long.valueOf(ingEmc) : String.valueOf(ChatColor.RED) + "0 (\u672a\u8bbe\u7f6e)"));
        this.plugin.getLogger().info("    - " + String.valueOf(ingredient.getType()) + " x" + ingredient.getAmount() + " [" + (isPdc ? "PDC" : "Vanilla") + "]");
        this.plugin.getLogger().info("      Key: " + ingKey);
        if (!ingKey.equals(baseKey)) {
            this.plugin.getLogger().info("      Base Key: " + baseKey);
        }
        this.plugin.getLogger().info("      EMC: " + ingEmc);
    }
}

