/*
 * Decompiled with CFR 0.152.
 */
package org.Little_100.projecte.listeners;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.Little_100.projecte.ProjectE;
import org.Little_100.projecte.gui.PdcItemDebugGUI;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class PdcItemDebugGUIListener
implements Listener {
    private final ProjectE plugin;
    private final Map<UUID, PdcItemDebugGUI> openGuis = new HashMap<UUID, PdcItemDebugGUI>();

    public PdcItemDebugGUIListener(ProjectE plugin) {
        this.plugin = plugin;
    }

    public void registerGui(Player player, PdcItemDebugGUI gui) {
        this.openGuis.put(player.getUniqueId(), gui);
    }

    public void unregisterGui(Player player) {
        this.openGuis.remove(player.getUniqueId());
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        String title = event.getView().getTitle();
        if (!title.startsWith(String.valueOf(ChatColor.DARK_PURPLE) + "PDC\u7269\u54c1\u8c03\u8bd5")) {
            return;
        }
        event.setCancelled(true);
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null || clicked.getType() == Material.AIR) {
            return;
        }
        PdcItemDebugGUI gui = this.openGuis.get(player.getUniqueId());
        if (gui == null) {
            return;
        }
        if (clicked.getType() == Material.ARROW) {
            String displayName = clicked.getItemMeta().getDisplayName();
            if (displayName.contains("\u4e0b\u4e00\u9875")) {
                gui.nextPage();
            } else if (displayName.contains("\u4e0a\u4e00\u9875")) {
                gui.previousPage();
            }
            return;
        }
        if (clicked.getType() == Material.BARRIER) {
            player.closeInventory();
            this.unregisterGui(player);
            return;
        }
        if (this.plugin.getEmcManager().isPdcItem(clicked)) {
            ItemStack originalItem = clicked.clone();
            if (originalItem.hasItemMeta()) {
                originalItem.getItemMeta().setLore(null);
            }
            gui.showItemDebug(clicked);
        }
    }
}

