/*
 * Decompiled with CFR 0.152.
 */
package org.Little_100.projecte.tools.kleinstar;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.Little_100.projecte.ProjectE;
import org.Little_100.projecte.util.Constants;
import org.Little_100.projecte.util.CustomModelDataUtil;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class KleinStarManager {
    private final ProjectE plugin;
    private final Map<Integer, ItemStack> kleinStars = new HashMap<Integer, ItemStack>();
    private final Map<Integer, Long> kleinStarCapacities = new HashMap<Integer, Long>();
    private final NamespacedKey storedEmcKey;
    private final NamespacedKey capacityKey;

    public KleinStarManager(ProjectE plugin) {
        this.plugin = plugin;
        this.storedEmcKey = new NamespacedKey((Plugin)plugin, "stored_emc");
        this.capacityKey = new NamespacedKey((Plugin)plugin, "emc_capacity");
        this.initializeCapacities();
        this.initializeKleinStars();
    }

    private void initializeCapacities() {
        this.kleinStarCapacities.put(1, 50000L);
        this.kleinStarCapacities.put(2, 200000L);
        this.kleinStarCapacities.put(3, 800000L);
        this.kleinStarCapacities.put(4, 3200000L);
        this.kleinStarCapacities.put(5, 12800000L);
        this.kleinStarCapacities.put(6, 51200000L);
    }

    private void initializeKleinStars() {
        this.kleinStars.put(1, this.createKleinStar(1, "klein_star_ein"));
        this.kleinStars.put(2, this.createKleinStar(2, "klein_star_zwei"));
        this.kleinStars.put(3, this.createKleinStar(3, "klein_star_drei"));
        this.kleinStars.put(4, this.createKleinStar(4, "klein_star_vier"));
        this.kleinStars.put(5, this.createKleinStar(5, "klein_star_sphere"));
        this.kleinStars.put(6, this.createKleinStar(6, "klein_star_omega"));
    }

    private ItemStack createKleinStar(int level, String nameKey) {
        ItemMeta finalMeta;
        ItemStack kleinStar = new ItemStack(Material.DIAMOND_HOE);
        ItemMeta meta = kleinStar.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(this.plugin.getLanguageManager().get("item." + nameKey + ".name"));
            ArrayList<String> lore = new ArrayList<String>();
            lore.add(this.plugin.getLanguageManager().get("item." + nameKey + ".lore1"));
            lore.add(this.plugin.getLanguageManager().get("item." + nameKey + ".lore2").replace("{staremc}", "0"));
            meta.setLore(lore);
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
            if (meta instanceof Damageable) {
                ((Damageable)meta).setDamage(kleinStar.getType().getMaxDurability() - 2);
            }
            kleinStar.setItemMeta(meta);
        }
        if ((finalMeta = (kleinStar = CustomModelDataUtil.setCustomModelDataBoth(kleinStar, "klein_star_" + level, level)).getItemMeta()) != null) {
            PersistentDataContainer container = finalMeta.getPersistentDataContainer();
            long capacity = this.kleinStarCapacities.getOrDefault(level, 0L);
            container.set(Constants.KLEIN_STAR_KEY, PersistentDataType.INTEGER, (Object)level);
            container.set(this.storedEmcKey, PersistentDataType.LONG, (Object)0L);
            container.set(this.capacityKey, PersistentDataType.LONG, (Object)capacity);
            kleinStar.setItemMeta(finalMeta);
        }
        return kleinStar;
    }

    public ItemStack getKleinStar(int level) {
        ItemStack original = this.kleinStars.get(level);
        if (original == null) {
            return null;
        }
        return new ItemStack(original);
    }

    public boolean isKleinStar(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return false;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        return container.has(Constants.KLEIN_STAR_KEY, PersistentDataType.INTEGER);
    }

    public long getStoredEmc(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return 0L;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return 0L;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        return (Long)container.getOrDefault(this.storedEmcKey, PersistentDataType.LONG, (Object)0L);
    }

    public long getCapacity(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return 0L;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return 0L;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        return (Long)container.getOrDefault(this.capacityKey, PersistentDataType.LONG, (Object)0L);
    }

    public ItemStack setStoredEmc(ItemStack item, long emc) {
        if (item == null || !item.hasItemMeta()) {
            return item;
        }
        ItemStack newItem = new ItemStack(item);
        ItemMeta meta = newItem.getItemMeta();
        if (meta == null) {
            return newItem;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        container.set(this.storedEmcKey, PersistentDataType.LONG, (Object)emc);
        newItem.setItemMeta(meta);
        this.updateLoreAndDurability(newItem);
        return newItem;
    }

    public void updateLoreAndDurability(ItemStack item) {
        if (item == null || !item.hasItemMeta() || !this.isKleinStar(item)) {
            return;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return;
        }
        long storedEmc = this.getStoredEmc(item);
        int level = this.getKleinStarLevel(item);
        if (level <= 0) {
            return;
        }
        List lore = meta.getLore();
        if (lore != null && lore.size() >= 2) {
            String lore2Template;
            HashMap<Integer, String> levelToNameKey = new HashMap<Integer, String>();
            levelToNameKey.put(1, "klein_star_ein");
            levelToNameKey.put(2, "klein_star_zwei");
            levelToNameKey.put(3, "klein_star_drei");
            levelToNameKey.put(4, "klein_star_vier");
            levelToNameKey.put(5, "klein_star_sphere");
            levelToNameKey.put(6, "klein_star_omega");
            String nameKey = (String)levelToNameKey.get(level);
            if (nameKey != null && (lore2Template = this.plugin.getLanguageManager().get("item." + nameKey + ".lore2")) != null) {
                lore.set(1, lore2Template.replace("{staremc}", String.format("%,d", storedEmc)));
                meta.setLore(lore);
            }
        }
        if (meta instanceof Damageable) {
            int newDamage;
            long capacity = this.getCapacity(item);
            short maxDurability = item.getType().getMaxDurability();
            if (storedEmc >= capacity) {
                newDamage = 1;
            } else if (capacity > 0L) {
                double emcRatio = (double)storedEmc / (double)capacity;
                int variableDurability = maxDurability - 3;
                int damageOffset = (int)Math.round((double)variableDurability * (1.0 - emcRatio));
                newDamage = 2 + damageOffset;
            } else {
                newDamage = maxDurability - 2;
            }
            newDamage = Math.max(1, Math.min(newDamage, maxDurability - 1));
            ((Damageable)meta).setDamage(newDamage);
        }
        item.setItemMeta(meta);
    }

    public int getKleinStarLevel(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return -1;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return -1;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        return (Integer)container.getOrDefault(Constants.KLEIN_STAR_KEY, PersistentDataType.INTEGER, (Object)-1);
    }

    public static boolean hasEnoughEMC(Player player, long amount) {
        long totalEmc = 0L;
        for (ItemStack item : player.getInventory().getContents()) {
            if (item == null || !KleinStarManager.getInstance().isKleinStar(item)) continue;
            totalEmc += KleinStarManager.getInstance().getStoredEmc(item);
        }
        return totalEmc >= amount;
    }

    public static void consumeEMC(Player player, long amount) {
        long remaining = amount;
        ItemStack[] contents = player.getInventory().getContents();
        for (int i = 0; i < contents.length; ++i) {
            ItemStack item = contents[i];
            if (item == null || !KleinStarManager.getInstance().isKleinStar(item)) continue;
            long stored = KleinStarManager.getInstance().getStoredEmc(item);
            if (stored >= remaining) {
                player.getInventory().setItem(i, KleinStarManager.getInstance().setStoredEmc(item, stored - remaining));
                break;
            }
            player.getInventory().setItem(i, KleinStarManager.getInstance().setStoredEmc(item, 0L));
            remaining -= stored;
        }
    }

    public static boolean hasKleinStar(Player player) {
        for (ItemStack item : player.getInventory().getContents()) {
            if (item == null || !KleinStarManager.getInstance().isKleinStar(item)) continue;
            return true;
        }
        return false;
    }

    private static KleinStarManager getInstance() {
        return ProjectE.getInstance().getKleinStarManager();
    }
}

