/*
 * Decompiled with CFR 0.152.
 */
package org.Little_100.projecte;

import java.util.HashMap;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;

public class CovalenceDustCraftListener
implements Listener {
    @EventHandler
    public void onCraftItem(InventoryClickEvent event) {
        if (event.getSlotType() != InventoryType.SlotType.RESULT) {
            return;
        }
        if (!(event.getInventory() instanceof CraftingInventory)) {
            return;
        }
        CraftingInventory inv = (CraftingInventory)event.getInventory();
        ItemStack result = inv.getResult();
        if (result == null || !this.isCovalenceDust(result)) {
            return;
        }
        event.setCancelled(true);
        Player player = (Player)event.getWhoClicked();
        if (event.isShiftClick()) {
            this.handleShiftClick(player, inv, result);
        } else {
            this.handleNormalClick(player, inv, result);
        }
    }

    private void handleShiftClick(Player player, CraftingInventory inv, ItemStack result) {
        int numCrafted;
        int maxCrafts = this.calculateMaxCrafts(inv);
        if (maxCrafts <= 0) {
            return;
        }
        ItemStack resultStack = result.clone();
        resultStack.setAmount(result.getAmount() * maxCrafts);
        HashMap leftovers = player.getInventory().addItem(new ItemStack[]{resultStack});
        int craftedAmount = resultStack.getAmount();
        if (!leftovers.isEmpty()) {
            craftedAmount -= leftovers.values().stream().mapToInt(ItemStack::getAmount).sum();
        }
        if ((numCrafted = craftedAmount / result.getAmount()) > 0) {
            this.consumeIngredients(inv, numCrafted);
            player.updateInventory();
        }
    }

    private void handleNormalClick(Player player, CraftingInventory inv, ItemStack result) {
        int canAdd;
        ItemStack cursorItem = player.getItemOnCursor();
        if (cursorItem == null || cursorItem.getType() == Material.AIR) {
            this.consumeIngredients(inv, 1);
            player.setItemOnCursor(result);
            player.updateInventory();
        } else if (cursorItem.isSimilar(result) && (canAdd = result.getMaxStackSize() - cursorItem.getAmount()) >= result.getAmount()) {
            this.consumeIngredients(inv, 1);
            cursorItem.setAmount(cursorItem.getAmount() + result.getAmount());
            player.setItemOnCursor(cursorItem);
            player.updateInventory();
        }
    }

    private int calculateMaxCrafts(CraftingInventory inv) {
        int maxCrafts = Integer.MAX_VALUE;
        for (ItemStack item : inv.getMatrix()) {
            if (item == null || item.getType() == Material.AIR) continue;
            maxCrafts = Math.min(maxCrafts, item.getAmount());
        }
        return maxCrafts == Integer.MAX_VALUE ? 0 : maxCrafts;
    }

    private void consumeIngredients(CraftingInventory inv, int numCrafts) {
        ItemStack[] matrix = inv.getMatrix();
        for (int i = 0; i < matrix.length; ++i) {
            ItemStack item = matrix[i];
            if (item == null || item.getType() == Material.AIR) continue;
            item.setAmount(item.getAmount() - numCrafts);
            if (item.getAmount() > 0) continue;
            matrix[i] = null;
        }
        inv.setMatrix(matrix);
    }

    private boolean isCovalenceDust(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return false;
        }
        String id = (String)item.getItemMeta().getPersistentDataContainer().get(new NamespacedKey("projecte", "projecte_id"), PersistentDataType.STRING);
        return "low_covalence_dust".equals(id) || "medium_covalence_dust".equals(id) || "high_covalence_dust".equals(id);
    }
}

