/*
 * Decompiled with CFR 0.152.
 */
package org.Little_100.projecte;

import java.util.HashMap;
import org.Little_100.projecte.ProjectE;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;

public class CraftingListener
implements Listener {
    private final ProjectE plugin;

    public CraftingListener(ProjectE plugin) {
        this.plugin = plugin;
        Bukkit.getLogger().info("[ProjectE] CraftingListener initialized - Final Version");
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onCraftItem(CraftItemEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        Recipe recipe = event.getRecipe();
        if (recipe == null) {
            return;
        }
        CraftingInventory inventory = event.getInventory();
        boolean hasPhilosopherStone = false;
        for (ItemStack item : inventory.getMatrix()) {
            if (item == null || !this.plugin.isPhilosopherStone(item)) continue;
            hasPhilosopherStone = true;
            break;
        }
        if (!hasPhilosopherStone) {
            return;
        }
        event.setCancelled(true);
        ItemStack result = recipe.getResult().clone();
        this.plugin.getLogger().info("\u8d24\u8005\u4e4b\u77f3\u5408\u6210: " + String.valueOf(result.getType()) + " x" + result.getAmount());
        if (event.isShiftClick()) {
            int maxCrafts = this.calculateMaxCrafts(inventory);
            this.plugin.getLogger().info("\u6279\u91cf\u5408\u6210\uff0c\u6700\u5927\u6b21\u6570: " + maxCrafts);
            if (maxCrafts <= 0) {
                this.plugin.getLogger().info("\u65e0\u6cd5\u8fdb\u884c\u6279\u91cf\u5408\u6210: \u6750\u6599\u4e0d\u8db3");
                return;
            }
            int totalAmount = result.getAmount() * maxCrafts;
            result.setAmount(totalAmount);
            this.plugin.getLogger().info("\u5408\u6210\u603b\u91cf: " + totalAmount);
            this.consumeIngredients(inventory, maxCrafts);
        } else {
            this.plugin.getLogger().info("\u5355\u6b21\u5408\u6210: " + String.valueOf(result.getType()));
            this.consumeIngredients(inventory, 1);
        }
        this.plugin.getLogger().info("\u5c06\u7269\u54c1\u6dfb\u52a0\u5230\u73a9\u5bb6\u80cc\u5305: " + String.valueOf(result.getType()) + " x" + result.getAmount());
        HashMap leftover = player.getInventory().addItem(new ItemStack[]{result});
        if (!leftover.isEmpty()) {
            this.plugin.getLogger().info("\u80cc\u5305\u5df2\u6ee1\uff0c\u90e8\u5206\u7269\u54c1\u6389\u843d\u5728\u5730\u4e0a");
            for (ItemStack item : leftover.values()) {
                player.getWorld().dropItemNaturally(player.getLocation(), item);
            }
        }
        player.updateInventory();
    }

    private void consumeIngredients(CraftingInventory inventory, int times) {
        if (times <= 0) {
            this.plugin.getLogger().warning("\u5c1d\u8bd5\u6d88\u80170\u6216\u8d1f\u6570\u6750\u6599\uff0c\u64cd\u4f5c\u88ab\u53d6\u6d88");
            return;
        }
        ItemStack[] matrix = inventory.getMatrix();
        this.plugin.getLogger().info("\u6d88\u8017\u6750\u6599\uff0c\u6b21\u6570: " + times);
        StringBuilder before = new StringBuilder("\u6d88\u8017\u524d\u6750\u6599: ");
        for (ItemStack item : matrix) {
            if (item != null) {
                before.append(item.getType()).append("x").append(item.getAmount()).append(", ");
                continue;
            }
            before.append("\u7a7a, ");
        }
        this.plugin.getLogger().info(before.toString());
        for (int i = 0; i < matrix.length; ++i) {
            ItemStack item = matrix[i];
            if (item == null || item.getType() == Material.AIR) continue;
            if (this.plugin.isPhilosopherStone(item)) {
                this.plugin.getLogger().info("\u4fdd\u7559\u8d24\u8005\u4e4b\u77f3\u5728\u4f4d\u7f6e " + i);
                continue;
            }
            int newAmount = item.getAmount() - times;
            this.plugin.getLogger().info("\u6750\u6599 " + String.valueOf(item.getType()) + " \u5728\u4f4d\u7f6e " + i + ": " + item.getAmount() + " -> " + String.valueOf(newAmount > 0 ? Integer.valueOf(newAmount) : "\u6d88\u8017\u5b8c"));
            if (newAmount <= 0) {
                matrix[i] = null;
                continue;
            }
            item.setAmount(newAmount);
        }
        StringBuilder after = new StringBuilder("\u6d88\u8017\u540e\u6750\u6599: ");
        for (ItemStack item : matrix) {
            if (item != null) {
                after.append(item.getType()).append("x").append(item.getAmount()).append(", ");
                continue;
            }
            after.append("\u7a7a, ");
        }
        this.plugin.getLogger().info(after.toString());
        try {
            inventory.setMatrix(matrix);
            this.plugin.getLogger().info("\u5408\u6210\u683c\u5df2\u66f4\u65b0");
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("\u66f4\u65b0\u5408\u6210\u683c\u5931\u8d25: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private int calculateMaxCrafts(CraftingInventory inventory) {
        int maxCrafts = Integer.MAX_VALUE;
        for (ItemStack item : inventory.getMatrix()) {
            if (item == null || item.getType() == Material.AIR || this.plugin.isPhilosopherStone(item)) continue;
            maxCrafts = Math.min(maxCrafts, item.getAmount());
        }
        return maxCrafts == Integer.MAX_VALUE ? 0 : maxCrafts;
    }
}

