/*
 * Decompiled with CFR 0.152.
 */
package org.Little_100.projecte;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Logger;
import org.Little_100.projecte.ProjectE;

public class DatapackManager {
    private final ProjectE plugin;
    private final Logger logger;

    public DatapackManager(ProjectE plugin) {
        this.plugin = plugin;
        this.logger = plugin.getLogger();
    }

    public void setupDatapack() {
        if (!this.plugin.getConfig().getBoolean("Advancement_Datapack", false)) {
            this.logger.info("Advancement datapack is disabled in the config. Skipping setup.");
            return;
        }
        if (this.plugin.getConfig().getBoolean("ConfrimDatapack", false)) {
            this.logger.info("Datapack is already confirmed. Skipping setup.");
            return;
        }
        File worldContainer = this.plugin.getServer().getWorldContainer();
        File datapackDir = new File(worldContainer, "world/datapacks");
        if (!datapackDir.exists() && !datapackDir.mkdirs()) {
            this.logger.severe("Failed to create datapacks directory: " + datapackDir.getAbsolutePath());
            return;
        }
        String datapackFileName = "ProjectE_Datapack.zip";
        File datapackFile = new File(datapackDir, datapackFileName);
        String resourcePath = "pack/ProjectE Datapack.zip";
        try (InputStream in = this.plugin.getResource(resourcePath);){
            if (in == null) {
                this.logger.warning("Datapack file not found in plugin resources: " + resourcePath);
                return;
            }
            if (datapackFile.exists()) {
                this.logger.info("ProjectE datapack already exists. Skipping installation.");
                return;
            }
            try (FileOutputStream out = new FileOutputStream(datapackFile);){
                int len;
                byte[] buffer = new byte[1024];
                while ((len = in.read(buffer)) > 0) {
                    ((OutputStream)out).write(buffer, 0, len);
                }
                this.logger.info("Successfully installed ProjectE datapack to: " + datapackFile.getAbsolutePath());
                this.logger.info("Please run '/datapack enable \"file/" + datapackFileName + "\"' and '/reload' or restart the server to apply the datapack.");
                this.plugin.getConfig().set("ConfrimDatapack", (Object)true);
                this.plugin.saveConfig();
                this.logger.info("Set 'ConfrimDatapack' to true in config.yml.");
            }
        }
        catch (Exception e) {
            this.logger.severe("Could not install ProjectE datapack: " + e.getMessage());
            e.printStackTrace();
        }
    }
}

