/*
 * Decompiled with CFR 0.152.
 */
package org.Little_100.projecte;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.Little_100.projecte.CommandManager;
import org.Little_100.projecte.ProjectE;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class GUIEditorListener
implements Listener {
    private final ProjectE plugin;
    private final CommandManager commandManager;

    public GUIEditorListener(ProjectE plugin, CommandManager commandManager) {
        this.plugin = plugin;
        this.commandManager = commandManager;
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        Player player = (Player)event.getPlayer();
        Map<Player, String> editors = this.commandManager.getOpenGuiEditors();
        if (editors.containsKey(player)) {
            String fileName = editors.get(player);
            Inventory inventory = event.getInventory();
            boolean isEmpty = true;
            for (ItemStack item : inventory.getContents()) {
                if (item == null) continue;
                isEmpty = false;
                break;
            }
            if (isEmpty) {
                editors.remove(player);
                return;
            }
            File guiFile = new File(this.plugin.getDataFolder(), fileName);
            YamlConfiguration guiConfig = new YamlConfiguration();
            guiConfig.set("title", (Object)((HumanEntity)inventory.getViewers().get(0)).getOpenInventory().getTitle());
            guiConfig.set("size", (Object)inventory.getSize());
            for (int i = 0; i < inventory.getSize(); ++i) {
                ItemStack item;
                item = inventory.getItem(i);
                if (item == null) continue;
                String path = "items." + i;
                guiConfig.set(path + ".material", (Object)item.getType().toString());
                if (!item.hasItemMeta()) continue;
                ItemMeta meta = item.getItemMeta();
                if (meta.hasDisplayName()) {
                    guiConfig.set(path + ".name", (Object)meta.getDisplayName().replace(String.valueOf('\u00a7'), "&"));
                }
                if (meta.hasLore()) {
                    ArrayList<String> lore = new ArrayList<String>();
                    for (String line : meta.getLore()) {
                        lore.add(line.replace(String.valueOf('\u00a7'), "&"));
                    }
                    guiConfig.set(path + ".lore", lore);
                }
                if (!meta.hasCustomModelData()) continue;
                guiConfig.set(path + ".custom_model_data", (Object)meta.getCustomModelData());
            }
            try {
                guiConfig.save(guiFile);
                player.sendMessage(this.plugin.getLanguageManager().get("serverside.command.gui.saved"));
            }
            catch (IOException e) {
                e.printStackTrace();
                player.sendMessage(this.plugin.getLanguageManager().get("serverside.command.gui.save_failed"));
            }
            editors.remove(player);
        }
    }
}

