/*
 * Decompiled with CFR 0.152.
 */
package org.Little_100.projecte;

import java.io.File;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.Little_100.projecte.AlchemicalBag.AlchemicalBagManager;
import org.Little_100.projecte.Armor.ArmorListener;
import org.Little_100.projecte.Armor.ArmorManager;
import org.Little_100.projecte.Armor.GemHelmetGUIListener;
import org.Little_100.projecte.BlockDataManager;
import org.Little_100.projecte.BlockListener;
import org.Little_100.projecte.CommandManager;
import org.Little_100.projecte.CovalenceDust;
import org.Little_100.projecte.CovalenceDustCraftListener;
import org.Little_100.projecte.CovalenceDustListener;
import org.Little_100.projecte.CraftingListener;
import org.Little_100.projecte.CustomCommand;
import org.Little_100.projecte.DatapackManager;
import org.Little_100.projecte.DebugManager;
import org.Little_100.projecte.EmcManager;
import org.Little_100.projecte.FuelManager;
import org.Little_100.projecte.GUIEditorListener;
import org.Little_100.projecte.GeyserPlayerJoinListener;
import org.Little_100.projecte.ItemStackLimitListener;
import org.Little_100.projecte.LanguageManager;
import org.Little_100.projecte.PhilosopherStoneGUIListener;
import org.Little_100.projecte.PhilosopherStoneListener;
import org.Little_100.projecte.PlayerJoinListener;
import org.Little_100.projecte.RecipeManager;
import org.Little_100.projecte.ResourcePackManager;
import org.Little_100.projecte.Tome.TransmutationTabletBook;
import org.Little_100.projecte.Tome.TransmutationTabletBookListener;
import org.Little_100.projecte.Tools.DiviningRodGUI;
import org.Little_100.projecte.Tools.DiviningRodListener;
import org.Little_100.projecte.Tools.Divining_Rod;
import org.Little_100.projecte.Tools.KleinStar.KleinStarListener;
import org.Little_100.projecte.Tools.KleinStar.KleinStarManager;
import org.Little_100.projecte.Tools.RepairTalismanListener;
import org.Little_100.projecte.Tools.Repair_Talisman;
import org.Little_100.projecte.Tools.ToolAbilityListener;
import org.Little_100.projecte.Tools.ToolChargeGUIListener;
import org.Little_100.projecte.Tools.ToolListener;
import org.Little_100.projecte.Tools.ToolManager;
import org.Little_100.projecte.TransmutationTable.GUIListener;
import org.Little_100.projecte.accessories.AccessoryListener;
import org.Little_100.projecte.accessories.AccessoryRecipeManager;
import org.Little_100.projecte.accessories.BodyStone;
import org.Little_100.projecte.accessories.LifeStone;
import org.Little_100.projecte.accessories.MindStone;
import org.Little_100.projecte.accessories.SoulStone;
import org.Little_100.projecte.compatibility.GeyserAdapter;
import org.Little_100.projecte.compatibility.SchedulerAdapter;
import org.Little_100.projecte.compatibility.SchedulerMatcher;
import org.Little_100.projecte.compatibility.VersionAdapter;
import org.Little_100.projecte.compatibility.VersionMatcher;
import org.Little_100.projecte.devices.CondenserListener;
import org.Little_100.projecte.devices.CondenserManager;
import org.Little_100.projecte.devices.DeviceListener;
import org.Little_100.projecte.devices.DeviceManager;
import org.Little_100.projecte.devices.FurnaceListener;
import org.Little_100.projecte.devices.FurnaceManager;
import org.Little_100.projecte.storage.DatabaseManager;
import org.Little_100.projecte.util.CustomBlockArtUtil;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandMap;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class ProjectE
extends JavaPlugin {
    private static ProjectE instance;
    private ItemStack philosopherStone;
    private NamespacedKey philosopherStoneKey;
    private RecipeManager recipeManager;
    private DatabaseManager databaseManager;
    private AccessoryRecipeManager accessoryRecipeManager;
    private EmcManager emcManager;
    private VersionAdapter versionAdapter;
    private AlchemicalBagManager alchemicalBagManager;
    private LanguageManager languageManager;
    private ResourcePackManager resourcePackManager;
    private DatapackManager datapackManager;
    private SchedulerAdapter schedulerAdapter;
    private BlockDataManager blockDataManager;
    private PhilosopherStoneListener philosopherStoneListener;
    private FuelManager fuelManager;
    private CovalenceDust covalenceDust;
    private Divining_Rod diviningRod;
    private Repair_Talisman repairTalisman;
    private DiviningRodGUI diviningRodGUI;
    private KleinStarManager kleinStarManager;
    private ToolManager toolManager;
    private ArmorManager armorManager;
    private ArmorListener armorListener;
    private final Map<Material, Material> upgradeMap = new HashMap<Material, Material>();
    private final Map<Material, Material> downgradeMap = new HashMap<Material, Material>();
    private boolean excludePDC;
    private boolean onlyMcItems;
    private GeyserAdapter geyserAdapter;
    private FileConfiguration devicesConfig;
    private FileConfiguration opItemConfig;
    private FurnaceManager furnaceManager;
    private DeviceManager deviceManager;
    private CondenserManager condenserManager;

    public FileConfiguration getDevicesConfig() {
        if (this.devicesConfig == null) {
            File devicesFile = new File(this.getDataFolder(), "devices.yml");
            if (!devicesFile.exists()) {
                this.saveResource("devices.yml", false);
            }
            this.devicesConfig = YamlConfiguration.loadConfiguration((File)devicesFile);
        }
        return this.devicesConfig;
    }

    public FileConfiguration getOpItemConfig() {
        if (this.opItemConfig == null) {
            File opItemFile = new File(this.getDataFolder(), "op_item.yml");
            if (!opItemFile.exists()) {
                this.saveResource("op_item.yml", false);
            }
            this.opItemConfig = YamlConfiguration.loadConfiguration((File)opItemFile);
        }
        return this.opItemConfig;
    }

    public void onEnable() {
        instance = this;
        this.saveDefaultConfig();
        this.loadConfigOptions();
        this.getOpItemConfig();
        this.languageManager = new LanguageManager(this);
        DebugManager.init(this);
        try {
            ZipEntry entry;
            File langFolder = new File(this.getDataFolder(), "lang");
            if (!langFolder.exists()) {
                langFolder.mkdirs();
            }
            ZipInputStream zip = new ZipInputStream(((Object)((Object)this)).getClass().getProtectionDomain().getCodeSource().getLocation().openStream());
            while ((entry = zip.getNextEntry()) != null) {
                File outFile;
                String name = entry.getName();
                if (!name.startsWith("lang/") || !name.endsWith(".yml") || entry.isDirectory() || (outFile = new File(this.getDataFolder(), name)).exists()) continue;
                this.saveResource(name, false);
                HashMap<String, String> placeholders = new HashMap<String, String>();
                placeholders.put("file", name);
                this.getLogger().info(this.languageManager.get("plugin.autofix_language_file", placeholders));
            }
            zip.close();
        }
        catch (Exception e) {
            this.getLogger().warning("Error auto-releasing yml language files: " + e.getMessage());
        }
        this.databaseManager = new DatabaseManager(this.getDataFolder());
        this.versionAdapter = VersionMatcher.getAdapter();
        if (this.versionAdapter == null) {
            this.getLogger().severe("Failed to find a compatible version adapter. Disabling plugin.");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.schedulerAdapter = SchedulerMatcher.getSchedulerAdapter(this);
        this.blockDataManager = new BlockDataManager(this);
        this.emcManager = new EmcManager(this);
        try {
            this.getLogger().info("Calculating EMC values...");
            this.emcManager.calculateAndStoreEmcValues(false);
            this.getLogger().info("EMC calculation complete.");
        }
        catch (Exception e) {
            this.getLogger().severe("An error occurred during EMC calculation. Some items may not have EMC values. Please check your config.yml for formatting errors.");
            e.printStackTrace();
        }
        if (this.deviceManager != null) {
            this.deviceManager.reloadDeviceItems();
        }
        this.loadCustomEmcValues();
        this.createPhilosopherStone();
        this.fuelManager = new FuelManager(this);
        this.getServer().getPluginManager().registerEvents((Listener)this.fuelManager, (Plugin)this);
        this.getLogger().info("FuelManager initialized with special fuels.");
        new CustomBlockArtUtil(this, this.schedulerAdapter);
        this.fuelManager.setFuelEmcValues();
        this.covalenceDust = new CovalenceDust(this);
        this.covalenceDust.setCovalenceDustEmcValues();
        this.diviningRod = new Divining_Rod(this);
        this.diviningRod.setDiviningRodEmcValues();
        this.diviningRodGUI = new DiviningRodGUI(this);
        this.repairTalisman = new Repair_Talisman(this);
        this.repairTalisman.setEmcValue();
        new RepairTalismanListener(this);
        this.kleinStarManager = new KleinStarManager(this);
        this.toolManager = new ToolManager(this);
        this.armorManager = new ArmorManager(this);
        if (this.getConfig().getBoolean("AlchemicalBag.enabled", true)) {
            this.alchemicalBagManager = new AlchemicalBagManager(this);
            this.alchemicalBagManager.register();
            this.getLogger().info("Alchemical Bag feature is enabled.");
        } else {
            this.getLogger().info("Alchemical Bag feature is disabled in the config.");
        }
        this.furnaceManager = new FurnaceManager(this);
        this.deviceManager = new DeviceManager(this);
        this.deviceManager.registerDevices();
        this.condenserManager = new CondenserManager(this);
        this.getServer().getPluginManager().registerEvents((Listener)new ToolListener(this), (Plugin)this);
        this.accessoryRecipeManager = new AccessoryRecipeManager(this);
        this.accessoryRecipeManager.registerRecipes();
        this.removeVanillaRecipe();
        this.initMaterialMaps();
        this.philosopherStoneListener = new PhilosopherStoneListener(this);
        Bukkit.getPluginManager().registerEvents((Listener)this.philosopherStoneListener, (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new PhilosopherStoneGUIListener(this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new ItemStackLimitListener(this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new GUIListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new ToolChargeGUIListener(this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new ToolAbilityListener(this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new BlockListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new CovalenceDustListener(this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new CovalenceDustCraftListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new DiviningRodListener(this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new KleinStarListener(this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new PlayerJoinListener(this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new CraftingListener(this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new TransmutationTabletBookListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new AccessoryListener(), (Plugin)this);
        this.armorListener = new ArmorListener(this);
        Bukkit.getPluginManager().registerEvents((Listener)this.armorListener, (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new GemHelmetGUIListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new FurnaceListener(this, this.furnaceManager), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new CondenserListener(this), (Plugin)this);
        this.covalenceDust = new CovalenceDust(this);
        CommandManager commandManager = new CommandManager(this);
        this.getCommand("projecte").setExecutor((CommandExecutor)commandManager);
        this.getCommand("projecte").setTabCompleter((TabCompleter)commandManager);
        this.getServer().getPluginManager().registerEvents((Listener)new GUIEditorListener(this, commandManager), (Plugin)this);
        this.registerCustomCommands(commandManager);
        this.recipeManager = new RecipeManager(this);
        this.recipeManager.registerAllRecipes();
        this.resourcePackManager = new ResourcePackManager(this);
        this.getLogger().info("Resource Pack Manager initialized.");
        this.datapackManager = new DatapackManager(this);
        this.datapackManager.setupDatapack();
        this.getLogger().info("ProjectE plugin has been enabled!");
        this.startContinuousParticleTask();
        this.geyserAdapter = new GeyserAdapter(this);
        if (this.geyserAdapter.isGeyserApiAvailable()) {
            this.getServer().getPluginManager().registerEvents((Listener)new GeyserPlayerJoinListener(this), (Plugin)this);
        }
        this.getServer().getPluginManager().registerEvents((Listener)new DeviceListener(this), (Plugin)this);
    }

    public void onDisable() {
        if (this.recipeManager != null) {
            this.recipeManager.unregisterAllRecipes();
        }
        if (this.accessoryRecipeManager != null) {
            this.accessoryRecipeManager.unregisterAllRecipes();
        }
        if (this.alchemicalBagManager != null) {
            this.alchemicalBagManager.unregister();
        }
        if (this.databaseManager != null) {
            this.databaseManager.close();
        }
        this.getLogger().info("ProjectE plugin has been disabled!");
    }

    public static ProjectE getInstance() {
        return instance;
    }

    public ItemStack getPhilosopherStone() {
        return new ItemStack(Material.POPPED_CHORUS_FRUIT);
    }

    public boolean isPhilosopherStone(ItemStack item) {
        if (item == null) {
            return false;
        }
        return item.getType() == Material.POPPED_CHORUS_FRUIT;
    }

    public NamespacedKey getPhilosopherStoneKey() {
        return this.philosopherStoneKey;
    }

    private void createPhilosopherStone() {
        this.philosopherStone = new ItemStack(Material.POPPED_CHORUS_FRUIT);
    }

    private void removeVanillaRecipe() {
        try {
            Bukkit.removeRecipe((NamespacedKey)NamespacedKey.minecraft((String)"popped_chorus_fruit"));
        }
        catch (Exception e) {
            this.getLogger().warning("Could not remove vanilla popped chorus fruit recipe: " + e.getMessage());
        }
    }

    private void initMaterialMaps() {
        this.upgradeMap.put(Material.COAL, Material.COPPER_INGOT);
        this.upgradeMap.put(Material.COPPER_INGOT, Material.IRON_INGOT);
        this.upgradeMap.put(Material.IRON_INGOT, Material.GOLD_INGOT);
        this.upgradeMap.put(Material.GOLD_INGOT, Material.DIAMOND);
        this.upgradeMap.put(Material.DIAMOND, Material.NETHERITE_INGOT);
        this.upgradeMap.put(Material.COAL_BLOCK, Material.COPPER_BLOCK);
        this.upgradeMap.put(Material.COPPER_BLOCK, Material.IRON_BLOCK);
        this.upgradeMap.put(Material.IRON_BLOCK, Material.GOLD_BLOCK);
        this.upgradeMap.put(Material.GOLD_BLOCK, Material.DIAMOND_BLOCK);
        this.upgradeMap.put(Material.DIAMOND_BLOCK, Material.NETHERITE_BLOCK);
        this.upgradeMap.put(Material.COAL_ORE, Material.COPPER_ORE);
        this.upgradeMap.put(Material.COPPER_ORE, Material.IRON_ORE);
        this.upgradeMap.put(Material.IRON_ORE, Material.GOLD_ORE);
        this.upgradeMap.put(Material.GOLD_ORE, Material.DIAMOND_ORE);
        this.upgradeMap.put(Material.DIAMOND_ORE, Material.ANCIENT_DEBRIS);
        this.upgradeMap.put(Material.DEEPSLATE_COAL_ORE, Material.DEEPSLATE_COPPER_ORE);
        this.upgradeMap.put(Material.DEEPSLATE_COPPER_ORE, Material.DEEPSLATE_IRON_ORE);
        this.upgradeMap.put(Material.DEEPSLATE_IRON_ORE, Material.DEEPSLATE_GOLD_ORE);
        this.upgradeMap.put(Material.DEEPSLATE_GOLD_ORE, Material.DEEPSLATE_DIAMOND_ORE);
        this.upgradeMap.put(Material.DEEPSLATE_DIAMOND_ORE, Material.ANCIENT_DEBRIS);
        this.downgradeMap.put(Material.COPPER_INGOT, Material.COAL);
        this.downgradeMap.put(Material.IRON_INGOT, Material.COPPER_INGOT);
        this.downgradeMap.put(Material.GOLD_INGOT, Material.IRON_INGOT);
        this.downgradeMap.put(Material.DIAMOND, Material.GOLD_INGOT);
        this.downgradeMap.put(Material.NETHERITE_INGOT, Material.DIAMOND);
        this.downgradeMap.put(Material.COPPER_BLOCK, Material.COAL_BLOCK);
        this.downgradeMap.put(Material.IRON_BLOCK, Material.COPPER_BLOCK);
        this.downgradeMap.put(Material.GOLD_BLOCK, Material.IRON_BLOCK);
        this.downgradeMap.put(Material.DIAMOND_BLOCK, Material.GOLD_BLOCK);
        this.downgradeMap.put(Material.NETHERITE_BLOCK, Material.DIAMOND_BLOCK);
        this.downgradeMap.put(Material.COPPER_ORE, Material.COAL_ORE);
        this.downgradeMap.put(Material.IRON_ORE, Material.COPPER_ORE);
        this.downgradeMap.put(Material.GOLD_ORE, Material.IRON_ORE);
        this.downgradeMap.put(Material.DIAMOND_ORE, Material.GOLD_ORE);
        this.downgradeMap.put(Material.ANCIENT_DEBRIS, Material.DIAMOND_ORE);
        this.downgradeMap.put(Material.DEEPSLATE_COPPER_ORE, Material.DEEPSLATE_COAL_ORE);
        this.downgradeMap.put(Material.DEEPSLATE_IRON_ORE, Material.DEEPSLATE_COPPER_ORE);
        this.downgradeMap.put(Material.DEEPSLATE_GOLD_ORE, Material.DEEPSLATE_IRON_ORE);
        this.downgradeMap.put(Material.DEEPSLATE_DIAMOND_ORE, Material.DEEPSLATE_GOLD_ORE);
    }

    public RecipeManager getRecipeManager() {
        return this.recipeManager;
    }

    public DatabaseManager getDatabaseManager() {
        return this.databaseManager;
    }

    public EmcManager getEmcManager() {
        return this.emcManager;
    }

    public void reloadPlugin() {
        this.reloadConfig();
        this.loadConfigOptions();
        this.languageManager.loadLanguageFiles();
        if (this.recipeManager != null) {
            this.recipeManager.unregisterAllRecipes();
            this.recipeManager.registerAllRecipes();
        }
        if (this.accessoryRecipeManager != null) {
            this.accessoryRecipeManager.unregisterAllRecipes();
            this.accessoryRecipeManager.registerRecipes();
        }
        this.getLogger().info("All recipes have been reloaded.");
        this.emcManager = new EmcManager(this);
        this.emcManager.calculateAndStoreEmcValues(true);
        if (this.deviceManager != null) {
            this.deviceManager.reloadDeviceItems();
        }
        this.loadCustomEmcValues();
        if (this.fuelManager != null) {
            this.fuelManager.setFuelEmcValues();
        }
        if (this.covalenceDust != null) {
            this.covalenceDust.setCovalenceDustEmcValues();
        }
        if (this.diviningRod != null) {
            this.diviningRod.setDiviningRodEmcValues();
        }
        if (this.repairTalisman != null) {
            this.repairTalisman.setEmcValue();
        }
        this.getLogger().info("ProjectE plugin has been reloaded!");
    }

    public VersionAdapter getVersionAdapter() {
        return this.versionAdapter;
    }

    public SchedulerAdapter getSchedulerAdapter() {
        return this.schedulerAdapter;
    }

    public LanguageManager getLanguageManager() {
        return this.languageManager;
    }

    public ResourcePackManager getResourcePackManager() {
        return this.resourcePackManager;
    }

    public GeyserAdapter getGeyserAdapter() {
        return this.geyserAdapter;
    }

    public Material getUpgradedMaterial(Material material) {
        return this.upgradeMap.getOrDefault(material, null);
    }

    public Material getDowngradedMaterial(Material material) {
        return this.downgradeMap.getOrDefault(material, null);
    }

    public FuelManager getFuelManager() {
        return this.fuelManager;
    }

    public CovalenceDust getCovalenceDust() {
        return this.covalenceDust;
    }

    public Divining_Rod getDiviningRod() {
        return this.diviningRod;
    }

    public Repair_Talisman getRepairTalisman() {
        return this.repairTalisman;
    }

    public KleinStarManager getKleinStarManager() {
        return this.kleinStarManager;
    }

    public DiviningRodGUI getDiviningRodGUI() {
        return this.diviningRodGUI;
    }

    public ToolManager getToolManager() {
        return this.toolManager;
    }

    public ArmorManager getArmorManager() {
        return this.armorManager;
    }

    public ArmorListener getArmorListener() {
        return this.armorListener;
    }

    public boolean isPdcExcluded() {
        return this.excludePDC;
    }

    public BlockDataManager getBlockDataManager() {
        return this.blockDataManager;
    }

    public boolean isOnlyMcItems() {
        return this.onlyMcItems;
    }

    public FurnaceManager getFurnaceManager() {
        return this.furnaceManager;
    }

    public DeviceManager getDeviceManager() {
        return this.deviceManager;
    }

    public CondenserManager getCondenserManager() {
        return this.condenserManager;
    }

    private void loadConfigOptions() {
        this.excludePDC = this.getConfig().getBoolean("TransmutationTable.EMC.Exclude_PDC.enabled", true);
        this.onlyMcItems = this.getConfig().getBoolean("TransmutationTable.EMC.Exclude_PDC.only_mc_items", true);
    }

    private void startContinuousParticleTask() {
        if (!this.getConfig().getBoolean("philosopher_stone.particle.enabled", true)) {
            return;
        }
        long keepAlive = this.getConfig().getLong("philosopher_stone.particle.keep-alive", 5L);
        long period = keepAlive == -1L ? 10L : keepAlive * 20L;
        this.schedulerAdapter.runTimer(() -> {
            for (Player player : Bukkit.getOnlinePlayers()) {
                ItemStack mainHand = player.getInventory().getItemInMainHand();
                ItemStack offHand = player.getInventory().getItemInOffHand();
                if (!this.isPhilosopherStone(mainHand) && !this.isPhilosopherStone(offHand)) continue;
                Block targetBlock = null;
                try {
                    if (player.getWorld() != null && player.getWorld().isChunkLoaded(player.getLocation().getBlockX() >> 4, player.getLocation().getBlockZ() >> 4)) {
                        targetBlock = player.getTargetBlock(null, 10);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (targetBlock == null || targetBlock.getType().isAir()) continue;
                this.philosopherStoneListener.showContinuousOutline(player, targetBlock);
            }
        }, 1L, period);
    }

    public ItemStack getItemStackFromKey(String key) {
        if (key.startsWith("projecte:")) {
            key = key.substring("projecte:".length());
        } else if (key.startsWith("minecraft:")) {
            key = key.substring("minecraft:".length());
        }
        switch (key) {
            case "philosopher_stone": {
                return this.getPhilosopherStone();
            }
            case "alchemical_coal": {
                return this.fuelManager.getAlchemicalCoal();
            }
            case "mobius_fuel": {
                return this.fuelManager.getMobiusFuel();
            }
            case "aeternalis_fuel": {
                return this.fuelManager.getAeternalisFuel();
            }
            case "alchemical_coal_block": {
                return this.fuelManager.getAlchemicalCoalBlock();
            }
            case "mobius_fuel_block": {
                return this.fuelManager.getMobiusFuelBlock();
            }
            case "aeternalis_fuel_block": {
                return this.fuelManager.getAeternalisFuelBlock();
            }
            case "dark_matter": {
                return this.fuelManager.getDarkMatter();
            }
            case "red_matter": {
                return this.fuelManager.getRedMatter();
            }
            case "dark_matter_block": {
                return this.fuelManager.getDarkMatterBlock();
            }
            case "red_matter_block": {
                return this.fuelManager.getRedMatterBlock();
            }
            case "low_covalence_dust": {
                return this.covalenceDust.getLowCovalenceDust();
            }
            case "medium_covalence_dust": {
                return this.covalenceDust.getMediumCovalenceDust();
            }
            case "high_covalence_dust": {
                return this.covalenceDust.getHighCovalenceDust();
            }
            case "low_divining_rod": {
                return this.diviningRod.getLowDiviningRod();
            }
            case "medium_divining_rod": {
                return this.diviningRod.getMediumDiviningRod();
            }
            case "high_divining_rod": {
                return this.diviningRod.getHighDiviningRod();
            }
            case "repair_talisman": {
                return this.repairTalisman.getRepairTalisman();
            }
            case "dark_matter_pickaxe": {
                return this.toolManager.getDarkMatterPickaxe();
            }
            case "dark_matter_axe": {
                return this.toolManager.getDarkMatterAxe();
            }
            case "dark_matter_shovel": {
                return this.toolManager.getDarkMatterShovel();
            }
            case "dark_matter_hoe": {
                return this.toolManager.getDarkMatterHoe();
            }
            case "dark_matter_sword": {
                return this.toolManager.getDarkMatterSword();
            }
            case "dark_matter_shears": {
                return this.toolManager.getDarkMatterShears();
            }
            case "dark_matter_hammer": {
                return this.toolManager.getDarkMatterHammer();
            }
            case "red_matter_pickaxe": {
                return this.toolManager.getRedMatterPickaxe();
            }
            case "red_matter_axe": {
                return this.toolManager.getRedMatterAxe();
            }
            case "red_matter_shovel": {
                return this.toolManager.getRedMatterShovel();
            }
            case "red_matter_hoe": {
                return this.toolManager.getRedMatterHoe();
            }
            case "red_matter_sword": {
                return this.toolManager.getRedMatterSword();
            }
            case "red_matter_shears": {
                return this.toolManager.getRedMatterShears();
            }
            case "red_matter_hammer": {
                return this.toolManager.getRedMatterHammer();
            }
            case "red_matter_katar": {
                return this.toolManager.getRedMatterKatar();
            }
            case "red_matter_morningstar": {
                return this.toolManager.getRedMatterMorningstar();
            }
            case "dark_matter_helmet": {
                return this.armorManager.getDarkMatterHelmet();
            }
            case "dark_matter_chestplate": {
                return this.armorManager.getDarkMatterChestplate();
            }
            case "dark_matter_leggings": {
                return this.armorManager.getDarkMatterLeggings();
            }
            case "dark_matter_boots": {
                return this.armorManager.getDarkMatterBoots();
            }
            case "red_matter_helmet": {
                return this.armorManager.getRedMatterHelmet();
            }
            case "red_matter_chestplate": {
                return this.armorManager.getRedMatterChestplate();
            }
            case "red_matter_leggings": {
                return this.armorManager.getRedMatterLeggings();
            }
            case "red_matter_boots": {
                return this.armorManager.getRedMatterBoots();
            }
            case "gem_helmet": {
                return this.armorManager.getGemHelmet();
            }
            case "gem_chestplate": {
                return this.armorManager.getGemChestplate();
            }
            case "gem_leggings": {
                return this.armorManager.getGemLeggings();
            }
            case "gem_boots": {
                return this.armorManager.getGemBoots();
            }
            case "klein_star_ein": {
                return this.kleinStarManager.getKleinStar(1);
            }
            case "klein_star_zwei": {
                return this.kleinStarManager.getKleinStar(2);
            }
            case "klein_star_drei": {
                return this.kleinStarManager.getKleinStar(3);
            }
            case "klein_star_vier": {
                return this.kleinStarManager.getKleinStar(4);
            }
            case "klein_star_sphere": {
                return this.kleinStarManager.getKleinStar(5);
            }
            case "klein_star_omega": {
                return this.kleinStarManager.getKleinStar(6);
            }
            case "body_stone": {
                return BodyStone.createBodyStone();
            }
            case "soul_stone": {
                return SoulStone.createSoulStone();
            }
            case "life_stone": {
                return LifeStone.createLifeStone();
            }
            case "mind_stone": {
                return MindStone.createMindStone();
            }
            case "dark_matter_furnace": {
                return this.deviceManager.getDarkMatterFurnaceItem();
            }
            case "red_matter_furnace": {
                return this.deviceManager.getRedMatterFurnaceItem();
            }
            case "alchemical_chest": {
                return this.deviceManager.getAlchemicalChestItem();
            }
            case "energy_condenser": {
                return this.deviceManager.getEnergyCondenserItem();
            }
            case "energy_condenser_mk2": {
                return this.deviceManager.getEnergyCondenserMK2Item();
            }
            case "transmutation_table": {
                return this.getPhilosopherStone();
            }
            case "alchemical_bag": {
                return AlchemicalBagManager.getAlchemicalBag();
            }
            case "transmutation_tablet_book": {
                return TransmutationTabletBook.createTransmutationTabletBook();
            }
        }
        Material material = this.versionAdapter.getMaterial(key.toUpperCase());
        if (material != null) {
            return new ItemStack(material);
        }
        return null;
    }

    private void registerCustomCommands(CommandManager commandManager) {
        YamlConfiguration commandsConfig;
        File commandsFile = new File(this.getDataFolder(), "command.yml");
        if (!commandsFile.exists()) {
            this.saveResource("command.yml", false);
        }
        if ((commandsConfig = YamlConfiguration.loadConfiguration((File)commandsFile)).isConfigurationSection("OpenTransmutationTable")) {
            try {
                Field bukkitCommandMap = Bukkit.getServer().getClass().getDeclaredField("commandMap");
                bukkitCommandMap.setAccessible(true);
                CommandMap commandMap = (CommandMap)bukkitCommandMap.get(Bukkit.getServer());
                for (String key : commandsConfig.getConfigurationSection("OpenTransmutationTable").getKeys(false)) {
                    String commandName = commandsConfig.getString("OpenTransmutationTable." + key + ".command");
                    if (commandName.contains(" ")) {
                        this.getLogger().info("Skipping registration of sub-command: " + commandName);
                        continue;
                    }
                    String description = commandsConfig.getString("OpenTransmutationTable." + key + ".description");
                    CustomCommand command = new CustomCommand(commandName, commandManager);
                    command.setDescription(description);
                    commandMap.register(this.getDescription().getName(), (Command)command);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void loadCustomEmcValues() {
        File customEmcFile = new File(this.getDataFolder(), "custommoditememc.yml");
        if (!customEmcFile.exists()) {
            this.saveResource("custommoditememc.yml", false);
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)customEmcFile);
        DatabaseManager db = this.getDatabaseManager();
        for (String key : config.getKeys(false)) {
            long emcValue = config.getLong(key);
            if (emcValue <= 0L) continue;
            String fullKey = "projecte:" + key;
            db.setEmc(fullKey, emcValue);
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("item", fullKey);
            placeholders.put("emc", String.valueOf(emcValue));
            DebugManager.log("debug.emc.custom_emc_loaded", placeholders);
        }
        this.getLogger().info("Loaded custom EMC values from custommoditememc.yml");
    }

    private void setKleinStarEmcValues() {
    }
}

