/*
 * Decompiled with CFR 0.152.
 */
package org.Little_100.projecte.Tome;

import org.Little_100.projecte.ProjectE;
import org.Little_100.projecte.TransmutationTable.TransmutationGUI;
import org.Little_100.projecte.util.CustomModelDataUtil;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class TransmutationTabletBookListener
implements Listener {
    private final NamespacedKey projecteIdKey = new NamespacedKey((Plugin)ProjectE.getInstance(), "projecte_id");

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        ItemStack item = event.getItem();
        if ((event.getAction() == Action.RIGHT_CLICK_AIR || event.getAction() == Action.RIGHT_CLICK_BLOCK) && item != null) {
            boolean extremeMode = ProjectE.getInstance().getConfig().getBoolean("debug.extreme_tablet_mode", true);
            if (extremeMode && item.getType() == Material.ENCHANTED_BOOK) {
                ProjectE.getInstance().getLogger().info("\u6781\u7aef\u5bbd\u677e\u6a21\u5f0f\u6fc0\u6d3b\uff1a\u4efb\u4f55\u9644\u9b54\u4e66\u90fd\u53ef\u4ee5\u4f5c\u4e3a\u8f6c\u6362\u5353");
                try {
                    new TransmutationGUI(player).open();
                    event.setCancelled(true);
                    return;
                }
                catch (Exception e) {
                    ProjectE.getInstance().getLogger().warning("\u6781\u7aef\u6a21\u5f0f\u4e0b\u6253\u5f00GUI\u5931\u8d25: " + e.getMessage());
                }
            }
            if (item.getType() == Material.ENCHANTED_BOOK) {
                ProjectE.getInstance().getLogger().info("\u73a9\u5bb6\u53f3\u952e\u4e86\u9644\u9b54\u4e66: " + player.getName());
                ItemMeta meta = item.getItemMeta();
                if (meta != null) {
                    ProjectE.getInstance().getLogger().info("\u7269\u54c1\u540d\u79f0: " + (meta.hasDisplayName() ? meta.getDisplayName() : "\u65e0\u540d\u79f0"));
                    try {
                        if (meta.hasCustomModelData()) {
                            ProjectE.getInstance().getLogger().info("CustomModelData\u503c: " + meta.getCustomModelData());
                        } else {
                            ProjectE.getInstance().getLogger().info("\u7269\u54c1\u6ca1\u6709CustomModelData");
                        }
                    }
                    catch (Exception e) {
                        ProjectE.getInstance().getLogger().warning("\u68c0\u67e5CustomModelData\u65f6\u51fa\u9519: " + e.getMessage());
                    }
                    try {
                        if (meta.getPersistentDataContainer().has(this.projecteIdKey, PersistentDataType.STRING)) {
                            String id = (String)meta.getPersistentDataContainer().get(this.projecteIdKey, PersistentDataType.STRING);
                            ProjectE.getInstance().getLogger().info("PersistentDataContainer ID: " + id);
                            if ("transmutation_tablet_book".equals(id)) {
                                ProjectE.getInstance().getLogger().info("\u901a\u8fc7PDC ID\u76f4\u63a5\u5339\u914d\u6210\u529f");
                                new TransmutationGUI(player).open();
                                event.setCancelled(true);
                                return;
                            }
                        } else {
                            ProjectE.getInstance().getLogger().info("\u7269\u54c1\u6ca1\u6709ProjectE ID\u6807\u8bb0");
                        }
                    }
                    catch (Exception e) {
                        ProjectE.getInstance().getLogger().warning("\u68c0\u67e5PDC\u65f6\u51fa\u9519: " + e.getMessage());
                    }
                }
                try {
                    boolean shouldOpenGui = false;
                    String reason = "\u672a\u77e5";
                    if (meta != null && meta.hasCustomModelData() && meta.getCustomModelData() == 1) {
                        shouldOpenGui = true;
                        reason = "CMD=1";
                    } else if (meta != null && meta.hasDisplayName()) {
                        String displayName = meta.getDisplayName();
                        if (displayName.contains("\u8f6c\u6362") || displayName.contains("\u4fbf\u643a") || displayName.toLowerCase().contains("transmutation")) {
                            shouldOpenGui = true;
                            reason = "\u540d\u79f0\u5173\u952e\u8bcd";
                        }
                    } else if (meta != null && meta.hasLore() && !meta.getLore().isEmpty()) {
                        for (String loreLine : meta.getLore()) {
                            if (!loreLine.contains("\u8f6c\u6362") && !loreLine.contains("transmutation")) continue;
                            shouldOpenGui = true;
                            reason = "Lore\u5173\u952e\u8bcd";
                            break;
                        }
                    } else if (this.isTransmutationTabletBook(item)) {
                        shouldOpenGui = true;
                        reason = "\u6807\u51c6\u65b9\u6cd5";
                    }
                    if (shouldOpenGui) {
                        ProjectE.getInstance().getLogger().info("\u6210\u529f\u8bc6\u522b\u8f6c\u6362\u5353 (\u539f\u56e0: " + reason + ")\uff0c\u6253\u5f00GUI");
                        new TransmutationGUI(player).open();
                        event.setCancelled(true);
                        return;
                    }
                    if (ProjectE.getInstance().getConfig().getBoolean("debug.try_all_books", true)) {
                        ProjectE.getInstance().getLogger().info("\u5c1d\u8bd5\u5c06\u4efb\u4f55\u9644\u9b54\u4e66\u4f5c\u4e3a\u8f6c\u6362\u5353");
                        new TransmutationGUI(player).open();
                        event.setCancelled(true);
                    }
                }
                catch (Exception e) {
                    ProjectE.getInstance().getLogger().warning("\u68c0\u67e5\u8f6c\u6362\u5353\u65f6\u53d1\u751f\u9519\u8bef: " + e.getMessage());
                    e.printStackTrace();
                }
            }
        }
    }

    @EventHandler
    public void onPrepareAnvil(PrepareAnvilEvent event) {
        ItemStack first = event.getInventory().getItem(0);
        ItemStack second = event.getInventory().getItem(1);
        if (this.isTransmutationTabletBookSafe(first) || this.isTransmutationTabletBookSafe(second)) {
            event.setResult(null);
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (event.getInventory().getType() == InventoryType.GRINDSTONE) {
            ItemStack first = event.getInventory().getItem(0);
            ItemStack second = event.getInventory().getItem(1);
            if (this.isTransmutationTabletBookSafe(first) || this.isTransmutationTabletBookSafe(second)) {
                event.setCancelled(true);
            }
        }
    }

    private boolean isTransmutationTabletBookSafe(ItemStack item) {
        try {
            return this.isTransmutationTabletBook(item);
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean isTransmutationTabletBook(ItemStack item) {
        ProjectE.getInstance().getLogger().info("\u68c0\u67e5\u7269\u54c1\u662f\u5426\u4e3a\u8f6c\u6362\u5353...");
        if (item == null) {
            ProjectE.getInstance().getLogger().info("\u7269\u54c1\u4e3anull");
            return false;
        }
        if (item.getType() != Material.ENCHANTED_BOOK) {
            ProjectE.getInstance().getLogger().info("\u7269\u54c1\u4e0d\u662f\u9644\u9b54\u4e66");
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            ProjectE.getInstance().getLogger().info("\u7269\u54c1\u6ca1\u6709\u5143\u6570\u636e");
            return false;
        }
        boolean ultraLooseMode = ProjectE.getInstance().getConfig().getBoolean("debug.ultra_loose_tablet_detection", true);
        if (ultraLooseMode) {
            ProjectE.getInstance().getLogger().info("\u8d85\u5bbd\u677e\u68c0\u6d4b\u6a21\u5f0f\u5df2\u542f\u7528");
            if (meta.hasDisplayName() || meta.hasLore() && !meta.getLore().isEmpty()) {
                ProjectE.getInstance().getLogger().info("\u8d85\u5bbd\u677e\u5339\u914d\u6210\u529f: \u9644\u9b54\u4e66\u6709\u540d\u79f0\u6216\u63cf\u8ff0");
                return true;
            }
        }
        if (meta.getPersistentDataContainer().has(this.projecteIdKey, PersistentDataType.STRING)) {
            String id = (String)meta.getPersistentDataContainer().get(this.projecteIdKey, PersistentDataType.STRING);
            ProjectE.getInstance().getLogger().info("\u7269\u54c1\u6709ProjectE ID: " + id);
            if ("transmutation_tablet_book".equals(id)) {
                return true;
            }
        } else {
            ProjectE.getInstance().getLogger().info("\u7269\u54c1\u6ca1\u6709ProjectE ID");
        }
        try {
            if (meta.hasCustomModelData()) {
                int cmdValue = meta.getCustomModelData();
                ProjectE.getInstance().getLogger().info("\u7269\u54c1\u6709CustomModelData: " + cmdValue);
                if (cmdValue == 1) {
                    return true;
                }
            } else {
                ProjectE.getInstance().getLogger().info("\u7269\u54c1\u6ca1\u6709CustomModelData");
            }
        }
        catch (Exception e) {
            ProjectE.getInstance().getLogger().info("\u68c0\u67e5CustomModelData\u65f6\u53d1\u751f\u5f02\u5e38: " + e.getMessage());
        }
        try {
            int cmdValue = CustomModelDataUtil.getCustomModelDataInt(item);
            ProjectE.getInstance().getLogger().info("CustomModelDataUtil\u68c0\u6d4b\u5230\u7684\u503c: " + cmdValue);
            if (cmdValue == 1) {
                return true;
            }
        }
        catch (Exception e) {
            ProjectE.getInstance().getLogger().info("\u4f7f\u7528CustomModelDataUtil\u65f6\u53d1\u751f\u5f02\u5e38: " + e.getMessage());
        }
        if (meta.hasDisplayName()) {
            String displayName = meta.getDisplayName();
            String expectedName = ProjectE.getInstance().getLanguageManager().get("item.transmutation_tablet_book.name");
            ProjectE.getInstance().getLogger().info("\u7269\u54c1\u540d\u79f0: " + displayName + ", \u671f\u671b\u540d\u79f0: " + expectedName);
            if (displayName.contains(expectedName) || expectedName.contains(displayName) || displayName.toLowerCase().contains("transmutation") || displayName.contains("\u8f6c\u6362") || displayName.contains("\u4fbf\u643a") || displayName.contains("\u5353")) {
                ProjectE.getInstance().getLogger().info("\u540d\u79f0\u5bbd\u677e\u5339\u914d\u6210\u529f");
                return true;
            }
        } else {
            ProjectE.getInstance().getLogger().info("\u7269\u54c1\u6ca1\u6709\u540d\u79f0");
        }
        if (meta.hasLore() && !meta.getLore().isEmpty()) {
            for (String loreLine : meta.getLore()) {
                if (!loreLine.contains("\u8f6c\u6362") && !loreLine.contains("transmutation") && !loreLine.contains("\u4fbf\u643a") && !loreLine.contains("tablet")) continue;
                ProjectE.getInstance().getLogger().info("\u901a\u8fc7Lore\u5173\u952e\u8bcd\u5339\u914d\u6210\u529f");
                return true;
            }
        }
        ProjectE.getInstance().getLogger().info("\u7269\u54c1\u4e0d\u662f\u8f6c\u6362\u5353");
        return false;
    }
}

