/*
 * Decompiled with CFR 0.152.
 */
package org.Little_100.projecte.Tools;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.Little_100.projecte.ProjectE;
import org.Little_100.projecte.Tools.Divining_Rod;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.ItemStack;

public class DiviningRodListener
implements Listener {
    private final ProjectE plugin;
    private final Divining_Rod diviningRod;
    private final Map<UUID, Integer> playerModes = new HashMap<UUID, Integer>();
    private final Map<UUID, Long> cooldowns = new HashMap<UUID, Long>();
    private final Map<Material, Material> oreMappings = new HashMap<Material, Material>();

    public DiviningRodListener(ProjectE plugin) {
        this.plugin = plugin;
        this.diviningRod = plugin.getDiviningRod();
        this.initializeOreMappings();
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        ItemStack item = player.getInventory().getItemInMainHand();
        Action action = event.getAction();
        if (action == Action.RIGHT_CLICK_BLOCK && !player.isSneaking() && (this.diviningRod.isLowDiviningRod(item) || this.diviningRod.isMediumDiviningRod(item) || this.diviningRod.isHighDiviningRod(item))) {
            event.setCancelled(true);
            if (this.checkCooldown(player)) {
                this.scanBlocks(player, item, event.getClickedBlock().getLocation());
                this.setCooldown(player);
            }
        }
    }

    @EventHandler
    public void onPlayerSwapHandItems(PlayerSwapHandItemsEvent event) {
        Player player = event.getPlayer();
        ItemStack item = player.getInventory().getItemInMainHand();
        if (player.isSneaking() && item != null && (this.diviningRod.isLowDiviningRod(item) || this.diviningRod.isMediumDiviningRod(item) || this.diviningRod.isHighDiviningRod(item))) {
            event.setCancelled(true);
            if (this.diviningRod.isMediumDiviningRod(item) || this.diviningRod.isHighDiviningRod(item)) {
                this.plugin.getDiviningRodGUI().openGUI(player);
            }
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!event.getView().getTitle().equals(this.plugin.getLanguageManager().get("clientside.divining_rod.gui.title"))) {
            return;
        }
        event.setCancelled(true);
        Player player = (Player)event.getWhoClicked();
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null || clickedItem.getType() == Material.AIR) {
            return;
        }
        int mode = -1;
        if (clickedItem.getType() == Material.STONE) {
            mode = 0;
        } else if (clickedItem.getType() == Material.IRON_INGOT) {
            mode = 1;
        } else if (clickedItem.getType() == Material.DIAMOND) {
            mode = 2;
        }
        if (mode != -1) {
            this.playerModes.put(player.getUniqueId(), mode);
            String modeName = this.getModeName(mode);
            player.sendMessage(this.plugin.getLanguageManager().get("clientside.divining_rod.mode_changed", Map.of("mode", modeName)));
            player.closeInventory();
        }
    }

    private void initializeOreMappings() {
        this.oreMappings.put(Material.COAL_ORE, Material.COAL);
        this.oreMappings.put(Material.DEEPSLATE_COAL_ORE, Material.COAL);
        this.oreMappings.put(Material.COPPER_ORE, Material.COPPER_INGOT);
        this.oreMappings.put(Material.DEEPSLATE_COPPER_ORE, Material.COPPER_INGOT);
        this.oreMappings.put(Material.IRON_ORE, Material.IRON_INGOT);
        this.oreMappings.put(Material.DEEPSLATE_IRON_ORE, Material.IRON_INGOT);
        this.oreMappings.put(Material.GOLD_ORE, Material.GOLD_INGOT);
        this.oreMappings.put(Material.DEEPSLATE_GOLD_ORE, Material.GOLD_INGOT);
        this.oreMappings.put(Material.DIAMOND_ORE, Material.DIAMOND);
        this.oreMappings.put(Material.DEEPSLATE_DIAMOND_ORE, Material.DIAMOND);
        this.oreMappings.put(Material.EMERALD_ORE, Material.EMERALD);
        this.oreMappings.put(Material.DEEPSLATE_EMERALD_ORE, Material.EMERALD);
        this.oreMappings.put(Material.LAPIS_ORE, Material.LAPIS_LAZULI);
        this.oreMappings.put(Material.DEEPSLATE_LAPIS_ORE, Material.LAPIS_LAZULI);
        this.oreMappings.put(Material.NETHER_GOLD_ORE, Material.GOLD_NUGGET);
        this.oreMappings.put(Material.NETHER_QUARTZ_ORE, Material.QUARTZ);
        this.oreMappings.put(Material.REDSTONE_ORE, Material.REDSTONE);
        this.oreMappings.put(Material.DEEPSLATE_REDSTONE_ORE, Material.REDSTONE);
        this.oreMappings.put(Material.ANCIENT_DEBRIS, Material.NETHERITE_SCRAP);
    }

    private boolean checkCooldown(Player player) {
        return !this.cooldowns.containsKey(player.getUniqueId()) || System.currentTimeMillis() - this.cooldowns.get(player.getUniqueId()) > 500L;
    }

    private void setCooldown(Player player) {
        this.cooldowns.put(player.getUniqueId(), System.currentTimeMillis());
    }

    private String getModeName(int mode) {
        switch (mode) {
            case 0: {
                return "3x3x3";
            }
            case 1: {
                return "16x3x3";
            }
            case 2: {
                return "64x3x3";
            }
        }
        return "Unknown";
    }

    private void scanBlocks(Player player, ItemStack item, Location center) {
        int mode = 0;
        mode = this.diviningRod.isLowDiviningRod(item) ? 0 : this.playerModes.getOrDefault(player.getUniqueId(), 0);
        int[] dimensions = this.getScanDimensions(mode);
        int halfX = dimensions[0] / 2;
        int halfY = dimensions[1] / 2;
        int halfZ = dimensions[2] / 2;
        long totalEmc = 0L;
        int blockCount = 0;
        long maxEmc = 0L;
        Material maxEmcMaterial = null;
        for (int x = -halfX; x <= halfX; ++x) {
            for (int y = -halfY; y <= halfY; ++y) {
                for (int z = -halfZ; z <= halfZ; ++z) {
                    Material mappedMaterial;
                    Block block = center.clone().add((double)x, (double)y, (double)z).getBlock();
                    if (block.getType() == Material.AIR || !(mappedMaterial = this.oreMappings.getOrDefault(block.getType(), block.getType())).isItem()) continue;
                    ItemStack blockStack = new ItemStack(mappedMaterial);
                    String itemKey = this.plugin.getEmcManager().getItemKey(blockStack);
                    long emc = this.plugin.getEmcManager().getEmc(itemKey);
                    if (emc <= 0L) continue;
                    totalEmc += emc;
                    ++blockCount;
                    if (emc <= maxEmc) continue;
                    maxEmc = emc;
                    maxEmcMaterial = mappedMaterial;
                }
            }
        }
        if (blockCount > 0) {
            long averageEmc = totalEmc / (long)blockCount;
            player.sendMessage(this.plugin.getLanguageManager().get("clientside.divining_rod.scan_results"));
            player.sendMessage(this.plugin.getLanguageManager().get("clientside.divining_rod.total_blocks", Map.of("count", String.valueOf(blockCount))));
            player.sendMessage(this.plugin.getLanguageManager().get("clientside.divining_rod.average_emc", Map.of("emc", String.valueOf(averageEmc))));
            if (this.diviningRod.isHighDiviningRod(item) && maxEmcMaterial != null) {
                player.sendMessage(this.plugin.getLanguageManager().get("clientside.divining_rod.max_emc", Map.of("emc", String.valueOf(maxEmc))));
            }
        } else {
            player.sendMessage(this.plugin.getLanguageManager().get("clientside.divining_rod.no_emc_blocks"));
        }
    }

    private int[] getScanDimensions(int mode) {
        switch (mode) {
            case 0: {
                return new int[]{3, 3, 3};
            }
            case 1: {
                return new int[]{16, 3, 3};
            }
            case 2: {
                return new int[]{64, 3, 3};
            }
        }
        return new int[]{3, 3, 3};
    }
}

