/*
 * Decompiled with CFR 0.152.
 */
package org.Little_100.projecte.Tools;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.Little_100.projecte.ProjectE;
import org.Little_100.projecte.util.CustomModelDataUtil;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Tag;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class ToolManager {
    private final ProjectE plugin;
    private ItemStack darkMatterPickaxe;
    private ItemStack darkMatterAxe;
    private ItemStack darkMatterShovel;
    private ItemStack darkMatterHoe;
    private ItemStack darkMatterSword;
    private ItemStack darkMatterShears;
    private ItemStack darkMatterHammer;
    private ItemStack redMatterPickaxe;
    private ItemStack redMatterAxe;
    private ItemStack redMatterShovel;
    private ItemStack redMatterHoe;
    private ItemStack redMatterSword;
    private ItemStack redMatterShears;
    private ItemStack redMatterHammer;
    private ItemStack redMatterKatar;
    private ItemStack redMatterMorningstar;

    public ToolManager(ProjectE plugin) {
        this.plugin = plugin;
        this.createDarkMatterTools();
        this.createRedMatterTools();
        this.registerToolEmcValues();
    }

    private void registerToolEmcValues() {
        this.plugin.getEmcManager().setEmcValue(this.darkMatterPickaxe, 434176L);
        this.plugin.getEmcManager().setEmcValue(this.darkMatterAxe, 434176L);
        this.plugin.getEmcManager().setEmcValue(this.darkMatterShovel, 155648L);
        this.plugin.getEmcManager().setEmcValue(this.darkMatterHoe, 294912L);
        this.plugin.getEmcManager().setEmcValue(this.darkMatterSword, 286720L);
        this.plugin.getEmcManager().setEmcValue(this.darkMatterShears, 147456L);
        this.plugin.getEmcManager().setEmcValue(this.darkMatterHammer, 303104L);
        this.plugin.getEmcManager().setEmcValue(this.redMatterPickaxe, 1974272L);
        this.plugin.getEmcManager().setEmcValue(this.redMatterAxe, 1974272L);
        this.plugin.getEmcManager().setEmcValue(this.redMatterShovel, 761856L);
        this.plugin.getEmcManager().setEmcValue(this.redMatterHoe, 1368064L);
        this.plugin.getEmcManager().setEmcValue(this.redMatterSword, 892928L);
        this.plugin.getEmcManager().setEmcValue(this.redMatterShears, 614400L);
        this.plugin.getEmcManager().setEmcValue(this.redMatterHammer, 1515520L);
        this.plugin.getEmcManager().setEmcValue(this.redMatterKatar, 7512064L);
        this.plugin.getEmcManager().setEmcValue(this.redMatterMorningstar, 7055312L);
    }

    private void createDarkMatterTools() {
        this.darkMatterPickaxe = this.createToolItem(Material.DIAMOND_PICKAXE, "dark_matter_pickaxe", 1, "item.dark_matter_pickaxe.name", 8.0, 1.2);
        this.darkMatterAxe = this.createToolItem(Material.DIAMOND_AXE, "dark_matter_axe", 1, "item.dark_matter_axe.name", 9.0, 1.0);
        this.darkMatterShovel = this.createToolItem(Material.DIAMOND_SHOVEL, "dark_matter_shovel", 1, "item.dark_matter_shovel.name", 6.0, 1.0);
        this.darkMatterHoe = this.createToolItem(Material.DIAMOND_HOE, "dark_matter_hoe", 7, "item.dark_matter_hoe.name", 1.0, 1.0);
        this.darkMatterSword = this.createToolItem(Material.DIAMOND_SWORD, "dark_matter_sword", 1, "item.dark_matter_sword.name", 13.0, 1.6);
        this.darkMatterShears = this.createToolItem(Material.SHEARS, "dark_matter_shears", 1, "item.dark_matter_shears.name", 1.0, 1.0);
        this.darkMatterHammer = this.createToolItem(Material.DIAMOND_PICKAXE, "dark_matter_hammer", 3, "item.dark_matter_hammer.name", 14.0, 1.2);
    }

    private void createRedMatterTools() {
        this.redMatterPickaxe = this.createToolItem(Material.DIAMOND_PICKAXE, "red_matter_pickaxe", 2, "item.red_matter_pickaxe.name", 9.0, 1.2);
        this.redMatterAxe = this.createToolItem(Material.DIAMOND_AXE, "red_matter_axe", 2, "item.red_matter_axe.name", 10.0, 1.0);
        this.redMatterShovel = this.createToolItem(Material.DIAMOND_SHOVEL, "red_matter_shovel", 2, "item.red_matter_shovel.name", 7.0, 1.0);
        this.redMatterHoe = this.createToolItem(Material.DIAMOND_HOE, "red_matter_hoe", 8, "item.red_matter_hoe.name", 1.0, 4.0);
        this.redMatterSword = this.createToolItem(Material.DIAMOND_SWORD, "red_matter_sword", 2, "item.red_matter_sword.name", 14.0, 1.6);
        this.redMatterShears = this.createToolItem(Material.SHEARS, "red_matter_shears", 2, "item.red_matter_shears.name", 1.0, 1.0);
        this.redMatterHammer = this.createToolItem(Material.DIAMOND_PICKAXE, "red_matter_hammer", 4, "item.red_matter_hammer.name", 15.0, 1.2);
        this.redMatterKatar = this.createToolItem(Material.DIAMOND_AXE, "red_matter_katar", 10, "item.red_matter_katar.name", 24.0, 1.6);
        this.redMatterMorningstar = this.createToolItem(Material.DIAMOND_PICKAXE, "red_matter_morningstar", 11, "item.red_matter_morningstar.name", 24.0, 1.2);
    }

    private ItemStack createToolItem(Material baseMaterial, String id, int customModelData, String displayNameKey, double attackDamage, double attackSpeed) {
        ItemStack item = new ItemStack(baseMaterial);
        CustomModelDataUtil.registerMapping(id, customModelData);
        item = CustomModelDataUtil.setCustomModelData(item, id);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(this.plugin.getLanguageManager().get(displayNameKey));
            PersistentDataContainer container = meta.getPersistentDataContainer();
            container.set(new NamespacedKey((Plugin)this.plugin, "projecte_id"), PersistentDataType.STRING, (Object)id);
            container.set(new NamespacedKey((Plugin)this.plugin, "projecte_charge"), PersistentDataType.INTEGER, (Object)0);
            container.set(new NamespacedKey((Plugin)this.plugin, "projecte_mode"), PersistentDataType.STRING, (Object)"tall");
            if (id.equals("red_matter_sword")) {
                container.set(new NamespacedKey((Plugin)this.plugin, "projecte_sword_mode"), PersistentDataType.INTEGER, (Object)0);
            } else if (id.equals("red_matter_katar")) {
                container.set(new NamespacedKey((Plugin)this.plugin, "projecte_katar_mode"), PersistentDataType.INTEGER, (Object)0);
            } else if (id.equals("red_matter_morningstar")) {
                container.set(new NamespacedKey((Plugin)this.plugin, "projecte_morningstar_mode"), PersistentDataType.STRING, (Object)"normal");
            }
            if (attackDamage > 0.0) {
                AttributeModifier damageModifier = new AttributeModifier(UUID.randomUUID(), "generic.attack_damage", attackDamage - 1.0, AttributeModifier.Operation.ADD_NUMBER, EquipmentSlot.HAND);
                meta.addAttributeModifier(Attribute.valueOf((String)"GENERIC_ATTACK_DAMAGE"), damageModifier);
            }
            if (attackSpeed > 0.0) {
                AttributeModifier speedModifier = new AttributeModifier(UUID.randomUUID(), "generic.attack_speed", attackSpeed - 4.0, AttributeModifier.Operation.ADD_NUMBER, EquipmentSlot.HAND);
                meta.addAttributeModifier(Attribute.valueOf((String)"GENERIC_ATTACK_SPEED"), speedModifier);
            }
            item.setItemMeta(meta);
            this.updateLore(item);
        }
        return item;
    }

    public void updateLore(ItemStack item) {
        Object mode;
        List<String> loreKeys;
        if (item == null || !item.hasItemMeta()) {
            return;
        }
        ItemMeta meta = item.getItemMeta();
        PersistentDataContainer container = meta.getPersistentDataContainer();
        String id = (String)container.get(new NamespacedKey((Plugin)this.plugin, "projecte_id"), PersistentDataType.STRING);
        if (id == null) {
            return;
        }
        if (id.startsWith("dark_matter_")) {
            loreKeys = List.of("item.dark_matter_tool.lore1");
        } else if (id.startsWith("red_matter_")) {
            loreKeys = List.of("item.red_matter_tool.lore1");
        } else {
            return;
        }
        ArrayList<Object> newLore = new ArrayList<Object>();
        for (String key : loreKeys) {
            newLore.add(this.plugin.getLanguageManager().get(key));
        }
        Integer charge = (Integer)container.get(new NamespacedKey((Plugin)this.plugin, "projecte_charge"), PersistentDataType.INTEGER);
        if (charge != null) {
            newLore.add(this.plugin.getLanguageManager().get("clientside.dark_matter_tool.charge").replace("{level}", charge.toString()));
        }
        if (this.isRedMatterSword(item)) {
            mode = (Integer)container.get(new NamespacedKey((Plugin)this.plugin, "projecte_sword_mode"), PersistentDataType.INTEGER);
            if (mode != null) {
                String modeKey = (Integer)mode == 0 ? "clientside.red_matter_sword.mode_hostile" : "clientside.red_matter_sword.mode_all";
                newLore.add(this.plugin.getLanguageManager().get("clientside.red_matter_sword.mode_prefix") + " " + this.plugin.getLanguageManager().get(modeKey));
            }
        } else if (this.isRedMatterKatar(item)) {
            mode = (Integer)container.get(new NamespacedKey((Plugin)this.plugin, "projecte_katar_mode"), PersistentDataType.INTEGER);
            if (mode != null) {
                String modeKey = (Integer)mode == 0 ? "clientside.red_matter_katar.mode_all" : "clientside.red_matter_katar.mode_hostile";
                newLore.add(this.plugin.getLanguageManager().get("clientside.red_matter_katar.mode_prefix") + " " + this.plugin.getLanguageManager().get(modeKey));
            }
        } else if (this.isRedMatterMorningstar(item) && (mode = (String)container.get(new NamespacedKey((Plugin)this.plugin, "projecte_morningstar_mode"), PersistentDataType.STRING)) != null) {
            String modeKey = "clientside.red_matter_morningstar.mode_" + (String)mode;
            newLore.add(this.plugin.getLanguageManager().get("clientside.red_matter_morningstar.mode_prefix") + " " + this.plugin.getLanguageManager().get(modeKey));
        }
        meta.setLore(newLore);
        item.setItemMeta(meta);
    }

    public ItemStack getDarkMatterPickaxe() {
        ItemStack item = this.darkMatterPickaxe.clone();
        this.updateLore(item);
        return item;
    }

    public ItemStack getDarkMatterAxe() {
        ItemStack item = this.darkMatterAxe.clone();
        this.updateLore(item);
        return item;
    }

    public ItemStack getDarkMatterShovel() {
        ItemStack item = this.darkMatterShovel.clone();
        this.updateLore(item);
        return item;
    }

    public ItemStack getDarkMatterHoe() {
        ItemStack item = this.darkMatterHoe.clone();
        this.updateLore(item);
        return item;
    }

    public ItemStack getDarkMatterSword() {
        ItemStack item = this.darkMatterSword.clone();
        this.updateLore(item);
        return item;
    }

    public ItemStack getDarkMatterShears() {
        return this.darkMatterShears.clone();
    }

    public ItemStack getDarkMatterHammer() {
        return this.darkMatterHammer.clone();
    }

    public ItemStack getRedMatterPickaxe() {
        ItemStack item = this.redMatterPickaxe.clone();
        this.updateLore(item);
        return item;
    }

    public ItemStack getRedMatterAxe() {
        ItemStack item = this.redMatterAxe.clone();
        this.updateLore(item);
        return item;
    }

    public ItemStack getRedMatterShovel() {
        ItemStack item = this.redMatterShovel.clone();
        this.updateLore(item);
        return item;
    }

    public ItemStack getRedMatterHoe() {
        ItemStack item = this.redMatterHoe.clone();
        this.updateLore(item);
        return item;
    }

    public ItemStack getRedMatterSword() {
        ItemStack item = this.redMatterSword.clone();
        this.updateLore(item);
        return item;
    }

    public ItemStack getRedMatterShears() {
        return this.redMatterShears.clone();
    }

    public ItemStack getRedMatterHammer() {
        return this.redMatterHammer.clone();
    }

    public ItemStack getRedMatterKatar() {
        ItemStack item = this.redMatterKatar.clone();
        this.updateLore(item);
        return item;
    }

    public ItemStack getRedMatterMorningstar() {
        ItemStack item = this.redMatterMorningstar.clone();
        this.updateLore(item);
        return item;
    }

    public boolean isDarkMatterPickaxe(ItemStack item) {
        return this.isTool(item, "dark_matter_pickaxe");
    }

    public boolean isDarkMatterAxe(ItemStack item) {
        return this.isTool(item, "dark_matter_axe");
    }

    public boolean isDarkMatterShovel(ItemStack item) {
        return this.isTool(item, "dark_matter_shovel");
    }

    public boolean isDarkMatterHoe(ItemStack item) {
        return this.isTool(item, "dark_matter_hoe");
    }

    public boolean isDarkMatterSword(ItemStack item) {
        return this.isTool(item, "dark_matter_sword");
    }

    public boolean isDarkMatterShears(ItemStack item) {
        return this.isTool(item, "dark_matter_shears");
    }

    public boolean isDarkMatterHammer(ItemStack item) {
        return this.isTool(item, "dark_matter_hammer");
    }

    public boolean isDarkMatterTool(ItemStack item) {
        String id = this.getToolId(item);
        return id != null && id.startsWith("dark_matter_");
    }

    public boolean isRedMatterPickaxe(ItemStack item) {
        return this.isTool(item, "red_matter_pickaxe");
    }

    public boolean isRedMatterAxe(ItemStack item) {
        return this.isTool(item, "red_matter_axe");
    }

    public boolean isRedMatterShovel(ItemStack item) {
        return this.isTool(item, "red_matter_shovel");
    }

    public boolean isRedMatterHoe(ItemStack item) {
        return this.isTool(item, "red_matter_hoe");
    }

    public boolean isRedMatterSword(ItemStack item) {
        return this.isTool(item, "red_matter_sword");
    }

    public boolean isRedMatterShears(ItemStack item) {
        return this.isTool(item, "red_matter_shears");
    }

    public boolean isRedMatterHammer(ItemStack item) {
        return this.isTool(item, "red_matter_hammer");
    }

    public boolean isRedMatterKatar(ItemStack item) {
        return this.isTool(item, "red_matter_katar");
    }

    public boolean isRedMatterMorningstar(ItemStack item) {
        return this.isTool(item, "red_matter_morningstar");
    }

    public boolean isRedMatterTool(ItemStack item) {
        String id = this.getToolId(item);
        return id != null && id.startsWith("red_matter_");
    }

    public boolean isProjectETool(ItemStack item) {
        String id = this.getToolId(item);
        return id != null && (id.startsWith("dark_matter_") || id.startsWith("red_matter_"));
    }

    private boolean isTool(ItemStack item, String id) {
        if (item == null || !item.hasItemMeta()) {
            return false;
        }
        String foundId = this.getToolId(item);
        return id.equals(foundId);
    }

    public String getToolId(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return null;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return null;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        return (String)container.get(new NamespacedKey((Plugin)this.plugin, "projecte_id"), PersistentDataType.STRING);
    }

    public int getCharge(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return 0;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return 0;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        return (Integer)container.getOrDefault(new NamespacedKey((Plugin)this.plugin, "projecte_charge"), PersistentDataType.INTEGER, (Object)0);
    }

    public int getSwordMode(ItemStack sword) {
        if (sword == null || !sword.hasItemMeta()) {
            return 0;
        }
        ItemMeta meta = sword.getItemMeta();
        if (meta == null) {
            return 0;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        return (Integer)container.getOrDefault(new NamespacedKey((Plugin)this.plugin, "projecte_sword_mode"), PersistentDataType.INTEGER, (Object)0);
    }

    public boolean isValidMaterialForTool(Material blockMaterial, ItemStack tool) {
        String id = this.getToolId(tool);
        if (id == null) {
            return false;
        }
        if (id.endsWith("_sword") || id.endsWith("_hoe") || id.endsWith("_shears")) {
            return false;
        }
        if (id.endsWith("_pickaxe") || id.endsWith("_hammer")) {
            return Tag.MINEABLE_PICKAXE.isTagged((Keyed)blockMaterial);
        }
        if (id.endsWith("_axe")) {
            return Tag.MINEABLE_AXE.isTagged((Keyed)blockMaterial);
        }
        if (id.endsWith("_shovel")) {
            return Tag.MINEABLE_SHOVEL.isTagged((Keyed)blockMaterial);
        }
        return false;
    }

    public void updateToolEfficiency(ItemStack tool) {
        String id;
        if (tool == null || !tool.hasItemMeta()) {
            return;
        }
        ItemMeta meta = tool.getItemMeta();
        if (meta == null) {
            return;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        int charge = (Integer)container.getOrDefault(new NamespacedKey((Plugin)this.plugin, "projecte_charge"), PersistentDataType.INTEGER, (Object)0);
        int efficiencyLevel = this.isRedMatterTool(tool) ? 7 + charge * 2 : 5 + charge * 2;
        Enchantment efficiencyEnchantment = Enchantment.getByKey((NamespacedKey)NamespacedKey.minecraft((String)"efficiency"));
        if (efficiencyEnchantment == null && (efficiencyEnchantment = Enchantment.getByName((String)"EFFICIENCY")) == null) {
            this.plugin.getLogger().warning("Could not find the Efficiency enchantment.");
            return;
        }
        if (meta.hasEnchant(efficiencyEnchantment)) {
            meta.removeEnchant(efficiencyEnchantment);
        }
        if ((id = this.getToolId(tool)) != null && (id.endsWith("_sword") || id.endsWith("_hoe") || id.endsWith("_shears"))) {
            tool.setItemMeta(meta);
            return;
        }
        if (id != null && id.endsWith("_hammer")) {
            Enchantment silkTouchEnchant = Enchantment.getByKey((NamespacedKey)NamespacedKey.minecraft((String)"silk_touch"));
            if (silkTouchEnchant == null) {
                silkTouchEnchant = Enchantment.getByName((String)"SILK_TOUCH");
            }
            if (silkTouchEnchant != null && meta.hasEnchant(silkTouchEnchant)) {
                meta.removeEnchant(silkTouchEnchant);
            }
        }
        meta.addEnchant(efficiencyEnchantment, efficiencyLevel, true);
        tool.setItemMeta(meta);
    }

    public void updateHammerAttackDamage(ItemStack hammer) {
        if (!this.isRedMatterHammer(hammer)) {
            return;
        }
        ItemMeta meta = hammer.getItemMeta();
        if (meta == null) {
            return;
        }
        meta.removeAttributeModifier(Attribute.valueOf((String)"GENERIC_ATTACK_DAMAGE"));
        int charge = this.getCharge(hammer);
        double baseDamage = 15.0;
        double newDamage = baseDamage + (double)charge;
        AttributeModifier damageModifier = new AttributeModifier(UUID.randomUUID(), "generic.attack_damage", newDamage - 1.0, AttributeModifier.Operation.ADD_NUMBER, EquipmentSlot.HAND);
        meta.addAttributeModifier(Attribute.valueOf((String)"GENERIC_ATTACK_DAMAGE"), damageModifier);
        hammer.setItemMeta(meta);
    }

    public void updateSwordAttackDamage(ItemStack sword) {
        if (!this.isDarkMatterSword(sword) && !this.isRedMatterSword(sword)) {
            return;
        }
        ItemMeta meta = sword.getItemMeta();
        if (meta == null) {
            return;
        }
        meta.removeAttributeModifier(Attribute.valueOf((String)"GENERIC_ATTACK_DAMAGE"));
        int charge = this.getCharge(sword);
        double baseDamage = this.isDarkMatterSword(sword) ? 13.0 : 14.0;
        double newDamage = baseDamage + (double)charge;
        AttributeModifier damageModifier = new AttributeModifier(UUID.randomUUID(), "generic.attack_damage", newDamage - 1.0, AttributeModifier.Operation.ADD_NUMBER, EquipmentSlot.HAND);
        meta.addAttributeModifier(Attribute.valueOf((String)"GENERIC_ATTACK_DAMAGE"), damageModifier);
        sword.setItemMeta(meta);
    }

    public void updateKatarAttackDamage(ItemStack katar) {
        if (!this.isRedMatterKatar(katar)) {
            return;
        }
        ItemMeta meta = katar.getItemMeta();
        if (meta == null) {
            return;
        }
        meta.removeAttributeModifier(Attribute.valueOf((String)"GENERIC_ATTACK_DAMAGE"));
        int charge = this.getCharge(katar);
        double baseDamage = 24.0;
        double newDamage = baseDamage + (double)charge;
        AttributeModifier damageModifier = new AttributeModifier(UUID.randomUUID(), "generic.attack_damage", newDamage - 1.0, AttributeModifier.Operation.ADD_NUMBER, EquipmentSlot.HAND);
        meta.addAttributeModifier(Attribute.valueOf((String)"GENERIC_ATTACK_DAMAGE"), damageModifier);
        katar.setItemMeta(meta);
    }

    public boolean isTool(String id) {
        if (id == null) {
            return false;
        }
        switch (id) {
            case "dark_matter_pickaxe": 
            case "dark_matter_axe": 
            case "dark_matter_shovel": 
            case "dark_matter_hoe": 
            case "dark_matter_sword": 
            case "dark_matter_shears": 
            case "dark_matter_hammer": 
            case "red_matter_pickaxe": 
            case "red_matter_axe": 
            case "red_matter_shovel": 
            case "red_matter_hoe": 
            case "red_matter_sword": 
            case "red_matter_shears": 
            case "red_matter_hammer": 
            case "red_matter_katar": 
            case "red_matter_morningstar": {
                return true;
            }
        }
        return false;
    }

    public ItemStack getTool(String id) {
        if (id == null) {
            return null;
        }
        switch (id) {
            case "dark_matter_pickaxe": {
                return this.getDarkMatterPickaxe();
            }
            case "dark_matter_axe": {
                return this.getDarkMatterAxe();
            }
            case "dark_matter_shovel": {
                return this.getDarkMatterShovel();
            }
            case "dark_matter_hoe": {
                return this.getDarkMatterHoe();
            }
            case "dark_matter_sword": {
                return this.getDarkMatterSword();
            }
            case "dark_matter_shears": {
                return this.getDarkMatterShears();
            }
            case "dark_matter_hammer": {
                return this.getDarkMatterHammer();
            }
            case "red_matter_pickaxe": {
                return this.getRedMatterPickaxe();
            }
            case "red_matter_axe": {
                return this.getRedMatterAxe();
            }
            case "red_matter_shovel": {
                return this.getRedMatterShovel();
            }
            case "red_matter_hoe": {
                return this.getRedMatterHoe();
            }
            case "red_matter_sword": {
                return this.getRedMatterSword();
            }
            case "red_matter_shears": {
                return this.getRedMatterShears();
            }
            case "red_matter_hammer": {
                return this.getRedMatterHammer();
            }
            case "red_matter_katar": {
                return this.getRedMatterKatar();
            }
            case "red_matter_morningstar": {
                return this.getRedMatterMorningstar();
            }
        }
        return null;
    }

    public List<String> getToolIds() {
        return new ArrayList<String>(List.of("dark_matter_pickaxe", "dark_matter_axe", "dark_matter_shovel", "dark_matter_hoe", "dark_matter_sword", "dark_matter_shears", "dark_matter_hammer", "red_matter_pickaxe", "red_matter_axe", "red_matter_shovel", "red_matter_hoe", "red_matter_sword", "red_matter_shears", "red_matter_hammer", "red_matter_katar", "red_matter_morningstar"));
    }
}

