/*
 * Decompiled with CFR 0.152.
 */
package org.Little_100.projecte.TransmutationTable;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.Little_100.projecte.EmcManager;
import org.Little_100.projecte.LanguageManager;
import org.Little_100.projecte.ProjectE;
import org.Little_100.projecte.compatibility.VersionAdapter;
import org.Little_100.projecte.storage.DatabaseManager;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class TransmutationGUI
implements InventoryHolder {
    private final Inventory inventory;
    private final Player player;
    private final DatabaseManager databaseManager;
    private final VersionAdapter versionAdapter;
    private final EmcManager emcManager;
    private final LanguageManager languageManager;
    private long playerEmc;
    private GuiState currentState = GuiState.MAIN;
    private int page = 0;

    public TransmutationGUI(Player player) {
        this.player = player;
        this.databaseManager = ProjectE.getInstance().getDatabaseManager();
        this.versionAdapter = ProjectE.getInstance().getVersionAdapter();
        this.emcManager = ProjectE.getInstance().getEmcManager();
        this.languageManager = ProjectE.getInstance().getLanguageManager();
        this.playerEmc = this.databaseManager.getPlayerEmc(player.getUniqueId());
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)54, (String)this.getTitle());
        this.initializeItems();
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public void open() {
        this.player.openInventory(this.inventory);
    }

    private String getTitle() {
        String formattedEmc = String.format("%,d", this.playerEmc);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("emc", formattedEmc);
        switch (this.currentState.ordinal()) {
            case 1: {
                return this.languageManager.get("clientside.transmutation_table.sell_title", placeholders);
            }
            case 2: {
                return this.languageManager.get("clientside.transmutation_table.buy_title", placeholders);
            }
            case 4: {
                return this.languageManager.get("clientside.transmutation_table.charge_title", placeholders);
            }
        }
        return this.languageManager.get("clientside.transmutation_table.title", placeholders);
    }

    private void initializeItems() {
        this.inventory.clear();
        switch (this.currentState.ordinal()) {
            case 0: {
                this.setupMainScreen();
                break;
            }
            case 1: {
                this.setupSellScreen();
                break;
            }
            case 2: {
                this.setupBuyScreen();
                break;
            }
            case 3: {
                this.setupLearnScreen();
                break;
            }
            case 4: {
                this.setupChargeScreen();
            }
        }
    }

    private void setupMainScreen() {
        ItemStack sellButton = this.createGuiItem(Material.ANVIL, this.languageManager.get("clientside.transmutation_table.buttons.sell"), this.languageManager.get("clientside.transmutation_table.buttons.sell_lore"));
        ItemStack buyButton = this.createGuiItem(Material.EMERALD, this.languageManager.get("clientside.transmutation_table.buttons.buy"), this.languageManager.get("clientside.transmutation_table.buttons.buy_lore"));
        ItemStack learnButton = this.createGuiItem(Material.BOOK, this.languageManager.get("clientside.transmutation_table.buttons.learn"), this.languageManager.get("clientside.transmutation_table.buttons.learn_lore"));
        ItemStack chargeButton = this.createGuiItem(Material.REDSTONE_TORCH, this.languageManager.get("clientside.transmutation_table.buttons.charge"), this.languageManager.get("clientside.transmutation_table.buttons.charge_lore"));
        this.inventory.setItem(20, sellButton);
        this.inventory.setItem(21, chargeButton);
        this.inventory.setItem(22, buyButton);
        this.inventory.setItem(24, learnButton);
    }

    private void setupSellScreen() {
        int i;
        ItemStack grayPane = this.createGuiItem(Material.LIGHT_GRAY_STAINED_GLASS_PANE, "", new String[0]);
        for (i = 0; i < 54; ++i) {
            this.inventory.setItem(i, grayPane);
        }
        for (i = 1; i < 5; ++i) {
            for (int j = 1; j < 8; ++j) {
                this.inventory.setItem(i * 9 + j, null);
            }
        }
        ItemStack confirmButton = this.createGuiItem(Material.EMERALD_BLOCK, this.languageManager.get("clientside.transmutation_table.buttons.confirm_sell"), this.languageManager.get("clientside.transmutation_table.buttons.confirm_sell_lore"));
        ItemStack backButton = this.createGuiItem(Material.BARRIER, this.languageManager.get("clientside.transmutation_table.buttons.back"), this.languageManager.get("clientside.transmutation_table.buttons.back_lore"));
        this.inventory.setItem(49, confirmButton);
        this.inventory.setItem(0, backButton);
    }

    public void setupBuyScreen() {
        this.inventory.clear();
        ItemStack grayPane = this.createGuiItem(Material.LIGHT_GRAY_STAINED_GLASS_PANE, "", new String[0]);
        for (int i = 0; i < 54; ++i) {
            if (i >= 9 && i <= 44 && i % 9 != 0 && i % 9 != 8) continue;
            this.inventory.setItem(i, grayPane);
        }
        List<String> learnedItems = this.databaseManager.getLearnedItems(this.player.getUniqueId());
        int itemsPerPage = 28;
        int startIndex = this.page * itemsPerPage;
        int endIndex = Math.min(startIndex + itemsPerPage, learnedItems.size());
        int slotIndex = 0;
        for (int i = startIndex; i < endIndex; ++i) {
            long emc;
            String itemKey = learnedItems.get(i);
            ItemStack item = ProjectE.getInstance().getItemStackFromKey(itemKey);
            if (item == null || (emc = this.emcManager.getEmc(itemKey)) <= 0L) continue;
            ItemMeta meta = item.getItemMeta();
            long stackEmc = emc * (long)item.getMaxStackSize();
            HashMap<String, String> lorePlaceholders = new HashMap<String, String>();
            lorePlaceholders.put("emc", String.format("%,d", emc));
            lorePlaceholders.put("stack_emc", String.format("%,d", stackEmc));
            lorePlaceholders.put("amount", String.valueOf(item.getMaxStackSize()));
            meta.setLore(Arrays.asList(this.languageManager.get("clientside.transmutation_table.item_lore.emc_single", lorePlaceholders), this.languageManager.get("clientside.transmutation_table.item_lore.emc_stack", lorePlaceholders), this.languageManager.get("clientside.transmutation_table.item_lore.buy_one", lorePlaceholders), this.languageManager.get("clientside.transmutation_table.item_lore.buy_stack", lorePlaceholders)));
            item.setItemMeta(meta);
            int row = slotIndex / 7;
            int col = slotIndex % 7;
            this.inventory.setItem(9 + row * 9 + (col + 1), item);
            ++slotIndex;
        }
        ItemStack backButton = this.createGuiItem(Material.BARRIER, this.languageManager.get("clientside.transmutation_table.buttons.back"), this.languageManager.get("clientside.transmutation_table.buttons.back_lore"));
        this.inventory.setItem(0, backButton);
        if (this.page > 0) {
            ItemStack prevButton = this.createGuiItem(Material.ARROW, this.languageManager.get("clientside.transmutation_table.buttons.prev_page"), new String[0]);
            this.inventory.setItem(48, prevButton);
        }
        if (endIndex < learnedItems.size()) {
            ItemStack nextButton = this.createGuiItem(Material.ARROW, this.languageManager.get("clientside.transmutation_table.buttons.next_page"), new String[0]);
            this.inventory.setItem(50, nextButton);
        }
    }

    private void setupLearnScreen() {
        int i;
        ItemStack grayPane = this.createGuiItem(Material.LIGHT_GRAY_STAINED_GLASS_PANE, "", new String[0]);
        for (i = 0; i < 54; ++i) {
            this.inventory.setItem(i, grayPane);
        }
        for (i = 1; i < 5; ++i) {
            for (int j = 1; j < 8; ++j) {
                this.inventory.setItem(i * 9 + j, null);
            }
        }
        ItemStack confirmButton = this.createGuiItem(Material.EMERALD_BLOCK, this.languageManager.get("clientside.transmutation_table.buttons.confirm_learn"), this.languageManager.get("clientside.transmutation_table.buttons.confirm_learn_lore"));
        ItemStack backButton = this.createGuiItem(Material.BARRIER, this.languageManager.get("clientside.transmutation_table.buttons.back"), this.languageManager.get("clientside.transmutation_table.buttons.back_lore"));
        this.inventory.setItem(49, confirmButton);
        this.inventory.setItem(0, backButton);
    }

    private void setupChargeScreen() {
        int i;
        ItemStack grayPane = this.createGuiItem(Material.LIGHT_GRAY_STAINED_GLASS_PANE, "", new String[0]);
        for (i = 0; i < 54; ++i) {
            this.inventory.setItem(i, grayPane);
        }
        for (i = 1; i < 5; ++i) {
            for (int j = 1; j < 8; ++j) {
                this.inventory.setItem(i * 9 + j, null);
            }
        }
        ItemStack confirmButton = this.createGuiItem(Material.EMERALD_BLOCK, this.languageManager.get("clientside.transmutation_table.buttons.confirm_charge"), this.languageManager.get("clientside.transmutation_table.buttons.confirm_charge_lore"));
        ItemStack backButton = this.createGuiItem(Material.BARRIER, this.languageManager.get("clientside.transmutation_table.buttons.back"), this.languageManager.get("clientside.transmutation_table.buttons.back_lore"));
        this.inventory.setItem(49, confirmButton);
        this.inventory.setItem(0, backButton);
    }

    public GuiState getCurrentState() {
        return this.currentState;
    }

    public void setState(GuiState state) {
        this.currentState = state;
        this.page = 0;
        this.initializeItems();
    }

    public void setPage(int page) {
        this.page = page;
        this.initializeItems();
    }

    public int getPage() {
        return this.page;
    }

    protected ItemStack createGuiItem(Material material, String name, String ... lore) {
        ItemStack item = new ItemStack(material, 1);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(name);
        meta.setLore(Arrays.asList(lore));
        item.setItemMeta(meta);
        return item;
    }

    private boolean isGuiItem(int slot, GuiState state) {
        if (state == GuiState.CHARGE) {
            if (slot == 49 || slot == 0) {
                return true;
            }
            if (slot >= 1 && slot <= 7) {
                return true;
            }
            if (slot >= 46 && slot <= 52) {
                return true;
            }
            if (slot % 9 == 0 || slot % 9 == 8) {
                return true;
            }
        }
        return false;
    }

    public static enum GuiState {
        MAIN,
        SELL,
        BUY,
        LEARN,
        CHARGE;

    }
}

