/*
 * Decompiled with CFR 0.152.
 */
package org.Little_100.projecte.devices;

import org.Little_100.projecte.ProjectE;
import org.Little_100.projecte.devices.FurnaceManager;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class FurnaceListener
implements Listener {
    private final ProjectE plugin;
    private final FurnaceManager furnaceManager;

    public FurnaceListener(ProjectE plugin, FurnaceManager furnaceManager) {
        this.plugin = plugin;
        this.furnaceManager = furnaceManager;
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Block clickedBlock = event.getClickedBlock();
        if (clickedBlock == null || clickedBlock.getType() != Material.BARRIER && clickedBlock.getType() != Material.BEACON) {
            return;
        }
        Location loc = clickedBlock.getLocation();
        if (this.furnaceManager.isFurnace(loc)) {
            Player player = event.getPlayer();
            FurnaceManager.FurnaceState state = this.furnaceManager.getFurnaceState(loc);
            if (state != null) {
                player.openInventory(state.getInventory());
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        Inventory clickedInventory = event.getClickedInventory();
        if (clickedInventory == null || !(event.getWhoClicked() instanceof Player)) {
            return;
        }
        if (!this.isCustomFurnaceGui(event.getView().getTitle())) {
            return;
        }
        FurnaceManager.FurnaceState state = null;
        for (FurnaceManager.FurnaceState furnaceState : this.furnaceManager.getActiveFurnaces().values()) {
            if (!furnaceState.getInventory().equals((Object)clickedInventory)) continue;
            state = furnaceState;
            break;
        }
        if (state == null) {
            return;
        }
        int slot = event.getRawSlot();
        if (slot >= state.getInventory().getSize()) {
            return;
        }
        FurnaceManager.FurnaceType type = state.getType();
        if (this.furnaceManager.isNonInteractive(type, slot) || this.furnaceManager.isArrowSlot(type, slot) || this.furnaceManager.isFuelIndicatorSlot(type, slot)) {
            event.setCancelled(true);
            return;
        }
        if (this.furnaceManager.isOutputSlot(type, slot) && event.getCursor() != null && event.getCursor().getType() != Material.AIR) {
            event.setCancelled(true);
        }
    }

    private boolean isCustomFurnaceGui(String title) {
        String darkMatterTitle = this.plugin.getLanguageManager().get("gui.furnace.dark_matter_title");
        String redMatterTitle = this.plugin.getLanguageManager().get("gui.furnace.red_matter_title");
        return title.equals(darkMatterTitle) || title.equals(redMatterTitle);
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        Block block = event.getBlock();
        Location loc = block.getLocation();
        if (this.furnaceManager.isFurnace(loc)) {
            FurnaceManager.FurnaceState state = this.furnaceManager.getFurnaceState(loc);
            if (state == null) {
                return;
            }
            event.setCancelled(true);
            block.setType(Material.AIR);
            ItemStack drop = state.getType() == FurnaceManager.FurnaceType.DARK_MATTER ? this.plugin.getDeviceManager().getDarkMatterFurnaceItem() : this.plugin.getDeviceManager().getRedMatterFurnaceItem();
            loc.getWorld().dropItemNaturally(loc, drop);
            this.furnaceManager.removeFurnace(loc);
        }
    }
}

