/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Core.commands.cp;

import com.Infinity.Nexus.Core.commands.CopyPaste;
import com.Infinity.Nexus.Core.commands.cp.PasteHistory;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayDeque;
import java.util.HashMap;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.blocks.BlockStateArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class Replace {
    public static int replace(CommandContext<CommandSourceStack> context) {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayer();
        if (player == null) {
            return 0;
        }
        String playerName = player.getName().getString();
        BlockPos pos1 = CopyPaste.playerPos1.get(playerName);
        BlockPos pos2 = CopyPaste.playerPos2.get(playerName);
        if (pos1 == null || pos2 == null) {
            player.sendSystemMessage((Component)Component.literal((String)"\u00a7f[\u00a7bINC\u00a7f]: \u00a7cError: You need to set both pos1 and pos2 first!"));
            return 0;
        }
        try {
            BlockState fromBlock = BlockStateArgument.getBlock(context, (String)"from").getState();
            BlockState toBlock = BlockStateArgument.getBlock(context, (String)"to").getState();
            ServerLevel world = ((CommandSourceStack)context.getSource()).getLevel();
            int minX = Math.min(pos1.getX(), pos2.getX());
            int minY = Math.min(pos1.getY(), pos2.getY());
            int minZ = Math.min(pos1.getZ(), pos2.getZ());
            int maxX = Math.max(pos1.getX(), pos2.getX());
            int maxY = Math.max(pos1.getY(), pos2.getY());
            int maxZ = Math.max(pos1.getZ(), pos2.getZ());
            int blocksReplaced = 0;
            HashMap<BlockPos, BlockState> replacedBlocks = new HashMap<BlockPos, BlockState>();
            HashMap<BlockPos, CompoundTag> replacedBlockEntities = new HashMap<BlockPos, CompoundTag>();
            for (int x = minX; x <= maxX; ++x) {
                for (int y = minY; y <= maxY; ++y) {
                    for (int z = minZ; z <= maxZ; ++z) {
                        BlockPos pos = new BlockPos(x, y, z);
                        BlockState current = world.getBlockState(pos);
                        if (!current.equals(fromBlock)) continue;
                        replacedBlocks.put(pos, current);
                        BlockEntity blockEntity = world.getBlockEntity(pos);
                        if (blockEntity != null) {
                            CompoundTag tag = blockEntity.saveWithFullMetadata((HolderLookup.Provider)world.registryAccess());
                            replacedBlockEntities.put(pos, tag);
                        }
                        world.setBlock(pos, toBlock, 3);
                        ++blocksReplaced;
                    }
                }
            }
            if (!replacedBlocks.isEmpty()) {
                CopyPaste.playerHistory.computeIfAbsent(playerName, k -> new ArrayDeque()).push(new PasteHistory(replacedBlocks, replacedBlockEntities));
            }
            player.sendSystemMessage((Component)Component.literal((String)("\u00a7f[\u00a7bINC\u00a7f]: \u00a7aReplaced \u00a7e" + blocksReplaced + " \u00a7ablocks from \u00a7e" + fromBlock.getBlock().getName().getString() + " \u00a7ato \u00a7e" + toBlock.getBlock().getName().getString())));
            return 1;
        }
        catch (Exception e) {
            player.sendSystemMessage((Component)Component.literal((String)"\u00a7f[\u00a7bINC\u00a7f]: \u00a7cError: Invalid block specified!"));
            return 0;
        }
    }
}

