/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Core.renderer;

import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class EnergyInfoArea {
    private final int xPos;
    private final int yPos;
    private final int width;
    private final int height;
    private final IEnergyStorage energy;

    public EnergyInfoArea(int xMin, int yMin, IEnergyStorage energy) {
        this(xMin, yMin, energy, 6, 62);
    }

    public EnergyInfoArea(int xMin, int yMin, IEnergyStorage energy, int width, int height) {
        this.xPos = xMin;
        this.yPos = yMin;
        this.width = width;
        this.height = height;
        this.energy = energy;
    }

    public List<Component> getTooltips() {
        return List.of(Component.literal((String)(this.energy.getEnergyStored() + " / " + this.energy.getMaxEnergyStored() + " FE")));
    }

    public void render(GuiGraphics guiGraphics) {
        int stored = (int)((float)this.height * ((float)this.energy.getEnergyStored() / (float)this.energy.getMaxEnergyStored()));
        guiGraphics.fillGradient(this.xPos, this.yPos + (this.height - stored), this.xPos + this.width, this.yPos + this.height, -1714028544, -1714028544);
    }

    public void renderHorizontal(GuiGraphics guiGraphics) {
        int filledWidth = (int)((float)this.width * ((float)this.energy.getEnergyStored() / (float)this.energy.getMaxEnergyStored()));
        guiGraphics.fillGradient(this.xPos, this.yPos, this.xPos + filledWidth, this.yPos + this.height, -1714028544, -1714028544);
    }
}

