/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Core.renderer.area;

import com.Infinity.Nexus.Core.renderer.area.AreaRenderable;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.AABB;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;

@EventBusSubscriber(modid="infinity_nexus_core", value={Dist.CLIENT})
public class GenericAreaRenderer {
    private static final int CHUNK_RADIUS = 16;
    private static final List<Class<? extends BlockEntity>> REGISTERED_ENTITIES = new ArrayList<Class<? extends BlockEntity>>();

    public static void registerEntityForAreaRendering(Class<? extends BlockEntity> entityClass) {
        if (!REGISTERED_ENTITIES.contains(entityClass)) {
            REGISTERED_ENTITIES.add(entityClass);
        }
    }

    public static void unregisterEntityForAreaRendering(Class<? extends BlockEntity> entityClass) {
        REGISTERED_ENTITIES.remove(entityClass);
    }

    @SubscribeEvent
    public static void onRenderWorld(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_TRIPWIRE_BLOCKS) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        ClientLevel clientLevel = mc.level;
        if (clientLevel == null || mc.player == null) {
            return;
        }
        BlockPos playerPos = mc.player.blockPosition();
        int playerChunkX = playerPos.getX() >> 4;
        int playerChunkZ = playerPos.getZ() >> 4;
        PoseStack poseStack = event.getPoseStack();
        double camX = mc.gameRenderer.getMainCamera().getPosition().x;
        double camY = mc.gameRenderer.getMainCamera().getPosition().y;
        double camZ = mc.gameRenderer.getMainCamera().getPosition().z;
        VertexConsumer consumer = mc.renderBuffers().bufferSource().getBuffer(RenderType.lines());
        for (int dx = -16; dx <= 16; ++dx) {
            for (int dz = -16; dz <= 16; ++dz) {
                int chunkX = playerChunkX + dx;
                int chunkZ = playerChunkZ + dz;
                LevelChunk chunk = clientLevel.getChunkSource().getChunk(chunkX, chunkZ, false);
                if (chunk == null) continue;
                for (BlockEntity be : chunk.getBlockEntities().values()) {
                    AreaRenderable areaRenderable;
                    if (!(be instanceof AreaRenderable) || !(areaRenderable = (AreaRenderable)be).shouldShowArea()) continue;
                    GenericAreaRenderer.renderArea(poseStack, consumer, areaRenderable, camX, camY, camZ);
                }
            }
        }
        mc.renderBuffers().bufferSource().endBatch(RenderType.lines());
    }

    private static void renderArea(PoseStack poseStack, VertexConsumer consumer, AreaRenderable areaRenderable, double camX, double camY, double camZ) {
        BlockPos min = areaRenderable.getAreaMin();
        BlockPos max = areaRenderable.getAreaMax();
        AABB box = new AABB((double)min.getX(), (double)min.getY(), (double)min.getZ(), (double)(max.getX() + 1), (double)(max.getY() + 1), (double)(max.getZ() + 1));
        float[] color = areaRenderable.getAreaColor();
        poseStack.pushPose();
        poseStack.translate(-camX, -camY, -camZ);
        LevelRenderer.renderLineBox((PoseStack)poseStack, (VertexConsumer)consumer, (AABB)box, (float)color[0], (float)color[1], (float)color[2], (float)color[3]);
        poseStack.popPose();
    }
}

