/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Core.utils;

import com.Infinity.Nexus.Core.itemStackHandler.RestrictedItemStackHandler;
import com.Infinity.Nexus.Core.utils.ItemStackHandlerUtils;
import com.Infinity.Nexus.Core.utils.ModUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class EnergyUtils {
    public static IEnergyStorage getItemEnergyStorage(ItemStack stack) {
        if (stack.isEmpty()) {
            return null;
        }
        try {
            IEnergyStorage storage = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
            if (storage == null) {
                return null;
            }
        }
        catch (Exception ignored) {
            return null;
        }
        return (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
    }

    public static boolean isItemEnergyStorage(ItemStack stack) {
        return stack.getCapability(Capabilities.EnergyStorage.ITEM) != null;
    }

    public static void extractEnergyFromRecipe(IEnergyStorage energyStorage, int recipeEnergy, int machineLevel, int maxProgress, ItemStackHandler itemHandler, int[] upgradeSlots) {
        int speed = ModUtils.getSpeed(itemHandler, upgradeSlots) + 1;
        int strength = ModUtils.getStrength(itemHandler, upgradeSlots) * 10;
        int baseEnergy = (recipeEnergy + machineLevel * 20) / maxProgress;
        int speedAdjustedEnergy = baseEnergy * (speed + machineLevel);
        int efficiencyReduction = Math.multiplyExact(strength, speedAdjustedEnergy / 100);
        int finalEnergy = Math.max(speedAdjustedEnergy - efficiencyReduction, 1);
        energyStorage.extractEnergy(finalEnergy, false);
    }

    @Nullable
    public static IEnergyStorage getBlockCapabilityEnergyHandler(Level level, BlockPos pos, Direction direction) {
        return (IEnergyStorage)level.getCapability(Capabilities.EnergyStorage.BLOCK, pos, null);
    }

    public static void fillItem(IEnergyStorage energyStorage, RestrictedItemStackHandler itemHandler, int inputItemSlot, int outputItemSlot, int transferAmount) {
        IEnergyStorage inputStorage = EnergyUtils.getItemEnergyStorage(itemHandler.getStackInSlot(inputItemSlot));
        if (inputStorage == null) {
            return;
        }
        if (energyStorage.getEnergyStored() <= 0) {
            return;
        }
        EnergyUtils.transferEnergy(energyStorage, inputStorage, transferAmount);
        if (inputStorage.getEnergyStored() <= inputStorage.getMaxEnergyStored()) {
            return;
        }
        if (!itemHandler.getStackInSlot(outputItemSlot).isEmpty()) {
            return;
        }
        ItemStackHandlerUtils.insertItem(outputItemSlot, itemHandler.getStackInSlot(inputItemSlot), false, itemHandler);
        ItemStackHandlerUtils.extractItem(inputItemSlot, 1, false, itemHandler);
    }

    public static void drainItem(IEnergyStorage energyStorage, RestrictedItemStackHandler itemHandler, int inputItemSlot, int outputItemSlot, int transferAmount) {
        IEnergyStorage outputStorage = EnergyUtils.getItemEnergyStorage(itemHandler.getStackInSlot(inputItemSlot));
        if (outputStorage == null) {
            return;
        }
        if (energyStorage.getEnergyStored() <= 0) {
            return;
        }
        EnergyUtils.transferEnergy(outputStorage, energyStorage, transferAmount);
        if (outputStorage.getEnergyStored() > 0) {
            return;
        }
        if (!itemHandler.getStackInSlot(outputItemSlot).isEmpty()) {
            return;
        }
        ItemStackHandlerUtils.insertItem(outputItemSlot, itemHandler.getStackInSlot(inputItemSlot), false, itemHandler);
        ItemStackHandlerUtils.extractItem(inputItemSlot, 1, false, itemHandler);
    }

    public static int transferEnergy(IEnergyStorage source, IEnergyStorage target, int maxTransfer) {
        if (source == null || target == null || maxTransfer <= 0) {
            return 0;
        }
        if (!source.canExtract() || !target.canReceive()) {
            return 0;
        }
        int availableEnergy = source.getEnergyStored();
        if (availableEnergy <= 0) {
            return 0;
        }
        int neighborCapacity = target.getMaxEnergyStored() - target.getEnergyStored();
        if (neighborCapacity <= 0) {
            return 0;
        }
        int transferAmount = Math.min(Math.min(availableEnergy, maxTransfer), neighborCapacity);
        if (transferAmount > 0) {
            int actuallyReceived = target.receiveEnergy(transferAmount, false);
            source.extractEnergy(actuallyReceived, false);
            return actuallyReceived;
        }
        return 0;
    }

    public static int extractEnergy(IEnergyStorage source, int amount, boolean simulate) {
        if (source == null || amount <= 0 || !source.canExtract()) {
            return 0;
        }
        return source.extractEnergy(amount, simulate);
    }

    public static int insertEnergy(IEnergyStorage target, int amount, boolean simulate) {
        if (target == null || amount <= 0 || !target.canReceive()) {
            return 0;
        }
        return target.receiveEnergy(amount, simulate);
    }
}

