/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Core.utils;

import com.Infinity.Nexus.Core.component.CoreDataComponents;
import com.Infinity.Nexus.Core.itemStackHandler.RestrictedItemStackHandler;
import com.Infinity.Nexus.Core.items.ModItems;
import com.Infinity.Nexus.Core.items.custom.ComponentItem;
import com.Infinity.Nexus.Core.items.custom.UpgradeItem;
import com.Infinity.Nexus.Core.utils.ItemStackHandlerUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;

public class ModUtils {
    public static int getComponentLevel(ItemStack stack) {
        if (stack.getItem() == ModItems.REDSTONE_COMPONENT.get()) {
            return 1;
        }
        if (stack.getItem() == ModItems.BASIC_COMPONENT.get()) {
            return 2;
        }
        if (stack.getItem() == ModItems.REINFORCED_COMPONENT.get()) {
            return 3;
        }
        if (stack.getItem() == ModItems.LOGIC_COMPONENT.get()) {
            return 4;
        }
        if (stack.getItem() == ModItems.ADVANCED_COMPONENT.get()) {
            return 5;
        }
        if (stack.getItem() == ModItems.REFINED_COMPONENT.get()) {
            return 6;
        }
        if (stack.getItem() == ModItems.INTEGRAL_COMPONENT.get()) {
            return 7;
        }
        if (stack.getItem() == ModItems.INFINITY_COMPONENT.get()) {
            return 8;
        }
        if (stack.getItem() == ModItems.ANCESTRAL_COMPONENT.get()) {
            return 9;
        }
        return 0;
    }

    public static String cycleSideValue(String side) {
        return switch (side) {
            case "down" -> "north";
            case "north" -> "south";
            case "south" -> "west";
            case "west" -> "east";
            case "east" -> "up";
            default -> "down";
        };
    }

    private static Direction getPushDirection(String side) {
        return switch (side) {
            case "down" -> Direction.DOWN;
            case "north" -> Direction.NORTH;
            case "south" -> Direction.SOUTH;
            case "west" -> Direction.WEST;
            case "east" -> Direction.EAST;
            default -> Direction.UP;
        };
    }

    public static int getSpeed(ItemStackHandler itemHandler, int[] upgradeSlots) {
        int speed = 0;
        for (int i : upgradeSlots) {
            if (itemHandler.getStackInSlot(i).getItem() == ModItems.SPEED_UPGRADE.get()) {
                speed += itemHandler.getStackInSlot(i).getCount();
                continue;
            }
            if (itemHandler.getStackInSlot(i).getItem() != ModItems.PUSHER_UPGRADE.get()) continue;
            speed += 4;
        }
        return speed;
    }

    public static int getStrength(ItemStackHandler itemHandler, int[] upgradeSlots) {
        int strength = 0;
        for (int i : upgradeSlots) {
            if (itemHandler.getStackInSlot(i).getItem() != ModItems.STRENGTH_UPGRADE.get()) continue;
            strength += itemHandler.getStackInSlot(i).getCount();
        }
        return strength;
    }

    public static int getMuffler(ItemStackHandler itemHandler, int[] upgradeSlots) {
        int muffler = 0;
        for (int i : upgradeSlots) {
            if (itemHandler.getStackInSlot(i).getItem() != ModItems.MUFFLER_UPGRADE.get()) continue;
            ++muffler;
        }
        return muffler;
    }

    public static boolean getPusher(ItemStackHandler itemHandler, int[] upgradeSlots) {
        for (int i : upgradeSlots) {
            if (itemHandler.getStackInSlot(i).getItem() != ModItems.PUSHER_UPGRADE.get()) continue;
            return true;
        }
        return false;
    }

    public static boolean isUpgrade(ItemStack stack) {
        return stack.getItem() instanceof UpgradeItem;
    }

    public static boolean canPlaceItemInContainer(ItemStack itemStack, int slotIndex, IItemHandler iItemHandler) {
        ItemStack slotStack = iItemHandler.getStackInSlot(slotIndex);
        if (!slotStack.isEmpty()) {
            if (!itemStack.is(slotStack.getItem())) {
                return false;
            }
            if (!ItemStack.isSameItemSameComponents((ItemStack)itemStack, (ItemStack)slotStack)) {
                return false;
            }
            int slotCapacity = iItemHandler.getSlotLimit(slotIndex);
            int stackCapacity = itemStack.getMaxStackSize();
            int slotCount = slotStack.getCount();
            int itemCount = itemStack.getCount();
            if (itemCount + slotCount > slotCapacity) {
                return false;
            }
            if (itemCount + slotCount > stackCapacity) {
                return false;
            }
        }
        return true;
    }

    public static boolean isComponent(ItemStack stack) {
        return stack.getItem() instanceof ComponentItem;
    }

    public static void useComponent(ItemStack component, Level level, BlockPos pos) {
        if (component.getItem() == ModItems.ANCESTRAL_COMPONENT.get()) {
            int uses = (Integer)component.getOrDefault(CoreDataComponents.ANCESTRAL_COMPONENT_USES, (Object)1);
            boolean isInfinite = (Boolean)component.getOrDefault(CoreDataComponents.ANCESTRAL_COMPONENT_DURABILITY, (Object)false);
            if (uses <= 1 && !isInfinite) {
                component.shrink(1);
                level.playSound(null, pos, SoundEvents.LAVA_EXTINGUISH, SoundSource.BLOCKS, 1.0f, 1.0f);
            } else if (isInfinite) {
                component.set(CoreDataComponents.ANCESTRAL_COMPONENT_USES, (Object)(uses - 1));
            } else {
                component.set(CoreDataComponents.ANCESTRAL_COMPONENT_USES, (Object)(uses - 1));
            }
        } else if (component.getDamageValue() >= component.getMaxDamage() && component.getItem() != ModItems.INFINITY_COMPONENT.get()) {
            if (!component.getComponents().toString().contains("eternal")) {
                component.shrink(1);
                level.playSound(null, pos, SoundEvents.ITEM_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        } else {
            component.setDamageValue(component.getDamageValue() + 1);
        }
    }

    public static boolean canInsert(IItemHandler itemHandler, int slots, ItemStack stack) {
        return itemHandler.getStackInSlot(slots).isEmpty() && !ModUtils.isUpgrade(stack) && !ModUtils.isComponent(stack);
    }

    public static void ejectItemsWhePusher(BlockPos pos, int[] componentSlot, int[] outputSlot, ItemStackHandler inventory, Level level) {
        if (inventory instanceof RestrictedItemStackHandler) {
            ModUtils.ejectItemsWhePusher(pos, componentSlot, outputSlot, (RestrictedItemStackHandler)inventory, level);
            return;
        }
    }

    public static void ejectItemsWhePusher(BlockPos pos, int[] componentSlot, int[] outputSlot, RestrictedItemStackHandler inventory, Level level) {
        if (ModUtils.getPusher(inventory, componentSlot)) {
            try {
                Direction direction;
                IItemHandler destinationInventory;
                BlockEntity blockEntity = level.getBlockEntity(pos);
                if (blockEntity != null && (destinationInventory = ItemStackHandlerUtils.getBlockCapabilityItemHandler(level, pos.relative(direction = ModUtils.getPushDirection((String)inventory.getStackInSlot(ModUtils.getPusherSlot(inventory)).getOrDefault(CoreDataComponents.PUSHER_DIRECTION, (Object)"up"))), direction)) != null) {
                    block2: for (int i : outputSlot) {
                        ItemStack outputStack = inventory.getStackInSlot(i);
                        if (outputStack.isEmpty()) continue;
                        for (int j = 0; j < destinationInventory.getSlots(); ++j) {
                            if (!destinationInventory.getStackInSlot(j).isEmpty() && destinationInventory.getStackInSlot(j).getItem() != outputStack.getItem() || !destinationInventory.isItemValid(j, outputStack.copy()) || !ModUtils.canPlaceItemInContainer(outputStack.copy(), j, destinationInventory)) continue;
                            if (destinationInventory.getStackInSlot(j).getCount() + outputStack.getCount() < destinationInventory.getSlotLimit(j)) {
                                destinationInventory.insertItem(j, outputStack, false);
                                ItemStackHandlerUtils.extractItem(i, outputStack.getCount(), false, inventory);
                                continue block2;
                            }
                            if (destinationInventory.getStackInSlot(j).getCount() + 1 > destinationInventory.getSlotLimit(j)) continue;
                            destinationInventory.insertItem(j, new ItemStack((ItemLike)outputStack.getItem(), 1), false);
                            ItemStackHandlerUtils.extractItem(i, 1, false, inventory);
                            ModUtils.ejectItemsWhePusher(pos, componentSlot, outputSlot, inventory, level);
                            continue block2;
                        }
                    }
                }
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
    }

    private static int getPusherSlot(ItemStackHandler inventory) {
        for (int i = 0; i < inventory.getSlots(); ++i) {
            if (inventory.getStackInSlot(i).getItem() != ModItems.PUSHER_UPGRADE.get()) continue;
            return i;
        }
        return -1;
    }
}

