/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Core.block.entity;

import com.Infinity.Nexus.Core.items.ModItems;
import java.util.function.Supplier;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModBlocks {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"infinity_nexus_core");
    public static final DeferredBlock<Block> FAKE_STONE = ModBlocks.registerBlock("fake_stone", () -> new Block(BlockBehaviour.Properties.of().strength(2.0f, 6.0f).sound(SoundType.STONE).mapColor(MapColor.STONE)));
    public static final DeferredBlock<Block> FAKE_GRASS_BLOCK = ModBlocks.registerBlock("fake_grass_block", () -> new Block(BlockBehaviour.Properties.of().strength(2.0f, 6.0f).sound(SoundType.ROOTED_DIRT).mapColor(MapColor.GRASS)));
    public static final DeferredBlock<Block> FAKE_DIRT = ModBlocks.registerBlock("fake_dirt", () -> new Block(BlockBehaviour.Properties.of().strength(2.0f, 6.0f).sound(SoundType.ROOTED_DIRT).mapColor(MapColor.DIRT)));

    private static <T extends Block> DeferredBlock<T> registerBlock(String name, Supplier<T> block) {
        DeferredBlock toReturn = BLOCKS.register(name, block);
        ModBlocks.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> void registerBlockItem(String name, DeferredBlock<T> block) {
        ModItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }
}

